/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.HandleLayout;

public class HandleLayoutImpl
extends BasicObjectLayoutImpl
implements HandleLayout {
    public static final HandleLayout INSTANCE = new HandleLayoutImpl();
    protected static final Shape.Allocator HANDLE_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey OBJECT_IDENTIFIER = new HiddenKey("object");
    protected static final Property OBJECT_PROPERTY = Property.create(OBJECT_IDENTIFIER, HANDLE_ALLOCATOR.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);

    protected HandleLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createHandleShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new HandleType(logicalClass, metaClass)).addProperty(OBJECT_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createHandle(DynamicObjectFactory factory, Object object) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsHandle(factory));
        assert (factory.getShape().hasProperty(OBJECT_IDENTIFIER));
        assert (object != null);
        return factory.newInstance(object);
    }

    @Override
    public boolean isHandle(Object object) {
        return object instanceof DynamicObject && this.isHandle((DynamicObject)object);
    }

    @Override
    public boolean isHandle(DynamicObject object) {
        return this.isHandle(object.getShape().getObjectType());
    }

    private boolean isHandle(ObjectType objectType) {
        return objectType instanceof HandleType;
    }

    private boolean createsHandle(DynamicObjectFactory factory) {
        return this.isHandle(factory.getShape().getObjectType());
    }

    @Override
    public Object getObject(DynamicObject object) {
        assert (this.isHandle(object));
        assert (object.getShape().hasProperty(OBJECT_IDENTIFIER));
        return OBJECT_PROPERTY.get(object, true);
    }

    protected static class HandleType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public HandleType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public HandleType setLogicalClass(DynamicObject logicalClass) {
            return new HandleType(logicalClass, this.metaClass);
        }

        @Override
        public HandleType setMetaClass(DynamicObject metaClass) {
            return new HandleType(this.logicalClass, metaClass);
        }
    }
}

