/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

public class AtExitManager {
    private final RubyContext context;
    private final Deque<DynamicObject> atExitHooks = new ConcurrentLinkedDeque<DynamicObject>();
    private final Deque<DynamicObject> systemExitHooks = new ConcurrentLinkedDeque<DynamicObject>();

    public AtExitManager(RubyContext context) {
        this.context = context;
    }

    public void add(DynamicObject block, boolean always) {
        if (always) {
            this.systemExitHooks.push(block);
        } else {
            this.atExitHooks.push(block);
        }
    }

    public DynamicObject runAtExitHooks() {
        return this.runExitHooks(this.atExitHooks);
    }

    public void runSystemExitHooks() {
        this.runExitHooks(this.systemExitHooks);
    }

    @CompilerDirectives.TruffleBoundary
    private DynamicObject runExitHooks(Deque<DynamicObject> stack) {
        DynamicObject lastException = null;
        while (true) {
            DynamicObject block;
            try {
                block = stack.pop();
            }
            catch (NoSuchElementException e) {
                return lastException;
            }
            try {
                ProcNodes.rootCall(block, new Object[0]);
                continue;
            }
            catch (RaiseException e) {
                lastException = AtExitManager.handleAtExitException(this.context, e);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public List<DynamicObject> getHandlers() {
        ArrayList<DynamicObject> handlers = new ArrayList<DynamicObject>();
        handlers.addAll(this.atExitHooks);
        handlers.addAll(this.systemExitHooks);
        return handlers;
    }

    public static DynamicObject handleAtExitException(RubyContext context, RaiseException raiseException) {
        DynamicObject rubyException = raiseException.getRubyException();
        if (Layouts.BASIC_OBJECT.getLogicalClass(rubyException) != context.getCoreLibrary().getSystemExitClass()) {
            BacktraceFormatter.createDefaultFormatter(context).printBacktrace(rubyException, Layouts.EXCEPTION.getBacktrace(rubyException));
        }
        return rubyException;
    }
}

