/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.DataHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.python.core.PySystemState;

public class DataHandlerTest
extends TestCase {
    private DataHandler _handler;

    protected void setUp() throws Exception {
        PySystemState.initialize();
        this._handler = new DataHandler();
    }

    public void testGetPyObjectResultSetIntInt() throws Exception {
        ResultSet rs = (ResultSet)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new DefaultReturnHandler());
        List<String> unsupportedTypes = Arrays.asList("ARRAY", "DATALINK", "DISTINCT", "REF", "ROWID", "STRUCT");
        for (Field field : Types.class.getDeclaredFields()) {
            String typeName = field.getName();
            int type = field.getInt(null);
            if (unsupportedTypes.contains(typeName)) {
                try {
                    this._handler.getPyObject(rs, 1, type);
                    DataHandlerTest.fail((String)"SQLException expected");
                }
                catch (SQLException sqle) {}
                continue;
            }
            DataHandlerTest.assertNotNull((String)(typeName + " should return None"), (Object)this._handler.getPyObject(rs, 1, type));
        }
    }

    static class DefaultReturnHandler
    implements InvocationHandler {
        DefaultReturnHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<Number> returnType = method.getReturnType();
            if (returnType.equals(Boolean.class) || returnType.equals(Boolean.TYPE)) {
                return Boolean.FALSE;
            }
            if (Character.TYPE.equals(returnType)) {
                return Character.valueOf('0');
            }
            if (Byte.TYPE.equals(returnType)) {
                return (byte)0;
            }
            if (Short.TYPE.equals(returnType)) {
                return (short)0;
            }
            if (Integer.TYPE.equals(returnType)) {
                return 0;
            }
            if (Long.TYPE.equals(returnType)) {
                return 0L;
            }
            if (Float.TYPE.equals(returnType)) {
                return Float.valueOf(0.0f);
            }
            if (Double.TYPE.equals(returnType)) {
                return 0.0;
            }
            if (returnType.isPrimitive()) {
                throw new RuntimeException("unhandled primitve type " + returnType);
            }
            if (returnType.isAssignableFrom(BigInteger.class)) {
                return BigInteger.ZERO;
            }
            if (returnType.isAssignableFrom(BigDecimal.class)) {
                return BigDecimal.ZERO;
            }
            if (returnType.isAssignableFrom(Number.class)) {
                return 0;
            }
            return null;
        }
    }
}

