/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.providers.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.providers.spi.Trigger;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.HintContext;

public final class HintDescription {
    private final HintMetadata metadata;
    private final Trigger trigger;
    private final Worker worker;
    private final AdditionalQueryConstraints additionalConstraints;
    private final String hintText;
    private final Set<HintMetadata.Options> options;

    private HintDescription(HintMetadata metadata, Trigger trigger, Worker worker, AdditionalQueryConstraints additionalConstraints, String hintText, Set<HintMetadata.Options> options) {
        this.metadata = metadata;
        this.trigger = trigger;
        this.worker = worker;
        this.additionalConstraints = additionalConstraints;
        this.hintText = hintText;
        this.options = options;
    }

    static HintDescription create(HintMetadata metadata, Trigger trigger, Worker worker, AdditionalQueryConstraints additionalConstraints, String hintText, Set<HintMetadata.Options> options) {
        return new HintDescription(metadata, trigger, worker, additionalConstraints, hintText, options);
    }

    public String toString() {
        return "[HintDescription:" + this.trigger + "]";
    }

    public AdditionalQueryConstraints getAdditionalConstraints() {
        return this.additionalConstraints;
    }

    public String getHintText() {
        return this.hintText;
    }

    public HintMetadata getMetadata() {
        return this.metadata;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public Worker getWorker() {
        return this.worker;
    }

    public Set<HintMetadata.Options> getOptions() {
        return this.options;
    }

    public static final class AdditionalQueryConstraints {
        public final Set<String> requiredErasedTypes;
        private static final AdditionalQueryConstraints EMPTY = new AdditionalQueryConstraints(Collections.emptySet());

        public AdditionalQueryConstraints(Set<String> requiredErasedTypes) {
            this.requiredErasedTypes = Collections.unmodifiableSet(new HashSet<String>(requiredErasedTypes));
        }

        public static AdditionalQueryConstraints empty() {
            return EMPTY;
        }
    }

    public static interface Worker {
        public Collection<? extends ErrorDescription> createErrors(HintContext var1);
    }
}

