/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.dev.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.ProjectUtil;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.ServerType;
import org.netbeans.modules.websvc.core.WSStackUtils;
import org.netbeans.modules.websvc.core.dev.wizard.PortChooser;
import org.netbeans.modules.websvc.core.dev.wizard.WsdlServiceHandler;
import org.netbeans.modules.websvc.core.dev.wizard.nodes.WsdlNode;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperGenerator;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperHandler;
import org.netbeans.modules.websvc.project.api.WebService;
import org.netbeans.modules.websvc.project.api.WebServiceData;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.SAXException;

public class WebServiceFromWSDLPanel
extends JPanel
implements HelpCtx.Provider,
DocumentListener {
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static String previousDirectory = "";
    private final FileFilter WSDL_FILE_FILTER = new WsdlFileFilter();
    private boolean isWaitingForScan = false;
    private WsdlModeler wsdlModeler;
    private WsdlModel wsdlModel;
    private WsdlService service;
    private WsdlPort port;
    private WsdlServiceHandler wsdlServiceHandler;
    private Project project;
    private WizardDescriptor wizardDescriptor;
    private JAXWSSupport wss;
    private boolean jsr109Supported;
    private boolean jsr109oldSupported;
    private boolean jaxWsInJ2ee14Supported;
    private WebModule wm;
    private RequestProcessor.Task generateWsdlModelTask;
    private URL wsdlURL;
    private WsdlWrapperHandler wsdlHandler;
    private WSStackUtils wsStackUtils;
    private JButton jButtonBrowsePort;
    private JButton jButtonWSDLFileBrowse;
    private JLabel jLabelPort;
    private JLabel jLabelPortDescription;
    private JLabel jLabelWSDLFile;
    private JTextField jTextFieldPort;
    private JTextField jTextFieldWSDLFile;
    private JCheckBox sessionBeanCB;
    private JCheckBox useProviderBtn;

    public WebServiceFromWSDLPanel(Project project) {
        this.project = project;
        this.initComponents();
        this.initJsr109Info();
        this.jTextFieldWSDLFile.getDocument().addDocumentListener(this);
        if (this.supportsJaxrpc()) {
            this.useProviderBtn.setVisible(false);
        }
        if (JaxWsUtils.isEjbJavaEE5orHigher(project)) {
            this.sessionBeanCB.setSelected(true);
            this.sessionBeanCB.setEnabled(false);
        } else if (WebServiceFromWSDLPanel.isEjbInWebSupported(project)) {
            this.sessionBeanCB.setEnabled(true);
        } else {
            this.sessionBeanCB.setEnabled(false);
        }
        this.generateWsdlModelTask = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                WsdlWrapperHandler handler = null;
                try {
                    handler = WsdlWrapperGenerator.parse((String)WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                }
                catch (ParserConfigurationException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                catch (SAXException ex) {
                    String mes = NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_SAXException", (Object)ex.getLocalizedMessage());
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                if (handler != null && !handler.isServiceElement()) {
                    StreamSource source = new StreamSource(WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                    try {
                        File wsdlFile = new File(System.getProperty("java.io.tmpdir"), WsdlWrapperGenerator.getWrapperName((URL)WebServiceFromWSDLPanel.this.wsdlURL));
                        wsdlFile = wsdlFile.getCanonicalFile();
                        if (!wsdlFile.exists()) {
                            try {
                                wsdlFile.createNewFile();
                                wsdlFile.deleteOnExit();
                            }
                            catch (IOException ex) {
                                String mes = NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_UnableToCreateTempFile", (Object)wsdlFile.getPath());
                                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                                return;
                            }
                        }
                        WsdlWrapperGenerator.generateWrapperWSDLContent((File)wsdlFile, (StreamSource)source, (String)handler.getTargetNsPrefix(), (String)WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                        WebServiceFromWSDLPanel.this.wsdlURL = wsdlFile.toURI().toURL();
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
                WebServiceFromWSDLPanel.this.wsdlHandler = handler;
                WebServiceFromWSDLPanel.this.wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(WebServiceFromWSDLPanel.this.wsdlURL);
                WebServiceFromWSDLPanel.this.wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                    public void modelCreated(WsdlModel model) {
                        WebServiceFromWSDLPanel.this.wsdlModel = model;
                        if (WebServiceFromWSDLPanel.this.wsdlModel == null) {
                            String serviceName = null;
                            String portName = null;
                            try {
                                WebServiceFromWSDLPanel.this.wsdlServiceHandler = WsdlServiceHandler.parse(WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                                serviceName = WebServiceFromWSDLPanel.this.wsdlServiceHandler.getServiceName();
                                portName = WebServiceFromWSDLPanel.this.wsdlServiceHandler.getPortName();
                            }
                            catch (ParserConfigurationException ex) {
                            }
                            catch (SAXException ex) {
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                            if (serviceName != null && portName != null) {
                                WebServiceFromWSDLPanel.this.jTextFieldPort.setText(serviceName + "#" + portName);
                            } else {
                                RequestProcessor.getDefault().post(new Runnable(){

                                    @Override
                                    public void run() {
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"TXT_CannotGenerateService", (Object)WebServiceFromWSDLPanel.this.wsdlModeler.getCreationException().getLocalizedMessage()), 2));
                                    }
                                });
                            }
                        } else {
                            WebServiceFromWSDLPanel.this.jButtonBrowsePort.setEnabled(true);
                            List services = WebServiceFromWSDLPanel.this.wsdlModel.getServices();
                            if (services != null && services.size() > 0) {
                                WebServiceFromWSDLPanel.this.service = (WsdlService)services.get(0);
                                List ports = WebServiceFromWSDLPanel.this.service.getPorts();
                                if (ports != null && ports.size() > 0) {
                                    WebServiceFromWSDLPanel.this.port = (WsdlPort)ports.get(0);
                                }
                            }
                        }
                        if (WebServiceFromWSDLPanel.this.service != null && WebServiceFromWSDLPanel.this.port != null) {
                            String bindingType;
                            WebServiceFromWSDLPanel.this.jTextFieldPort.setText(WebServiceFromWSDLPanel.this.service.getName() + "#" + WebServiceFromWSDLPanel.this.port.getName());
                            if (WebServiceFromWSDLPanel.this.wsdlHandler != null && (bindingType = WebServiceFromWSDLPanel.this.wsdlHandler.getBindingTypeForPort(WebServiceFromWSDLPanel.this.port.getName())) != null) {
                                WebServiceFromWSDLPanel.this.port.setSOAPVersion(bindingType);
                            }
                        }
                        WebServiceFromWSDLPanel.this.fireChange();
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.jLabelWSDLFile = new JLabel();
        this.jTextFieldWSDLFile = new JTextField();
        this.jButtonWSDLFileBrowse = new JButton();
        this.jLabelPortDescription = new JLabel();
        this.jLabelPort = new JLabel();
        this.jTextFieldPort = new JTextField();
        this.jButtonBrowsePort = new JButton();
        this.useProviderBtn = new JCheckBox();
        this.sessionBeanCB = new JCheckBox();
        this.jLabelWSDLFile.setLabelFor(this.jTextFieldWSDLFile);
        Mnemonics.setLocalizedText((JLabel)this.jLabelWSDLFile, (String)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_WSDL_File"));
        this.jLabelWSDLFile.setToolTipText(NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"HINT_WSDL_File"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonWSDLFileBrowse, (String)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_Browse"));
        this.jButtonWSDLFileBrowse.setToolTipText(NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"HINT_WSDL_File"));
        this.jButtonWSDLFileBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceFromWSDLPanel.this.jButtonWSDLFileBrowseActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabelPortDescription, (String)NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("LBL_PortMessage"));
        this.jLabelPort.setLabelFor(this.jTextFieldPort);
        Mnemonics.setLocalizedText((JLabel)this.jLabelPort, (String)NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("LBL_WebServicePort"));
        this.jLabelPort.setToolTipText(NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"TTL_SelectPort"));
        this.jTextFieldPort.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonBrowsePort, (String)NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("LBL_BrowsePort"));
        this.jButtonBrowsePort.setToolTipText(NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"TTL_SelectPort"));
        this.jButtonBrowsePort.setEnabled(false);
        this.jButtonBrowsePort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebServiceFromWSDLPanel.this.jButtonBrowsePortActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.useProviderBtn, (String)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_UseProvider"));
        Mnemonics.setLocalizedText((AbstractButton)this.sessionBeanCB, (String)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_WsAsSessionBean"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelWSDLFile).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldWSDLFile, -1, 781, Short.MAX_VALUE).addComponent(this.jLabelPortDescription, -1, 781, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabelPort).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPort, -1, 640, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonWSDLFileBrowse, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonBrowsePort, GroupLayout.Alignment.TRAILING, -1, 141, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.useProviderBtn)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.sessionBeanCB))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelWSDLFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonWSDLFileBrowse).addComponent(this.jTextFieldWSDLFile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelPortDescription, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonBrowsePort).addComponent(this.jLabelPort).addComponent(this.jTextFieldPort, -2, -1, -2)).addGap(57, 57, 57).addComponent(this.useProviderBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sessionBeanCB, -2, 11, -2).addContainerGap(105, Short.MAX_VALUE)));
        this.jTextFieldWSDLFile.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("A11Y_WSDLFilePath"));
        this.jButtonWSDLFileBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("A11Y_WSDLFileButton"));
        this.jTextFieldPort.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("A11Y"));
    }

    private void jButtonBrowsePortActionPerformed(ActionEvent evt) {
        WsdlNode root = new WsdlNode(this.wsdlModel);
        PortChooser chooser = new PortChooser((Node)root);
        final DialogDescriptor dd = new DialogDescriptor((Object)chooser, NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"TTL_SelectPort"));
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue;
                if (evt.getPropertyName().equals("portChooser_isValid") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                    dd.setValid(((Boolean)newvalue).booleanValue());
                }
            }
        });
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result == DialogDescriptor.OK_OPTION) {
            String portOwnerName;
            if ((ProjectUtil.isJavaEE5orHigher((Project)this.project) || this.jaxWsInJ2ee14Supported || !this.jsr109Supported && !this.jsr109oldSupported || !this.jsr109Supported && this.jsr109oldSupported) && (portOwnerName = chooser.getSelectedPortOwnerName()) != null) {
                String bindingType;
                this.jTextFieldPort.setText(portOwnerName + "#" + chooser.getSelectedNodes()[0].getDisplayName());
                this.service = this.wsdlModel.getServiceByName(portOwnerName);
                this.port = this.service.getPortByName(chooser.getSelectedNodes()[0].getDisplayName());
                if (this.wsdlHandler != null && (bindingType = this.wsdlHandler.getBindingTypeForPort(this.port.getName())) != null) {
                    this.port.setSOAPVersion(bindingType);
                }
            }
            this.fireChange();
        }
    }

    private void jButtonWSDLFileBrowseActionPerformed(ActionEvent evt) {
        File wsdlFile;
        JFileChooser chooser = new JFileChooser(previousDirectory);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.addChoosableFileFilter(this.WSDL_FILE_FILTER);
        chooser.setFileFilter(this.WSDL_FILE_FILTER);
        if (chooser.showOpenDialog(this) == 0 && (wsdlFile = chooser.getSelectedFile()) != null) {
            this.jTextFieldWSDLFile.setText(wsdlFile.getAbsolutePath());
            previousDirectory = wsdlFile.getPath();
        }
    }

    void validate(WizardDescriptor wizardDescriptor) {
    }

    private void initJsr109Info() {
        this.wsStackUtils = new WSStackUtils(this.project);
        this.jsr109Supported = this.wsStackUtils.isJsr109Supported();
        this.jaxWsInJ2ee14Supported = ServerType.JBOSS == this.wsStackUtils.getServerType();
        this.jsr109oldSupported = this.wsStackUtils.isJsr109OldSupported();
        this.wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        this.wss = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
    }

    private boolean projectHasEmbeddedSpaces() {
        FileObject projectDir = this.project.getProjectDirectory();
        File projectDirFile = FileUtil.toFile((FileObject)projectDir);
        String path = projectDirFile.getAbsolutePath();
        int index = path.indexOf(" ");
        return index != -1;
    }

    private boolean supportsJaxrpc() {
        boolean noJsr109InWeb = this.wm != null && !this.jsr109Supported && !this.jsr109oldSupported;
        boolean jaxWsInWeb14 = this.wm != null && this.jaxWsInJ2ee14Supported;
        return !ProjectUtil.isJavaEE5orHigher((Project)this.project) && !noJsr109InWeb && !jaxWsInWeb14;
    }

    boolean isValid(WizardDescriptor wizardDescriptor) {
        String wsdlFilePath;
        WSStackUtils.ErrorMessage message = this.wsStackUtils.getErrorMessage(WSStackUtils.WizardType.WS_FROM_WSDL);
        if (message != null) {
            wizardDescriptor.putProperty(message.getWizardMessageProperty(), (Object)message.getText());
            if (message.isSerious()) {
                return false;
            }
        }
        if ((wsdlFilePath = this.jTextFieldWSDLFile.getText().trim()).length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_EnterWsdlName"));
            return false;
        }
        if (!(wsdlFilePath.startsWith("http://") || wsdlFilePath.startsWith("https://") || wsdlFilePath.startsWith("www."))) {
            File f = new File(wsdlFilePath);
            if ((f = WebServiceFromWSDLPanel.getCanonicalFile(f)) == null) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_WsdlInvalid"));
                return false;
            }
            if (!f.exists()) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_WsdlDoesNotExist"));
                return false;
            }
        }
        if (ProjectUtil.isJavaEE5orHigher((Project)this.project) || JaxWsUtils.isEjbJavaEE5orHigher(this.project) || this.jaxWsInJ2ee14Supported || !this.jsr109Supported && !this.jsr109oldSupported || !this.jsr109Supported && this.jsr109oldSupported) {
            if (this.wsdlModel != null) {
                if (this.service == null) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_NoService"));
                    return false;
                }
                if (this.port == null) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_NoPort"));
                    return false;
                }
                if (this.findServiceInProject(this.service.getName(), this.port.getName())) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_ServiceNameExists", (Object)this.service.getName(), (Object)this.port.getName()));
                    return false;
                }
            } else {
                if (this.wsdlServiceHandler != null && this.wsdlServiceHandler.getServiceName() != null && this.wsdlServiceHandler.getPortName() != null) {
                    if (this.findServiceInProject(this.wsdlServiceHandler.getServiceName(), this.wsdlServiceHandler.getPortName())) {
                        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_ServiceNameExists", (Object)this.wsdlServiceHandler.getServiceName(), (Object)this.wsdlServiceHandler.getPortName()));
                        return false;
                    }
                    if (message != null) {
                        wizardDescriptor.putProperty(message.getWizardMessageProperty(), (Object)message.getText());
                    } else {
                        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
                    }
                    return true;
                }
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_NoPort"));
                return false;
            }
        }
        if (this.projectHasEmbeddedSpaces()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_SPACE_IN_PROJECT_PATH"));
        } else if (message != null) {
            wizardDescriptor.putProperty(message.getWizardMessageProperty(), (Object)message.getText());
        } else {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        }
        return true;
    }

    void store(WizardDescriptor d) {
        String wsdlLocation = this.jTextFieldWSDLFile.getText().trim();
        Boolean useProvider = this.useProviderBtn.isSelected();
        Boolean isSessionBean = this.sessionBeanCB.isSelected();
        if (wsdlLocation.startsWith("www.")) {
            wsdlLocation = "http://" + wsdlLocation;
        }
        if (wsdlLocation.startsWith("http://") || wsdlLocation.startsWith("https://")) {
            d.putProperty("wsdl_url", (Object)wsdlLocation);
        } else {
            d.putProperty("wsdlFilePath", (Object)wsdlLocation);
        }
        d.putProperty("wsdlModel", (Object)this.wsdlModel);
        d.putProperty("wsdlModeler", (Object)this.wsdlModeler);
        d.putProperty("wsdlService", (Object)this.service);
        d.putProperty("wsdlPort", (Object)this.port);
        d.putProperty("wsdlServiceHandler", (Object)this.wsdlServiceHandler);
        d.putProperty("useProvider", (Object)useProvider);
        d.putProperty("endpointAsStatelessBean", (Object)isSessionBean);
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WebServiceFromWSDLPanel.class);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        Iterator<ChangeListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().stateChanged(e);
        }
    }

    private void updatePortBrowseButton() {
        this.wsdlModel = null;
        this.service = null;
        this.port = null;
        this.jTextFieldPort.setText("");
        String wsdlFilePath = this.jTextFieldWSDLFile.getText().trim();
        if (wsdlFilePath.length() == 0) {
            this.jButtonBrowsePort.setEnabled(false);
        } else {
            if (!(wsdlFilePath.startsWith("http://") || wsdlFilePath.startsWith("https://") || wsdlFilePath.startsWith("www."))) {
                File f = new File(wsdlFilePath);
                if ((f = WebServiceFromWSDLPanel.getCanonicalFile(f)) == null) {
                    this.jButtonBrowsePort.setEnabled(false);
                    return;
                }
                if (!f.exists()) {
                    this.jButtonBrowsePort.setEnabled(false);
                    return;
                }
            }
            this.fireChange();
            if (ProjectUtil.isJavaEE5orHigher((Project)this.project) || JaxWsUtils.isEjbJavaEE5orHigher(this.project) || this.jaxWsInJ2ee14Supported || !this.jsr109Supported && !this.jsr109oldSupported || !this.jsr109Supported && this.jsr109oldSupported) {
                this.createModel();
            }
        }
    }

    private void createModel() {
        String wsdlFilePath = this.jTextFieldWSDLFile.getText().trim();
        if (wsdlFilePath.startsWith("www.")) {
            wsdlFilePath = "http://" + wsdlFilePath;
        }
        if (wsdlFilePath.startsWith("http://") && wsdlFilePath.length() > 7 || wsdlFilePath.startsWith("https://") && wsdlFilePath.length() > 8) {
            try {
                this.wsdlURL = new URL(wsdlFilePath);
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        } else {
            File normalizedWsdlFilePath = FileUtil.normalizeFile((File)new File(this.jTextFieldWSDLFile.getText().trim()));
            this.wsdlURL = null;
            try {
                this.wsdlURL = normalizedWsdlFilePath.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        this.generateWsdlModelTask.schedule(1000);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updatePortBrowseButton();
        this.fireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updatePortBrowseButton();
        this.fireChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updatePortBrowseButton();
        this.fireChange();
    }

    public static File getCanonicalFile(File f) {
        File f1;
        try {
            f1 = f.getCanonicalFile();
        }
        catch (IOException e) {
            f1 = null;
        }
        return f1;
    }

    private boolean findServiceInProject(String serviceName, String portName) {
        block3: {
            block2: {
                JAXWSSupport support = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
                if (support == null) break block2;
                for (Object o : support.getServices()) {
                    Service s = (Service)o;
                    if (s.getWsdlUrl() == null || !serviceName.equals(s.getServiceName()) || !portName.equals(s.getPortName())) continue;
                    return true;
                }
                break block3;
            }
            WebServiceData wsData = WebServiceData.getWebServiceData((Project)this.project);
            if (wsData == null) break block3;
            List webServices = wsData.getServiceProviders();
            for (WebService webService : webServices) {
                if (!serviceName.equals(webService.getIdentifier())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isEjbInWebSupported(Project prj) {
        J2eeModule j2eeModule;
        if (prj == null) {
            throw new IllegalArgumentException("Passed null to Util.isEjbInWebSupported(Project prj)");
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)prj.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (j2eeModule = j2eeModuleProvider.getJ2eeModule()) != null) {
            J2eeModule.Type type = j2eeModule.getType();
            double version = Double.parseDouble(j2eeModule.getModuleVersion());
            if (J2eeModule.Type.WAR.equals(type) && version >= 3.0) {
                return true;
            }
        }
        return false;
    }

    private static class WsdlFileFilter
    extends FileFilter {
        private WsdlFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            String ext = FileUtil.getExtension((String)f.getName());
            return f.isDirectory() || "wsdl".equalsIgnoreCase(ext) || "asmx".equalsIgnoreCase(ext);
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_WsdlFilterDescription");
        }
    }
}

