/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.common.ProjectUtil;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.project.config.ServiceAlreadyExistsExeption;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.jaxws.projects.JaxWsCatalogPanel;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class JavaEEWSOpenHook
extends ProjectOpenedHook {
    private static final RequestProcessor METADATA_MODEL_RP = new RequestProcessor("JavaEEWSOpenHook.WS_REQUEST_PROCESSOR");
    private final Project prj;
    PropertyChangeListener pcl;

    public JavaEEWSOpenHook(Project prj) {
        this.prj = prj;
    }

    protected void projectOpened() {
        block8: {
            JAXWSSupport support = JAXWSSupport.getJAXWSSupport((FileObject)this.prj.getProjectDirectory());
            if (support != null && (JaxWsUtils.isEjbJavaEE5orHigher(this.prj) || ProjectUtil.isJavaEE5orHigher((Project)this.prj))) {
                final MetadataModel wsModel = support.getWebservicesMetadataModel();
                try {
                    wsModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<WebservicesMetadata, Void>(){

                        public Void run(WebservicesMetadata metadata) {
                            Webservices webServices = metadata.getRoot();
                            JavaEEWSOpenHook.this.pcl = new WebservicesChangeListener((MetadataModel<WebservicesMetadata>)wsModel, JavaEEWSOpenHook.this.prj);
                            webServices.addPropertyChangeListener(JavaEEWSOpenHook.this.pcl);
                            return null;
                        }
                    });
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            FileObject jaxWsFo = WSUtils.findJaxWsFileObject((Project)this.prj);
            try {
                JAXWSClientSupport jaxWsClientSupport;
                if (jaxWsFo == null || !WSUtils.hasClients((FileObject)jaxWsFo) || (jaxWsClientSupport = (JAXWSClientSupport)this.prj.getLookup().lookup(JAXWSClientSupport.class)) == null) break block8;
                FileObject wsdlFolder = null;
                try {
                    wsdlFolder = jaxWsClientSupport.getWsdlFolder(false);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (wsdlFolder == null || wsdlFolder.getParent().getFileObject("jax-ws-catalog.xml") == null) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                JaxWsCatalogPanel.generateJaxWsCatalog(JavaEEWSOpenHook.this.prj, jaxWsClientSupport);
                            }
                            catch (IOException ex) {
                                Logger.getLogger(JaxWsCatalogPanel.class.getName()).log(Level.WARNING, "Cannot create jax-ws-catalog.xml", ex);
                            }
                        }
                    });
                }
            }
            catch (IOException ex) {
                Logger.getLogger(JavaEEWSOpenHook.class.getName()).log(Level.WARNING, "Cannot read nbproject/jax-ws.xml file", ex);
            }
        }
    }

    protected void projectClosed() {
        JAXWSSupport support = JAXWSSupport.getJAXWSSupport((FileObject)this.prj.getProjectDirectory());
        if (support != null && (JaxWsUtils.isEjbJavaEE5orHigher(this.prj) || ProjectUtil.isJavaEE5orHigher((Project)this.prj))) {
            MetadataModel wsModel = support.getWebservicesMetadataModel();
            try {
                wsModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<WebservicesMetadata, Void>(){

                    public Void run(WebservicesMetadata metadata) {
                        Webservices webServices = metadata.getRoot();
                        webServices.removePropertyChangeListener(JavaEEWSOpenHook.this.pcl);
                        return null;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ RequestProcessor access$200() {
        return METADATA_MODEL_RP;
    }

    private static class WebservicesChangeListener
    implements PropertyChangeListener {
        MetadataModel<WebservicesMetadata> wsModel;
        Project prj;
        private RequestProcessor.Task updateJaxWsTask = JavaEEWSOpenHook.access$200().create(new Runnable(){

            @Override
            public void run() {
                WebservicesChangeListener.this.updateJaxWs();
            }
        });

        WebservicesChangeListener(MetadataModel<WebservicesMetadata> wsModel, Project prj) {
            this.wsModel = wsModel;
            this.prj = prj;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.updateJaxWsTask.schedule(1000);
        }

        private void updateJaxWs() {
            try {
                this.wsModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<WebservicesMetadata, Void>(){

                    public Void run(WebservicesMetadata metadata) {
                        HashMap<String, String> result = new HashMap<String, String>();
                        Webservices webServices = metadata.getRoot();
                        for (WebserviceDescription wsDesc : webServices.getWebserviceDescription()) {
                            PortComponent[] ports;
                            for (PortComponent port : ports = wsDesc.getPortComponent()) {
                                if ("javax.xml.ws.WebServiceProvider".equals(wsDesc.getDisplayName())) {
                                    result.put("fromWsdl:" + wsDesc.getWebserviceDescriptionName(), port.getDisplayName());
                                    continue;
                                }
                                if (JaxWsUtils.isInSourceGroup(WebservicesChangeListener.this.prj, port.getServiceEndpointInterface())) {
                                    result.put(port.getDisplayName(), port.getPortComponentName());
                                    continue;
                                }
                                if (wsDesc.getWsdlFile() == null) continue;
                                result.put("fromWsdl:" + wsDesc.getWebserviceDescriptionName(), port.getDisplayName());
                            }
                        }
                        WebservicesChangeListener.this.updateWsModel(result);
                        return null;
                    }
                });
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }

        private void updateWsModel(Map<String, String> services) {
            final JaxWsModel jaxWsModel = (JaxWsModel)this.prj.getLookup().lookup(JaxWsModel.class);
            if (jaxWsModel != null) {
                Service[] allServices;
                HashMap<String, Service> oldServices = new HashMap<String, Service>();
                HashMap<String, Service> oldServicesFromWsdl = new HashMap<String, Service>();
                for (Service s : allServices = jaxWsModel.getServices()) {
                    if (s.getWsdlUrl() == null) {
                        oldServices.put(s.getImplementationClass(), s);
                        continue;
                    }
                    oldServicesFromWsdl.put("fromWsdl:" + s.getServiceName(), s);
                }
                HashSet<String> commonServices = new HashSet<String>();
                Set keys1 = oldServices.keySet();
                Set<String> keys2 = services.keySet();
                for (String key : keys1) {
                    if (!keys2.contains(key)) continue;
                    commonServices.add(key);
                }
                for (String key : commonServices) {
                    oldServices.remove(key);
                    services.remove(key);
                }
                boolean needToSave = false;
                for (String key : oldServices.keySet()) {
                    jaxWsModel.removeService(((Service)oldServices.get(key)).getName());
                    needToSave = true;
                }
                HashSet removedFromWsdl = new HashSet(oldServicesFromWsdl.keySet());
                removedFromWsdl.removeAll(services.keySet());
                for (String key : removedFromWsdl) {
                    Service service = (Service)oldServicesFromWsdl.remove(key);
                    if (service == null) continue;
                    jaxWsModel.removeService(service.getName());
                }
                for (String key : services.keySet()) {
                    if (key.startsWith("fromWsdl:")) {
                        Service oldServiceFromWsdl = (Service)oldServicesFromWsdl.get(key);
                        String newImplClass = services.get(key);
                        if (oldServiceFromWsdl == null || oldServiceFromWsdl.getImplementationClass().equals(newImplClass)) continue;
                        oldServiceFromWsdl.setImplementationClass(newImplClass);
                        needToSave = true;
                        continue;
                    }
                    if (jaxWsModel.findServiceByImplementationClass(key) != null) continue;
                    try {
                        jaxWsModel.addService(services.get(key), key);
                        needToSave = true;
                    }
                    catch (ServiceAlreadyExistsExeption ex) {}
                }
                if (needToSave) {
                    ProjectManager.mutex().writeAccess(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                jaxWsModel.write();
                            }
                            catch (IOException ex) {
                                ErrorManager.getDefault().notify((Throwable)ex);
                            }
                        }
                    });
                }
            }
        }
    }
}

