/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projectsui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.projects.EditorContextSupport;
import org.netbeans.modules.debugger.jpda.projectsui.DebuggerBreakpointAnnotation;
import org.netbeans.modules.debugger.jpda.projectsui.LineTranslations;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.text.AnnotationProvider;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class BreakpointAnnotationProvider
implements AnnotationProvider {
    private final Map<JPDABreakpoint, Set<Annotation>> breakpointToAnnotations = new IdentityHashMap<JPDABreakpoint, Set<Annotation>>();
    private final Set<FileObject> annotatedFiles = new WeakSet();
    private Set<PropertyChangeListener> dataObjectListeners;
    private volatile boolean breakpointsActive = true;
    private RequestProcessor annotationProcessor = new RequestProcessor("Annotation Refresh", 1);
    private RequestProcessor contextWaitingProcessor = new RequestProcessor("Annotation Refresh Context Waiting", 1);

    static BreakpointAnnotationProvider getInstance() {
        for (AnnotationProvider act : Lookup.getDefault().lookupAll(AnnotationProvider.class)) {
            if (!(act instanceof BreakpointAnnotationProvider)) continue;
            return (BreakpointAnnotationProvider)act;
        }
        throw new IllegalStateException("BreakpointAnnotationProvider is not registered in Lookup!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Line.Set set, Lookup lookup) {
        FileObject fo = (FileObject)lookup.lookup(FileObject.class);
        if (fo != null) {
            DataObject dobj = (DataObject)lookup.lookup(DataObject.class);
            if (dobj != null) {
                PropertyChangeListener pchl = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("primaryFile".equals(evt.getPropertyName())) {
                            DataObject dobj = (DataObject)evt.getSource();
                            final FileObject newFO = dobj.getPrimaryFile();
                            BreakpointAnnotationProvider.this.annotationProcessor.post(new Runnable(){

                                @Override
                                public void run() {
                                    BreakpointAnnotationProvider.this.annotate(newFO);
                                }
                            });
                        }
                    }
                };
                dobj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)pchl, (Object)dobj));
                BreakpointAnnotationProvider breakpointAnnotationProvider = this;
                synchronized (breakpointAnnotationProvider) {
                    if (this.dataObjectListeners == null) {
                        this.dataObjectListeners = new HashSet<PropertyChangeListener>();
                    }
                    this.dataObjectListeners.add(pchl);
                }
            }
            this.annotate(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotate(FileObject fo) {
        Map<JPDABreakpoint, Set<Annotation>> map = this.breakpointToAnnotations;
        synchronized (map) {
            for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
                JPDABreakpoint b;
                int[] lines;
                if (!BreakpointAnnotationProvider.isAnnotatable(breakpoint) || (lines = this.getAnnotationLines(b = (JPDABreakpoint)breakpoint, fo)) == null || lines.length <= 0) continue;
                this.removeAnnotations(b);
                this.breakpointToAnnotations.put(b, (Set<Annotation>)new WeakSet());
                if (b instanceof LineBreakpoint) {
                    LineBreakpoint lb = (LineBreakpoint)b;
                    LineTranslations.getTranslations().unregisterFromLineUpdates(lb);
                    LineTranslations.getTranslations().registerForLineUpdates(lb);
                }
                this.addAnnotationTo(b, fo, lines);
            }
            this.annotatedFiles.add(fo);
        }
    }

    void setBreakpointsActive(boolean active) {
        if (this.breakpointsActive == active) {
            return;
        }
        this.breakpointsActive = active;
        this.annotationProcessor.post((Runnable)new AnnotationRefresh(null, true, true));
    }

    void postAnnotationRefresh(JPDABreakpoint b, boolean remove, boolean add) {
        this.annotationProcessor.post((Runnable)new AnnotationRefresh(b, remove, add));
    }

    static boolean isAnnotatable(Breakpoint b) {
        return (b instanceof LineBreakpoint || b instanceof FieldBreakpoint || b instanceof MethodBreakpoint || b instanceof ClassLoadUnloadBreakpoint) && !((JPDABreakpoint)b).isHidden();
    }

    private static String getAnnotationType(JPDABreakpoint b, boolean isConditional, boolean active) {
        String annotationType;
        boolean isInvalid;
        boolean bl = isInvalid = b.getValidity() == Breakpoint.VALIDITY.INVALID;
        if (b instanceof LineBreakpoint) {
            annotationType = b.isEnabled() ? (isConditional ? "CondBreakpoint" : "Breakpoint") : (isConditional ? "DisabledCondBreakpoint" : "DisabledBreakpoint");
        } else if (b instanceof FieldBreakpoint) {
            annotationType = b.isEnabled() ? "FieldBreakpoint" : "DisabledFieldBreakpoint";
        } else if (b instanceof MethodBreakpoint) {
            annotationType = b.isEnabled() ? "MethodBreakpoint" : "DisabledMethodBreakpoint";
        } else if (b instanceof ClassLoadUnloadBreakpoint) {
            annotationType = b.isEnabled() ? "ClassBreakpoint" : "DisabledClassBreakpoint";
        } else {
            throw new IllegalStateException(b.toString());
        }
        if (!active) {
            annotationType = annotationType + "_stroke";
        } else if (isInvalid && b.isEnabled()) {
            annotationType = annotationType + "_broken";
        }
        return annotationType;
    }

    private int[] getAnnotationLines(JPDABreakpoint b, FileObject fo) {
        if (b instanceof LineBreakpoint) {
            LineBreakpoint lb = (LineBreakpoint)b;
            try {
                if (fo.toURL().equals(new URL(lb.getURL()))) {
                    return new int[]{lb.getLineNumber()};
                }
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }
        if (b instanceof FieldBreakpoint) {
            int line;
            String fieldName;
            FieldBreakpoint fb = (FieldBreakpoint)b;
            String className = fb.getClassName();
            Future fi = EditorContextSupport.getFieldLineNumber((FileObject)fo, (String)className, (String)(fieldName = fb.getFieldName()));
            if (fi != null) {
                if (!fi.isDone()) {
                    this.delayedAnnotation(b, fo, fi);
                    return null;
                }
                try {
                    line = (Integer)fi.get();
                }
                catch (InterruptedException ex) {
                    return null;
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            } else {
                return null;
            }
            return new int[]{line};
        }
        if (b instanceof MethodBreakpoint) {
            MethodBreakpoint mb = (MethodBreakpoint)b;
            String[] filters = mb.getClassFilters();
            int[] lns = new int[]{};
            for (int i = 0; i < filters.length; ++i) {
                Future futurelns;
                if (filters[i].startsWith("*") || filters[i].endsWith("*") || (futurelns = EditorContextSupport.getMethodLineNumbers((FileObject)fo, (String)filters[i], (String[])mb.getClassExclusionFilters(), (String)mb.getMethodName(), (String)mb.getMethodSignature())) == null) continue;
                if (!futurelns.isDone()) {
                    this.delayedAnnotation2(b, fo, futurelns);
                    continue;
                }
                try {
                    int[] newlns = (int[])futurelns.get();
                    if (newlns == null) continue;
                    if (lns.length == 0) {
                        lns = newlns;
                        continue;
                    }
                    int[] ln = new int[lns.length + newlns.length];
                    System.arraycopy(lns, 0, ln, 0, lns.length);
                    System.arraycopy(newlns, 0, ln, lns.length, newlns.length);
                    lns = ln;
                    continue;
                }
                catch (InterruptedException ex) {
                    continue;
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return lns;
        }
        if (b instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint cb = (ClassLoadUnloadBreakpoint)b;
            String[] filters = cb.getClassFilters();
            int[] lns = new int[]{};
            for (int i = 0; i < filters.length; ++i) {
                Future futurelns;
                if (filters[i].startsWith("*") || filters[i].endsWith("*") || (futurelns = EditorContextSupport.getClassLineNumber((FileObject)fo, (String)filters[i], (String[])cb.getClassExclusionFilters())) == null) continue;
                if (!futurelns.isDone()) {
                    this.delayedAnnotation(b, fo, futurelns);
                    continue;
                }
                try {
                    Integer newline = (Integer)futurelns.get();
                    if (newline == null) continue;
                    if (lns.length == 0) {
                        lns = new int[]{newline};
                        continue;
                    }
                    int[] ln = new int[lns.length + 1];
                    System.arraycopy(lns, 0, ln, 0, lns.length);
                    ln[lns.length] = newline;
                    lns = ln;
                    continue;
                }
                catch (InterruptedException ex) {
                    continue;
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return lns;
        }
        throw new IllegalStateException(b.toString());
    }

    private void delayedAnnotation(final JPDABreakpoint b, final FileObject fo, final Future<Integer> fi) {
        this.contextWaitingProcessor.post(new Runnable(){

            @Override
            public void run() {
                try {
                    Integer line = (Integer)fi.get();
                    if (line != null) {
                        BreakpointAnnotationProvider.this.addAnnotationTo(b, fo, new int[]{line});
                    }
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private void delayedAnnotation2(final JPDABreakpoint b, final FileObject fo, final Future<int[]> futurelns) {
        this.contextWaitingProcessor.post(new Runnable(){

            @Override
            public void run() {
                try {
                    int[] lines = (int[])futurelns.get();
                    if (lines != null && lines.length > 0) {
                        BreakpointAnnotationProvider.this.addAnnotationTo(b, fo, lines);
                    }
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private void addAnnotationTo(JPDABreakpoint b, FileObject fo) {
        int[] lines = this.getAnnotationLines(b, fo);
        this.addAnnotationTo(b, fo, lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAnnotationTo(JPDABreakpoint b, FileObject fo, int[] lines) {
        DataObject dataObject;
        if (lines == null || lines.length == 0) {
            return;
        }
        String condition = BreakpointAnnotationProvider.getCondition((Breakpoint)b);
        boolean isConditional = condition.trim().length() > 0 || b.getHitCountFilteringStyle() != null;
        String annotationType = BreakpointAnnotationProvider.getAnnotationType(b, isConditional, this.breakpointsActive);
        try {
            dataObject = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException donfex) {
            Logger.getLogger(BreakpointAnnotationProvider.class.getName()).log(Level.INFO, "No DO for " + fo, donfex);
            return;
        }
        LineCookie lc = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
        if (lc == null) {
            return;
        }
        ArrayList<DebuggerBreakpointAnnotation> annotations = new ArrayList<DebuggerBreakpointAnnotation>();
        for (int l : lines) {
            try {
                Line line = lc.getLineSet().getCurrent(l - 1);
                DebuggerBreakpointAnnotation annotation = new DebuggerBreakpointAnnotation(annotationType, line, (Breakpoint)b);
                annotations.add(annotation);
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (annotations.isEmpty()) {
            return;
        }
        Map<JPDABreakpoint, Set<Annotation>> map = this.breakpointToAnnotations;
        synchronized (map) {
            Set<Annotation> bpAnnotations = this.breakpointToAnnotations.get(b);
            if (bpAnnotations == null) {
                this.breakpointToAnnotations.put(b, (Set<Annotation>)new WeakSet(annotations));
            } else {
                bpAnnotations.addAll(annotations);
                this.breakpointToAnnotations.put(b, bpAnnotations);
            }
        }
    }

    private void removeAnnotations(JPDABreakpoint b) {
        assert (Thread.holdsLock(this.breakpointToAnnotations));
        Set<Annotation> annotations = this.breakpointToAnnotations.remove(b);
        if (annotations == null) {
            return;
        }
        for (Annotation a : annotations) {
            a.detach();
        }
    }

    static String getCondition(Breakpoint b) {
        if (!(b instanceof JPDABreakpoint)) {
            return "";
        }
        if (b instanceof LineBreakpoint) {
            return ((LineBreakpoint)b).getCondition();
        }
        if (b instanceof FieldBreakpoint) {
            return ((FieldBreakpoint)b).getCondition();
        }
        if (b instanceof MethodBreakpoint) {
            return ((MethodBreakpoint)b).getCondition();
        }
        if (b instanceof ClassLoadUnloadBreakpoint) {
            return "";
        }
        throw new IllegalStateException(b.toString());
    }

    private final class AnnotationRefresh
    implements Runnable {
        private final JPDABreakpoint b;
        private final boolean remove;
        private final boolean add;

        public AnnotationRefresh(JPDABreakpoint b, boolean remove, boolean add) {
            this.b = b;
            this.remove = remove;
            this.add = add;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = BreakpointAnnotationProvider.this.breakpointToAnnotations;
            synchronized (map) {
                if (this.b != null) {
                    this.refreshAnnotation(this.b);
                } else {
                    ArrayList bpts = new ArrayList(BreakpointAnnotationProvider.this.breakpointToAnnotations.keySet());
                    for (JPDABreakpoint bp : bpts) {
                        this.refreshAnnotation(bp);
                    }
                }
            }
        }

        private void refreshAnnotation(JPDABreakpoint b) {
            BreakpointAnnotationProvider.this.removeAnnotations(b);
            if (this.remove && !this.add) {
                BreakpointAnnotationProvider.this.breakpointToAnnotations.remove(b);
            }
            if (this.add) {
                BreakpointAnnotationProvider.this.breakpointToAnnotations.put(b, new WeakSet());
                for (FileObject fo : BreakpointAnnotationProvider.this.annotatedFiles) {
                    BreakpointAnnotationProvider.this.addAnnotationTo(b, fo);
                }
            }
        }
    }
}

