/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projectsui;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.jpda.projectsui.ToolTipView;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public class ToolTipAnnotation
extends Annotation
implements Runnable {
    private static final Set<String> JAVA_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));
    private static final int MAX_STRING_LENGTH;
    private Line.Part lp;
    private EditorCookie ec;

    public String getShortDescription() {
        if ("true".equals(System.getProperty("org.netbeans.modules.debugger.jpda.doNotShowTooltips"))) {
            return null;
        }
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return null;
        }
        JPDADebugger d = (JPDADebugger)currentEngine.lookupFirst(null, JPDADebugger.class);
        if (d == null) {
            return null;
        }
        Line.Part lp = (Line.Part)this.getAttachedAnnotatable();
        if (lp == null) {
            return null;
        }
        Line line = lp.getLine();
        DataObject dob = DataEditorSupport.findDataObject((Line)line);
        if (dob == null) {
            return null;
        }
        EditorCookie ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        this.lp = lp;
        this.ec = ec;
        RequestProcessor rp = (RequestProcessor)currentEngine.lookupFirst(null, RequestProcessor.class);
        if (rp == null) {
            rp = RequestProcessor.getDefault();
        }
        rp.post((Runnable)this);
        return null;
    }

    @Override
    public void run() {
        String toolTipText;
        StyledDocument doc;
        ObjectVariable tooltipVariable = null;
        if (this.lp == null || this.ec == null) {
            return;
        }
        try {
            doc = this.ec.openDocument();
        }
        catch (IOException ex) {
            return;
        }
        final JEditorPane ep = EditorContextDispatcher.getDefault().getMostRecentEditor();
        if (ep == null || ep.getDocument() != doc) {
            return;
        }
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return;
        }
        final JPDADebugger d = (JPDADebugger)currentEngine.lookupFirst(null, JPDADebugger.class);
        if (d == null) {
            return;
        }
        JPDAThread t = d.getCurrentThread();
        if (t == null || !t.isSuspended()) {
            return;
        }
        boolean[] isMethodPtr = new boolean[]{false};
        String[] fieldOfPtr = new String[]{null};
        int offset = NbDocument.findLineOffset((StyledDocument)doc, (int)this.lp.getLine().getLineNumber()) + this.lp.getColumn();
        final String expression = ToolTipAnnotation.getIdentifier(d, doc, ep, offset, isMethodPtr, fieldOfPtr);
        if (expression == null) {
            return;
        }
        try {
            Object v = null;
            List operations = t.getLastOperations();
            if (operations != null) {
                for (EditorContext.Operation operation : operations) {
                    if (!expression.endsWith(operation.getMethodName()) || operation.getMethodStartPosition().getOffset() > offset || offset > operation.getMethodEndPosition().getOffset()) continue;
                    v = operation.getReturnValue();
                }
            }
            if (v == null) {
                CallStackFrame currentCallStackFrame;
                if (isMethodPtr[0]) {
                    return;
                }
                String fieldClass = fieldOfPtr[0];
                if (fieldClass != null && (currentCallStackFrame = d.getCurrentCallStackFrame()) != null) {
                    v = this.findField(currentCallStackFrame, fieldClass, expression);
                }
                if (v == null) {
                    v = d.evaluate(expression);
                }
            }
            if (v == null) {
                return;
            }
            String type = v.getType();
            if (v instanceof ObjectVariable) {
                tooltipVariable = (ObjectVariable)v;
                try {
                    Object jdiValue = v.getClass().getMethod("getJDIValue", new Class[0]).invoke(v, new Object[0]);
                    if (jdiValue == null) {
                        tooltipVariable = null;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (tooltipVariable != null) {
                    v = this.getFormattedValue(d, (ObjectVariable)v);
                }
            }
            if (v instanceof ObjectVariable) {
                try {
                    String toString = ((ObjectVariable)v).getToStringValue();
                    toolTipText = expression + " = " + (type.length() == 0 ? "" : "(" + type + ") ") + toString;
                }
                catch (InvalidExpressionException ex) {
                    toolTipText = expression + " = " + (type.length() == 0 ? "" : "(" + type + ") ") + v.getValue();
                }
            } else {
                toolTipText = expression + " = " + (type.length() == 0 ? "" : "(" + type + ") ") + v.getValue();
            }
        }
        catch (InvalidExpressionException e) {
            FileObject fo = (FileObject)this.lp.getLine().getLookup().lookup(FileObject.class);
            Source src = fo != null ? Source.create((FileObject)fo) : Source.create((Document)doc);
            String typeName = this.resolveTypeName(offset, src);
            toolTipText = typeName != null ? typeName : expression + " = >" + e.getMessage() + "<";
        }
        toolTipText = ToolTipAnnotation.truncateLongText(toolTipText);
        if (tooltipVariable != null) {
            final ObjectVariable var = tooltipVariable;
            final String toolTip = toolTipText;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    final ToolTipView.ExpandableTooltip et = ToolTipView.createExpandableTooltip(toolTip);
                    et.addExpansionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            et.setBorder(BorderFactory.createLineBorder(et.getForeground()));
                            et.removeAll();
                            et.setWidthCheck(false);
                            final ToolTipView ttView = ToolTipView.getToolTipView(d, expression, var);
                            et.add(ttView);
                            et.revalidate();
                            et.repaint();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    EditorUI eui = Utilities.getEditorUI((JTextComponent)ep);
                                    if (eui != null) {
                                        ttView.setToolTipSupport(eui.getToolTipSupport());
                                        eui.getToolTipSupport().setToolTip((JComponent)et, PopupManager.ViewPortBounds, PopupManager.AbovePreferred, 0, 0, 4);
                                    } else {
                                        ToolTipAnnotation.this.firePropertyChange("shortDescription", null, toolTip);
                                    }
                                }
                            });
                        }
                    });
                    EditorUI eui = Utilities.getEditorUI((JTextComponent)ep);
                    if (eui != null) {
                        eui.getToolTipSupport().setToolTip((JComponent)et);
                    } else {
                        ToolTipAnnotation.this.firePropertyChange("shortDescription", null, toolTip);
                    }
                }
            });
        } else {
            this.firePropertyChange("shortDescription", null, toolTipText);
        }
    }

    private Variable getFormattedValue(JPDADebugger d, ObjectVariable ov) {
        try {
            return (Variable)d.getClass().getMethod("getFormattedValue", ObjectVariable.class).invoke((Object)d, ov);
        }
        catch (Exception ex) {
            return ov;
        }
    }

    private static String truncateLongText(String text) {
        if (text.length() > MAX_STRING_LENGTH && !text.regionMatches(false, 0, "<html>", 0, 6)) {
            text = text.substring(0, MAX_STRING_LENGTH) + "...";
        }
        return text;
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getIdentifier(JPDADebugger debugger, StyledDocument doc, JEditorPane ep, int offset, boolean[] isMethodPtr, String[] fieldOfPtr) {
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            return t;
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            boolean[] isFieldStatic;
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            for (identStart = col; identStart > 0 && (Character.isJavaIdentifierPart(t.charAt(identStart - 1)) || t.charAt(identStart - 1) == '.'); --identStart) {
            }
            for (identEnd = col; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
            }
            if (identStart == identEnd) {
                return null;
            }
            String ident = t.substring(identStart, identEnd);
            if (JAVA_KEYWORDS.contains(ident)) {
                return null;
            }
            int newOffset = NbDocument.findLineOffset((StyledDocument)doc, (int)line) + identStart + 1;
            if (!ToolTipAnnotation.isValidTooltipLocation(debugger, doc, newOffset, ident, fieldOfPtr, isFieldStatic = new boolean[]{false})) {
                return null;
            }
            while (identEnd < lineLen && Character.isWhitespace(t.charAt(identEnd))) {
                ++identEnd;
            }
            if (identEnd < lineLen && t.charAt(identEnd) == '(') {
                isMethodPtr[0] = true;
            }
            return ident;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private static boolean isValidTooltipLocation(JPDADebugger debugger, final StyledDocument doc, final int offset, final String expr, final String[] fieldOfPtr, boolean[] isFieldStatic) {
        Future parsingTask;
        CallStackFrame currentFrame = debugger.getCurrentCallStackFrame();
        if (currentFrame == null) {
            return false;
        }
        final boolean[] isValid = new boolean[]{true};
        final String[] className = new String[]{""};
        try {
            parsingTask = ParserManager.parseWhenScanFinished(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    javax.lang.model.element.Element typeElement;
                    String name;
                    ElementKind ek;
                    ExpressionTree packgTree;
                    Parser.Result res = resultIterator.getParserResult(offset);
                    if (res == null) {
                        return;
                    }
                    CompilationController controller = CompilationController.get((Parser.Result)res);
                    if (controller == null || controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TreeUtilities treeUtilities = controller.getTreeUtilities();
                    SourcePositions positions = controller.getTrees().getSourcePositions();
                    TreePath mainPath = treeUtilities.pathFor(offset);
                    CompilationUnitTree unitTree = controller.getCompilationUnit();
                    if ((long)offset >= positions.getStartPosition(unitTree, packgTree = unitTree.getPackageName()) && (long)offset <= positions.getEndPosition(unitTree, packgTree)) {
                        isValid[0] = false;
                        return;
                    }
                    Tree tree = mainPath.getLeaf();
                    Tree.Kind kind = tree.getKind();
                    if (kind == Tree.Kind.STRING_LITERAL) {
                        isValid[0] = false;
                        return;
                    }
                    int startPos = (int)positions.getStartPosition(unitTree, tree);
                    int endPos = (int)positions.getEndPosition(unitTree, tree);
                    int startLine = LineDocumentUtils.getLineIndex((LineDocument)((LineDocument)doc), (int)startPos);
                    int endLine = LineDocumentUtils.getLineIndex((LineDocument)((LineDocument)doc), (int)endPos);
                    int line = LineDocumentUtils.getLineIndex((LineDocument)((LineDocument)doc), (int)offset);
                    if (kind != Tree.Kind.VARIABLE && (startLine != line || endLine != line)) {
                        isValid[0] = false;
                        return;
                    }
                    for (Comment comm : treeUtilities.getComments(tree, true)) {
                        if (comm.pos() < 0 || comm.pos() > offset || offset > comm.endPos()) continue;
                        isValid[0] = false;
                        return;
                    }
                    for (Comment comm : treeUtilities.getComments(tree, false)) {
                        if (comm.pos() < 0 || comm.pos() > offset || offset > comm.endPos()) continue;
                        isValid[0] = false;
                        return;
                    }
                    for (TreePath path = mainPath; path != null; path = path.getParentPath()) {
                        tree = path.getLeaf();
                        kind = tree.getKind();
                        if (kind == Tree.Kind.IMPORT) {
                            isValid[0] = false;
                            return;
                        }
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)kind) || className[0].length() != 0) continue;
                        TypeElement typeElement2 = (TypeElement)controller.getTrees().getElement(path);
                        className[0] = ElementUtilities.getBinaryName((TypeElement)typeElement2);
                    }
                    javax.lang.model.element.Element element = controller.getTrees().getElement(mainPath);
                    if (element != null && ElementKind.FIELD.equals((Object)(ek = element.getKind())) && (name = element.getSimpleName().toString()).equals(expr) && (typeElement = element.getEnclosingElement()) instanceof TypeElement) {
                        String binaryClassName;
                        fieldOfPtr[0] = binaryClassName = ElementUtilities.getBinaryName((TypeElement)((TypeElement)typeElement));
                    }
                }
            });
        }
        catch (ParseException ex) {
            return false;
        }
        parsingTask.cancel(false);
        if (!isValid[0]) {
            return false;
        }
        if (className[0].length() > 0) {
            HashSet<String> superTypeNames = new HashSet<String>();
            This thisVar = currentFrame.getThisVariable();
            if (thisVar != null) {
                String fqn = thisVar.getType();
                ToolTipAnnotation.addClassNames(fqn, superTypeNames);
                for (Super superTypeVar = thisVar.getSuper(); superTypeVar != null; superTypeVar = superTypeVar.getSuper()) {
                    fqn = superTypeVar.getType();
                    superTypeNames.add(fqn);
                }
                List allInterfaces = thisVar.getClassType().getAllInterfaces();
                for (JPDAClassType intrfc : allInterfaces) {
                    superTypeNames.add(intrfc.getName());
                }
            } else {
                ToolTipAnnotation.addClassNames(currentFrame.getClassName(), superTypeNames);
            }
            if (!superTypeNames.contains(className[0])) {
                return false;
            }
        }
        return true;
    }

    private static String findRelativeClassReference(String currentCassName, String binaryClassName, boolean isStatic) {
        int i = binaryClassName.indexOf(36);
        if (i < 0) {
            if (isStatic) {
                return binaryClassName;
            }
            return binaryClassName + ".this";
        }
        boolean anonymous = false;
        StringBuilder clazz = new StringBuilder(binaryClassName.substring(0, i));
        while (0 <= i && i < binaryClassName.length()) {
            String name;
            int i2;
            if ((i2 = binaryClassName.indexOf(36, ++i)) < 0) {
                i2 = binaryClassName.length();
            }
            if ((name = binaryClassName.substring(i, i2)).isEmpty()) {
                return null;
            }
            if (Character.isDigit(name.charAt(0))) {
                anonymous = true;
                break;
            }
            clazz.append('.');
            clazz.append(name);
            i = i2;
        }
        if (anonymous) {
            if (!currentCassName.startsWith(binaryClassName)) {
                return null;
            }
            if (binaryClassName.equals(currentCassName)) {
                return "this";
            }
            return null;
        }
        if (!isStatic) {
            clazz.append('.');
            clazz.append("this");
        }
        return clazz.toString();
    }

    private static void addClassNames(String fqn, Set<String> typeNames) {
        int i;
        do {
            typeNames.add(fqn);
        } while ((fqn = (i = fqn.lastIndexOf(36)) > 0 ? fqn.substring(0, i) : null) != null);
    }

    private String resolveTypeName(final int offset, Source source) {
        final String[] result = new String[]{null};
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result res = resultIterator.getParserResult(offset);
                    if (res == null) {
                        return;
                    }
                    CompilationController controller = CompilationController.get((Parser.Result)res);
                    if (controller == null || controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TreePath path = controller.getTreeUtilities().pathFor(offset);
                    javax.lang.model.element.Element elem = controller.getTrees().getElement(path);
                    ElementKind kind = elem.getKind();
                    if (kind == ElementKind.CLASS || kind == ElementKind.ENUM || kind == ElementKind.ANNOTATION_TYPE) {
                        result[0] = elem.asType().toString();
                    }
                }
            });
        }
        catch (ParseException ex) {
            // empty catch block
        }
        return result[0];
    }

    private static boolean testParentOf(Types types, TypeMirror currentElement, TypeMirror typeMirror) {
        List<? extends TypeMirror> directSupertypes = types.directSupertypes(currentElement);
        for (TypeMirror typeMirror2 : directSupertypes) {
            if (typeMirror2.equals(typeMirror)) {
                return true;
            }
            boolean isParent = ToolTipAnnotation.testParentOf(types, typeMirror2, typeMirror);
            if (!isParent) continue;
            return true;
        }
        return false;
    }

    private Variable findField(CallStackFrame csf, String fieldClass, String fieldName) {
        int i;
        This thisVariable = csf.getThisVariable();
        if (thisVariable == null) {
            return null;
        }
        Field field = thisVariable.getField(fieldName);
        if (field != null && field.getDeclaringClass().getName().equals(fieldClass)) {
            return field;
        }
        ObjectVariable outer = null;
        for (i = 0; i < 10 && (outer = (ObjectVariable)thisVariable.getField("this$" + i)) == null; ++i) {
        }
        while (outer != null) {
            field = outer.getField(fieldName);
            if (field != null && field.getDeclaringClass().getName().equals(fieldClass)) {
                return field;
            }
            if (i == 0) break;
            outer = (ObjectVariable)outer.getField("this$" + --i);
        }
        return null;
    }

    static {
        int maxStringLength = 100000;
        String javaV = System.getProperty("java.version");
        if (javaV.startsWith("1.8.0")) {
            char c;
            String update = "";
            for (int i = "1.8.0_".length(); i < javaV.length() && Character.isDigit(c = javaV.charAt(i)); ++i) {
                update = update + c;
            }
            int updateNo = 0;
            if (!update.isEmpty()) {
                try {
                    updateNo = Integer.parseInt(update);
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            if (updateNo < 60) {
                maxStringLength = 1000;
            }
        }
        MAX_STRING_LENGTH = maxStringLength;
    }
}

