/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.hints.formatstring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.analysis.api.AnalyzerResponse;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.syntaxerr.AbstractCodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditFactory;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfoHintProvider;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.highlight.hints.ErrorInfoImpl;
import org.netbeans.modules.cnd.highlight.hints.SafeFix;
import org.netbeans.modules.cnd.highlight.hints.formatstring.FormatError;
import org.netbeans.modules.cnd.highlight.hints.formatstring.FormattedPrintFunction;
import org.netbeans.modules.cnd.highlight.hints.formatstring.Parameter;
import org.netbeans.modules.cnd.highlight.hints.formatstring.Utilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FormatStringAudit
extends AbstractCodeAudit {
    private static final boolean CHECKS_ENABLED;

    private FormatStringAudit(String id, String name, String description, String defaultSeverity, boolean defaultEnabled, AuditPreferences myPreferences) {
        super(id, name, description, defaultSeverity, defaultEnabled, myPreferences);
    }

    public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
        return kind == CsmErrorProvider.EditorEvent.FileBased;
    }

    public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        final CsmFile file = request.getFile();
        if (file != null) {
            if (request.isCancelled()) {
                return;
            }
            Document doc_ = request.getDocument();
            if (doc_ == null) {
                CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((CsmFile)file);
                doc_ = CsmUtilities.openDocument((CloneableEditorSupport)ces);
            }
            final Document doc = doc_;
            final LinkedList result = new LinkedList();
            Collection references = CsmReferenceResolver.getDefault().getReferences(file);
            for (CsmReference reference : references) {
                CsmObject object = reference.getReferencedObject();
                if (!Utilities.isFormattedPrintFunction(object)) continue;
                final int startOffset = reference.getStartOffset();
                doc.render(new Runnable(){

                    @Override
                    public void run() {
                        TokenSequence docTokenSequence = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)startOffset, (boolean)false, (boolean)true);
                        if (docTokenSequence == null) {
                            return;
                        }
                        CsmReferenceResolver rr = CsmReferenceResolver.getDefault();
                        StringBuilder paramBuf = new StringBuilder();
                        ArrayList<Parameter> params = new ArrayList<Parameter>();
                        State state = State.DEFAULT;
                        boolean formatFlag = false;
                        StringBuilder formatString = null;
                        int paramOffset = -1;
                        int bracketsCounter = 0;
                        int formatStringOffset = -1;
                        boolean doNotResolveType = false;
                        while (docTokenSequence.moveNext()) {
                            CsmReference ref;
                            Token token = docTokenSequence.token();
                            TokenId tokenId = token.id();
                            if (tokenId.equals(CppTokenId.IDENTIFIER) && state == State.DEFAULT) {
                                CsmReference reference = rr.findReference(file, doc, docTokenSequence.offset());
                                CsmObject object = reference.getReferencedObject();
                                state = State.START;
                                continue;
                            }
                            if (tokenId.equals(CppTokenId.LPAREN) && state == State.START) {
                                state = State.IN_PARAM;
                                continue;
                            }
                            if (tokenId.equals(CppTokenId.LPAREN) && state == State.IN_PARAM) {
                                state = State.IN_PARAM_BRACKET;
                                ++bracketsCounter;
                                if (!formatFlag) continue;
                                paramBuf.append(token.text());
                                if (paramOffset != -1) continue;
                                paramOffset = docTokenSequence.offset();
                                continue;
                            }
                            if (tokenId.equals(CppTokenId.LPAREN) && state == State.IN_PARAM_BRACKET) {
                                ++bracketsCounter;
                                if (!formatFlag) continue;
                                paramBuf.append(token.text());
                                if (paramOffset != -1) continue;
                                paramOffset = docTokenSequence.offset();
                                continue;
                            }
                            if (tokenId.equals(CppTokenId.RPAREN) && state == State.IN_PARAM_BRACKET) {
                                if (--bracketsCounter == 0) {
                                    state = State.IN_PARAM;
                                }
                                if (!formatFlag) continue;
                                paramBuf.append(token.text());
                                if (paramOffset != -1) continue;
                                paramOffset = docTokenSequence.offset();
                                continue;
                            }
                            if (tokenId.equals(CppTokenId.RPAREN) && state == State.IN_PARAM) {
                                if (paramBuf.length() > 0) {
                                    params.add(new Parameter(paramBuf.toString(), paramOffset, !doNotResolveType));
                                    paramOffset = -1;
                                }
                                result.add(new FormattedPrintFunction(file, formatStringOffset, formatString == null ? "" : formatString.toString(), params));
                                return;
                            }
                            if (state == State.IN_PARAM && tokenId.equals(CppTokenId.STRING_LITERAL) && !formatFlag) {
                                params = new ArrayList();
                                if (formatString == null) {
                                    formatString = new StringBuilder();
                                }
                                formatString.append(token.text().toString());
                                formatStringOffset = docTokenSequence.offset();
                                continue;
                            }
                            if (state == State.IN_PARAM && !formatFlag && formatString != null && tokenId.equals(CppTokenId.COMMA)) {
                                formatFlag = true;
                                continue;
                            }
                            if (state == State.IN_PARAM && formatFlag && tokenId.equals(CppTokenId.COMMA)) {
                                if (paramBuf.length() > 0) {
                                    params.add(new Parameter(paramBuf.toString(), paramOffset, !doNotResolveType));
                                    paramOffset = -1;
                                }
                                doNotResolveType = false;
                                paramBuf = new StringBuilder();
                                continue;
                            }
                            if ((state == State.IN_PARAM || state == State.IN_PARAM_BRACKET) && !tokenId.primaryCategory().equals("comment") && formatFlag) {
                                if (paramBuf.length() == 0 && tokenId.primaryCategory().equals("whitespace")) continue;
                                if (paramOffset == -1) {
                                    paramOffset = docTokenSequence.offset();
                                }
                                if ((ref = rr.findReference(file, doc, docTokenSequence.offset())) != null && CsmKindUtilities.isMacro((CsmObject)ref.getReferencedObject())) {
                                    doNotResolveType = true;
                                }
                                paramBuf.append(token.text());
                                continue;
                            }
                            if (state != State.IN_PARAM && state != State.IN_PARAM_BRACKET || tokenId.primaryCategory().equals("comment") || (ref = rr.findReference(file, doc, docTokenSequence.offset())) == null || !CsmKindUtilities.isMacro((CsmObject)ref.getReferencedObject())) continue;
                            break;
                        }
                    }
                });
            }
            LinkedList<FormatError> errors = new LinkedList<FormatError>();
            for (FormattedPrintFunction function : result) {
                errors.addAll(function.validate());
            }
            for (FormatError error : errors) {
                CsmErrorInfo.Severity severity = FormatStringAudit.toSeverity((String)this.minimalSeverity());
                try {
                    if (response instanceof AnalyzerResponse) {
                        ((AnalyzerResponse)response).addError(AnalyzerResponse.AnalyzerSeverity.DetectedError, null, file.getFileObject(), (CsmErrorInfo)new FormatStringErrorInfoImpl(doc, "General", this.getID(), this.getName() + "\n" + Utilities.getMessageForError(error), severity, error));
                        continue;
                    }
                    response.addError((CsmErrorInfo)new FormatStringErrorInfoImpl(doc, "General", this.getID(), Utilities.getMessageForError(error), severity, error));
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    static {
        String checksEnabled = System.getProperty("printf.check.enable");
        CHECKS_ENABLED = checksEnabled != null ? Boolean.parseBoolean(checksEnabled) : true;
    }

    private static final class FixFormat
    extends SafeFix {
        private final BaseDocument doc;
        private final FormatError error;
        private final Position start;
        private final Position end;
        private final String oldText;
        private final String newText;

        public FixFormat(BaseDocument doc, FormatError error, Position start, Position end) throws BadLocationException {
            this.doc = doc;
            this.error = error;
            this.start = start;
            this.end = end;
            int length = end.getOffset() - start.getOffset();
            this.oldText = doc.getText(start.getOffset(), length);
            this.newText = error.getType().equals((Object)FormatError.FormatErrorType.TYPE_MISMATCH) ? this.getAppropriateFormat(error.getFlag()) : this.oldText.replace(error.getFlag(), "");
        }

        public String getText() {
            return NbBundle.getMessage(FormatStringAudit.class, (String)"FormatStringAudit.fix.flag", (Object)this.oldText, (Object)this.newText);
        }

        @Override
        public ChangeInfo performFix() throws BadLocationException, Exception {
            int length = this.end.getOffset() - this.start.getOffset();
            this.doc.replace(this.start.getOffset(), length, this.newText, null);
            return null;
        }

        private String getAppropriateFormat(String type) {
            List<String> formats = Utilities.typeToFormat(type);
            String specifier = this.error.getSpecifier();
            if (specifier.startsWith("l")) {
                specifier.replace("l", "");
            } else if (specifier.startsWith("h")) {
                specifier.replace("h", "");
            }
            for (String format : formats) {
                if (!format.contains(specifier)) continue;
                return format;
            }
            if (formats.isEmpty()) {
                return "p";
            }
            return formats.get(0);
        }
    }

    public static final class FormatStringFixProvider
    extends CsmErrorInfoHintProvider {
        protected List<Fix> doGetFixes(CsmErrorInfo info, List<Fix> alreadyFound) {
            if (info instanceof FormatStringErrorInfoImpl) {
                alreadyFound.addAll(this.createFixes((FormatStringErrorInfoImpl)info));
            }
            return alreadyFound;
        }

        private List<? extends Fix> createFixes(FormatStringErrorInfoImpl info) {
            try {
                ArrayList<FixFormat> fixes = new ArrayList<FixFormat>();
                switch (info.error.getType()) {
                    case FLAG: 
                    case LENGTH: 
                    case TYPE_MISMATCH: {
                        fixes.add(new FixFormat(info.doc, info.error, info.startPosition, info.endPosition));
                        break;
                    }
                }
                return fixes;
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return Collections.emptyList();
            }
        }
    }

    private static final class FormatStringErrorInfoImpl
    extends ErrorInfoImpl {
        private final BaseDocument doc;
        private final Position startPosition;
        private final Position endPosition;
        private final FormatError error;

        public FormatStringErrorInfoImpl(Document doc, String providerName, String audutName, String message, CsmErrorInfo.Severity severity, FormatError error) throws BadLocationException {
            super(providerName, audutName, message, severity, error.startOffset(), error.endOffset());
            this.doc = (BaseDocument)doc;
            this.error = error;
            this.startPosition = NbDocument.createPosition((Document)doc, (int)this.error.startOffset(), (Position.Bias)Position.Bias.Forward);
            this.endPosition = NbDocument.createPosition((Document)doc, (int)this.error.endOffset(), (Position.Bias)Position.Bias.Backward);
        }
    }

    public static final class Factory
    implements CodeAuditFactory {
        public AbstractCodeAudit create(AuditPreferences preferences) {
            String id = NbBundle.getMessage(FormatStringAudit.class, (String)"FormatStringAudit.name");
            String description = NbBundle.getMessage(FormatStringAudit.class, (String)"FormatStringAudit.description");
            return new FormatStringAudit(id, id, description, "error", CHECKS_ENABLED, preferences);
        }
    }

    private static enum State {
        DEFAULT,
        START,
        IN_PARAM,
        IN_PARAM_BRACKET;

    }
}

