/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.security;

import org.netbeans.modules.cnd.analysis.api.AnalyzerResponse;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.syntaxerr.AbstractCodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.highlight.hints.ErrorInfoImpl;
import org.netbeans.modules.cnd.highlight.security.FunctionsXmlService;
import org.openide.util.NbBundle;

public class FunctionUsageAudit
extends AbstractCodeAudit {
    private final FunctionsXmlService.Level level;
    private final FunctionsXmlService.Category category;
    private final String customType;

    public FunctionUsageAudit(FunctionsXmlService.Level level, FunctionsXmlService.Category category, String id, String name, String description, String defaultSeverity, String customType, boolean defaultEnabled, AuditPreferences myPreferences) {
        super(id, name, description, defaultSeverity, defaultEnabled, myPreferences);
        this.level = level;
        this.category = category;
        this.customType = customType;
    }

    public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
        return kind == CsmErrorProvider.EditorEvent.FileBased;
    }

    public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        CsmFile file = request.getFile();
        if (file != null) {
            for (CsmReference ref : CsmReferenceResolver.getDefault().getReferences(file)) {
                String description;
                CsmFunction function;
                String altText;
                if (request.isCancelled()) {
                    return;
                }
                if (!CsmKindUtilities.isFunction((CsmObject)ref.getReferencedObject()) || (altText = this.getAlternativesIfUnsafe(function = (CsmFunction)ref.getReferencedObject())) == null) continue;
                CsmErrorInfo.Severity severity = FunctionUsageAudit.toSeverity((String)this.minimalSeverity());
                String id = this.level.getLevel() + this.category.getName();
                String name = "(" + (Object)((Object)this.level) + ") " + function.getName().toString();
                String string = description = altText.isEmpty() ? this.getDescription() : this.getDescription() + NbBundle.getMessage(FunctionUsageAudit.class, (String)"FunctionUsageAudit.alternative", (Object)altText);
                if (response instanceof AnalyzerResponse) {
                    ((AnalyzerResponse)response).addError(AnalyzerResponse.AnalyzerSeverity.DetectedError, null, file.getFileObject(), (CsmErrorInfo)new ErrorInfoImpl("Security", this.getName(), id + "\n" + name + "\n" + description, severity, this.customType, ref.getStartOffset(), ref.getEndOffset()));
                    continue;
                }
                response.addError((CsmErrorInfo)new ErrorInfoImpl("Security", this.getName(), description, severity, this.customType, ref.getStartOffset(), ref.getEndOffset()));
            }
        }
    }

    private String getAlternativesIfUnsafe(CsmFunction function) {
        for (FunctionsXmlService.RvsdFunction unsafeFunction : this.category.getFunctions()) {
            if (!function.getName().toString().equals(unsafeFunction.getName())) continue;
            CsmFile srcFile = function.getContainingFile();
            for (CsmInclude include : CsmFileInfoQuery.getDefault().getIncludeStack(srcFile)) {
                if (!include.getIncludeName().toString().equals(unsafeFunction.getHeader())) continue;
                return unsafeFunction.getAlternativesString();
            }
        }
        return null;
    }
}

