/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.tooling.console;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.SystemColor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.common.api.RemoteFileCache;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.webkit.debugging.api.console.Console;
import org.netbeans.modules.web.webkit.debugging.api.console.ConsoleMessage;
import org.netbeans.modules.web.webkit.tooling.console.Bundle;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.FoldHandle;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOColors;
import org.openide.windows.IOFolding;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class BrowserConsoleLogger
implements Console.Listener {
    private static final String LEVEL_ERROR = "error";
    private static final String LEVEL_WARNING = "warning";
    private static final String LEVEL_DEBUG = "debug";
    private static final String PROMPT = "> ";
    private final Lookup projectContext;
    private InputOutput io;
    private Color colorStdBrighter;
    private ConsoleMessage lastMessage;
    private Console.InputCallback input;
    private ConsoleReader reader;
    private boolean isFoldingSupported;
    private final AtomicBoolean shownOnError = new AtomicBoolean(false);
    private final RequestProcessor rp = new RequestProcessor(BrowserConsoleLogger.class);
    private static final Logger LOG = Logger.getLogger(BrowserConsoleLogger.class.getName());
    private static final SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
    private static final String LOG_IGNORED = "log";
    private static final String CONSOLE_API = "console-api";
    private static final String TIME_SEPARATOR = " | ";
    private static final String[] KNOWN_SOURCE_TYPES = new String[]{"generic", "HTML5-SiteRoot", "HTML5-Tests", "HTML5-Tests-Selenium"};

    public BrowserConsoleLogger(Lookup projectContext) {
        this.projectContext = projectContext;
        this.initIO();
    }

    private void initIO() {
        this.io = IOProvider.getDefault().getIO(Bundle.BrowserConsoleLoggerTitle(), false);
        this.setIOColors();
        this.io.setInputVisible(true);
        this.isFoldingSupported = IOFolding.isSupported((InputOutput)this.io);
        this.io.getOut().print(PROMPT);
        Reader r = this.io.getIn();
        this.reader = new ConsoleReader(r);
        this.rp.post((Runnable)this.reader);
    }

    private void setIOColors() {
        if (IOColors.isSupported((InputOutput)this.io) && IOColorPrint.isSupported((InputOutput)this.io)) {
            Color colorStd = IOColors.getColor((InputOutput)this.io, (IOColors.OutputType)IOColors.OutputType.OUTPUT);
            Color background = UIManager.getDefaults().getColor("nb.output.background");
            if (background == null) {
                background = SystemColor.window;
            }
            this.colorStdBrighter = BrowserConsoleLogger.shiftTowards(colorStd, background);
            Color foreground = UIManager.getDefaults().getColor("nb.output.foreground");
            if (foreground == null) {
                foreground = SystemColor.textText;
            }
            IOColors.setColor((InputOutput)this.io, (IOColors.OutputType)IOColors.OutputType.INPUT, (Color)BrowserConsoleLogger.shiftTowards(foreground, Color.GREEN));
        }
    }

    public void close() {
        LOG.fine("close() closing IO");
        this.reader.closing();
        this.io.getErr().close();
        this.io.getOut().close();
        try {
            this.io.getIn().close();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static Color shiftTowards(Color c, Color b) {
        return new Color((c.getRed() + b.getRed()) / 2, (c.getGreen() + b.getGreen()) / 2, (c.getBlue() + b.getBlue()) / 2);
    }

    public void messageAdded(ConsoleMessage message) {
        try {
            this.lastMessage = message;
            this.logMessage(message);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void messagesCleared() {
        LOG.fine("messagesCleared() resetting IO");
        try {
            this.io.getOut().reset();
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.setIOColors();
        this.io.setInputVisible(true);
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        catch (InterruptedException ex) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        this.io.getOut().print(PROMPT);
    }

    public void messageRepeatCountUpdated(int count) {
        LOG.log(Level.FINE, "messageRepeatCountUpdated({0})", count);
        try {
            this.logMessage(this.lastMessage);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static String getCurrentTime() {
        return formatter.format(new Date(System.currentTimeMillis()));
    }

    private boolean shouldLogMessage(ConsoleMessage msg) {
        if (msg == null) {
            return false;
        }
        String level = msg.getLevel();
        String source = msg.getSource();
        return !LEVEL_WARNING.equals(level) || !"css".equals(source);
    }

    private void logMessage(ConsoleMessage msg) throws IOException {
        if (!this.shouldLogMessage(msg)) {
            return;
        }
        this.io.getOut().print("\b\b");
        Project project = (Project)this.projectContext.lookup(Project.class);
        this.logMessage(msg, project);
        this.io.getOut().print(PROMPT);
        boolean isErr = LEVEL_ERROR.equals(msg.getLevel());
        if (this.io.isClosed() || isErr && !this.shownOnError.getAndSet(true)) {
            this.io.select();
        }
    }

    private void logMessage(ConsoleMessage msg, Project project) throws IOException {
        List subMessages;
        StringBuilder sb;
        String level = msg.getLevel();
        boolean isErr = LEVEL_ERROR.equals(level);
        String time = BrowserConsoleLogger.getCurrentTime();
        String logInfo = BrowserConsoleLogger.createLogInfo(time, level, msg.getSource(), msg.getType());
        OutputWriter ow = isErr ? this.io.getErr() : this.io.getOut();
        String[] lines = msg.getText().replace("\r", "").split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String singleMessageLine = lines[i];
            if (this.colorStdBrighter == null && i == lines.length - 1) {
                singleMessageLine = singleMessageLine + logInfo;
            }
            Object[] res = this.tryToConvertLineToHyperlink(project, singleMessageLine);
            MyListener l = null;
            String newMessage1 = null;
            String newMessage2 = null;
            if (res != null) {
                l = (MyListener)res[0];
                newMessage1 = (String)res[1];
                newMessage2 = (String)res[2];
            }
            if (l != null && l.isValidHyperlink()) {
                if (this.colorStdBrighter != null && i == lines.length - 1) {
                    newMessage2 = newMessage2 + logInfo;
                }
                ow.print(newMessage1);
                ow.println(newMessage2, (OutputListener)l);
                continue;
            }
            ow.print(singleMessageLine);
            if (this.colorStdBrighter != null && i == lines.length - 1) {
                IOColorPrint.print((InputOutput)this.io, (CharSequence)logInfo, (Color)this.colorStdBrighter);
                continue;
            }
            ow.println("");
        }
        boolean doPrintStackTrace = LEVEL_ERROR.equals(level) || LEVEL_DEBUG.equals(level);
        boolean first = true;
        if (doPrintStackTrace && msg.getStackTrace() != null) {
            FoldHandle fold = null;
            if (this.isFoldingSupported) {
                fold = IOFolding.startFold((InputOutput)this.io, (boolean)false);
            }
            for (ConsoleMessage.StackFrame sf : msg.getStackTrace()) {
                String indent;
                if (first) {
                    indent = "    at ";
                    first = false;
                } else {
                    indent = "    at ";
                }
                ow.print(indent);
                ow.print(sf.getFunctionName());
                sb = new StringBuilder();
                String urlStr = sf.getURLString();
                urlStr = BrowserConsoleLogger.getProjectPath(project, urlStr);
                sb.append(" (").append(urlStr).append(":").append(sf.getLine()).append(":").append(sf.getColumn()).append(")");
                MyListener l = new MyListener(project, sf.getURLString(), sf.getLine(), sf.getColumn());
                if (l.isValidHyperlink()) {
                    ow.println(sb.toString(), (OutputListener)l);
                    continue;
                }
                ow.println(sb.toString());
            }
            if (fold != null) {
                fold.finish();
            }
        }
        if (first && msg.getURLString() != null && msg.getURLString().length() > 0) {
            MyListener l;
            ow.print("  at ");
            String url = msg.getURLString();
            String file = BrowserConsoleLogger.getProjectPath(project, url);
            sb = new StringBuilder(file);
            int line = msg.getLine();
            if (line != -1 && line != 0) {
                sb.append(":");
                sb.append(line);
            }
            if ((l = new MyListener(project, url, line, -1)).isValidHyperlink()) {
                ow.println(sb.toString(), (OutputListener)l);
            } else {
                ow.println(sb.toString());
            }
        }
        if (!(subMessages = msg.getSubMessages()).isEmpty()) {
            FoldHandle fold = null;
            if (this.isFoldingSupported) {
                fold = IOFolding.startFold((InputOutput)this.io, (boolean)false);
            }
            for (ConsoleMessage cm : subMessages) {
                this.logMessage(cm, project);
            }
            if (fold != null) {
                fold.finish();
            }
        }
    }

    void sessionWasClosed() {
        this.io.getOut().print("\b\b");
        this.io.getOut().println(Bundle.BrowserConsoleLoggerSessionClosed());
    }

    private Object[] tryToConvertLineToHyperlink(Project project, String line) {
        if (!line.endsWith(")")) {
            return this.tryToConvertLineURLToHyperlink(project, line);
        }
        int start = line.lastIndexOf(40);
        if (start == -1) {
            return null;
        }
        int lineNumberEnd = line.lastIndexOf(58);
        if (lineNumberEnd == -1) {
            return null;
        }
        int fileEnd = line.lastIndexOf(58, lineNumberEnd - 1);
        if (fileEnd == -1) {
            return null;
        }
        if (start >= fileEnd) {
            return null;
        }
        int lineNumber = -1;
        int columnNumber = -1;
        try {
            lineNumber = Integer.parseInt(line.substring(fileEnd + 1, lineNumberEnd));
            columnNumber = Integer.parseInt(line.substring(lineNumberEnd + 1, line.length() - 1));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (columnNumber != -1 && lineNumber == -1) {
            lineNumber = columnNumber;
        }
        if (lineNumber == -1) {
            return null;
        }
        String file = line.substring(start + 1, fileEnd);
        if (file.length() == 0) {
            return null;
        }
        String s1 = line.substring(0, start);
        String s2 = "(" + BrowserConsoleLogger.getProjectPath(project, file) + line.substring(fileEnd, line.length());
        MyListener l = new MyListener(project, file, lineNumber, columnNumber);
        return new Object[]{l, s1, s2};
    }

    private Object[] tryToConvertLineURLToHyperlink(Project project, String line) {
        int col2;
        int u1 = line.indexOf("http://");
        if (u1 < 0) {
            u1 = line.indexOf("https://");
        }
        if (u1 < 0) {
            return null;
        }
        int ue = line.indexOf(32, u1);
        if (ue < 0) {
            ue = line.length();
        }
        if ((col2 = line.lastIndexOf(58, ue)) < 0) {
            return null;
        }
        int col1 = line.lastIndexOf(58, col2 - 1);
        if (col1 < 0) {
            return null;
        }
        int lineNumber = -1;
        int columnNumber = -1;
        try {
            lineNumber = Integer.parseInt(line.substring(col1 + 1, col2));
            columnNumber = Integer.parseInt(line.substring(col2 + 1, ue));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (columnNumber != -1 && lineNumber == -1) {
            lineNumber = columnNumber;
        }
        if (lineNumber == -1) {
            return null;
        }
        String file = line.substring(u1, col1);
        if (file.length() == 0) {
            return null;
        }
        String s1 = line.substring(0, u1);
        String s2 = line.substring(u1, line.length());
        MyListener l = new MyListener(project, file, lineNumber, columnNumber);
        return new Object[]{l, s1, s2};
    }

    private static String createLogInfo(String time, String level, String source, String type) {
        StringBuilder logInfoBuilder = new StringBuilder(" (");
        logInfoBuilder.append(time);
        boolean separator = false;
        if (!LOG_IGNORED.equals(level) && !level.isEmpty()) {
            separator = true;
            logInfoBuilder.append(TIME_SEPARATOR);
            logInfoBuilder.append(level);
        }
        if (!CONSOLE_API.equals(source) && !source.isEmpty()) {
            if (separator) {
                logInfoBuilder.append(", ");
            } else {
                logInfoBuilder.append(TIME_SEPARATOR);
            }
            logInfoBuilder.append(source);
        }
        if (!LOG_IGNORED.equals(type)) {
            if (separator) {
                logInfoBuilder.append(", ");
            } else {
                logInfoBuilder.append(TIME_SEPARATOR);
            }
            logInfoBuilder.append(type);
        }
        logInfoBuilder.append(")\n");
        return logInfoBuilder.toString();
    }

    public static String getProjectPath(Project project, String urlStr) {
        try {
            String relPath;
            FileObject fo;
            URL url = new URL(urlStr);
            if (project != null && (fo = ServerURLMapping.fromServer((Project)project, (URL)url)) != null && (relPath = FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)fo)) != null) {
                urlStr = relPath;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return urlStr;
    }

    void setInput(Console.InputCallback input) {
        this.input = input;
    }

    private static Line getLine(Project project, String filePath, int lineNumber) {
        FileObject fileObject;
        block20: {
            if (filePath == null || lineNumber < 0) {
                return null;
            }
            fileObject = null;
            try {
                File file;
                if (filePath.startsWith("http:") || filePath.startsWith("https:")) {
                    URL url;
                    try {
                        url = new URI(filePath).toURL();
                    }
                    catch (URISyntaxException usex) {
                        url = new URL(filePath);
                    }
                    if (project != null) {
                        fileObject = ServerURLMapping.fromServer((Project)project, (URL)url);
                    }
                    if (fileObject == null) {
                        fileObject = RemoteFileCache.getRemoteFile((URL)url);
                    }
                    break block20;
                }
                if (filePath.startsWith("file:/")) {
                    URI uri;
                    try {
                        uri = new URI(filePath);
                    }
                    catch (URISyntaxException usex) {
                        uri = null;
                    }
                    if (uri == null || uri.getQuery() != null || uri.getFragment() != null) {
                        uri = WebUtils.stringToUrl((String)WebUtils.urlToString((URL)new URL(filePath), (boolean)true)).toURI();
                    }
                    file = Utilities.toFile((URI)uri);
                } else {
                    file = new File(filePath);
                    if (!file.isAbsolute() && project != null) {
                        fileObject = BrowserConsoleLogger.findFileInProjecSources(project, filePath);
                    }
                }
                if (fileObject == null) {
                    fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                }
            }
            catch (IOException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (fileObject == null) {
            LOG.log(Level.FINE, "Cannot resolve \"{0}\"", filePath);
            return null;
        }
        LineCookie lineCookie = BrowserConsoleLogger.getLineCookie(fileObject);
        if (lineCookie == null) {
            LOG.log(Level.INFO, "No line cookie for \"{0}\"", fileObject);
            return null;
        }
        try {
            return lineCookie.getLineSet().getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException ioob) {
            List lines = lineCookie.getLineSet().getLines();
            if (lines.size() > 0) {
                return (Line)lines.get(lines.size() - 1);
            }
            return null;
        }
    }

    private static FileObject findFileInProjecSources(Project project, String filePath) {
        Sources sources = ProjectUtils.getSources((Project)project);
        for (String sourceType : KNOWN_SOURCE_TYPES) {
            SourceGroup[] sourceGroups;
            for (SourceGroup sourceGroup : sourceGroups = sources.getSourceGroups(sourceType)) {
                FileObject rootFolder = sourceGroup.getRootFolder();
                FileObject fileObject = rootFolder.getFileObject(filePath);
                if (fileObject == null) continue;
                return fileObject;
            }
        }
        return null;
    }

    public static LineCookie getLineCookie(FileObject fo) {
        LineCookie result = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fo);
            if (dataObject != null) {
                result = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
            }
        }
        catch (DataObjectNotFoundException e) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachSeverity((Throwable)e, (Level)Level.INFO));
        }
        return result;
    }

    private class ConsoleReader
    implements Runnable {
        private final BufferedReader r;
        private volatile boolean closing = false;

        public ConsoleReader(Reader r) {
            this.r = new BufferedReader(r);
        }

        void closing() {
            this.closing = true;
        }

        @Override
        public void run() {
            block3: {
                try {
                    while (!this.closing) {
                        String line = this.r.readLine();
                        LOG.log(Level.FINE, "Got line from Console Reader: \"{0}\"", line);
                        if (line == null) continue;
                        BrowserConsoleLogger.this.input.line(line);
                    }
                }
                catch (IOException ex) {
                    if (this.closing) break block3;
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            LOG.log(Level.FINE, "ConsoleReader has finished. Bye.");
        }
    }

    public static class MyListener
    implements OutputListener {
        private final String url;
        private final int line;
        private final int column;
        private final Project project;

        public MyListener(Project project, String url, int line, int column) {
            this.url = url;
            this.line = line;
            this.column = column;
            this.project = project;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            Line l = this.getLine();
            if (l != null) {
                l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, this.column != -1 ? this.column - 1 : -1);
            }
        }

        private Line getLine() {
            return BrowserConsoleLogger.getLine(this.project, this.url, this.line - 1);
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        public boolean isValidHyperlink() {
            return this.getLine() != null;
        }
    }
}

