/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.tooling.networkmonitor;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.webkit.debugging.api.console.ConsoleMessage;
import org.netbeans.modules.web.webkit.debugging.api.network.Network;
import org.netbeans.modules.web.webkit.tooling.console.BrowserConsoleLogger;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;

class ModelItem
implements PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor(ModelItem.class.getName(), 5);
    private final Network.Request request;
    private final Network.WebSocketRequest wsRequest;
    private ChangeListener changeListener;
    private String data = "";
    private final BrowserFamilyId browserFamilyId;
    private final Project project;
    private final AtomicBoolean dataLoaded = new AtomicBoolean(false);

    public ModelItem(Network.Request request, Network.WebSocketRequest wsRequest, BrowserFamilyId browserFamilyId, Project project) {
        this.request = request;
        this.wsRequest = wsRequest;
        this.browserFamilyId = browserFamilyId;
        this.project = project;
        if (this.request != null) {
            this.request.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.request));
        } else {
            this.wsRequest.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.wsRequest));
        }
    }

    public boolean canBeShownToUser() {
        if (this.wsRequest != null) {
            return true;
        }
        if ("script".equals(this.request.getInitiatorType()) && this.request.getResponse() != null && !"Image".equals(this.request.getResponseType()) || this.request.getResponse() != null && "XHR".equals(this.request.getResponseType())) {
            return true;
        }
        if (this.browserFamilyId == BrowserFamilyId.JAVAFX_WEBVIEW && "other".equals(this.request.getInitiatorType()) && this.request.getResponse() != null && !"Image".equals(this.request.getResponseType()) && !"Document".equals(this.request.getResponseType())) {
            return true;
        }
        if (this.request.getResponseCode() != -1 && this.request.getResponseCode() >= 400) {
            return true;
        }
        return this.request.isFailed();
    }

    public boolean hasPostData() {
        return this.request != null && this.request.getRequest().get((Object)"postData") != null;
    }

    public boolean hasResponseData() {
        return this.request != null && this.request.hasData();
    }

    public boolean hasFrames() {
        return this.wsRequest != null && !this.wsRequest.getFrames().isEmpty();
    }

    public boolean hasCallStack() {
        return this.request != null && this.request.getInitiator() != null && this.request.getInitiator().get((Object)"stackTrace") != null;
    }

    Project getProject() {
        return this.project;
    }

    Network.Request getRequest() {
        return this.request;
    }

    private String getPostData() {
        return (String)this.request.getRequest().get((Object)"postData");
    }

    String getURL() {
        String url = this.request != null ? (String)this.request.getRequest().get((Object)"url") : this.wsRequest.getURL();
        return url;
    }

    String getHTTPMethod() {
        String method = this.request != null ? (String)this.request.getRequest().get((Object)"method") : "WebSocket";
        return method;
    }

    int getStatus() {
        int status = 0;
        if (this.request != null) {
            status = this.request.getResponseCode();
        }
        return status;
    }

    String getContentType() {
        String contentType = null;
        if (this.hasResponseData()) {
            contentType = ModelItem.stripDownContentType((JSONObject)this.request.getResponse().get((Object)"headers"));
        }
        return contentType;
    }

    public String toString() {
        if (this.request != null) {
            String s = (String)this.request.getRequest().get((Object)"url");
            int index = (s = s.replace("http://", "").replace("https://", "").replace("file:///", "")).indexOf("?");
            if (index != -1) {
                s = s.substring(0, index);
            }
            return (String)this.request.getRequest().get((Object)"method") + " " + s;
        }
        String s = String.valueOf(this.wsRequest.getURL());
        s = s.replace("ws://", "");
        return s;
    }

    void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("Network.Request.Response.Data".equals(evt.getPropertyName())) {
            this.startLoadingData();
        }
        this.fireChange();
    }

    public JSONObject getRequestHeaders() {
        if (this.request != null) {
            JSONObject requestHeaders = (JSONObject)this.request.getRequest().get((Object)"headers");
            JSONObject r = this.request.getResponse();
            if (r != null && (r = (JSONObject)r.get((Object)"requestHeaders")) != null) {
                for (Object o : r.entrySet()) {
                    Map.Entry m = (Map.Entry)o;
                    requestHeaders.put(m.getKey(), m.getValue());
                }
            }
            return requestHeaders;
        }
        JSONObject r = this.wsRequest.getHandshakeRequest();
        if (r == null) {
            return null;
        }
        return (JSONObject)r.get((Object)"headers");
    }

    public JSONObject getResponseHeaders() {
        if (this.request != null) {
            JSONObject r = this.request.getResponse();
            if (r == null) {
                return null;
            }
            return (JSONObject)r.get((Object)"headers");
        }
        JSONObject r = this.wsRequest.getHandshakeResponse();
        if (r == null) {
            return null;
        }
        return (JSONObject)r.get((Object)"headers");
    }

    public void updateHeadersPane(JTextPane pane) {
        try {
            this.updateTextPaneImpl(pane);
            pane.setCaretPosition(0);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateTextPaneImpl(JTextPane pane) throws BadLocationException {
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        StyledDocument doc = pane.getStyledDocument();
        Style boldStyle = doc.addStyle("bold", defaultStyle);
        StyleConstants.setBold(boldStyle, true);
        Style errorStyle = doc.addStyle("error", defaultStyle);
        StyleConstants.setBold(errorStyle, true);
        StyleConstants.setForeground(errorStyle, Color.red);
        Style paragraphStyle = doc.addStyle("paragraph", defaultStyle);
        StyleConstants.setFontSize(paragraphStyle, StyleConstants.getFontSize(paragraphStyle) + 5);
        StyleConstants.setForeground(paragraphStyle, Color.gray);
        pane.setText("");
        if (this.request != null) {
            doc.insertString(doc.getLength(), "Request URL: ", boldStyle);
            doc.insertString(doc.getLength(), (String)this.request.getRequest().get((Object)"url") + "\n", defaultStyle);
            doc.insertString(doc.getLength(), "Method: ", boldStyle);
            doc.insertString(doc.getLength(), (String)this.request.getRequest().get((Object)"method") + "\n", defaultStyle);
            JSONObject r = this.getResponseHeaders();
            if (r != null) {
                int statusCode = this.request.getResponseCode();
                doc.insertString(doc.getLength(), "Status: ", boldStyle);
                String status = (String)r.get((Object)"Status");
                if (status == null) {
                    status = statusCode == -1 ? "" : "" + statusCode + " " + this.request.getResponse().get((Object)"statusText");
                }
                doc.insertString(doc.getLength(), status + "\n", statusCode >= 400 ? errorStyle : defaultStyle);
                Boolean fromCache = (Boolean)r.get((Object)"fromDiskCache");
                if (Boolean.TRUE.equals(fromCache)) {
                    doc.insertString(doc.getLength(), "From Disk Cache: ", boldStyle);
                    doc.insertString(doc.getLength(), "yes\n", defaultStyle);
                }
            } else if (this.request.isFailed()) {
                doc.insertString(doc.getLength(), "Status: ", boldStyle);
                doc.insertString(doc.getLength(), "Request was cancelled.\n", errorStyle);
            }
        } else {
            doc.insertString(doc.getLength(), "Request URL: ", boldStyle);
            doc.insertString(doc.getLength(), this.wsRequest.getURL() + "\n", defaultStyle);
            doc.insertString(doc.getLength(), "Status: ", boldStyle);
            if (this.wsRequest.getErrorMessage() != null) {
                doc.insertString(doc.getLength(), this.wsRequest.getErrorMessage() + "\n", errorStyle);
            } else {
                doc.insertString(doc.getLength(), this.wsRequest.isClosed() ? "Closed\n" : (this.wsRequest.getHandshakeResponse() == null ? "Opening\n" : "Open\n"), defaultStyle);
            }
        }
        JSONObject requestHeaders = this.getRequestHeaders();
        if (requestHeaders == null) {
            return;
        }
        doc.insertString(doc.getLength(), "\n", defaultStyle);
        doc.insertString(doc.getLength(), "Request Headers\n", paragraphStyle);
        this.printHeaders(pane, requestHeaders, doc, boldStyle, defaultStyle);
        if (this.getResponseHeaders() != null) {
            doc.insertString(doc.getLength(), "\n", defaultStyle);
            doc.insertString(doc.getLength(), "Response Headers\n", paragraphStyle);
            this.printHeaders(pane, this.getResponseHeaders(), doc, boldStyle, defaultStyle);
        }
    }

    private void printHeaders(JTextPane pane, JSONObject headers, StyledDocument doc, Style boldStyle, Style defaultStyle) throws BadLocationException {
        assert (headers != null);
        TreeSet<Object> keys = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((String)o1).compareToIgnoreCase((String)o2);
            }
        });
        keys.addAll(headers.keySet());
        for (Object e : keys) {
            String key = (String)e;
            doc.insertString(doc.getLength(), key + ": ", boldStyle);
            String value = (String)headers.get((Object)key);
            doc.insertString(doc.getLength(), value + "\n", defaultStyle);
        }
    }

    private void fireChange() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChangeListener l = ModelItem.this.changeListener;
                if (l != null) {
                    l.stateChanged(null);
                }
            }
        });
    }

    private void loadRequestData() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                assert (ModelItem.this.request.hasData());
                String res = ModelItem.this.request.getResponseData();
                ModelItem.this.data = res != null ? res : "";
                ModelItem.this.fireChange();
            }
        });
    }

    public void updateResponsePane(JEditorPane pane, boolean rawData) {
        if (!this.hasResponseData()) {
            return;
        }
        try {
            this.updateResponseDataImpl(pane, rawData);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void updateFramesPane(JEditorPane pane, boolean rawData) {
        if (!this.hasFrames()) {
            return;
        }
        try {
            this.updateFramesImpl(pane, rawData);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void startLoadingData() {
        if (!this.request.hasData() || !this.canBeShownToUser() || this.dataLoaded.getAndSet(true)) {
            return;
        }
        this.data = "loading...";
        this.loadRequestData();
    }

    private void updateResponseDataImpl(JEditorPane pane, boolean rawData) throws BadLocationException {
        assert (this.data != null);
        if (rawData || this.data.isEmpty()) {
            pane.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/plain"));
            pane.setText(this.data);
        } else {
            String contentType = this.getContentType();
            ModelItem.reformatAndUseRightEditor(pane, this.data, contentType);
        }
        pane.setCaretPosition(0);
    }

    private void updateFramesImpl(JEditorPane pane, boolean rawData) throws BadLocationException {
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        StyledDocument doc = (StyledDocument)pane.getDocument();
        Style timingStyle = doc.addStyle("timing", defaultStyle);
        StyleConstants.setForeground(timingStyle, Color.lightGray);
        Style infoStyle = doc.addStyle("comment", defaultStyle);
        StyleConstants.setForeground(infoStyle, Color.darkGray);
        StyleConstants.setBold(infoStyle, true);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
        pane.setText("");
        StringBuilder sb = new StringBuilder();
        int lastFrameType = -1;
        for (Network.WebSocketFrame f : this.wsRequest.getFrames()) {
            int opcode = f.getOpcode();
            if (opcode == 0) {
                opcode = lastFrameType;
            } else {
                lastFrameType = opcode;
            }
            if (opcode == 1) {
                if (!rawData) {
                    doc.insertString(doc.getLength(), formatter.format(f.getTimestamp()), timingStyle);
                    doc.insertString(doc.getLength(), f.getDirection() == Network.Direction.SEND ? " SENT " : " RECV ", timingStyle);
                }
                doc.insertString(doc.getLength(), f.getPayload() + "\n", defaultStyle);
                continue;
            }
            if (opcode == 2) {
                if (!rawData) {
                    doc.insertString(doc.getLength(), formatter.format(f.getTimestamp()), timingStyle);
                    doc.insertString(doc.getLength(), f.getDirection() == Network.Direction.SEND ? " SENT " : " RECV ", timingStyle);
                }
                doc.insertString(doc.getLength(), f.getPayload() + "\n", defaultStyle);
                continue;
            }
            if (opcode != 8) continue;
            if (!rawData) {
                doc.insertString(doc.getLength(), formatter.format(f.getTimestamp()), timingStyle);
                doc.insertString(doc.getLength(), f.getDirection() == Network.Direction.SEND ? " SENT " : " RECV ", timingStyle);
            }
            doc.insertString(doc.getLength(), "Frame closed\n", infoStyle);
        }
        this.data = sb.toString();
        pane.setCaretPosition(0);
    }

    public void updatePostDataPane(JEditorPane pane, boolean rawData) {
        if (this.hasPostData()) {
            if (rawData) {
                pane.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/plain"));
                pane.setText(this.getPostData());
            } else {
                String contentType = ModelItem.stripDownContentType(this.getRequestHeaders());
                ModelItem.reformatAndUseRightEditor(pane, this.getPostData(), contentType);
            }
        }
    }

    void updateCallStack(InputOutput io) {
        try {
            io.getOut().reset();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (this.hasCallStack()) {
            List callStack = this.request.getInitiatorCallStack();
            for (ConsoleMessage.StackFrame sf : callStack) {
                String projectUrl = BrowserConsoleLogger.getProjectPath(this.project, sf.getURLString());
                io.getOut().print(sf.getFunctionName() + " ");
                String text = "(" + projectUrl + ":" + sf.getLine() + ":" + sf.getColumn() + ")";
                BrowserConsoleLogger.MyListener l = new BrowserConsoleLogger.MyListener(this.project, sf.getURLString(), sf.getLine(), sf.getColumn());
                if (l.isValidHyperlink()) {
                    try {
                        io.getOut().println(text, (OutputListener)l);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    continue;
                }
                io.getOut().println(text);
            }
        }
    }

    boolean isError() {
        if (this.wsRequest != null) {
            return this.wsRequest.getErrorMessage() != null;
        }
        return this.request.isFailed() || this.request.getResponseCode() >= 400;
    }

    boolean isLive() {
        return this.wsRequest != null && !this.wsRequest.isClosed();
    }

    private static String stripDownContentType(JSONObject o) {
        assert (o != null);
        String contentType = (String)o.get((Object)"Content-Type");
        if (contentType == null) {
            contentType = (String)o.get((Object)"content-type");
        }
        if (contentType == null) {
            return null;
        }
        int index = contentType.indexOf(";");
        if (index != -1) {
            contentType = contentType.substring(0, index);
        }
        return contentType;
    }

    private static void reformatAndUseRightEditor(JEditorPane pane, String data, String contentType) {
        EditorKit editorKit;
        String json;
        if ("application/javascript".equals(contentType = contentType == null ? "text/plain" : contentType.trim()) && (json = ModelItem.getJSONPResponse(data)) != null) {
            data = json;
            contentType = "application/json";
        }
        if ("application/json".equals(contentType) || "text/x-json".equals(contentType)) {
            data = ModelItem.reformatJSON(data);
            contentType = "text/x-json";
        }
        if ("application/xml".equals(contentType)) {
            contentType = "text/xml";
        }
        try {
            editorKit = CloneableEditorSupport.getEditorKit((String)contentType);
        }
        catch (IllegalArgumentException iaex) {
            contentType = "text/plain";
            editorKit = CloneableEditorSupport.getEditorKit((String)contentType);
        }
        pane.setEditorKit(editorKit);
        pane.setText(data);
    }

    private static String reformatJSON(String data) {
        Object o = JSONValue.parse((String)data);
        StringBuilder sb = new StringBuilder();
        if (o instanceof JSONArray) {
            ModelItem.jsonPrettyPrintArray((JSONArray)o, sb, 0);
        } else if (o instanceof JSONObject) {
            ModelItem.jsonPrettyPrintObject((JSONObject)o, sb, 0);
        }
        return sb.toString();
    }

    private static void jsonPrettyPrintObject(JSONObject jsonObject, StringBuilder sb, int indent) {
        ModelItem.print(sb, "{\n", indent);
        boolean first = true;
        for (Object o : jsonObject.entrySet()) {
            if (!first) {
                sb.append(",\n");
            }
            Map.Entry en = (Map.Entry)o;
            Object value = en.getValue();
            String key = "\"" + en.getKey() + "\"";
            if (value instanceof JSONObject) {
                ModelItem.print(sb, key + ": ", indent + 2);
                ModelItem.jsonPrettyPrintObject((JSONObject)value, sb, indent + 2);
            } else if (value instanceof JSONArray) {
                ModelItem.print(sb, key + ": ", indent + 2);
                ModelItem.jsonPrettyPrintArray((JSONArray)value, sb, indent + 2);
            } else if (value instanceof String) {
                ModelItem.print(sb, key + ": \"" + ((String)value).replace("\"", "\\\"") + "\"", indent + 2);
            } else {
                ModelItem.print(sb, key + ": " + value, indent + 2);
            }
            first = false;
        }
        sb.append("\n");
        ModelItem.print(sb, "}", indent);
    }

    private static void jsonPrettyPrintArray(JSONArray jsonObject, StringBuilder sb, int indent) {
        ModelItem.print(sb, "[\n", indent);
        boolean first = true;
        for (Object value : jsonObject) {
            if (!first) {
                sb.append(",\n");
            }
            if (value instanceof JSONObject) {
                ModelItem.jsonPrettyPrintObject((JSONObject)value, sb, indent + 2);
            } else if (value instanceof JSONArray) {
                ModelItem.jsonPrettyPrintArray((JSONArray)value, sb, indent + 2);
            } else if (value instanceof String) {
                ModelItem.print(sb, "\"" + ((String)value).replace("\"", "\\\"") + "\"", indent + 2);
            } else {
                ModelItem.print(sb, String.valueOf(value), indent + 2);
            }
            first = false;
        }
        sb.append("\n");
        ModelItem.print(sb, "]", indent);
    }

    private static void print(StringBuilder sb, String text, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        sb.append(text);
    }

    static String getJSONPResponse(String data) {
        Pattern p = Pattern.compile("([0-9a-zA-Z_$]+?\\()([\\{\\[].*?[\\}\\]])(\\)[\\;]?[\n\r]?)", 32);
        Matcher m = p.matcher(data);
        if (m.matches()) {
            return m.group(2);
        }
        return null;
    }
}

