/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JComponent;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.project.ui.Hacks;
import org.netbeans.modules.project.ui.NewFileIterator;
import org.netbeans.modules.project.ui.NewProjectWizard;
import org.netbeans.modules.project.ui.TemplateChooserPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class NewFileWizard
extends TemplateWizard {
    public static final String INCLUDES_TEMPLATES_WITH_PROJECTS = "INCLUDES_TEMPLATES_WITH_PROJECTS";
    @NullAllowed
    private Project currP;
    private MessageFormat format;
    private final boolean includeTemplatesWithProject;

    @CheckForNull
    private Project getCurrentProject() {
        return this.currP;
    }

    private void setCurrentProject(@NullAllowed Project p) {
        this.currP = p;
    }

    public NewFileWizard(@NullAllowed Project project, boolean includeTemplatesWithProjects) {
        this.setCurrentProject(project);
        this.includeTemplatesWithProject = includeTemplatesWithProjects;
        this.putProperty(INCLUDES_TEMPLATES_WITH_PROJECTS, this.includeTemplatesWithProject);
        this.putProperty("project", this.getCurrentProject());
        this.format = new MessageFormat(NbBundle.getBundle(NewFileWizard.class).getString("LBL_NewFileWizard_MessageFormat"));
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                block8: {
                    if ("project".equals(evt.getPropertyName())) {
                        Project newProject = (Project)evt.getNewValue();
                        if (!Utilities.compareObjects((Object)NewFileWizard.this.getCurrentProject(), (Object)newProject)) {
                            NewFileWizard.this.setCurrentProject(newProject);
                            try {
                                if (Templates.getTemplate((WizardDescriptor)NewFileWizard.this) == null) break block8;
                                DataObject obj = DataObject.find((FileObject)Templates.getTemplate((WizardDescriptor)NewFileWizard.this));
                                Object unknownIterator = obj.getPrimaryFile().getAttribute("instantiatingIterator");
                                if (unknownIterator == null) {
                                    unknownIterator = obj.getPrimaryFile().getAttribute("templateWizardIterator");
                                }
                                if (unknownIterator == null) {
                                    try {
                                        obj.getPrimaryFile().setAttribute("instantiatingIterator", (Object)NewFileIterator.genericFileIterator());
                                    }
                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                }
                                Hacks.reloadPanelsInWizard(NewFileWizard.this, obj);
                            }
                            catch (DataObjectNotFoundException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            }
        });
    }

    public void updateState() {
        String title;
        super.updateState();
        String substitute = (String)this.getProperty("NewFileWizard_Title");
        if (substitute == null) {
            title = NbBundle.getBundle(NewFileWizard.class).getString("LBL_NewFileWizard_Title");
        } else {
            Object[] args = new Object[]{NbBundle.getBundle(NewFileWizard.class).getString("LBL_NewFileWizard_Subtitle"), substitute};
            title = this.format.format(args);
        }
        super.setTitle(title);
    }

    public void setTitle(String ignore) {
    }

    protected WizardDescriptor.Panel<WizardDescriptor> createTemplateChooser() {
        TemplateChooserPanel panel = new TemplateChooserPanel(this.getCurrentProject(), this.includeTemplatesWithProject);
        JComponent jc = (JComponent)panel.getComponent();
        jc.getAccessibleContext().setAccessibleName(NbBundle.getBundle(NewProjectWizard.class).getString("ACSN_NewFileWizard"));
        jc.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewProjectWizard.class).getString("ACSD_NewFileWizard"));
        return panel;
    }

    protected WizardDescriptor.Panel<WizardDescriptor> createTargetChooser() {
        SourceGroup[] sourceGroups;
        Project project = this.getCurrentProject();
        if (project != null) {
            Sources c = ProjectUtils.getSources((Project)project);
            sourceGroups = c.getSourceGroups("generic");
        } else {
            sourceGroups = new SourceGroup[]{};
        }
        return Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups).create();
    }
}

