/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

abstract class LookupSensitiveAction
extends BasicAction
implements Runnable,
LookupListener,
Presenter.Popup,
Presenter.Menu {
    static final Logger UILOG = Logger.getLogger("org.netbeans.ui.actions");
    private static final Logger LOG = Logger.getLogger(LookupSensitiveAction.class.getName());
    protected static final RequestProcessor RP = new RequestProcessor(LookupSensitiveAction.class);
    private Lookup lookup;
    private Class<?>[] watch;
    private boolean needsRefresh = true;
    private final Object RESULTS_LOCK = new Object();
    private boolean initialized = false;
    private Lookup.Result[] results;
    private boolean refreshing = false;

    public LookupSensitiveAction(Icon icon, Lookup lookup, Class[] watch) {
        super(null, icon);
        if (lookup == null) {
            lookup = LastActivatedWindowLookup.INSTANCE;
        }
        this.lookup = lookup;
        this.watch = watch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean init() {
        Object object = this.RESULTS_LOCK;
        synchronized (object) {
            if (this.initialized) {
                return false;
            }
            this.results = new Lookup.Result[this.watch.length];
            for (int i = 0; i < this.watch.length; ++i) {
                this.results[i] = this.lookup.lookupResult(this.watch[i]);
                this.results[i].allItems();
                LookupListener resultListener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)this.results[i]);
                this.results[i].addLookupListener(resultListener);
            }
            this.initialized = true;
            return true;
        }
    }

    @Override
    public Object getValue(String key) {
        this.init();
        if (this.needsRefresh) {
            this.doRefresh(true);
        }
        return super.getValue(key);
    }

    @Override
    public boolean isEnabled() {
        this.init();
        if (this.needsRefresh) {
            this.doRefresh(true);
        }
        return super.isEnabled();
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        boolean isKey;
        this.init();
        if (UILOG.isLoggable(Level.FINE) && !(isKey = e.getSource() instanceof JMenuItem ? false : !(e.getSource() instanceof JButton))) {
            LogRecord r = new LogRecord(Level.FINE, "UI_ACTION_BUTTON_PRESS");
            r.setResourceBundle(NbBundle.getBundle(LookupSensitiveAction.class));
            r.setParameters(new Object[]{e.getSource(), e.getSource().getClass().getName(), this, this.getClass().getName(), this.getValue("Name")});
            r.setLoggerName(UILOG.getName());
            UILOG.log(r);
        }
        this.actionPerformed(this.lookup);
    }

    protected final Lookup getLookup() {
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh(boolean immediate) {
        if (this.refreshing) {
            return;
        }
        this.refreshing = true;
        try {
            if (LOG.isLoggable(Level.FINER)) {
                LogRecord r = new LogRecord(Level.FINER, "LOG_ACTION_REFRESH");
                r.setResourceBundle(NbBundle.getBundle(LookupSensitiveAction.class));
                r.setParameters(new Object[]{this.getClass(), this.lookup});
                r.setLoggerName(LOG.getName());
                LOG.log(r);
            }
            this.refresh(this.lookup, immediate);
        }
        finally {
            this.refreshing = false;
        }
        this.needsRefresh = false;
    }

    protected abstract void actionPerformed(Lookup var1);

    protected abstract void refresh(Lookup var1, boolean var2);

    public void resultChanged(LookupEvent e) {
        if (this.refreshing) {
            return;
        }
        if (this.getPropertyChangeListeners().length == 0) {
            this.needsRefresh = true;
        } else {
            Mutex.EVENT.readAccess((Runnable)this);
        }
    }

    @Override
    public void run() {
        this.doRefresh(false);
    }

    public JMenuItem getMenuPresenter() {
        return new DynamicMenuItem(this, false);
    }

    public JMenuItem getPopupPresenter() {
        return new DynamicMenuItem(this, true);
    }

    static final class LastActivatedWindowLookup
    extends ProxyLookup
    implements PropertyChangeListener {
        static final Lookup INSTANCE = new LastActivatedWindowLookup();
        private final TopComponent.Registry reg = TopComponent.getRegistry();

        LastActivatedWindowLookup() {
            this.reg.addPropertyChangeListener((PropertyChangeListener)this);
            this.updateLookups();
        }

        private void updateLookups() {
            Node[] nodes = this.reg.getActivatedNodes();
            Lookup[] delegates = new Lookup[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                delegates[i] = nodes[i].getLookup();
            }
            this.setLookups(delegates);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if ("activatedNodes".equals(ev.getPropertyName())) {
                this.updateLookups();
            }
        }
    }

    private class DynamicMenuItem
    extends JMenuItem
    implements DynamicMenuContent {
        private AbstractAction action;
        private boolean popup;

        public DynamicMenuItem(AbstractAction action, boolean popup) {
            this.action = action;
            this.popup = popup;
            Actions.connect((JMenuItem)this, (Action)action, (boolean)popup);
        }

        public JComponent[] getMenuPresenters() {
            JMenuItem menuPresenter = new JMenuItem();
            Actions.connect((JMenuItem)menuPresenter, (Action)this.action, (boolean)this.popup);
            return new JComponent[]{menuPresenter};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }
    }
}

