/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.output.DataViewDBTable;
import org.netbeans.modules.db.dataview.output.DataViewTableUIModel;
import org.netbeans.modules.db.dataview.output.DataViewUI;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

class DataViewPageContext {
    public static final String PROP_pageSize = "pageSize";
    public static final String PROP_totalRows = "totalRows";
    public static final String PROP_currentPos = "currentPos";
    public static final String PROP_tableMetaData = "tableMetaData";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private int pageSize = 10;
    private int totalRows = -1;
    private int currentPos = 1;
    private DataViewDBTable tableMetaData = null;
    private final DataViewTableUIModel model = new DataViewTableUIModel(new DBColumn[0]);

    DataViewPageContext(int pageSize) {
        this.pageSize = pageSize;
    }

    public DataViewDBTable getTableMetaData() {
        return this.tableMetaData;
    }

    public void setTableMetaData(DataViewDBTable tableMetaData) {
        DataViewDBTable old = this.tableMetaData;
        this.tableMetaData = tableMetaData;
        this.firePropertyChange(PROP_tableMetaData, old, tableMetaData);
        this.resetEditableState();
    }

    void resetEditableState() {
        this.model.setEditable(this.tableMetaData == null ? false : this.tableMetaData.hasOneTable());
    }

    int getPageSize() {
        return this.pageSize;
    }

    synchronized void setPageSize(int pageSize) {
        int oldPageSize = this.pageSize;
        this.pageSize = pageSize;
        this.firePropertyChange(PROP_pageSize, oldPageSize, pageSize);
    }

    int getCurrentPos() {
        return this.currentPos;
    }

    private synchronized void setCurrentPos(int currentPos) {
        int oldPos = this.currentPos;
        this.currentPos = currentPos;
        this.firePropertyChange(PROP_currentPos, oldPos, currentPos);
    }

    synchronized void first() {
        this.setCurrentPos(1);
    }

    synchronized void previous() {
        this.setCurrentPos(this.getCurrentPos() - this.pageSize);
    }

    synchronized void next() {
        this.setCurrentPos(this.getCurrentPos() + this.pageSize);
    }

    synchronized void last() {
        if (this.pageSize < 1) {
            return;
        }
        int rem = this.totalRows % this.pageSize;
        int newCurrentPos = this.totalRows - (rem == 0 ? this.pageSize : rem) + 1;
        this.setCurrentPos(newCurrentPos);
    }

    DataViewTableUIModel getModel() {
        return this.model;
    }

    boolean isTotalRowCountAvailable() {
        return this.totalRows >= 0;
    }

    int getTotalRows() {
        return this.totalRows;
    }

    synchronized void setTotalRows(Integer totalCount) {
        if (totalCount == null) {
            totalCount = -1;
        }
        int oldTotalRows = this.totalRows;
        this.totalRows = totalCount;
        this.firePropertyChange(PROP_totalRows, oldTotalRows, totalCount);
    }

    boolean hasRows() {
        return this.model.getRowCount() > 0;
    }

    boolean hasNext() {
        if (this.pageSize == 0) {
            return false;
        }
        return this.currentPos + this.pageSize <= this.totalRows && this.hasRows() || this.totalRows < 0 && this.getModel().getRowCount() >= this.pageSize;
    }

    boolean hasOnePageOnly() {
        return this.pageSize == 0 || this.totalRows > 0 && this.totalRows < this.pageSize;
    }

    boolean hasPrevious() {
        return this.pageSize != 0 && this.currentPos - this.pageSize > 0 && this.hasRows();
    }

    boolean isLastPage() {
        return this.pageSize == 0 || this.currentPos + this.pageSize > this.totalRows && this.totalRows > 0;
    }

    boolean refreshRequiredOnInsert() {
        return this.pageSize == 0 || this.isLastPage() && this.model.getRowCount() <= this.pageSize;
    }

    String pageOf() {
        String curPage = NbBundle.getMessage(DataViewUI.class, (String)"LBL_not_available");
        String totalPages = NbBundle.getMessage(DataViewUI.class, (String)"LBL_not_available");
        if (this.pageSize == 0) {
            curPage = "1";
            totalPages = "1";
        }
        if (this.pageSize > 0 && this.currentPos >= 0) {
            curPage = Integer.toString(this.currentPos / this.pageSize + (this.pageSize == 1 ? 0 : 1));
        }
        if (this.pageSize > 0 && this.totalRows >= 0) {
            totalPages = Integer.toString(this.totalRows / this.pageSize + (this.totalRows % this.pageSize > 0 ? 1 : 0));
        }
        return NbBundle.getMessage(DataViewPageContext.class, (String)"LBL_page_of", (Object)curPage, (Object)totalPages);
    }

    synchronized void decrementRowSize(int count) {
        this.setTotalRows(this.getTotalRows() - count);
        if (this.pageSize == 0 || this.totalRows <= this.pageSize) {
            this.first();
        } else if (this.currentPos > this.totalRows) {
            this.previous();
        }
    }

    synchronized void incrementRowSize(int count) {
        this.setTotalRows(this.getTotalRows() + count);
        if (this.pageSize == 0 || this.totalRows <= this.pageSize) {
            this.first();
        } else if (this.currentPos > this.totalRows) {
            this.previous();
        }
    }

    protected void firePropertyChange(final String propertyName, final Object oldValue, final Object newValue) {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                DataViewPageContext.this.pcs.firePropertyChange(propertyName, oldValue, newValue);
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }
}

