/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Color;
import java.awt.Point;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultRowSorter;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.TransferHandler;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.renderer.CheckBoxProvider;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.JRendererCheckBox;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.table.TableColumnExt;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.table.JXTableDecorator;
import org.netbeans.modules.db.dataview.table.ResultSetCellRenderer;
import org.netbeans.modules.db.dataview.table.ResultSetTableModel;
import org.netbeans.modules.db.dataview.table.StringFallbackRowSorter;
import org.netbeans.modules.db.dataview.table.celleditor.AlwaysEnable;
import org.netbeans.modules.db.dataview.table.celleditor.BlobFieldTableCellEditor;
import org.netbeans.modules.db.dataview.table.celleditor.BooleanTableCellEditor;
import org.netbeans.modules.db.dataview.table.celleditor.ClobFieldTableCellEditor;
import org.netbeans.modules.db.dataview.table.celleditor.DateTimePickerCellEditor;
import org.netbeans.modules.db.dataview.table.celleditor.NumberFieldEditor;
import org.netbeans.modules.db.dataview.table.celleditor.StringTableCellEditor;
import org.netbeans.modules.db.dataview.util.BinaryToStringConverter;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;

public class ResultSetJXTable
extends JXTableDecorator {
    private static final String data = "WE WILL EITHER FIND A WAY, OR MAKE ONE.";
    private static final Logger mLogger = Logger.getLogger(ResultSetJXTable.class.getName());
    private static final int MAX_COLUMN_WIDTH = 25;
    private static final DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final int multiplier;
    private final TableModelListener dataExchangedListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getFirstRow() == -1) {
                ResultSetJXTable.this.updateHeader();
            }
        }
    };

    public ResultSetJXTable() {
        this.setAutoCreateColumnsFromModel(false);
        this.setTransferHandler(new TableTransferHandler());
        this.setShowGrid(true, true);
        this.setGridColor(GRID_COLOR);
        this.getTableHeader().setReorderingAllowed(false);
        this.setColumnControlVisible(true);
        this.getColumnControl().setToolTipText(NbBundle.getMessage(ResultSetJXTable.class, (String)"ResultSetJXTable.columnControl.tooltip"));
        this.setFillsViewportHeight(true);
        this.setHorizontalScrollEnabled(true);
        this.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)ROW_COLOR, (Color)ALTERNATE_ROW_COLOR)});
        this.addHighlighter((Highlighter)new ColorHighlighter(HighlightPredicate.ROLLOVER_ROW, ROLLOVER_ROW_COLOR, null));
        this.setDefaultCellRenderers();
        this.setDefaultCellEditors();
        this.multiplier = this.getFontMetrics(this.getFont()).stringWidth(data) / data.length() + 4;
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setModel(this.createDefaultDataModel());
        this.getActionMap().put("selectNextColumnCell", new EditingAwareAction(this.getActionMap().get("selectNextColumnCell")));
        this.getActionMap().put("selectPreviousColumnCell", new EditingAwareAction(this.getActionMap().get("selectPreviousColumnCell")));
        this.getActionMap().put("selectNextRowCell", new EditingAwareAction(this.getActionMap().get("selectNextRowCell")));
        this.getActionMap().put("selectNextPreviousCell", new EditingAwareAction(this.getActionMap().get("selectPreviousRowCell")));
        this.setSurrendersFocusOnKeystroke(true);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeaderImpl(this.columnModel);
    }

    protected RowSorter<? extends TableModel> createDefaultRowSorter() {
        return new StringFallbackRowSorter(this.getModel());
    }

    protected TableModel createDefaultDataModel() {
        return new ResultSetTableModel(new DBColumn[0]);
    }

    public <R extends TableModel> void setRowFilter(RowFilter<? super R, ? super Integer> filter) {
        if (this.getRowSorter() instanceof DefaultRowSorter) {
            ((DefaultRowSorter)this.getRowSorter()).setRowFilter(filter);
        } else {
            super.setRowFilter(filter);
        }
    }

    public void setModel(TableModel dataModel) {
        if (!(dataModel instanceof ResultSetTableModel)) {
            throw new IllegalArgumentException("TableModel for ResultSetJXTable must be an  instance of ResultSetTableModel");
        }
        if (this.getModel() != null) {
            this.getModel().removeTableModelListener(this.dataExchangedListener);
        }
        super.setModel(dataModel);
        this.updateHeader();
        dataModel.addTableModelListener(this.dataExchangedListener);
    }

    public ResultSetTableModel getModel() {
        return (ResultSetTableModel)super.getModel();
    }

    protected void setDefaultCellRenderers() {
        this.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new ResultSetCellRenderer()));
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new ResultSetCellRenderer()));
        this.setDefaultRenderer(Number.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((StringValue)StringValues.NUMBER_TO_STRING, 4)));
        this.setDefaultRenderer(Boolean.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((ComponentProvider<? extends JComponent>)new CheckBoxProvider())));
        this.setDefaultRenderer(Date.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((StringValue)StringValues.DATE_TO_STRING)));
        this.setDefaultRenderer(Time.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((StringValue)ResultSetCellRenderer.TIME_TO_STRING)));
        this.setDefaultRenderer(Timestamp.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((StringValue)ResultSetCellRenderer.DATETIME_TO_STRING)));
        this.setDefaultRenderer(java.util.Date.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((StringValue)ResultSetCellRenderer.DATETIME_TO_STRING)));
    }

    protected void setDefaultCellEditors() {
        KeyListener kl = this.createControKeyListener();
        JTextField txtFld = new JTextField();
        txtFld.addKeyListener(kl);
        this.setDefaultEditor(Object.class, new StringTableCellEditor(txtFld));
        this.setDefaultEditor(String.class, new StringTableCellEditor(txtFld));
        this.setDefaultEditor(Time.class, new StringTableCellEditor(txtFld));
        this.setDefaultEditor(Blob.class, new BlobFieldTableCellEditor());
        this.setDefaultEditor(Clob.class, new ClobFieldTableCellEditor());
        JTextField numFld = new JTextField();
        txtFld.addKeyListener(kl);
        this.setDefaultEditor(Number.class, new NumberFieldEditor(numFld));
        JRendererCheckBox b = new JRendererCheckBox();
        b.addKeyListener(kl);
        this.setDefaultEditor(Boolean.class, new BooleanTableCellEditor(b));
        try {
            DateTimePickerCellEditor dateEditor = new DateTimePickerCellEditor(new SimpleDateFormat("yyyy-MM-dd"));
            this.setDefaultEditor(Date.class, dateEditor);
        }
        catch (NullPointerException npe) {
            mLogger.log(Level.WARNING, "While creating DatePickerCellEditor was thrown " + npe, npe);
        }
        try {
            DateTimePickerCellEditor dateTimeEditor = new DateTimePickerCellEditor(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
            dateTimeEditor.addKeyListener(kl);
            this.setDefaultEditor(Timestamp.class, dateTimeEditor);
            this.setDefaultEditor(java.util.Date.class, dateTimeEditor);
        }
        catch (NullPointerException npe) {
            mLogger.log(Level.WARNING, "While creating DateTimePickerCellEditor was thrown " + npe, npe);
        }
    }

    protected KeyListener createControKeyListener() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }
        };
    }

    protected void updateHeader() {
        TableColumnModel dtcm = this.createDefaultColumnModel();
        DBColumn[] columns = this.getModel().getColumns();
        List<Integer> columnWidthList = this.getColumnWidthList(columns);
        for (int i = 0; i < columns.length; ++i) {
            TableColumnExt tc = this.getColumnFactory().createTableColumn(i);
            tc.setPreferredWidth(columnWidthList.get(i));
            DBColumn col = columns[i];
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            if (col.getDisplayName() != null) {
                sb.append(DataViewUtils.escapeHTML(col.getDisplayName()));
            }
            sb.append("</html>");
            tc.setHeaderValue(sb.toString());
            tc.setIdentifier(col.getDisplayName() == null ? "COL_" + i : col.getDisplayName());
            dtcm.addColumn((TableColumn)tc);
        }
        this.setColumnModel(dtcm);
    }

    private List<Integer> getColumnWidthList(DBColumn[] columns) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (DBColumn col : columns) {
            int labelWidth;
            int fieldWidth = col.getDisplaySize();
            int colWidth = Math.max(fieldWidth, labelWidth = col.getDisplayName().length()) * this.multiplier;
            if (colWidth < 5) {
                colWidth = 15 * this.multiplier;
            }
            if (colWidth > 25 * this.multiplier) {
                colWidth = 25 * this.multiplier;
            }
            result.add(colWidth);
        }
        return result;
    }

    public boolean isCellEditable(int row, int column) {
        if (this.getCellEditor(row, column) instanceof AlwaysEnable) {
            return true;
        }
        try {
            if (this.getModel() != null) {
                int modelRow = this.convertRowIndexToModel(row);
                int modelColumn = this.convertColumnIndexToModel(column);
                return this.getModel().isCellEditable(modelRow, modelColumn);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    protected String quoteIfNecessary(String value) {
        if (value == null || value.isEmpty()) {
            return "\"\"";
        }
        if (value.contains("\t") || value.contains("\n") || value.contains("\"")) {
            return "\"" + value.replace("\"", "\"\"") + "\"";
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String convertToClipboardString(Object o, int limitSize) {
        if (o instanceof Blob) {
            Blob b = (Blob)o;
            try {
                if (b.length() <= (long)limitSize) {
                    return BinaryToStringConverter.convertToString(b.getBytes(1L, (int)b.length()), 16, false);
                }
            }
            catch (SQLException ex) {}
        } else if (o instanceof Clob) {
            Clob c = (Clob)o;
            try {
                if (c.length() <= (long)limitSize) {
                    return c.getSubString(1L, (int)c.length());
                }
            }
            catch (SQLException ex) {}
        } else {
            if (o instanceof Time) {
                DateFormat dateFormat = timeFormat;
                synchronized (dateFormat) {
                    return timeFormat.format((java.util.Date)o);
                }
            }
            if (o instanceof Date) {
                DateFormat dateFormat = ResultSetJXTable.dateFormat;
                synchronized (dateFormat) {
                    return ResultSetJXTable.dateFormat.format((java.util.Date)o);
                }
            }
            if (o instanceof java.util.Date) {
                DateFormat dateFormat = timestampFormat;
                synchronized (dateFormat) {
                    return timestampFormat.format((java.util.Date)o);
                }
            }
            if (o == null) {
                return "";
            }
        }
        return o.toString();
    }

    private StringSelection createTransferableTSV(boolean withHeader) {
        try {
            int[] columns;
            int[] rows = this.getSelectedRows();
            if (this.getRowSelectionAllowed()) {
                columns = new int[this.getColumnCount()];
                for (int a = 0; a < columns.length; ++a) {
                    columns[a] = a;
                }
            } else {
                columns = this.getSelectedColumns();
            }
            if (rows != null && columns != null) {
                StringBuilder output = new StringBuilder();
                if (withHeader) {
                    for (int column = 0; column < columns.length; ++column) {
                        Object o;
                        if (column > 0) {
                            output.append('\t');
                        }
                        String s = (o = this.getColumnModel().getColumn(column).getIdentifier()) != null ? o.toString() : "";
                        output.append(this.quoteIfNecessary(s));
                    }
                    output.append('\n');
                }
                for (int row = 0; row < rows.length; ++row) {
                    for (int column = 0; column < columns.length; ++column) {
                        if (column > 0) {
                            output.append('\t');
                        }
                        Object o = this.getValueAt(rows[row], columns[column]);
                        String s = this.convertToClipboardString(o, 0x100000);
                        output.append(this.quoteIfNecessary(s));
                    }
                    output.append('\n');
                }
                return new StringSelection(output.toString());
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            Exceptions.printStackTrace((Throwable)exc);
            return null;
        }
    }

    protected void copyRowValues(boolean withHeader) {
        ExClipboard clipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
        StringSelection selection = this.createTransferableTSV(withHeader);
        clipboard.setContents((Transferable)selection, (ClipboardOwner)selection);
    }

    private class EditingAwareAction
    extends AbstractAction {
        private final Action delegate;

        public EditingAwareAction(Action delegate) {
            this.delegate = delegate;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean editing = ResultSetJXTable.this.isEditing();
            this.delegate.actionPerformed(e);
            if (editing) {
                ResultSetJXTable.this.editCellAt(ResultSetJXTable.this.getSelectedRow(), ResultSetJXTable.this.getSelectedColumn());
            }
        }
    }

    private class TableTransferHandler
    extends TransferHandler
    implements UIResource {
        private TableTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return ResultSetJXTable.this.createTransferableTSV(false);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    private class JTableHeaderImpl
    extends JXTableHeader {
        public JTableHeaderImpl(TableColumnModel cm) {
            super(cm);
        }

        public String getToolTipText(MouseEvent e) {
            return this.getColumnToolTipText(e);
        }

        protected String getColumnToolTipText(MouseEvent e) {
            Point p = e.getPoint();
            int index = this.columnModel.getColumnIndexAtX(p.x);
            try {
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                ResultSetTableModel tm = ResultSetJXTable.this.getModel();
                if (tm != null) {
                    return tm.getColumnTooltip(realIndex);
                }
                return "";
            }
            catch (ArrayIndexOutOfBoundsException aio) {
                return null;
            }
        }
    }
}

