/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.copy;

import java.awt.EventQueue;
import java.util.List;
import java.util.concurrent.Callable;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.RepositoryFile;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNNodeKind;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.copy.SwitchTo;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SwitchToAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Switch";
    }

    @Override
    protected int getFileEnabledStatus() {
        return -8;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return super.enable(nodes) && nodes.length == 1;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        SVNUrl fileUrl;
        SVNUrl rootUrl;
        VCSFileProxy interestingFile;
        VCSFileProxy[] roots;
        Context ctx;
        block4: {
            ctx = this.getContext(nodes);
            if (!Subversion.getInstance().checkClientAvailable(ctx)) {
                return;
            }
            roots = SvnUtils.getActionRoots(ctx);
            if (roots == null || roots.length == 0) {
                return;
            }
            interestingFile = roots.length == 1 ? roots[0] : SvnUtils.getPrimaryFile(roots[0]);
            rootUrl = null;
            fileUrl = null;
            try {
                rootUrl = ContextAction.getSvnUrl(ctx);
                fileUrl = SvnUtils.getRepositoryUrl(interestingFile);
            }
            catch (SVNClientException ex) {
                if (rootUrl != null) break block4;
                SvnClientExceptionHandler.notifyException(ctx, ex, true, true);
                return;
            }
        }
        RepositoryFile repositoryFile = new RepositoryFile(ctx.getFileSystem(), rootUrl, fileUrl == null ? rootUrl : fileUrl, SVNRevision.HEAD);
        boolean hasChanges = Subversion.getInstance().getStatusCache().containsFiles(ctx, 88532, true);
        RequestProcessor rp = this.createRequestProcessor(ctx);
        SwitchTo switchTo = new SwitchTo(repositoryFile, interestingFile, hasChanges);
        this.performSwitch(switchTo, rp, nodes, roots);
    }

    private void performSwitch(final SwitchTo switchTo, final RequestProcessor rp, final Node[] nodes, final VCSFileProxy[] roots) {
        if (!switchTo.showDialog()) {
            return;
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                if (!SwitchToAction.this.validateInput(roots[0], switchTo.getRepositoryFile())) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwitchToAction.this.performSwitch(switchTo, rp, nodes, roots);
                        }
                    });
                } else {
                    ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(SwitchToAction.this, nodes, SwitchToAction.this.getCachedContext(nodes)){

                        @Override
                        public void perform() {
                            final 2 supp = this;
                            try {
                                SvnUtils.runWithoutIndexing(new Callable<Void>(){

                                    @Override
                                    public Void call() throws Exception {
                                        for (VCSFileProxy root : roots) {
                                            RepositoryFile toRepositoryFile = switchTo.getRepositoryFile();
                                            if (root.isFile() && roots.length > 1) {
                                                toRepositoryFile = toRepositoryFile.replaceLastSegment(root.getName(), 0);
                                            }
                                            SwitchToAction.performSwitch(toRepositoryFile, root, supp);
                                        }
                                        return null;
                                    }
                                }, roots);
                            }
                            catch (SVNClientException ex) {
                                SvnClientExceptionHandler.notifyException(new Context(roots), ex, true, false);
                            }
                        }
                    };
                    support.start(rp);
                }
            }
        });
    }

    private boolean validateInput(VCSFileProxy root, RepositoryFile toRepositoryFile) {
        boolean ret = false;
        Context context = new Context(root);
        try {
            SvnClient client = Subversion.getInstance().getClient(context, toRepositoryFile.getRepositoryUrl());
            ISVNInfo info = client.getInfo(context, toRepositoryFile.getFileUrl());
            if (info.getNodeKind() == SVNNodeKind.DIR && root.isFile()) {
                SvnClientExceptionHandler.annotate(NbBundle.getMessage(SwitchToAction.class, (String)"LBL_SwitchFileToFolderError"));
                ret = false;
            } else if (info.getNodeKind() == SVNNodeKind.FILE && root.isDirectory()) {
                SvnClientExceptionHandler.annotate(NbBundle.getMessage(SwitchToAction.class, (String)"LBL_SwitchFolderToFileError"));
                ret = false;
            } else {
                ret = true;
            }
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(context, ex, true, true);
            return ret;
        }
        return ret;
    }

    static void performSwitch(RepositoryFile toRepositoryFile, VCSFileProxy root, SvnProgressSupport support) {
        VCSFileProxy[][] split = VCSFileProxySupport.splitFlatOthers((VCSFileProxy[])new VCSFileProxy[]{root});
        boolean recursive = split[0].length <= 0;
        try {
            SvnClient client;
            Context context = new Context(root);
            try {
                client = Subversion.getInstance().getClient(context, toRepositoryFile.getRepositoryUrl());
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException(context, ex, true, true);
                return;
            }
            client.switchToUrl(root, toRepositoryFile.getFileUrl(), toRepositoryFile.getRevision(), recursive);
            List<VCSFileProxy> switchedFiles = SvnUtils.listManagedRecursively(root);
            VCSFileProxy[] fileArray = switchedFiles.toArray(new VCSFileProxy[switchedFiles.size()]);
            Subversion.getInstance().getStatusCache().getLabelsCache().flushFileLabels(fileArray);
            Subversion.getInstance().refreshAnnotations(fileArray);
            Subversion.getInstance().versionedFilesChanged();
        }
        catch (SVNClientException ex) {
            support.annotate(ex);
        }
    }
}

