/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.properties;

import java.awt.EventQueue;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.subversion.remote.FileInformation;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.ISVNStatus;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.properties.Bundle;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.subversion.remote.versioning.util.VersioningInfo;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class VersioningInfoAction
extends ContextAction {
    private static final Logger LOG = Logger.getLogger(VersioningInfoAction.class.getName());

    @Override
    protected boolean enable(Node[] nodes) {
        return super.enable(nodes);
    }

    @Override
    protected int getFileEnabledStatus() {
        return 89598;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return 89598;
    }

    @Override
    public String getName() {
        return Bundle.CTL_VersioningInfoAction();
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_VersioningInfo";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        Context ctx = this.getContext(nodes);
        final VCSFileProxy[] roots = ctx.getRootFiles();
        if (roots == null || roots.length == 0) {
            LOG.log(Level.FINE, "No versioned folder in the selected context for {0}", nodes);
            return;
        }
        VCSFileProxy root = roots[0];
        SVNUrl repositoryUrl = null;
        try {
            repositoryUrl = ContextAction.getSvnUrl(ctx);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(ctx, ex, true, true);
            return;
        }
        if (repositoryUrl == null) {
            LOG.log(Level.WARNING, "Could not retrieve repository root for context file {0}", new Object[]{root});
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
        SvnProgressSupport support = new SvnProgressSupport(ctx.getFileSystem()){
            private FileStatusCache cache;

            @Override
            protected void perform() {
                Arrays.sort(roots, new Comparator<VCSFileProxy>(){

                    @Override
                    public int compare(VCSFileProxy f1, VCSFileProxy f2) {
                        return f1.getName().compareTo(f2.getName());
                    }
                });
                final LinkedHashMap<VCSFileProxy, LinkedHashMap<String, String>> properties = new LinkedHashMap<VCSFileProxy, LinkedHashMap<String, String>>(roots.length);
                this.cache = Subversion.getInstance().getStatusCache();
                for (VCSFileProxy root : roots) {
                    FileInformation fi = this.cache.getStatus(root);
                    LinkedHashMap<String, String> fileProps = new LinkedHashMap<String, String>();
                    properties.put(root, fileProps);
                    String relativePath = VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_Unknown");
                    try {
                        relativePath = SvnUtils.getRelativePath(root);
                    }
                    catch (SVNClientException ex) {
                        // empty catch block
                    }
                    fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_RelativePath"), relativePath);
                    fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_Status"), fi.getStatusText());
                    if ((fi.getStatus() & 0x15DF8) == 0) continue;
                    this.putPropsForVersioned(fileProps, root, fi);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VersioningInfo.show(properties);
                    }
                });
            }

            private void putPropsForVersioned(LinkedHashMap<String, String> fileProps, VCSFileProxy file, FileInformation fi) {
                ISVNStatus status = fi.getEntry(file);
                if (status == null || status.getUrl() == null) {
                    return;
                }
                FileStatusCache.FileLabelInfo labelInfo = this.cache.getLabelsCache().getLabelInfo(file, true);
                String repositoryRootUrl = VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_Unknown");
                String binaryString = labelInfo.getBinaryString();
                String stickyString = labelInfo.getStickyString();
                try {
                    SVNUrl url = SvnUtils.getRepositoryRootUrl(file);
                    if (url != null) {
                        repositoryRootUrl = SvnUtils.decodeToString(url);
                    }
                }
                catch (SVNClientException ex) {
                    // empty catch block
                }
                fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_RepositoryUrl"), status.getUrlString());
                fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_RepositoryRootUrl"), repositoryRootUrl);
                if (status.getRevision() != null && status.getRevision().getNumber() > 0L) {
                    fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_Revision"), status.getRevision().toString());
                }
                if (!"".equals(binaryString)) {
                    fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_Mime"), binaryString);
                }
                if (!"".equals(stickyString)) {
                    fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_Branch"), stickyString);
                }
                if ((fi.getStatus() & 0x14FF8) != 0) {
                    boolean lockedLocally;
                    boolean bl = lockedLocally = status.getLockOwner() != null;
                    if (lockedLocally) {
                        fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_Lock"), VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_LockPresent"));
                        fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_LockOwner"), status.getLockOwner());
                        if (status.getLockCreationDate() != null) {
                            fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_LockCreationDate"), DateFormat.getDateTimeInstance().format(status.getLockCreationDate()));
                        }
                        if (status.getLockComment() != null) {
                            fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_LockComment"), status.getLockComment());
                        }
                    }
                    try {
                        SvnClient client = Subversion.getInstance().getClient(file);
                        SVNUrl url = status.getUrl();
                        ISVNInfo info = null;
                        if (url == null) {
                            LOG.log(Level.WARNING, "putPropsForVersioned: though versioned it has no svn url: {0}, {1}, {2}, {3}, {4}", new Object[]{file, fi, status.getTextStatus(), status.getUrlString(), status.getFile()});
                        } else {
                            info = client.getInfo(new Context(file), url);
                        }
                        if (info != null) {
                            if (!lockedLocally && info.getLockOwner() != null) {
                                fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_Lock"), VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_LockRemote"));
                                fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_LockOwner"), info.getLockOwner());
                                if (info.getLockCreationDate() != null) {
                                    fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_LockCreationDate"), DateFormat.getDateTimeInstance().format(info.getLockCreationDate()));
                                }
                                if (info.getLockComment() != null) {
                                    fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_LockComment"), info.getLockComment());
                                }
                            }
                            fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_LastChangedAuthor"), info.getLastCommitAuthor());
                            fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_LastChangedDate"), DateFormat.getDateTimeInstance().format(info.getLastChangedDate()));
                            fileProps.put(VersioningInfoAction.getMessage("LBL_VersioningInfo_Property_LastChangedRevision"), info.getLastChangedRevision().toString());
                        }
                    }
                    catch (SVNClientException ex) {
                        LOG.log(Level.FINE, null, ex);
                    }
                }
            }
        };
        support.start(rp, repositoryUrl, NbBundle.getMessage(VersioningInfoAction.class, (String)"LBL_VersioningInfo_Progress"));
    }

    private static String getMessage(String resourceName) {
        return NbBundle.getMessage(VersioningInfoAction.class, (String)resourceName);
    }
}

