/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.versioning.util;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.subversion.remote.versioning.util.VCSHyperlinkProvider;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class VCSHyperlinkSupport {
    private static final Logger LOG = Logger.getLogger(VCSHyperlinkSupport.class.getName());
    private Map<String, List<Hyperlink>> linkers = new HashMap<String, List<Hyperlink>>();

    public <T extends Hyperlink> T getLinker(Class<T> t, int idx) {
        return this.getLinker(t, Integer.toString(idx));
    }

    public <T extends Hyperlink> T getLinker(Class<T> t, String idx) {
        List<Hyperlink> list = this.linkers.get(idx);
        if (list == null) {
            return null;
        }
        for (Hyperlink linker : list) {
            if (linker.getClass() != t) continue;
            return (T)linker;
        }
        return null;
    }

    public void add(Hyperlink l, int idx) {
        this.add(l, Integer.toString(idx));
    }

    public void add(Hyperlink l, String idx) {
        if (l == null) {
            return;
        }
        List<Hyperlink> list = this.linkers.get(idx);
        if (list == null) {
            list = new ArrayList<Hyperlink>();
        }
        list.add(l);
        this.linkers.put(idx, list);
    }

    public <T extends Hyperlink> void remove(Class<T> c, String idx) {
        if (c == null) {
            return;
        }
        List<Hyperlink> list = this.linkers.get(idx);
        if (list == null) {
            return;
        }
        Iterator<Hyperlink> it = list.iterator();
        while (it.hasNext()) {
            if (it.next().getClass() != c) continue;
            it.remove();
            return;
        }
    }

    public void remove(Hyperlink l, String idx) {
        if (l == null) {
            return;
        }
        List<Hyperlink> list = this.linkers.get(idx);
        if (list == null) {
            return;
        }
        list.remove(l);
    }

    public boolean mouseMoved(Point p, JComponent component, int idx) {
        return this.mouseMoved(p, component, Integer.toString(idx));
    }

    public boolean mouseMoved(Point p, JComponent component, String idx) {
        List<Hyperlink> list = this.linkers.get(idx);
        if (list == null) {
            return false;
        }
        for (Hyperlink linker : list) {
            if (!linker.mouseMoved(p, component)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(Point p, int idx) {
        return this.mouseClicked(p, Integer.toString(idx));
    }

    public boolean mouseClicked(Point p, String idx) {
        List<Hyperlink> list = this.linkers.get(idx);
        if (list == null) {
            return false;
        }
        for (Hyperlink linker : list) {
            if (!linker.mouseClicked(p)) continue;
            return true;
        }
        return false;
    }

    public void computeBounds(JTextPane textPane, int idx) {
        this.computeBounds(textPane, Integer.toString(idx));
    }

    public void computeBounds(JTextPane textPane, String idx) {
        List<Hyperlink> list = this.linkers.get(idx);
        if (list == null) {
            return;
        }
        for (Hyperlink linker : list) {
            linker.computeBounds(textPane);
        }
    }

    public static interface BoundsTranslator {
        public void correctTranslation(Container var1, Rectangle var2);
    }

    public static class AuthorLinker
    extends StyledDocumentHyperlink {
        private static final String AUTHOR_ICON_STYLE = "authorIconStyle";
        private Rectangle bounds;
        private final int docstart;
        private final int docend;
        private final String author;
        private final Style authorStyle;

        public AuthorLinker(Style authorStyle, StyledDocument sd, String author) throws BadLocationException {
            this(authorStyle, sd, author, null);
        }

        public AuthorLinker(Style authorStyle, StyledDocument sd, String author, String insertToChat) throws BadLocationException {
            this.author = author;
            this.authorStyle = authorStyle;
            int doclen = sd.getLength();
            int textlen = author.length();
            this.docstart = doclen;
            this.docend = doclen + textlen;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
            this.computeBounds(textPane, null);
        }

        public void computeBounds(JTextPane textPane, BoundsTranslator translator) {
            Rectangle tpBounds = textPane.getBounds();
            TextUI tui = textPane.getUI();
            this.bounds = new Rectangle();
            try {
                Rectangle startr = tui.modelToView(textPane, this.docstart, Position.Bias.Forward).getBounds();
                Rectangle endr = tui.modelToView(textPane, this.docend, Position.Bias.Backward).getBounds();
                this.bounds = new Rectangle(tpBounds.x + startr.x, startr.y, endr.x - startr.x, startr.height);
                if (null != translator) {
                    translator.correctTranslation(textPane, this.bounds);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        public boolean mouseClicked(Point p) {
            return this.bounds != null && this.bounds.contains(p);
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null && this.bounds.contains(p)) {
                component.setCursor(Cursor.getPredefinedCursor(12));
                component.setToolTipText(NbBundle.getMessage(VCSHyperlinkSupport.class, (String)"LBL_StartChat", (Object)this.author));
                return true;
            }
            return false;
        }

        @Override
        public void insertString(StyledDocument sd, Style style) throws BadLocationException {
            if (style == null) {
                style = this.authorStyle;
            }
            sd.insertString(sd.getLength(), this.author, style);
            String iconStyleName = AUTHOR_ICON_STYLE + this.author;
            Style iconStyle = sd.getStyle(iconStyleName);
            if (iconStyle == null) {
                iconStyle = sd.addStyle(iconStyleName, null);
            }
            sd.insertString(sd.getLength(), " ", style);
            sd.insertString(sd.getLength(), " ", iconStyle);
        }
    }

    public static class IssueLinker
    extends StyledDocumentHyperlink {
        private Rectangle[] bounds;
        private final int[] docstart;
        private final int[] docend;
        private final int[] start;
        private final int[] end;
        private final String text;
        private final VCSHyperlinkProvider hp;
        private final VCSFileProxy root;
        private final int length;
        private final Style issueHyperlinkStyle;

        private IssueLinker(VCSHyperlinkProvider hp, Style issueHyperlinkStyle, VCSFileProxy root, StyledDocument sd, String text, int[] spans) {
            this.length = spans.length / 2;
            this.docstart = new int[this.length];
            this.docend = new int[this.length];
            this.start = new int[this.length];
            this.end = new int[this.length];
            this.hp = hp;
            this.root = root;
            this.text = text;
            this.issueHyperlinkStyle = issueHyperlinkStyle;
            int i = 0;
            while (i < spans.length) {
                int spanstart;
                int spanend;
                int linkeridx = i / 2;
                if ((spanend = spans[i++]) < (spanstart = spans[i++])) {
                    LOG.warning("Hyperlink provider " + hp.getClass().getName() + " returns wrong spans [" + spanstart + "," + spanend + "]");
                    continue;
                }
                int doclen = sd.getLength();
                this.start[linkeridx] = spanstart;
                this.end[linkeridx] = spanend;
                this.docstart[linkeridx] = doclen + spanstart;
                this.docend[linkeridx] = doclen + spanend;
            }
        }

        public static IssueLinker create(VCSHyperlinkProvider hp, Style issueHyperlinkStyle, VCSFileProxy root, StyledDocument sd, String text) {
            int[] spans = hp.getSpans(text);
            if (spans == null) {
                return null;
            }
            if (spans.length % 2 != 0) {
                LOG.warning("Hyperlink provider " + hp.getClass().getName() + " returns wrong spans");
                return null;
            }
            if (spans.length > 0) {
                IssueLinker l = new IssueLinker(hp, issueHyperlinkStyle, root, sd, text, spans);
                return l;
            }
            return null;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
            this.computeBounds(textPane, null);
        }

        public void computeBounds(JTextPane textPane, BoundsTranslator translator) {
            Rectangle tpBounds = textPane.getBounds();
            TextUI tui = textPane.getUI();
            this.bounds = new Rectangle[this.length];
            for (int i = 0; i < this.length; ++i) {
                try {
                    Rectangle startr = tui.modelToView(textPane, this.docstart[i], Position.Bias.Forward);
                    Rectangle endr = tui.modelToView(textPane, this.docend[i], Position.Bias.Backward);
                    if (startr == null || endr == null) continue;
                    startr = startr.getBounds();
                    endr = endr.getBounds();
                    this.bounds[i] = new Rectangle(tpBounds.x + startr.x, startr.y, endr.x - startr.x, startr.height);
                    if (null == translator) continue;
                    translator.correctTranslation(textPane, this.bounds[i]);
                    continue;
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            for (int i = 0; i < this.start.length; ++i) {
                if (this.bounds == null || this.bounds[i] == null || !this.bounds[i].contains(p)) continue;
                component.setCursor(Cursor.getPredefinedCursor(12));
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseClicked(Point p) {
            for (int i = 0; i < this.start.length; ++i) {
                if (this.bounds == null || this.bounds[i] == null || !this.bounds[i].contains(p)) continue;
                this.hp.onClick(this.root, this.text, this.start[i], this.end[i]);
                return true;
            }
            return false;
        }

        @Override
        public void insertString(StyledDocument sd, Style style) throws BadLocationException {
            sd.insertString(sd.getLength(), this.text, style);
            for (int i = 0; i < this.length; ++i) {
                sd.setCharacterAttributes(sd.getLength() - this.text.length() + this.start[i], this.end[i] - this.start[i], this.issueHyperlinkStyle, false);
            }
        }
    }

    public static abstract class StyledDocumentHyperlink
    extends Hyperlink {
        public abstract void insertString(StyledDocument var1, Style var2) throws BadLocationException;
    }

    public static abstract class Hyperlink {
        public abstract boolean mouseMoved(Point var1, JComponent var2);

        public abstract boolean mouseClicked(Point var1);

        public abstract void computeBounds(JTextPane var1);
    }
}

