/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.overrides;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.navigation.overrides.BaseAnnotation;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

public class AnnotationsHolder
implements PropertyChangeListener,
Runnable {
    private static final Map<DataObject, AnnotationsHolder> file2holders = new HashMap<DataObject, AnnotationsHolder>();
    private final DataObject file;
    private final EditorCookie.Observable ec;
    private final RequestProcessor.Task task;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final List<BaseAnnotation> attachedAnnotations = new ArrayList<BaseAnnotation>();
    private final List<BaseAnnotation> pendingAnnotations = new ArrayList<BaseAnnotation>();
    private final ReentrantReadWriteLock attachedAnnotationsLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnnotationsHolder get(DataObject dao) {
        Map<DataObject, AnnotationsHolder> map = file2holders;
        synchronized (map) {
            AnnotationsHolder holder = file2holders.get(dao);
            if (holder != null) {
                return holder;
            }
            EditorCookie.Observable ec = (EditorCookie.Observable)dao.getLookup().lookup(EditorCookie.Observable.class);
            if (ec == null) {
                return null;
            }
            holder = new AnnotationsHolder(dao, ec);
            file2holders.put(dao, holder);
            return holder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearIfNeed(DataObject dao) {
        AnnotationsHolder holder;
        Map<DataObject, AnnotationsHolder> map = file2holders;
        synchronized (map) {
            holder = file2holders.remove(dao);
            if (holder != null) {
                holder.cancelled.set(true);
            }
        }
        if (holder != null) {
            holder.ec.removePropertyChangeListener((PropertyChangeListener)holder);
            holder.task.schedule(0);
        }
    }

    private AnnotationsHolder(DataObject file, EditorCookie.Observable ec) {
        this.file = file;
        this.ec = ec;
        Logger.getLogger("TIMER").log(Level.FINE, "Overridden AnnotationsHolder", new Object[]{file.getPrimaryFile(), this});
        this.task = new RequestProcessor("C/C++ Annotations Holder", 1).create((Runnable)this);
        ec.addPropertyChangeListener((PropertyChangeListener)this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AnnotationsHolder.this.checkForReset();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("openedPanes".endsWith(evt.getPropertyName()) || evt.getPropertyName() == null) {
            this.checkForReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<BaseAnnotation> toAdd;
        List<BaseAnnotation> list = this.pendingAnnotations;
        synchronized (list) {
            this.attachedAnnotationsLock.readLock().lock();
            try {
                for (BaseAnnotation a : this.attachedAnnotations) {
                    a.detachImpl();
                }
            }
            finally {
                this.attachedAnnotationsLock.readLock().unlock();
            }
            this.attachedAnnotationsLock.writeLock().lock();
            try {
                this.attachedAnnotations.clear();
            }
            finally {
                this.attachedAnnotationsLock.writeLock().unlock();
            }
            toAdd = new ArrayList<BaseAnnotation>(this.pendingAnnotations);
            this.pendingAnnotations.clear();
        }
        if (toAdd.isEmpty()) {
            return;
        }
        for (BaseAnnotation a : toAdd) {
            if (this.cancelled.get()) {
                return;
            }
            if (!a.attach()) continue;
            this.attachedAnnotationsLock.writeLock().lock();
            try {
                this.attachedAnnotations.add(a);
            }
            finally {
                this.attachedAnnotationsLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForReset() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.ec.getOpenedPanes() == null) {
            AnnotationsHolder remove;
            Map<DataObject, AnnotationsHolder> map = file2holders;
            synchronized (map) {
                remove = file2holders.remove(this.file);
                this.cancelled.set(true);
            }
            this.ec.removePropertyChangeListener((PropertyChangeListener)this);
            if (remove != null) {
                this.task.schedule(0);
            }
        } else {
            this.cancelled.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNewAnnotations(Collection<BaseAnnotation> annotations2set) {
        CndUtils.assertNonUiThread();
        List<BaseAnnotation> list = this.pendingAnnotations;
        synchronized (list) {
            this.pendingAnnotations.clear();
            this.pendingAnnotations.addAll(annotations2set);
        }
        this.task.schedule(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseAnnotation> getAttachedAnnotations() {
        CndUtils.assertUiThread();
        this.attachedAnnotationsLock.readLock().lock();
        try {
            ArrayList<BaseAnnotation> arrayList = new ArrayList<BaseAnnotation>(this.attachedAnnotations);
            return arrayList;
        }
        finally {
            this.attachedAnnotationsLock.readLock().unlock();
        }
    }
}

