/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.navigation.services.HierarchyModel;
import org.netbeans.modules.cnd.navigation.services.HierarchyModelImpl;
import org.netbeans.modules.cnd.navigation.services.IncludedModel;
import org.netbeans.modules.cnd.navigation.services.IncludedModelImpl;

public class HierarchyFactory {
    private HierarchyFactory() {
    }

    public static HierarchyFactory getInstance() {
        return new HierarchyFactory();
    }

    public HierarchyModel buildTypeHierarchyModel(CsmClass cls, Action[] actions, boolean subDirection, boolean plain, boolean recursive) {
        return new HierarchyModelImpl(cls, actions, subDirection, plain, recursive);
    }

    public IncludedModel buildIncludeHierarchyModel(CsmFile file, Action[] actions, boolean whoIncludes, boolean plain, boolean recursive) {
        if (whoIncludes && plain && !recursive) {
            Collection list = CsmIncludeHierarchyResolver.getDefault().getFiles(file);
            HashMap<CsmFile, Set<CsmFile>> map = new HashMap<CsmFile, Set<CsmFile>>();
            map.put(file, new HashSet(list));
            return new IncludedModelAdapter(actions, map, whoIncludes);
        }
        return new IncludedModelImpl(file, actions, whoIncludes, plain, recursive);
    }

    private static class IncludedModelAdapter
    implements IncludedModel {
        private final Map<CsmFile, Set<CsmFile>> map;
        private final Action[] actions;
        private Action close;
        private final boolean direction;

        public IncludedModelAdapter(Action[] actions, Map<CsmFile, Set<CsmFile>> map, boolean whoIncludes) {
            this.map = map;
            this.actions = actions;
            this.direction = whoIncludes;
        }

        @Override
        public Map<CsmFile, Set<CsmFile>> getModel() {
            return this.map;
        }

        @Override
        public Action[] getDefaultActions() {
            return this.actions;
        }

        @Override
        public Action getCloseWindowAction() {
            return this.close;
        }

        @Override
        public void setCloseWindowAction(Action close) {
            this.close = close;
        }

        @Override
        public boolean isDownDirection() {
            return !this.direction;
        }
    }
}

