/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.SecurityTableModel;
import org.openide.util.NbBundle;

public class MappingsTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Resource"), NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_File"), NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Jar"), NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Package"), NbBundle.getMessage(SecurityTableModel.class, (String)"LBL_Class")};
    private static final String[] attrNames = new String[]{"Resource", "File", "Jar", "Package", "Class"};
    private SessionFactory sessionFactory;

    public MappingsTableModel(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.sessionFactory == null) {
            return null;
        }
        String attrValue = this.sessionFactory.getAttributeValue("Mapping", row, attrNames[column]);
        return attrValue;
    }

    @Override
    public int getRowCount() {
        if (this.sessionFactory == null) {
            return 0;
        }
        return this.sessionFactory.sizeMapping();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void addRow(String[] values) {
        int index = this.sessionFactory.addMapping(true);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i].length() <= 0) continue;
            this.sessionFactory.setAttributeValue("Mapping", index, attrNames[i], values[i]);
        }
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public void editRow(int row, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.sessionFactory.setAttributeValue("Mapping", row, attrNames[i], values[i]);
        }
        this.fireTableRowsUpdated(row, row);
    }

    public void removeRow(int row) {
        this.sessionFactory.removeMapping(row);
        this.fireTableRowsDeleted(row, row);
    }
}

