/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.tool.hbm2x.HibernateMappingExporter;
import org.hibernate.tool.hbm2x.POJOExporter;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.cfg.model.HibernateConfiguration;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.spi.hibernate.HibernateFileLocationProvider;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.netbeans.modules.hibernate.wizards.HibernateCodGenNameLocationWizardDescriptor;
import org.netbeans.modules.hibernate.wizards.HibernateCodeGenWizardDescriptor;
import org.netbeans.modules.hibernate.wizards.HibernateCodeGenWizardHelper;
import org.netbeans.modules.hibernate.wizards.HibernateRevengDbTablesWizardDescriptor;
import org.netbeans.modules.hibernate.wizards.WizardErrorPanel;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HibernateCodeGenWizard
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private static final String PROP_HELPER = "wizard-helper";
    private int index;
    private Project project;
    private WizardDescriptor wizardDescriptor;
    private HibernateCodeGenWizardHelper helper;
    private HibernateCodGenNameLocationWizardDescriptor nameLocationDescriptor;
    private HibernateRevengDbTablesWizardDescriptor dbTablesDescriptor;
    private HibernateCodeGenWizardDescriptor codeGenDescriptor;
    private WizardDescriptor.Panel[] panels;
    private final String DEFAULT_REVENG_FILENAME = "hibernate.reveng";
    private final String CATALOG_NAME = "match-catalog";
    private final String EXCLUDE_NAME = "exclude";
    private final String ATTRIBUTE_NAME = "match-schema";
    private final String MATCH_NAME = "match-name";
    private final String resourceAttr = "resource";
    private final String classAttr = "class";
    private Logger logger = Logger.getLogger(HibernateCodeGenWizard.class.getName());

    public static HibernateCodeGenWizard create() {
        return new HibernateCodeGenWizard();
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            HibernateEnvironment hibernateEnv = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnv == null) {
                this.logger.log(Level.INFO, "Unsupported project {0}. Existing config wizard.", this.project);
                this.panels = new WizardDescriptor.Panel[]{WizardErrorPanel.getWizardErrorWizardPanel()};
            } else {
                this.panels = new WizardDescriptor.Panel[]{this.codeGenDescriptor};
            }
            String[] steps = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                if (steps[i] == null) {
                    steps[i] = c.getName();
                }
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    static HibernateCodeGenWizardHelper getHelper(WizardDescriptor wizardDescriptor) {
        return (HibernateCodeGenWizardHelper)wizardDescriptor.getProperty(PROP_HELPER);
    }

    public String name() {
        return NbBundle.getMessage(HibernateCodeGenWizard.class, (String)"Templates/Hibernate/CodeGen");
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public void addChangeListener(ChangeListener l) {
    }

    private String[] createSteps() {
        String[] beforeSteps = null;
        Object prop = this.wizardDescriptor.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        if (beforeSteps == null) {
            beforeSteps = new String[]{};
        }
        String[] res = new String[beforeSteps.length - 1 + this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeSteps.length - 1 ? beforeSteps[i] : this.panels[i - beforeSteps.length + 1].getComponent().getName();
        }
        return res;
    }

    private boolean foundRevengFileInProject(List<FileObject> revengFiles, String revengFileName) {
        for (FileObject fo : revengFiles) {
            if (!fo.getName().equals(revengFileName)) continue;
            return true;
        }
        return false;
    }

    public Set instantiate() throws IOException {
        assert (false) : "This method cannot be called if the class implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public final void initialize(WizardDescriptor wiz) {
        this.wizardDescriptor = wiz;
        this.project = Templates.getProject((WizardDescriptor)wiz);
        this.helper = new HibernateCodeGenWizardHelper(this.project);
        wiz.putProperty(PROP_HELPER, (Object)this.helper);
        String wizardTitle = NbBundle.getMessage(HibernateCodeGenWizard.class, (String)"Templates/Hibernate/CodeGen");
        this.nameLocationDescriptor = new HibernateCodGenNameLocationWizardDescriptor(this.project, wizardTitle);
        this.dbTablesDescriptor = new HibernateRevengDbTablesWizardDescriptor(this.project, wizardTitle);
        this.codeGenDescriptor = new HibernateCodeGenWizardDescriptor(this.project, wizardTitle);
        if (Templates.getTargetFolder((WizardDescriptor)wiz) == null) {
            FileObject location;
            HibernateFileLocationProvider provider = this.project != null ? (HibernateFileLocationProvider)this.project.getLookup().lookup(HibernateFileLocationProvider.class) : null;
            FileObject fileObject = location = provider != null ? provider.getSourceLocation() : null;
            if (location != null) {
                Templates.setTargetFolder((WizardDescriptor)wiz, (FileObject)location);
            }
        }
        if (wiz instanceof TemplateWizard) {
            HibernateEnvironment hibernateEnv = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            if (hibernateEnv == null) {
                return;
            }
            List<FileObject> revengFiles = hibernateEnv.getAllHibernateReverseEnggFileObjects();
            String targetName = "hibernate.reveng";
            if (!revengFiles.isEmpty() && this.foundRevengFileInProject(revengFiles, "hibernate.reveng")) {
                int revengFilesCount = revengFiles.size();
                targetName = "hibernate" + revengFilesCount++ + ".reveng";
                while (this.foundRevengFileInProject(revengFiles, targetName)) {
                    targetName = "hibernate" + revengFilesCount++ + ".reveng";
                }
            }
            ((TemplateWizard)wiz).setTargetName(targetName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateClasses(FileObject revengFile, ProgressHandle handle) throws IOException {
        JDBCMetaDataConfiguration cfg = null;
        ClassLoader oldClassLoader = null;
        File confFile = FileUtil.toFile((FileObject)this.helper.getConfigurationFile());
        File outputDirJava = FileUtil.toFile((FileObject)this.helper.getLocation().getRootFolder());
        File outputDirHbm = FileUtil.toFile((FileObject)HibernateUtil.getFirstSourceGroup(this.project).getRootFolder());
        try {
            POJOExporter exporter;
            this.logger.info("Setting up classloader");
            HibernateEnvironment env = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            List<URL> urls = env.getProjectClassPath(revengFile);
            HibernateCfgDataObject hibernateCfgDataObject = null;
            try {
                hibernateCfgDataObject = (HibernateCfgDataObject)DataObject.find((FileObject)this.helper.getConfigurationFile());
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
            if (hibernateCfgDataObject != null) {
                JDBCDriver jdbcDriver;
                HibernateConfiguration hCfg = hibernateCfgDataObject.getHibernateConfiguration();
                DatabaseConnection dbConnection = null;
                try {
                    dbConnection = HibernateUtil.getDBConnection(hCfg);
                }
                catch (DatabaseException ex) {
                    // empty catch block
                }
                if (dbConnection != null && (jdbcDriver = dbConnection.getJDBCDriver()) != null) {
                    urls.addAll(Arrays.asList(jdbcDriver.getURLs()));
                }
            }
            ClassLoader ccl = env.getProjectClassLoader(urls.toArray(new URL[0]));
            oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ccl);
            try {
                DefaultReverseEngineeringStrategy defaultStrategy;
                cfg = new JDBCMetaDataConfiguration();
                DefaultReverseEngineeringStrategy revStrategy = defaultStrategy = new DefaultReverseEngineeringStrategy();
                OverrideRepository or = new OverrideRepository();
                Configuration c = cfg.configure(confFile);
                or.addFile(FileUtil.toFile((FileObject)revengFile));
                revStrategy = or.getReverseEngineeringStrategy((ReverseEngineeringStrategy)revStrategy);
                ReverseEngineeringSettings settings = new ReverseEngineeringSettings((ReverseEngineeringStrategy)revStrategy);
                settings.setDefaultPackageName(this.helper.getPackageName());
                defaultStrategy.setSettings(settings);
                revStrategy.setSettings(settings);
                cfg.setReverseEngineeringStrategy(or.getReverseEngineeringStrategy((ReverseEngineeringStrategy)revStrategy));
                DataObject confDataObject = DataObject.find((FileObject)this.helper.getConfigurationFile());
                HibernateCfgDataObject hco = (HibernateCfgDataObject)confDataObject;
                HibernateConfiguration hibConf = hco.getHibernateConfiguration();
                DatabaseConnection dbconn = HibernateUtil.getDBConnection(hibConf);
                if (dbconn != null) {
                    dbconn.getJDBCConnection();
                }
                cfg.readFromJDBC();
                cfg.buildMappings();
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            try {
                if (this.helper.getDomainGen()) {
                    handle.progress(NbBundle.getMessage(HibernateCodeGenWizard.class, (String)"HibernateCodeGenerationPanel_WizardProgress_GenPOJO"), 1);
                    exporter = new POJOExporter((Configuration)cfg, outputDirJava);
                    exporter.getProperties().setProperty("jdk5", new Boolean(this.helper.getJavaSyntax()).toString());
                    exporter.getProperties().setProperty("ejb3", new Boolean(this.helper.getEjbAnnotation()).toString());
                    exporter.start();
                    FileUtil.refreshFor((File[])new File[]{outputDirJava});
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            try {
                if (this.helper.getHbmGen()) {
                    handle.progress(NbBundle.getMessage(HibernateCodeGenWizard.class, (String)"HibernateCodeGenerationPanel_WizardProgress_GenMapping"), 2);
                    exporter = new HibernateMappingExporter((Configuration)cfg, outputDirHbm);
                    exporter.start();
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        catch (Throwable throwable) {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            throw throwable;
        }
    }

    public void updateConfiguration() {
        try {
            DataObject confDataObject = DataObject.find((FileObject)this.helper.getConfigurationFile());
            HibernateCfgDataObject hco = (HibernateCfgDataObject)confDataObject;
            SessionFactory sf = hco.getHibernateConfiguration().getSessionFactory();
            HibernateEnvironment hibernateEnv = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
            FileObject pkg = SourceGroups.getFolderForPackage((SourceGroup)HibernateUtil.getFirstSourceGroup(this.project), (String)this.helper.getPackageName(), (boolean)false);
            boolean useJavaSourceLocation = false;
            if (pkg == null && this.helper.getDomainGen() && this.helper.getEjbAnnotation() && !this.helper.getHbmGen()) {
                String relativePkgName = this.helper.getPackageName().replace('.', '/');
                pkg = this.helper.getLocation().getRootFolder().getFileObject(relativePkgName);
                useJavaSourceLocation = true;
            }
            if (pkg != null && pkg.isFolder()) {
                pkg.getFileSystem().refresh(true);
                Enumeration enumeration = pkg.getChildren(true);
                if (this.helper.getDomainGen() && this.helper.getEjbAnnotation() && !this.helper.getHbmGen()) {
                    while (enumeration.hasMoreElements()) {
                        FileObject fo = (FileObject)enumeration.nextElement();
                        if (fo.getNameExt() == null || !fo.getMIMEType().equals("text/x-java")) continue;
                        int mappingIndex = sf.addMapping(true);
                        String javaFileName = useJavaSourceLocation ? HibernateUtil.getRelativeSourcePath(fo, this.helper.getLocation().getRootFolder()) : HibernateUtil.getRelativeSourcePath(fo, hibernateEnv.getSourceLocation());
                        String fileName = javaFileName.replaceAll("/", ".").substring(0, javaFileName.indexOf(".java", 0));
                        sf.setAttributeValue("Mapping", mappingIndex, "class", fileName);
                        hco.modelUpdatedFromUI();
                        hco.save();
                    }
                } else {
                    block3: while (enumeration.hasMoreElements()) {
                        FileObject fo = (FileObject)enumeration.nextElement();
                        if (fo.getNameExt() == null || !fo.getMIMEType().equals("text/x-hibernate-mapping+xml")) continue;
                        int mappingIndex = sf.addMapping(true);
                        String path = HibernateUtil.getRelativeSourcePath(fo, hibernateEnv.getSourceLocation());
                        for (int i = 0; i < mappingIndex; ++i) {
                            String tmpPath = sf.getAttributeValue("Mapping", i, "resource");
                            if (tmpPath == null ? path == null : tmpPath.equals(path)) continue block3;
                        }
                        sf.setAttributeValue("Mapping", mappingIndex, "resource", path);
                        hco.modelUpdatedFromUI();
                        hco.save();
                    }
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.panels = null;
    }

    public Set instantiate(ProgressHandle handle) throws IOException {
        handle.start(3);
        try {
            this.generateClasses(this.helper.getRevengFile(), handle);
            handle.progress(NbBundle.getMessage(HibernateCodeGenWizard.class, (String)"HibernateCodeGenerationPanel_WizardProgress_UpdateConf"), 3);
            this.updateConfiguration();
            return Collections.singleton(this.helper.getRevengFile());
        }
        catch (Exception e) {
            return Collections.EMPTY_SET;
        }
    }
}

