/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.qnavigator.navigator.LoadingNode;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorContent;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class NavigatorPanelUI
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private final NavigatorContent content;
    private final BeanTreeView navigatorPane;
    private final ExplorerManager explorerManager = new ExplorerManager();
    private final InstanceContent selectedNodes = new InstanceContent();
    private final Lookup lookup = new AbstractLookup((AbstractLookup.Content)this.selectedNodes);

    public NavigatorPanelUI(NavigatorContent content) {
        this.initComponents();
        this.content = content;
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.navigatorPane = new BeanTreeView();
        this.navigatorPane.setRootVisible(false);
        this.navigatorPane.setDropTarget(false);
        this.navigatorPane.setDragSource(false);
        this.add((Component)this.navigatorPane, "Center");
        this.explorerManager.setRootContext(content.getRoot());
        this.expandAll();
    }

    private void expandAll() {
        NavigatorModel model = this.content.getModel();
        if (model != null && model.getFilter().isExpandAll()) {
            this.navigatorPane.expandAll();
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    DataObject getDataObject() {
        return this.content.getDataObject();
    }

    void showWaitNode() {
        assert (SwingUtilities.isEventDispatchThread());
        this.navigatorPane.setRootVisible(true);
        this.explorerManager.setRootContext((Node)new LoadingNode());
    }

    void newContentReady() {
        Runnable update = new Runnable(){

            @Override
            public void run() {
                NavigatorPanelUI.this.navigatorPane.setRootVisible(false);
                NavigatorPanelUI.this.navigatorPane.setAutoWaitCursor(false);
                NavigatorPanelUI.this.explorerManager.setRootContext(NavigatorPanelUI.this.content.getRoot());
                NavigatorPanelUI.this.expandAll();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            update.run();
        } else {
            SwingUtilities.invokeLater(update);
        }
    }

    NavigatorContent getContent() {
        return this.content;
    }

    void selectNodes(Node[] nodes) {
        try {
            this.explorerManager.setSelectedNodes(nodes);
        }
        catch (IllegalArgumentException ex) {
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean result = super.requestFocusInWindow();
        this.navigatorPane.requestFocusInWindow();
        return result;
    }

    final Lookup getLookup() {
        return this.lookup;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            Node[] val = (Node[])evt.getNewValue();
            this.selectedNodes.set(Arrays.asList(val), null);
        }
    }
}

