/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public final class GlobalJavadocForBinaryImpl
implements JavadocForBinaryQueryImplementation {
    private static final Map<String, Boolean> knownGoodJavadoc = Collections.synchronizedMap(new HashMap());

    public JavadocForBinaryQuery.Result findJavadoc(URL root) {
        try {
            if (root.getProtocol().equals("jar")) {
                return this.findForBinaryRoot(root);
            }
            return this.findForSourceRoot(root);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    private JavadocForBinaryQuery.Result findForBinaryRoot(URL binaryRoot) throws MalformedURLException, MalformedURLException {
        URL jar = FileUtil.getArchiveFile((URL)binaryRoot);
        if (!jar.getProtocol().equals("file")) {
            Util.err.log(binaryRoot + " is not an archive file.");
            return null;
        }
        File binaryRootF = Utilities.toFile((URI)URI.create(jar.toExternalForm()));
        String n = binaryRootF.getName();
        if (!n.endsWith(".jar")) {
            Util.err.log(binaryRootF + " is not a *.jar");
            return null;
        }
        String cnbdashes = n.substring(0, n.length() - 4);
        NbPlatform supposedPlaf = null;
        for (NbPlatform plaf : NbPlatform.getPlatformsOrNot()) {
            if (!binaryRootF.getAbsolutePath().startsWith(plaf.getDestDir().getAbsolutePath() + File.separator)) continue;
            supposedPlaf = plaf;
            break;
        }
        if (supposedPlaf == null) {
            URL[] javadocRoots = ModuleList.getJavadocRootsForExternalModule(binaryRootF);
            if (javadocRoots.length > 0) {
                return this.findByDashedCNB(cnbdashes, javadocRoots, true);
            }
            Util.err.log(binaryRootF + " does not correspond to a known platform");
            return null;
        }
        Util.err.log("Platform in " + supposedPlaf.getDestDir() + " claimed to have Javadoc roots " + Arrays.asList(supposedPlaf.getJavadocRoots()));
        return this.findByDashedCNB(cnbdashes, supposedPlaf.getJavadocRoots(), true);
    }

    private JavadocForBinaryQuery.Result findForSourceRoot(URL root) throws MalformedURLException {
        NbModuleProject module;
        Project p;
        try {
            p = FileOwnerQuery.getOwner((URI)root.toURI());
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
        if (p != null && (module = (NbModuleProject)p.getLookup().lookup(NbModuleProject.class)) != null) {
            String cnb = module.getCodeNameBase();
            NbPlatform plaf = module.getPlatform(false);
            if (plaf != null) {
                Util.err.log("Platform in " + plaf.getDestDir() + " claimed to have Javadoc roots " + Arrays.asList(plaf.getJavadocRoots()));
                JavadocForBinaryQuery.Result r = this.findByDashedCNB(cnb.replace('.', '-'), plaf.getJavadocRoots(), false);
                if (r != null) {
                    return r;
                }
            }
        }
        return null;
    }

    @SuppressWarnings(value={"DE_MIGHT_IGNORE"})
    private JavadocForBinaryQuery.Result findByDashedCNB(String cnbdashes, URL[] roots, boolean allowRemote) throws MalformedURLException {
        final ArrayList<URL> candidates = new ArrayList<URL>();
        for (URL root : roots) {
            candidates.add(root);
            candidates.add(new URL(root, cnbdashes + '/'));
        }
        Iterator it = candidates.iterator();
        while (it.hasNext()) {
            URL u = (URL)it.next();
            if (URLMapper.findFileObject((URL)u) != null) continue;
            String uS = u.toString();
            Boolean knownGood = knownGoodJavadoc.get(uS);
            if (knownGood == null) {
                knownGood = false;
                if (allowRemote && uS.startsWith("http")) {
                    try {
                        new URL(u, "package-list").openStream().close();
                        knownGood = true;
                    }
                    catch (IOException x) {
                        // empty catch block
                    }
                    knownGoodJavadoc.put(uS, knownGood);
                }
            }
            if (knownGood.booleanValue()) continue;
            Util.err.log("No such Javadoc candidate URL " + u);
            it.remove();
        }
        if (candidates.isEmpty()) {
            return null;
        }
        return new JavadocForBinaryQuery.Result(){

            public URL[] getRoots() {
                return candidates.toArray(new URL[candidates.size()]);
            }

            public void addChangeListener(ChangeListener l) {
            }

            public void removeChangeListener(ChangeListener l) {
            }
        };
    }
}

