/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.FullSourceLoc;
import org.clang.basic.SourceLocation;
import org.clang.lex.ClangGlobals;
import org.clang.lex.Preprocessor;
import org.clang.lex.impl.LiteralSupportStatics;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.aliases.ushort;
import org.clank.support.void;
import org.llvm.adt.APInt;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorUInt;
import org.llvm.support.ConvertUTFGlobals;

public class CharLiteralParser
implements Destructors.ClassWithDestructor {
    private long Value;
    private short Kind;
    private boolean IsMultiChar;
    private boolean HadError;
    private SmallString UDSuffixBuf = new SmallString(32);
    private long UDSuffixOffset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharLiteralParser(char.ptr begin, char.ptr end, SourceLocation Loc, Preprocessor PP, short kind) {
        begin = Native.$tryClone((char.ptr)begin);
        SmallVectorUInt codepoint_buffer = null;
        APInt LitVal = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            this.HadError = false;
            this.Kind = kind;
            char.ptr TokBegin = Native.$tryClone((char.ptr)begin);
            if (this.Kind != 8) {
                begin.$preInc();
            }
            if (this.Kind == 10) {
                begin.$preInc();
            }
            assert (begin.$at(0) == 39) : "Invalid token lexed";
            begin.$preInc();
            if (end.$at(-1) != NativePointer.$((char)'\'')) {
                int UDSuffixEnd = end.$index();
                do {
                    end.$preDec();
                } while (end.$at(-1) != NativePointer.$((char)'\''));
                ClangGlobals.expandUCNs(this.UDSuffixBuf, new StringRef(end, UDSuffixEnd - end.$index()));
                this.UDSuffixOffset = end.$sub((abstract_iterator)TokBegin);
            }
            assert (end.$noteq((Object)begin)) : "Invalid token lexed";
            end.$preDec();
            assert (PP.getTargetInfo().getCharWidth() == 8) : "Assumes char is 8 bits";
            assert (PP.getTargetInfo().getIntWidth() <= 64 && (PP.getTargetInfo().getIntWidth() & 7) == 0) : "Assumes sizeof(int) on target is <= 64 and a multiple of char";
            assert (PP.getTargetInfo().getWCharWidth() <= 64) : "Assumes sizeof(wchar) on target is <= 64";
            codepoint_buffer = new SmallVectorUInt(4, 0L);
            codepoint_buffer.resize(end.$sub((abstract_iterator)begin));
            uint.ptr buffer_begin = (uint.ptr)Native.$tryClone((NativeCloneable)codepoint_buffer.ref$front().deref$ptr());
            uint.ptr buffer_end = (uint.ptr)buffer_begin.$add(codepoint_buffer.size());
            long largest_character_for_kind = 9 == this.Kind ? 0xFFFFFFFFL >> 32 - PP.getTargetInfo().getWCharWidth() : (10 == this.Kind ? 127L : (11 == this.Kind ? 65535L : (12 == this.Kind ? 0x10FFFFL : 127L)));
            while (begin.$noteq((Object)end)) {
                if (begin.$at(0) != NativePointer.$((char)'\\')) {
                    char.ptr start = Native.$tryClone((char.ptr)begin);
                    do {
                        begin.$preInc();
                    } while (begin.$noteq((Object)end) && begin.$star() != NativePointer.$((char)'\\'));
                    int tmp_in_start = start.$index();
                    uint.ptr tmp_out_start = (uint.ptr)Native.$tryClone((NativeCloneable)buffer_begin);
                    ConvertUTFGlobals.ConversionResult res = ConvertUTFGlobals.ConvertUTF8toUTF32((type.ptr)((type.ptr)Casts.reinterpret_cast(type.ptr.class, (void.ptr)start.$addr())), (char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)begin)), (type.ptr)buffer_begin.$addr(), (uint.ptr)buffer_end, (ConvertUTFGlobals.ConversionFlags)ConvertUTFGlobals.ConversionFlags.strictConversion);
                    if (res != ConvertUTFGlobals.ConversionResult.conversionOK) {
                        boolean NoErrorOnBadEncoding = this.isAscii();
                        long Msg = 623L;
                        if (NoErrorOnBadEncoding) {
                            Msg = 837L;
                        }
                        $c.clean($c.track((Object)PP.Diag(Loc, Msg)));
                        if (NoErrorOnBadEncoding) {
                            Native.$setIndex((char.ptr)start, (int)tmp_in_start);
                            buffer_begin = (uint.ptr)Native.$tryClone((NativeCloneable)tmp_out_start);
                            while (start.$noteq((Object)begin)) {
                                buffer_begin.$set((long)start.$star());
                                start.$preInc();
                                buffer_begin.$preInc();
                            }
                            continue;
                        }
                        this.HadError = true;
                        continue;
                    }
                    while (tmp_out_start.$less((Object)buffer_begin)) {
                        if (tmp_out_start.$star() > largest_character_for_kind) {
                            this.HadError = true;
                            $c.clean($c.track((Object)PP.Diag(Loc, 625L)));
                        }
                        tmp_out_start.$preInc();
                    }
                    continue;
                }
                if (begin.$at(1) == NativePointer.$((char)'u') || begin.$at(1) == NativePointer.$((char)'U')) {
                    ushort.ref UcnLen = NativePointer.create_ushort$ref((int)0);
                    if (!LiteralSupportStatics.ProcessUCNEscape(TokBegin, begin, end, buffer_begin.star$ref(), UcnLen, new FullSourceLoc(Loc, PP.getSourceManager()), PP.getDiagnostics(), PP.getLangOpts(), true)) {
                        this.HadError = true;
                    } else if (buffer_begin.$star() > largest_character_for_kind) {
                        this.HadError = true;
                        $c.clean($c.track((Object)PP.Diag(Loc, 625L)));
                    }
                    buffer_begin.$preInc();
                    continue;
                }
                long CharWidth = LiteralSupportStatics.getCharWidth(this.Kind, PP.getTargetInfo());
                bool.ref _HadError = NativePointer.create_bool$ref();
                long result = LiteralSupportStatics.ProcessCharEscape(TokBegin, begin, end, _HadError, new FullSourceLoc(Loc, PP.getSourceManager()), CharWidth, PP.getDiagnostics(), PP.getLangOpts());
                this.HadError = _HadError.$deref();
                buffer_begin.$set(result);
                buffer_begin.$preInc();
            }
            long NumCharsSoFar = buffer_begin.$sub((abstract_iterator)codepoint_buffer.ref$front().deref$ptr());
            if (NumCharsSoFar > 1L) {
                if (this.isWide()) {
                    $c.clean($c.track((Object)PP.Diag(Loc, 858L)));
                } else if (this.isAscii() && NumCharsSoFar == 4L) {
                    $c.clean($c.track((Object)PP.Diag(Loc, 765L)));
                } else if (this.isAscii()) {
                    $c.clean($c.track((Object)PP.Diag(Loc, 773L)));
                } else {
                    $c.clean($c.track((Object)PP.Diag(Loc, 680L)));
                }
                this.IsMultiChar = true;
            } else {
                this.IsMultiChar = false;
            }
            LitVal = new APInt(JavaDifferentiators.Uint_uint64_t.INSTANCE, PP.getTargetInfo().getIntWidth(), 0L);
            boolean multi_char_too_long = false;
            if (this.isAscii() && this.isMultiChar()) {
                LitVal.$assign(0L);
                for (long i = 0L; i < NumCharsSoFar; ++i) {
                    multi_char_too_long |= LitVal.countLeadingZeros() < 8;
                    LitVal.$lshiftassign(8);
                    $c.clean((Object)LitVal.$assignMove((APInt)$c.track((Object)LitVal.$plus(codepoint_buffer.$at(i) & 0xFFL))));
                }
            } else if (NumCharsSoFar > 0L) {
                LitVal.$assign(buffer_begin.$at(-1));
            }
            if (!this.HadError && multi_char_too_long) {
                $c.clean($c.track((Object)PP.Diag(Loc, 841L)));
            }
            this.Value = LitVal.getZExtValue();
            if (this.isAscii() && NumCharsSoFar == 1L && (this.Value & 0x80L) != 0L && PP.getLangOpts().CharIsSigned) {
                this.Value = (byte)this.Value;
            }
        }
        finally {
            if (LitVal != null) {
                LitVal.$destroy();
            }
            if (codepoint_buffer != null) {
                codepoint_buffer.$destroy();
            }
            $c.$destroy();
        }
    }

    public boolean hadError() {
        return this.HadError;
    }

    public boolean isAscii() {
        return this.Kind == 8;
    }

    public boolean isWide() {
        return this.Kind == 9;
    }

    public boolean isUTF16() {
        return this.Kind == 11;
    }

    public boolean isUTF32() {
        return this.Kind == 12;
    }

    public boolean isMultiChar() {
        return this.IsMultiChar;
    }

    public long getValue() {
        return this.Value;
    }

    public StringRef getUDSuffix() {
        return this.UDSuffixBuf.$StringRef();
    }

    public long getUDSuffixOffset() {
        assert (!this.UDSuffixBuf.empty()) : "no ud-suffix";
        return this.UDSuffixOffset;
    }

    public void $destroy() {
        if (this.UDSuffixBuf != null) {
            this.UDSuffixBuf.$destroy();
        }
    }
}

