/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import java.util.Arrays;
import org.clang.basic.ClangGlobals;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.tok;
import org.clang.lex.Preprocessor;
import org.clang.lex.SmallVectorToken;
import org.clang.lex.Token;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class MacroInfo
implements Destructors.ClassWithDestructor {
    private int Location;
    private int EndLocation;
    private IdentifierInfo[] ArgumentList;
    private int NumArguments;
    private SmallVectorToken ReplacementTokens;
    private static final SmallVectorToken DUMMY = SmallVectorToken.DEFAULT;
    private int DefinitionLength;
    private boolean IsDefinitionLengthCached;
    private boolean IsFunctionLike;
    private boolean IsC99Varargs;
    private boolean IsGNUVarargs;
    private boolean IsBuiltinMacro;
    private boolean HasCommaPasting;
    private boolean IsDisabled;
    private boolean IsUsed;
    private boolean IsAllowRedefinitionsWithoutWarning;
    private boolean IsWarnIfUnused;
    boolean FromASTFile;
    private boolean UsedForHeaderGuard;
    private int OwningModuleID;

    public void $destroy() {
        if (this.ReplacementTokens != DUMMY) {
            this.ReplacementTokens.set_size(0);
        }
    }

    protected MacroInfo() {
    }

    public MacroInfo(SourceLocation DefLoc) {
        this(DefLoc.getRawEncodingUInt());
    }

    public MacroInfo(int DefLoc) {
        this.Location = DefLoc;
        this.EndLocation = SourceLocation.getInvalid();
        this.ArgumentList = null;
        this.NumArguments = 0;
        this.ReplacementTokens = DUMMY;
        this.IsDefinitionLengthCached = false;
        this.IsFunctionLike = false;
        this.IsC99Varargs = false;
        this.IsGNUVarargs = false;
        this.IsBuiltinMacro = false;
        this.HasCommaPasting = false;
        this.IsDisabled = false;
        this.IsUsed = false;
        this.IsAllowRedefinitionsWithoutWarning = false;
        this.IsWarnIfUnused = false;
        this.FromASTFile = false;
        this.UsedForHeaderGuard = false;
    }

    public MacroInfo $assign(MacroInfo other) {
        this.Location = other.Location;
        this.EndLocation = other.EndLocation;
        this.ArgumentList = other.ArgumentList;
        this.NumArguments = other.NumArguments;
        this.ReplacementTokens = other.ReplacementTokens;
        this.DefinitionLength = other.DefinitionLength;
        this.IsDefinitionLengthCached = other.IsDefinitionLengthCached;
        this.IsFunctionLike = other.IsFunctionLike;
        this.IsC99Varargs = other.IsC99Varargs;
        this.IsGNUVarargs = other.IsGNUVarargs;
        this.IsBuiltinMacro = other.IsBuiltinMacro;
        this.HasCommaPasting = other.HasCommaPasting;
        this.IsDisabled = other.IsDisabled;
        this.IsUsed = other.IsUsed;
        this.IsAllowRedefinitionsWithoutWarning = other.IsAllowRedefinitionsWithoutWarning;
        this.IsWarnIfUnused = other.IsWarnIfUnused;
        this.FromASTFile = other.FromASTFile;
        this.OwningModuleID = other.OwningModuleID;
        return this;
    }

    public SourceLocation getDefinitionLoc() {
        return SourceLocation.getFromRawEncoding((int)this.Location);
    }

    public int getRawDefinitionLoc() {
        return this.Location;
    }

    public void setDefinitionEndLoc(SourceLocation EndLoc) {
        this.EndLocation = EndLoc.getRawEncodingUInt();
    }

    public void setDefinitionEndLoc(int EndLoc) {
        this.EndLocation = EndLoc;
    }

    public SourceLocation getDefinitionEndLoc() {
        return SourceLocation.getFromRawEncoding((int)this.EndLocation);
    }

    public int getRawDefinitionEndLoc() {
        return this.EndLocation;
    }

    public int getDefinitionLength(SourceManager SM) {
        if (this.IsDefinitionLengthCached) {
            return this.DefinitionLength;
        }
        return this.getDefinitionLengthSlow(SM);
    }

    public boolean isIdenticalTo(MacroInfo Other, Preprocessor PP, boolean Syntactically) {
        boolean Lexically;
        boolean bl = Lexically = !Syntactically;
        if (this.ReplacementTokens.size() != Other.ReplacementTokens.size() || this.getNumArgs() != Other.getNumArgs() || this.isFunctionLike() != Other.isFunctionLike() || this.isC99Varargs() != Other.isC99Varargs() || this.isGNUVarargs() != Other.isGNUVarargs()) {
            return false;
        }
        if (Lexically) {
            int I = 0;
            int OI = 0;
            while (I != this.NumArguments) {
                if (this.ArgumentList[I] != Other.ArgumentList[OI]) {
                    return false;
                }
                ++I;
                ++OI;
            }
        }
        int e = this.ReplacementTokens.size();
        for (int i = 0; i != e; ++i) {
            int RHSLen;
            Token A = this.ReplacementTokens.$at(i);
            Token B = Other.ReplacementTokens.$at(i);
            if (A.getKind() != B.getKind()) {
                return false;
            }
            if (i != 0 && (A.isAtStartOfLine() != B.isAtStartOfLine() || A.hasLeadingSpace() != B.hasLeadingSpace())) {
                return false;
            }
            if (A.getIdentifierInfo() != null || B.getIdentifierInfo() != null) {
                if (A.getIdentifierInfo() == B.getIdentifierInfo()) continue;
                if (Lexically) {
                    return false;
                }
                int AArgNum = this.getArgumentNum(A.getIdentifierInfo());
                if (AArgNum == -1) {
                    return false;
                }
                if (AArgNum == Other.getArgumentNum(B.getIdentifierInfo())) continue;
                return false;
            }
            SmallString LHSSpelling = PP.$getLHSTokenSpelling(A.getLength());
            SmallString RHSSpelling = PP.$getRHSTokenSpelling(B.getLength());
            int LHSLen = PP.copySpelling(A, LHSSpelling.$array(), 0);
            boolean $noteq = LHSLen != (RHSLen = PP.copySpelling(B, RHSSpelling.$array(), 0)) || LHSSpelling.$noteq((SmallVectorImplChar)RHSSpelling);
            PP.$releaseLHSTokenSpelling(LHSSpelling);
            PP.$releaseRHSTokenSpelling(RHSSpelling);
            if (!$noteq) continue;
            return false;
        }
        return true;
    }

    public void setIsBuiltinMacro() {
        this.setIsBuiltinMacro(true);
    }

    public void setIsBuiltinMacro(boolean Val) {
        this.IsBuiltinMacro = Val;
    }

    public void setIsUsed(boolean Val) {
        this.IsUsed = Val;
    }

    public void setIsAllowRedefinitionsWithoutWarning(boolean Val) {
        this.IsAllowRedefinitionsWithoutWarning = Val;
    }

    public void setIsWarnIfUnused(boolean val) {
        this.IsWarnIfUnused = val;
    }

    public void setArgumentList(SmallVector<IdentifierInfo> List2, BumpPtrAllocator PPAllocator) {
        assert (this.ArgumentList == null && this.NumArguments == 0) : "Argument list already set!";
        this.NumArguments = List2.size();
        if (this.NumArguments == 0) {
            return;
        }
        assert (this.NumArguments != 0);
        this.ArgumentList = new IdentifierInfo[this.NumArguments];
        for (int i = 0; i != this.NumArguments; ++i) {
            this.ArgumentList[i] = (IdentifierInfo)List2.$at(i);
        }
    }

    public boolean arg_empty() {
        return this.NumArguments == 0;
    }

    public type.ptr<IdentifierInfo> arg_begin() {
        llvm.errs().$out((CharSequence)"use $ArgumentList() and getNumArgs()\n");
        return NativePointer.create_type$ptr((Object[])this.ArgumentList);
    }

    public IdentifierInfo[] $ArgumentList() {
        return this.ArgumentList;
    }

    public type.ptr<IdentifierInfo> arg_end() {
        llvm.errs().$out((CharSequence)"use $ArgumentList() and getNumArgs()\n");
        return NativePointer.create_type$ptr((Object[])this.ArgumentList, (long)this.NumArguments);
    }

    public int getNumArgs() {
        return this.NumArguments;
    }

    public int getArgumentNum(IdentifierInfo Arg) {
        for (int I = 0; I != this.NumArguments; ++I) {
            if (this.ArgumentList[I] != Arg) continue;
            return I;
        }
        return -1;
    }

    public void setIsFunctionLike() {
        this.IsFunctionLike = true;
    }

    public boolean isFunctionLike() {
        return this.IsFunctionLike;
    }

    public boolean isObjectLike() {
        return !this.IsFunctionLike;
    }

    public void setIsC99Varargs() {
        this.IsC99Varargs = true;
    }

    public void setIsGNUVarargs() {
        this.IsGNUVarargs = true;
    }

    public boolean isC99Varargs() {
        return this.IsC99Varargs;
    }

    public boolean isGNUVarargs() {
        return this.IsGNUVarargs;
    }

    public boolean isVariadic() {
        return this.IsC99Varargs || this.IsGNUVarargs;
    }

    public boolean isBuiltinMacro() {
        return this.IsBuiltinMacro;
    }

    public boolean hasCommaPasting() {
        return this.HasCommaPasting;
    }

    public void setHasCommaPasting() {
        this.HasCommaPasting = true;
    }

    public boolean isUsed() {
        return this.IsUsed;
    }

    public boolean isAllowRedefinitionsWithoutWarning() {
        return this.IsAllowRedefinitionsWithoutWarning;
    }

    public boolean isWarnIfUnused() {
        return this.IsWarnIfUnused;
    }

    Token[] $ReplacementTokens() {
        return this.ReplacementTokens.$array();
    }

    public int getNumTokens() {
        return this.ReplacementTokens.size();
    }

    public Token getReplacementToken(int Tok) {
        assert (Tok < this.ReplacementTokens.size()) : "Invalid token #";
        return this.ReplacementTokens.$at(Tok);
    }

    public SmallVectorToken.iterator tokens_begin() {
        return this.ReplacementTokens.begin();
    }

    public SmallVectorToken.iterator tokens_end() {
        return this.ReplacementTokens.end();
    }

    public boolean tokens_empty() {
        return this.ReplacementTokens.empty();
    }

    public void AddTokenToBody(Token Tok) {
        assert (false) : "use setReplacementTokens at once";
        assert (!this.IsDefinitionLengthCached) : "Changing replacement tokens after definition length got calculated";
        this.ReplacementTokens.push_back(Tok);
    }

    void setReplacementTokens(SmallVectorToken BodyTokens) {
        assert (!this.IsDefinitionLengthCached) : "Changing replacement tokens after definition length got calculated";
        assert (this.ReplacementTokens == DUMMY);
        this.ReplacementTokens = BodyTokens.deepCopy();
    }

    public boolean isEnabled() {
        return !this.IsDisabled;
    }

    public void EnableMacro() {
        assert (this.IsDisabled) : "Cannot enable an already-enabled macro!";
        this.IsDisabled = false;
    }

    public void DisableMacro() {
        assert (!this.IsDisabled) : "Cannot disable an already-disabled macro!";
        this.IsDisabled = true;
    }

    public boolean isFromASTFile() {
        return this.FromASTFile;
    }

    public boolean isUsedForHeaderGuard() {
        return this.UsedForHeaderGuard;
    }

    public void setUsedForHeaderGuard(boolean Val) {
        this.UsedForHeaderGuard = Val;
    }

    public long getOwningModuleID() {
        if (this.isFromASTFile()) {
            return Unsigned.uint2long((int)this.OwningModuleID);
        }
        return 0L;
    }

    public void dump() {
        raw_ostream Out = llvm.errs();
        Out.$out(NativePointer.$((String)"MacroInfo ")).$out((Object)this);
        if (this.IsBuiltinMacro) {
            Out.$out(NativePointer.$((String)" builtin"));
        }
        if (this.IsDisabled) {
            Out.$out(NativePointer.$((String)" disabled"));
        }
        if (this.IsUsed) {
            Out.$out(NativePointer.$((String)" used"));
        }
        if (this.IsAllowRedefinitionsWithoutWarning) {
            Out.$out(NativePointer.$((String)" allow_redefinitions_without_warning"));
        }
        if (this.IsWarnIfUnused) {
            Out.$out(NativePointer.$((String)" warn_if_unused"));
        }
        if (this.FromASTFile) {
            Out.$out(NativePointer.$((String)" imported"));
        }
        if (this.UsedForHeaderGuard) {
            Out.$out(NativePointer.$((String)" header_guard"));
        }
        Out.$out(NativePointer.$((String)"\n    #define <macro>"));
        if (this.IsFunctionLike) {
            Out.$out(NativePointer.$((String)"("));
            for (int I = 0; I != this.NumArguments; ++I) {
                if (I != 0) {
                    Out.$out(NativePointer.$((String)", "));
                }
                Out.$out(this.ArgumentList[I].getName());
            }
            if (this.IsC99Varargs || this.IsGNUVarargs) {
                if (this.NumArguments != 0 && this.IsC99Varargs) {
                    Out.$out(NativePointer.$((String)", "));
                }
                Out.$out(NativePointer.$((String)"..."));
            }
            Out.$out(NativePointer.$((String)")"));
        }
        for (Token Tok : this.ReplacementTokens) {
            Out.$out(NativePointer.$((String)" "));
            char.ptr Punc = Native.$tryClone((char.ptr)tok.getPunctuatorSpelling((short)Tok.getKind()));
            if (Punc != null) {
                Out.$out(Punc);
                continue;
            }
            char.ptr Kwd = Native.$tryClone((char.ptr)tok.getKeywordSpelling((short)Tok.getKind()));
            if (Kwd != null) {
                Out.$out(Kwd);
                continue;
            }
            if (Tok.is((short)5)) {
                Out.$out(Tok.getIdentifierInfo().getName());
                continue;
            }
            if (Tok.isLiteral() && Tok.getLiteralData() != null) {
                Out.$out(new StringRef(Tok.getLiteralData(), Tok.getLength()));
                continue;
            }
            Out.$out(Tok.getName());
        }
    }

    private int getDefinitionLengthSlow(SourceManager SM) {
        assert (!this.IsDefinitionLengthCached);
        this.IsDefinitionLengthCached = true;
        if (this.ReplacementTokens.empty()) {
            this.DefinitionLength = 0;
            return 0;
        }
        Token firstToken = this.ReplacementTokens.front();
        Token lastToken = this.ReplacementTokens.back();
        int macroStart = firstToken.getRawLocation();
        int macroEnd = lastToken.getRawLocation();
        assert (SourceLocation.isValid((int)macroStart) && SourceLocation.isValid((int)macroEnd));
        assert (SourceLocation.isFileID((int)macroStart) || firstToken.is((short)4)) : "Macro defined in macro?";
        assert (SourceLocation.isFileID((int)macroEnd) || lastToken.is((short)4)) : "Macro defined in macro?";
        long startInfo = SM.getDecomposedExpansionLoc(macroStart);
        long endInfo = SM.getDecomposedExpansionLoc(macroEnd);
        assert (ClangGlobals.$first_FileID((long)startInfo) == ClangGlobals.$first_FileID((long)endInfo)) : "Macro definition spanning multiple FileIDs ?";
        assert (std.$second_uint((long)startInfo) <= std.$second_uint((long)endInfo));
        this.DefinitionLength = Unsigned.long2uint((long)(std.$second_uint((long)endInfo) - std.$second_uint((long)startInfo)));
        this.DefinitionLength += lastToken.getLength();
        return this.DefinitionLength;
    }

    void setOwningModuleID(long ID) {
        assert (this.isFromASTFile());
        this.OwningModuleID = Unsigned.long2uint((long)ID);
    }

    public String toString() {
        return "MacroInfo{Loc=[" + this.Location + "], EndLoc=[" + this.EndLocation + "]" + ", IsFunLike=" + this.IsFunctionLike + ", NumArgs=" + this.NumArguments + (this.NumArguments == 0 ? "" : ", Args=" + Arrays.toString(this.ArgumentList)) + ", BodyToks=" + this.ReplacementTokens + ", DefLen=" + this.DefinitionLength + ", IsDefLenCached=" + this.IsDefinitionLengthCached + ", IsC99Varargs=" + this.IsC99Varargs + ", IsGNUVarargs=" + this.IsGNUVarargs + ", IsBuiltinMacro=" + this.IsBuiltinMacro + ", HasCommaPasting=" + this.HasCommaPasting + ", IsDisabled=" + this.IsDisabled + ", IsUsed=" + this.IsUsed + ", IsAllowRedefinitionsWithoutWarning=" + this.IsAllowRedefinitionsWithoutWarning + ", IsWarnIfUnused=" + this.IsWarnIfUnused + ", FromASTFile=" + this.FromASTFile + ", OwningModuleID=" + this.OwningModuleID + '}';
    }
}

