/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.IdentifierInfo;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceRange;
import org.clang.basic.tok;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.support.raw_ostream;

public final class Token
implements Native.NativePOD<Token>,
NativeType.SizeofCapable {
    private int Loc;
    private int UintData;
    private Object PtrData;
    private byte[] CharPtrData;
    private int CharPtrDataIndex;
    private short Kind;
    private short Flags;
    private static int index;
    private static long instances;
    private static long failedCharPtrArray;
    private static long failedGetCharPtrArray;

    public short getKind() {
        return this.Kind;
    }

    public void setKind(short K) {
        this.Kind = K;
    }

    public boolean is(short K) {
        return this.Kind == K;
    }

    public boolean isNot(short K) {
        return this.Kind != K;
    }

    public boolean isAnyIdentifier() {
        return tok.isAnyIdentifier((short)this.Kind);
    }

    public boolean isLiteral() {
        return tok.isLiteral((short)this.Kind);
    }

    public boolean isAnnotation() {
        return tok.isAnnotation((short)this.Kind);
    }

    public SourceLocation getLocation() {
        return SourceLocation.getFromRawEncoding((int)this.Loc);
    }

    public int getRawLocation() {
        return this.Loc;
    }

    public int getLength() {
        assert (!this.isAnnotation()) : "Annotation tokens have no length field; kind:" + tok.getTokenName((short)this.getKind());
        assert (this.UintData >= 0);
        return this.UintData;
    }

    public void setLocation(SourceLocation L) {
        this.setLocation(L.getRawEncodingUInt());
    }

    public void setLocation(int L) {
        Token.isDebug(index);
        this.Loc = L;
    }

    public void setLength(long Len) {
        assert (!this.isAnnotation()) : "Annotation tokens have no length field; kind:" + tok.getTokenName((short)this.getKind());
        assert (Unsigned.long2uint((long)Len) >= 0);
        this.UintData = (int)Len;
    }

    public SourceLocation getAnnotationEndLoc() {
        assert (this.isAnnotation()) : "Used AnnotEndLocID on non-annotation token; kind:" + tok.getTokenName((short)this.getKind());
        return SourceLocation.getFromRawEncoding((int)this.UintData);
    }

    public void setAnnotationEndLoc(SourceLocation L) {
        this.setAnnotationEndLoc(L.getRawEncodingUInt());
    }

    public void setAnnotationEndLoc(int L) {
        assert (this.isAnnotation()) : "Used AnnotEndLocID on non-annotation token; kind:" + tok.getTokenName((short)this.getKind());
        this.UintData = L;
    }

    public SourceLocation getLastLoc() {
        return this.isAnnotation() ? this.getAnnotationEndLoc() : this.getLocation();
    }

    public SourceRange getAnnotationRange() {
        return new SourceRange(this.getRawLocation(), this.getAnnotationEndLoc().getRawEncodingUInt());
    }

    public void setAnnotationRange(SourceRange R) {
        this.setLocation(R.getRawBegin());
        this.setAnnotationEndLoc(R.getRawEnd());
    }

    public char.ptr getName() {
        return tok.getTokenName((short)this.Kind);
    }

    public void startToken() {
        Token.isDebug(index);
        this.Kind = 0;
        this.Flags = 0;
        this.PtrData = null;
        this.CharPtrData = null;
        this.CharPtrDataIndex = 0;
        this.UintData = 0;
        this.Loc = 0;
    }

    public void $destroy() {
        this.PtrData = null;
        this.CharPtrData = null;
    }

    public IdentifierInfo getIdentifierInfo() {
        assert (this.isNot((short)6)) : "getIdentifierInfo() on a tok::raw_identifier token! kind:" + tok.getTokenName((short)this.getKind());
        assert (!this.isAnnotation()) : "getIdentifierInfo() on an annotation token! kind:" + tok.getTokenName((short)this.getKind());
        if (this.isLiteral()) {
            return null;
        }
        if (this.is((short)1)) {
            return null;
        }
        return (IdentifierInfo)this.PtrData;
    }

    public void setIdentifierInfo(IdentifierInfo II) {
        this.PtrData = II;
        this.CharPtrData = null;
        this.CharPtrDataIndex = 0;
    }

    public Object getEofData() {
        assert (this.is((short)1)) : "unexpected kind:" + tok.getTokenName((short)this.getKind());
        return this.PtrData;
    }

    public void setEofData(Object D) {
        assert (this.is((short)1)) : "unexpected kind:" + tok.getTokenName((short)this.getKind());
        assert (this.PtrData == null);
        this.PtrData = D;
    }

    public StringRef getRawIdentifier() {
        assert (this.is((short)6)) : "unexpected kind:" + tok.getTokenName((short)this.getKind());
        if (this.CharPtrData == null) {
            return new StringRef((char.ptr)this.PtrData, this.getLength());
        }
        Token.trackFailedGetCharPtr();
        return new StringRef(NativePointer.create_char$ptr((byte[])this.CharPtrData, (long)this.CharPtrDataIndex), this.getLength());
    }

    public char.ptr getRawIdentifierData() {
        assert (this.is((short)6)) : "unexpected kind:" + tok.getTokenName((short)this.getKind());
        if (this.CharPtrData == null) {
            return (char.ptr)this.PtrData;
        }
        Token.trackFailedGetCharPtr();
        return NativePointer.create_char$ptr((byte[])this.CharPtrData, (long)this.CharPtrDataIndex);
    }

    boolean hasRawIdentiferData() {
        assert (this.is((short)6)) : "unexpected kind:" + tok.getTokenName((short)this.getKind());
        if (this.CharPtrData == null) {
            return this.PtrData instanceof char.ptr;
        }
        return true;
    }

    public byte[] $CharPtrData() {
        return this.CharPtrData;
    }

    public int $CharPtrDataIndex() {
        return this.CharPtrDataIndex;
    }

    public void setRawIdentifierData(char.ptr Ptr) {
        assert (this.is((short)6)) : "unexpected kind:" + tok.getTokenName((short)this.getKind());
        Token.trackFailedCharPtr();
        this.PtrData = Native.$toConst((char.ptr)Ptr);
        this.CharPtrData = null;
        this.CharPtrDataIndex = 0;
    }

    public void setRawIdentifierData(byte[] PtrArray, int PtrArIndex) {
        assert (this.is((short)6)) : "unexpected kind:" + tok.getTokenName((short)this.getKind());
        this.PtrData = null;
        this.CharPtrData = PtrArray;
        this.CharPtrDataIndex = PtrArIndex;
    }

    public char.ptr getLiteralData() {
        assert (this.isLiteral()) : "Cannot get literal data of non-literal kind:" + tok.getTokenName((short)this.getKind());
        if (this.CharPtrData == null) {
            return (char.ptr)this.PtrData;
        }
        Token.trackFailedGetCharPtr();
        return NativePointer.create_char$ptr((byte[])this.CharPtrData, (long)this.CharPtrDataIndex);
    }

    public void setLiteralData(char.ptr Ptr) {
        assert (this.isLiteral()) : "Cannot set literal data of non-literal kind:" + tok.getTokenName((short)this.getKind());
        Token.trackFailedCharPtr();
        this.PtrData = Native.$toConst((char.ptr)Ptr);
        this.CharPtrData = null;
        this.CharPtrDataIndex = 0;
    }

    public void setLiteralData(byte[] PtrArray, int PtrArIndex) {
        this.PtrData = null;
        this.CharPtrData = PtrArray;
        this.CharPtrDataIndex = PtrArIndex;
    }

    public Object getAnnotationValue() {
        assert (this.isAnnotation()) : "Used AnnotVal on non-annotation token kind:" + tok.getTokenName((short)this.getKind());
        return this.PtrData;
    }

    public void setAnnotationValue(Object Ptr) {
        assert (this.isAnnotation()) : "Used AnnotVal on non-annotation token kind:" + tok.getTokenName((short)this.getKind());
        this.PtrData = Native.$tryClone((Object)Ptr);
        this.CharPtrData = null;
        this.CharPtrDataIndex = 0;
    }

    public void setFlag(int Flag) {
        this.Flags = (short)(this.Flags | Flag);
    }

    public void clearFlag(int Flag) {
        this.Flags = (short)(this.Flags & ~Flag);
    }

    public long getFlags() {
        return this.Flags;
    }

    public void setFlagValue(int Flag, boolean Val) {
        if (Val) {
            this.setFlag(Flag);
        } else {
            this.clearFlag(Flag);
        }
    }

    public boolean isAtStartOfLine() {
        return (this.Flags & 1) != 0;
    }

    public boolean hasLeadingSpace() {
        return (this.Flags & 2) != 0;
    }

    public boolean isExpandDisabled() {
        return (this.Flags & 4) != 0;
    }

    public boolean isObjCAtKeyword(int objcKey) {
        IdentifierInfo II = this.getIdentifierInfo();
        if (II != null) {
            return II.getObjCKeywordID() == objcKey;
        }
        return false;
    }

    public int getObjCKeywordID() {
        IdentifierInfo specId = this.getIdentifierInfo();
        return specId != null ? specId.getObjCKeywordID() : 0;
    }

    public boolean needsCleaning() {
        return (this.Flags & 8) != 0;
    }

    public boolean hasLeadingEmptyMacro() {
        return (this.Flags & 0x10) != 0;
    }

    public boolean hasUDSuffix() {
        return (this.Flags & 0x20) != 0;
    }

    public boolean hasUCN() {
        return (this.Flags & 0x40) != 0;
    }

    public boolean stringifiedInMacro() {
        return (this.Flags & 0x100) != 0;
    }

    public Token $assign(Token $Prm0) {
        Token.isDebug(index);
        Token.isDebug(index);
        this.Loc = $Prm0.Loc;
        this.UintData = $Prm0.UintData;
        this.PtrData = $Prm0.PtrData;
        this.CharPtrData = $Prm0.CharPtrData;
        this.CharPtrDataIndex = $Prm0.CharPtrDataIndex;
        this.Kind = $Prm0.Kind;
        this.Flags = $Prm0.Flags;
        return this;
    }

    private static void isDebug(long index) {
    }

    public Token() {
        this.Loc = 0;
        index = this.trackInstance();
    }

    public Token(Token $Prm0) {
        this.Loc = $Prm0.Loc;
        this.UintData = $Prm0.UintData;
        this.PtrData = $Prm0.PtrData;
        this.CharPtrData = $Prm0.CharPtrData;
        this.CharPtrDataIndex = $Prm0.CharPtrDataIndex;
        this.Kind = $Prm0.Kind;
        this.Flags = $Prm0.Flags;
        index = this.trackInstance();
    }

    public String toString() {
        return "Tok{[" + index + "]Loc=[" + this.getLocation() + "], UintData=" + Unsigned.uint2long((int)this.UintData) + ", Kind=[" + this.getKind() + ":" + tok.getTokenName((short)this.getKind()) + "]," + " Flags=" + this.Flags + "[" + this.PtrData + "]}";
    }

    public Token clone() {
        return new Token(this);
    }

    public boolean $noteq(Token other) {
        return !this.$eq(other);
    }

    public boolean $eq(Token other) {
        return this.Flags == other.Flags && this.Kind == other.Kind && this.UintData == other.UintData && this.Loc == other.Loc && this.PtrData == other.PtrData;
    }

    public long $sizeof() {
        return Token.$sizeof_Token();
    }

    static int $sizeof_Token() {
        return NativeType.BYTES_IN_JAVA_OBJECT_HEADER + 8 + 8 + 4 + 2 + 2;
    }

    private static void trackFailedCharPtr() {
        if (NativeTrace.STATISTICS) {
            ++failedCharPtrArray;
        }
    }

    private static void trackFailedGetCharPtr() {
        if (NativeTrace.STATISTICS) {
            ++failedGetCharPtrArray;
        }
    }

    private static int trackInstance() {
        if (NativeTrace.STATISTICS) {
            ++instances;
        }
        Token.isDebug(instances);
        return (int)instances;
    }

    public static void clearStatistics() {
        instances = 0L;
        failedCharPtrArray = 0L;
        failedGetCharPtrArray = 0L;
    }

    public static void PrintStats(raw_ostream out) {
        out.$out((CharSequence)String.format("%22s created:\t", Token.class.getSimpleName())).$out((CharSequence)NativeTrace.formatNumber((long)instances)).$out((CharSequence)".\n");
        out.$out((CharSequence)String.format("%20s no byte[]:\t", Token.class.getSimpleName())).$out((CharSequence)NativeTrace.formatNumber((long)failedCharPtrArray)).$out((CharSequence)".\n");
        out.$out((CharSequence)String.format("%18s slow byte[]:\t", Token.class.getSimpleName())).$out((CharSequence)NativeTrace.formatNumber((long)failedGetCharPtrArray)).$out((CharSequence)".\n");
    }

    static {
        instances = 0L;
        failedCharPtrArray = 0L;
        failedGetCharPtrArray = 0L;
    }

    public static final class TokenFlags {
        public static final int StartOfLine = 1;
        public static final int LeadingSpace = 2;
        public static final int DisableExpand = 4;
        public static final int NeedsCleaning = 8;
        public static final int LeadingEmptyMacro = 16;
        public static final int HasUDSuffix = 32;
        public static final int HasUCN = 64;
        public static final int IgnoredComma = 128;
        public static final int StringifiedInMacro = 256;
    }
}

