/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import java.util.Arrays;
import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.lex.Lexer;
import org.clang.lex.MacroArgs;
import org.clang.lex.MacroInfo;
import org.clang.lex.Preprocessor;
import org.clang.lex.SmallVectorToken;
import org.clang.lex.Token;
import org.clang.lex.impl.PasteTokenHelper;
import org.clang.lex.impl.TokenLexerStatics;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class TokenLexer
implements Destructors.ClassWithDestructor {
    private MacroInfo Macro;
    private MacroArgs ActualArgs;
    private Preprocessor PP;
    Token[] Tokens;
    int TokensIndex;
    private int NumTokens;
    private int CurToken;
    private int ExpandLocStart;
    private int ExpandLocEnd;
    private int MacroExpansionStart;
    private int MacroStartSLocOffset;
    private int MacroDefStart;
    private int MacroDefLength;
    private boolean AtStartOfLine;
    private boolean HasLeadingSpace;
    private boolean NextTokGetsSpace;
    private boolean OwnsTokens;
    private boolean DisableMacroExpansion;
    public static final String OPTIMIZE_SIMPLE_PASTE_TOKEN_PROP = "clank.optimize.pastetokens";
    public static final boolean OPTIMIZE_SIMPLE_PASTE_TOKEN = Boolean.valueOf(System.getProperty("clank.optimize.pastetokens", "true"));
    private static long instances;
    private static long inits;

    private TokenLexer(TokenLexer $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    private void $assign(TokenLexer $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    public TokenLexer(Token Tok, int ILEnd, MacroInfo MI, MacroArgs ActualArgs, Preprocessor pp) {
        this.Macro = null;
        this.ActualArgs = null;
        this.PP = pp;
        this.ExpandLocStart = SourceLocation.getInvalid();
        this.ExpandLocEnd = SourceLocation.getInvalid();
        this.MacroExpansionStart = SourceLocation.getInvalid();
        this.MacroDefStart = SourceLocation.getInvalid();
        this.OwnsTokens = false;
        this.Init(Tok, ILEnd, MI, ActualArgs);
        TokenLexer.trackInstance();
    }

    public void Init(Token Tok, int ELEnd, MacroInfo MI, MacroArgs Actuals) {
        this.destroy();
        this.Macro = MI;
        this.ActualArgs = Actuals;
        this.CurToken = 0;
        this.ExpandLocStart = Tok.getRawLocation();
        this.ExpandLocEnd = ELEnd;
        this.AtStartOfLine = Tok.isAtStartOfLine();
        this.HasLeadingSpace = Tok.hasLeadingSpace();
        this.NextTokGetsSpace = false;
        this.Tokens = this.Macro.$ReplacementTokens();
        this.TokensIndex = 0;
        this.OwnsTokens = false;
        this.DisableMacroExpansion = false;
        this.NumTokens = this.Macro.getNumTokens();
        this.MacroExpansionStart = SourceLocation.getInvalid();
        SourceManager SM = this.PP.getSourceManager();
        this.MacroStartSLocOffset = Unsigned.long2uint((long)SM.getNextLocalOffset());
        if (this.NumTokens > 0) {
            assert (this.Tokens$at(0).getLocation().isValid());
            assert (this.Tokens$at(0).getLocation().isFileID() || this.Tokens$at(0).is((short)4)) : "Macro defined in macro?";
            assert (SourceLocation.isValid((int)this.ExpandLocStart));
            this.MacroDefStart = SM.getExpansionLoc(this.Tokens$at(0).getRawLocation());
            this.MacroDefLength = this.Macro.getDefinitionLength(SM);
            this.MacroExpansionStart = SM.createExpansionLoc(this.MacroDefStart, this.ExpandLocStart, this.ExpandLocEnd, (long)this.MacroDefLength);
        }
        if (this.Macro.isFunctionLike() && this.Macro.getNumArgs() != 0) {
            this.ExpandFunctionArguments();
        }
        this.Macro.DisableMacro();
        TokenLexer.trackInit();
    }

    private Token Tokens$at(int idx) {
        return this.Tokens[this.TokensIndex + idx];
    }

    public TokenLexer(Token[] TokArray, int TokArrayIdx, int NumToks, boolean DisableExpansion, boolean ownsTokens, Preprocessor pp) {
        this.Macro = null;
        this.ActualArgs = null;
        this.PP = pp;
        this.ExpandLocStart = SourceLocation.getInvalid();
        this.ExpandLocEnd = SourceLocation.getInvalid();
        this.MacroExpansionStart = SourceLocation.getInvalid();
        this.MacroDefStart = SourceLocation.getInvalid();
        this.OwnsTokens = false;
        this.Init(TokArray, TokArrayIdx, NumToks, DisableExpansion, ownsTokens);
        TokenLexer.trackInstance();
    }

    public final void Init(Token[] TokArray, int TokArrayIdx, int NumToks, boolean disableMacroExpansion, boolean ownsTokens) {
        this.destroy();
        this.Macro = null;
        this.ActualArgs = null;
        this.Tokens = TokArray;
        this.TokensIndex = TokArrayIdx;
        this.OwnsTokens = ownsTokens;
        this.DisableMacroExpansion = disableMacroExpansion;
        this.NumTokens = NumToks;
        this.CurToken = 0;
        this.ExpandLocStart = this.ExpandLocEnd = SourceLocation.getInvalid();
        this.AtStartOfLine = false;
        this.HasLeadingSpace = false;
        this.NextTokGetsSpace = false;
        this.MacroExpansionStart = SourceLocation.getInvalid();
        if (NumToks != 0) {
            this.AtStartOfLine = TokArray[TokArrayIdx].isAtStartOfLine();
            this.HasLeadingSpace = TokArray[TokArrayIdx].hasLeadingSpace();
        }
    }

    public void $destroy() {
        this.destroy();
    }

    public int isNextTokenLParen() {
        if (this.isAtEnd()) {
            return 2;
        }
        return this.Tokens$at(this.CurToken).is((short)21) ? 1 : 0;
    }

    public boolean Lex(Token Tok) {
        if (this.isAtEnd()) {
            if (this.Macro != null) {
                this.Macro.EnableMacro();
            }
            Tok.startToken();
            Tok.setFlagValue(1, this.AtStartOfLine);
            Tok.setFlagValue(2, this.HasLeadingSpace || this.NextTokGetsSpace);
            if (this.CurToken == 0) {
                Tok.setFlag(16);
            }
            return this.PP.HandleEndOfTokenLexer(Tok);
        }
        SourceManager SM = this.PP.getSourceManager();
        boolean isFirstToken = this.CurToken == 0;
        Tok.$assign(this.Tokens$at(this.CurToken++));
        boolean TokenIsFromPaste = false;
        if (!this.isAtEnd() && this.Macro != null && (this.Tokens$at(this.CurToken).is((short)66) || this.PP.getLangOpts().MSVCCompat && TokenLexerStatics.isWideStringLiteralFromMacro(Tok, this.Tokens$at(this.CurToken)))) {
            if (this.PasteTokens(Tok)) {
                return true;
            }
            TokenIsFromPaste = true;
        }
        if (SourceLocation.isValid((int)this.ExpandLocStart) && SM.isBeforeInSLocAddrSpace(Tok.getRawLocation(), Unsigned.uint2long((int)this.MacroStartSLocOffset))) {
            int instLoc;
            if (Tok.is((short)4)) {
                instLoc = SM.createExpansionLoc(Tok.getRawLocation(), this.ExpandLocStart, this.ExpandLocEnd, (long)Tok.getLength());
            } else {
                assert (SourceLocation.isValid((int)Tok.getRawLocation())) : Tok;
                assert (SourceLocation.isFileID((int)Tok.getRawLocation())) : Tok;
                instLoc = this.getExpansionLocForMacroDefLoc(Tok.getRawLocation());
            }
            Tok.setLocation(instLoc);
        }
        if (isFirstToken) {
            Tok.setFlagValue(1, this.AtStartOfLine);
            Tok.setFlagValue(2, this.HasLeadingSpace);
        } else {
            if (this.AtStartOfLine) {
                Tok.setFlag(1);
            }
            if (this.HasLeadingSpace) {
                Tok.setFlag(2);
            }
        }
        this.AtStartOfLine = false;
        this.HasLeadingSpace = false;
        if (!Tok.isAnnotation() && Tok.getIdentifierInfo() != null) {
            IdentifierInfo II = Tok.getIdentifierInfo();
            Tok.setKind(II.getTokenID());
            if (II.isPoisoned() && TokenIsFromPaste) {
                this.PP.HandlePoisonedIdentifier(Tok);
            }
            if (!this.DisableMacroExpansion && II.isHandleIdentifierCase()) {
                return this.PP.HandleIdentifier(Tok);
            }
        }
        return true;
    }

    public boolean isParsingPreprocessorDirective() {
        return this.Tokens$at(this.NumTokens - 1).is((short)2) && !this.isAtEnd();
    }

    private void destroy() {
        if (this.OwnsTokens) {
            Destructors.$destroyArray((Object)this.Tokens);
            this.Tokens = null;
            this.TokensIndex = -1;
            this.OwnsTokens = false;
        }
        if (this.ActualArgs != null) {
            this.ActualArgs.destroy(this.PP);
        }
    }

    private boolean isAtEnd() {
        return this.CurToken == this.NumTokens;
    }

    private boolean PasteTokens(Token Tok) {
        PasteTokenHelper helper = this.PP.$getPasteTokenHelper();
        boolean out = this.PasteTokens(Tok, helper);
        this.PP.$releasePasteTokenHelper(helper);
        return out;
    }

    private boolean PasteTokens(Token Tok, PasteTokenHelper helper) {
        boolean continueLoop;
        SmallString Buffer = helper.$Buffer();
        char.ptr.array ResultTokStrPtr = helper.$ResultTokStrPtr();
        byte[] ResultTokStrPtrArray = null;
        int ResultTokStrPtrIndex = 0;
        int StartLoc = Tok.getRawLocation();
        int PasteOpLoc = SourceLocation.getInvalid();
        do {
            PasteOpLoc = this.Tokens$at(this.CurToken).getRawLocation();
            if (this.Tokens$at(this.CurToken).is((short)66)) {
                ++this.CurToken;
            }
            assert (!this.isAtEnd()) : "No token on the RHS of a paste operator!";
            Token RHS = this.Tokens$at(this.CurToken);
            while (RHS.is((short)4)) {
                ++this.CurToken;
                RHS = this.Tokens$at(this.CurToken);
            }
            ++this.CurToken;
            continueLoop = !this.isAtEnd() && this.Tokens$at(this.CurToken).is((short)66);
            int LHSLen = Tok.getLength();
            int RHSLen = RHS.getLength();
            int newTokMaxLen = LHSLen + RHSLen;
            Buffer.resize(newTokMaxLen);
            LHSLen = this.PP.copySpelling(Tok, Buffer.$array(), 0);
            if (LHSLen == -1) {
                return true;
            }
            RHSLen = this.PP.copySpelling(RHS, Buffer.$array(), LHSLen);
            if (RHSLen == -1) {
                return true;
            }
            int newTokActualLen = LHSLen + RHSLen;
            if (newTokActualLen != newTokMaxLen) {
                assert (newTokActualLen < newTokMaxLen) : newTokActualLen + " must be smaller than " + newTokMaxLen;
                Buffer.resize(newTokActualLen);
            }
            assert (Buffer.size() == newTokActualLen) : "buffer size " + Buffer.size() + " vs. " + newTokActualLen;
            Token ResultTokTmp = helper.$ResultTokTmp();
            ResultTokTmp.startToken();
            ResultTokTmp.setKind((short)13);
            this.PP.CreateString(Buffer.$array(), 0, Buffer.size(), ResultTokTmp, SourceLocation.getInvalid(), SourceLocation.getInvalid());
            int ResultTokLoc = ResultTokTmp.getRawLocation();
            ResultTokStrPtrArray = ResultTokTmp.$CharPtrData();
            assert (ResultTokStrPtrArray != null);
            ResultTokStrPtrIndex = ResultTokTmp.$CharPtrDataIndex();
            assert (Buffer.$array() != ResultTokStrPtrArray);
            Token Result = helper.$Result();
            if (Tok.isAnyIdentifier() && this.isPastingSimpleIdentifer(Tok, RHS, ResultTokStrPtrArray, ResultTokStrPtrIndex, newTokActualLen)) {
                this.PP.IncrementPasteCounter(true);
                Result.startToken();
                Result.setKind((short)6);
                Result.setRawIdentifierData(ResultTokStrPtrArray, ResultTokStrPtrIndex);
                Result.setLocation(ResultTokLoc);
                Result.setLength(newTokActualLen);
            } else if (Tok.is((short)7) && this.isPastingSimpleNumericConstant(Tok, RHS, ResultTokStrPtrArray, ResultTokStrPtrIndex, newTokActualLen)) {
                this.PP.IncrementPasteCounter(true);
                Result.startToken();
                Result.setKind((short)7);
                Result.setLiteralData(ResultTokStrPtrArray, ResultTokStrPtrIndex);
                Result.setLocation(ResultTokLoc);
                Result.setLength(newTokActualLen);
            } else {
                boolean isInvalid;
                int LocFileID;
                this.PP.IncrementPasteCounter(false);
                assert (SourceLocation.isFileID((int)ResultTokLoc)) : "Should be a raw location into scratch buffer";
                SourceManager SourceMgr = this.PP.getSourceManager();
                MemoryBuffer ScratchBuf = SourceMgr.getBuffer(LocFileID = SourceMgr.getFileID(ResultTokLoc), null);
                if (ScratchBuf.isInvalid()) {
                    return false;
                }
                Native.$setArrayAndIndex((char.ptr.array)ResultTokStrPtr, (byte[])ResultTokStrPtrArray, (int)ResultTokStrPtrIndex);
                assert (ScratchBuf.getBufferStart().$array() == ResultTokStrPtrArray);
                Lexer TL = helper.$Lexer(SourceMgr.getLocForStartOfFile(LocFileID), this.PP.getLangOpts(), Native.$noClone((char.ptr)ScratchBuf.getBufferStart()), Native.$noClone((char.ptr)ResultTokStrPtr), ResultTokStrPtr.$index() + newTokActualLen);
                boolean bl = isInvalid = !TL.LexFromRawLexer(Result);
                if (isInvalid |= Result.is((short)1)) {
                    if (this.PP.getLangOpts().MicrosoftExt && Tok.is((short)42) && RHS.is((short)42)) {
                        this.HandleMicrosoftCommentPaste(Tok);
                        return true;
                    }
                    if (this.PP.getLangOpts().AsmPreprocessor) break;
                    SourceManager SM = this.PP.getSourceManager();
                    int Loc = SM.createExpansionLoc(PasteOpLoc, this.ExpandLocStart, this.ExpandLocEnd, 2L);
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.PP.Diag(Loc, this.PP.getLangOpts().MicrosoftExt ? 779L : 687L), (StringRef)Buffer.str()).$destroy();
                    break;
                }
                if (Result.is((short)66)) {
                    Result.setKind((short)0);
                }
            }
            Result.setFlagValue(1, Tok.isAtStartOfLine());
            Result.setFlagValue(2, Tok.hasLeadingSpace());
            Tok.$assign(Result);
        } while (continueLoop);
        int EndLoc = this.Tokens$at(this.CurToken - 1).getRawLocation();
        SourceManager SM = this.PP.getSourceManager();
        if (SourceLocation.isFileID((int)StartLoc)) {
            StartLoc = this.getExpansionLocForMacroDefLoc(StartLoc);
        }
        if (SourceLocation.isFileID((int)EndLoc)) {
            EndLoc = this.getExpansionLocForMacroDefLoc(EndLoc);
        }
        int MacroFID = SM.getFileID(this.MacroExpansionStart);
        while (SM.getFileID(StartLoc) != MacroFID) {
            StartLoc = std.$first_int((long)SM.getImmediateExpansionRange(StartLoc));
        }
        while (SM.getFileID(EndLoc) != MacroFID) {
            EndLoc = std.$second_int((long)SM.getImmediateExpansionRange(EndLoc));
        }
        Tok.setLocation(SM.createExpansionLoc(Tok.getRawLocation(), StartLoc, EndLoc, (long)Tok.getLength()));
        if (Tok.is((short)6)) {
            this.PP.LookUpIdentifierInfo(Tok);
        }
        return false;
    }

    private boolean isPastingSimpleIdentifer(Token LHS, Token RHS, byte[] PasteTokenSpelling, int PasteTokenSpellingStIndex, int Len) {
        assert (LHS.isAnyIdentifier()) : "must be checked above";
        if (!OPTIMIZE_SIMPLE_PASTE_TOKEN) {
            return RHS.isAnyIdentifier();
        }
        int i = LHS.getLength();
        int idx = PasteTokenSpellingStIndex + LHS.getLength();
        while (i < Len) {
            if (!ClangGlobals.isIdentifierBody((byte)PasteTokenSpelling[idx])) {
                return false;
            }
            ++i;
            ++idx;
        }
        return true;
    }

    private boolean isPastingSimpleNumericConstant(Token LHS, Token RHS, byte[] PasteTokenSpelling, int PasteTokenSpellingStIndex, int Len) {
        assert (LHS.is((short)7)) : "must be checked above";
        if (!OPTIMIZE_SIMPLE_PASTE_TOKEN) {
            return false;
        }
        int i = 0;
        while (i < Len) {
            if (!ClangGlobals.isDigit((byte)PasteTokenSpelling[PasteTokenSpellingStIndex])) {
                return false;
            }
            ++i;
            ++PasteTokenSpellingStIndex;
        }
        return true;
    }

    private void ExpandFunctionArguments() {
        SmallVectorToken ResultToks = this.PP.$getExpandFunctionArgumentsVector(this.NumTokens);
        boolean MadeChange = false;
        int origNumTokens = this.NumTokens;
        int e = this.NumTokens;
        for (int i = 0; i != e; ++i) {
            int ArgNo;
            boolean PasteAfter;
            Token CurTok = this.Tokens$at(i);
            if (i != 0 && !this.Tokens[i - 1].is((short)66) && CurTok.hasLeadingSpace()) {
                this.NextTokGetsSpace = true;
            }
            if (CurTok.is((short)65) || CurTok.is((short)67)) {
                int ArgNo2 = this.Macro.getArgumentNum(this.Tokens$at(i + 1).getIdentifierInfo());
                assert (ArgNo2 != -1) : "Token following # is not an argument?";
                int ExpansionLocStart = this.getExpansionLocForMacroDefLoc(CurTok.getRawLocation());
                int ExpansionLocEnd = this.getExpansionLocForMacroDefLoc(this.Tokens$at(i + 1).getRawLocation());
                Token Res = new Token();
                if (CurTok.is((short)65)) {
                    Res.$assign(this.ActualArgs.getStringifiedArgument(ArgNo2, this.PP, ExpansionLocStart, ExpansionLocEnd));
                } else {
                    Res.$assign(MacroArgs.StringifyArgument(this.ActualArgs.$UnexpArgTokens(), this.ActualArgs.getUnexpArgument(ArgNo2), this.PP, true, ExpansionLocStart, ExpansionLocEnd));
                }
                Res.setFlag(256);
                if (this.NextTokGetsSpace) {
                    Res.setFlag(2);
                }
                ResultToks.push_back(Res);
                MadeChange = true;
                ++i;
                this.NextTokGetsSpace = false;
                continue;
            }
            boolean NonEmptyPasteBefore = !ResultToks.empty() && ResultToks.back().is((short)66);
            boolean PasteBefore = i != 0 && this.Tokens[i - 1].is((short)66);
            boolean bl = PasteAfter = i + 1 != e && this.Tokens[i + 1].is((short)66);
            assert (!NonEmptyPasteBefore || PasteBefore);
            IdentifierInfo II = CurTok.getIdentifierInfo();
            int n = ArgNo = II != null ? this.Macro.getArgumentNum(II) : -1;
            if (ArgNo == -1) {
                ResultToks.push_back(CurTok);
                if (this.NextTokGetsSpace) {
                    ResultToks.back().setFlag(2);
                    this.NextTokGetsSpace = false;
                    continue;
                }
                if (!PasteBefore || NonEmptyPasteBefore) continue;
                ResultToks.back().clearFlag(2);
                continue;
            }
            MadeChange = true;
            if (!PasteBefore && this.ActualArgs.isVarargsElidedUse() && this.MaybeRemoveCommaBeforeVaArgs(ResultToks, false, this.Macro, ArgNo, this.PP)) continue;
            if (!PasteBefore && !PasteAfter) {
                int ResultArgToksIdx;
                Token[] ResultArgToks;
                int ArgTok = this.ActualArgs.getUnexpArgument(ArgNo);
                if (MacroArgs.ArgNeedsPreexpansion(this.ActualArgs.$UnexpArgTokens(), ArgTok, this.PP)) {
                    ResultArgToks = this.ActualArgs.getPreExpArgument(ArgNo, this.Macro, this.PP).$array();
                    ResultArgToksIdx = 0;
                } else {
                    ResultArgToksIdx = ArgTok;
                    ResultArgToks = this.ActualArgs.$UnexpArgTokens();
                }
                if (!ResultArgToks[ResultArgToksIdx].isNot((short)1)) continue;
                int FirstResult = ResultToks.size();
                int NumToks = MacroArgs.getArgLength(ResultArgToks, ResultArgToksIdx);
                ResultToks.prepareBeforeAppend(NumToks);
                ResultToks.append(ResultArgToks, ResultArgToksIdx, NumToks);
                if (NumToks == 1 && ResultToks.back().is((short)64)) {
                    ResultToks.back().setFlag(128);
                }
                int end = ResultToks.size();
                for (int idx = FirstResult; idx != end; ++idx) {
                    Token Tok = ResultToks.$at(idx);
                    if (!Tok.is((short)66)) continue;
                    Tok.setKind((short)0);
                }
                if (SourceLocation.isValid((int)this.ExpandLocStart)) {
                    this.updateLocForMacroArgTokens(CurTok.getRawLocation(), ResultToks.$array(), FirstResult, ResultToks.size());
                }
                ResultToks.$at(FirstResult).setFlagValue(2, this.NextTokGetsSpace);
                this.NextTokGetsSpace = false;
                continue;
            }
            int ArgToks = this.ActualArgs.getUnexpArgument(ArgNo);
            int NumToks = MacroArgs.getArgLength(this.ActualArgs.$UnexpArgTokens(), ArgToks);
            if (NumToks != 0) {
                if (NonEmptyPasteBefore && ResultToks.size() >= 2 && ResultToks.$at(ResultToks.size() - 2).is((short)64) && (long)ArgNo == (long)(this.Macro.getNumArgs() - 1) && this.Macro.isVariadic()) {
                    this.PP.Diag(ResultToks.pop_back_val().getLocation(), 778L).$destroy();
                }
                ResultToks.append(this.ActualArgs.$UnexpArgTokens(), ArgToks, NumToks);
                int end = ResultToks.size();
                for (int idx = ResultToks.size() - NumToks; idx != end; ++idx) {
                    Token Tok = ResultToks.$at(idx);
                    if (!Tok.is((short)66)) continue;
                    Tok.setKind((short)0);
                }
                if (SourceLocation.isValid((int)this.ExpandLocStart)) {
                    this.updateLocForMacroArgTokens(CurTok.getRawLocation(), ResultToks.$array(), ResultToks.size() - NumToks, ResultToks.size());
                }
                if (this.NextTokGetsSpace) {
                    ResultToks.$at(ResultToks.size() - NumToks).setFlag(2);
                }
                this.NextTokGetsSpace = false;
                continue;
            }
            if (PasteAfter) {
                ++i;
                continue;
            }
            assert (PasteBefore);
            if (NonEmptyPasteBefore) {
                assert (ResultToks.back().is((short)66));
                ResultToks.pop_back();
            }
            if (!this.ActualArgs.isVarargsElidedUse()) continue;
            this.MaybeRemoveCommaBeforeVaArgs(ResultToks, true, this.Macro, ArgNo, this.PP);
        }
        if (MadeChange) {
            assert (!this.OwnsTokens) : "This would leak if we already own the token list";
            this.NumTokens = ResultToks.size();
            this.TokensIndex = this.PP.cacheMacroExpandedTokens(this, ResultToks);
            this.OwnsTokens = false;
        }
    }

    private void HandleMicrosoftCommentPaste(Token Tok) {
        assert (this.Macro != null) : "Token streams can't paste comments";
        this.Macro.EnableMacro();
        this.PP.HandleMicrosoftCommentPaste(Tok);
    }

    private int getExpansionLocForMacroDefLoc(int loc) {
        assert (SourceLocation.isValid((int)this.ExpandLocStart) && SourceLocation.isValid((int)this.MacroExpansionStart)) : "Not appropriate for token streams";
        assert (SourceLocation.isValid((int)loc) && SourceLocation.isFileID((int)loc));
        SourceManager SM = this.PP.getSourceManager();
        assert (std.$first_bool((long)SM.isInSLocAddrSpace(loc, this.MacroDefStart, this.MacroDefLength))) : "Expected loc to come from the macro definition";
        int relativeOffset = std.$second_int((long)SM.isInSLocAddrSpace(loc, this.MacroDefStart, this.MacroDefLength));
        return SourceLocation.getRawLocWithOffset((int)this.MacroExpansionStart, (int)relativeOffset);
    }

    private void updateLocForMacroArgTokens(int ArgIdSpellLoc, Token[] begin_tokens, int begin_tokens_idx, int end_tokens) {
        SourceManager SM = this.PP.getSourceManager();
        int InstLoc = this.getExpansionLocForMacroDefLoc(ArgIdSpellLoc);
        while (begin_tokens_idx < end_tokens) {
            if (end_tokens - begin_tokens_idx == 1) {
                Token Tok = begin_tokens[begin_tokens_idx];
                Tok.setLocation(SM.createMacroArgExpansionLoc(Tok.getRawLocation(), InstLoc, (long)Tok.getLength()));
                return;
            }
            begin_tokens_idx = TokenLexerStatics.updateConsecutiveMacroArgTokens(SM, InstLoc, begin_tokens, begin_tokens_idx, end_tokens);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean MaybeRemoveCommaBeforeVaArgs(SmallVectorToken ResultToks, boolean HasPasteOperator, MacroInfo Macro, long MacroArgNo, Preprocessor PP) {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            if (!Macro.isVariadic() || MacroArgNo != (long)(Macro.getNumArgs() - 1)) {
                boolean bl = false;
                return bl;
            }
            if (!HasPasteOperator && !PP.getLangOpts().MSVCCompat) {
                boolean bl = false;
                return bl;
            }
            if (PP.getLangOpts().C99 && !PP.getLangOpts().GNUMode && Macro.getNumArgs() < 2) {
                boolean bl = false;
                return bl;
            }
            if (ResultToks.empty() || !ResultToks.back().is((short)64)) {
                boolean bl = false;
                return bl;
            }
            if (HasPasteOperator) {
                $c.clean($c.track((Object)PP.Diag(ResultToks.back().getLocation(), 778L)));
            }
            ResultToks.pop_back();
            if (!ResultToks.empty() && ResultToks.back().is((short)66)) {
                ResultToks.pop_back();
            }
            this.NextTokGetsSpace = false;
            boolean bl = true;
            return bl;
        }
        finally {
            $c.$destroy();
        }
    }

    void PropagateLineStartLeadingSpaceInfo(Token Result) {
        this.AtStartOfLine = Result.isAtStartOfLine();
        this.HasLeadingSpace = Result.hasLeadingSpace();
    }

    public String toString() {
        return "TokenLexer{Macro=" + this.Macro + "\n, Tokens=" + Arrays.toString(this.Tokens) + "\n, NumTokens=" + this.NumTokens + "\n, CurToken=" + this.CurToken + "\n, ExpandLocStart=" + this.ExpandLocStart + ", ExpandLocEnd=" + this.ExpandLocEnd + ", MacroExpansionStart=" + this.MacroExpansionStart + ", MacroStartSLocOffset=" + SourceLocation.getFromRawEncoding((int)this.MacroStartSLocOffset) + ", MacroDefStart=" + this.MacroDefStart + ", MacroDefLength=" + this.MacroDefLength + ", AtStartOfLine=" + this.AtStartOfLine + ", HasLeadingSpace=" + this.HasLeadingSpace + ", OwnsTokens=" + this.OwnsTokens + ", DisableMacroExpansion=" + this.DisableMacroExpansion + '}';
    }

    private static void trackInstance() {
        if (NativeTrace.STATISTICS) {
            ++instances;
        }
    }

    private static void trackInit() {
        if (NativeTrace.STATISTICS) {
            ++inits;
        }
    }

    public static void clearStatistics() {
        instances = 0L;
        inits = 0L;
    }

    public static void PrintStats(raw_ostream out) {
        out.$out((CharSequence)String.format("%22s created:\t", TokenLexer.class.getSimpleName())).$out((CharSequence)NativeTrace.formatNumber((long)instances)).$out((CharSequence)".\n");
        out.$out((CharSequence)String.format("%22s  inited:\t", TokenLexer.class.getSimpleName())).$out((CharSequence)NativeTrace.formatNumber((long)instances)).$out((CharSequence)".\n");
    }

    static {
        if (NativeTrace.VERBOSE_MODE) {
            llvm.errs().$out((CharSequence)"TokenLexer.PasteToken ").$out((CharSequence)(OPTIMIZE_SIMPLE_PASTE_TOKEN ? "optimized" : "original")).$out((CharSequence)"\n");
        }
        instances = 0L;
        inits = 0L;
    }
}

