/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.awt.Image;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.api.JspColoringData;
import org.netbeans.modules.web.core.api.JspContextInfo;
import org.netbeans.modules.web.core.jsploader.TagLibParseSupport;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.JspParserFactory;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class JspContextInfoImpl
extends JspContextInfo {
    private static TagLibParseSupport getTagLibParseSupport(FileObject fo) {
        TagLibParseSupport tlps = null;
        if (fo != null && fo.isValid()) {
            try {
                tlps = (TagLibParseSupport)DataObject.find((FileObject)fo).getCookie(TagLibParseSupport.class);
            }
            catch (DataObjectNotFoundException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
        }
        return tlps;
    }

    @Override
    public URLClassLoader getModuleClassLoader(FileObject fo) {
        return JspParserFactory.getJspParser().getModuleClassLoader(WebModule.getWebModule((FileObject)fo));
    }

    @Override
    public Map getTaglibMap(FileObject fo) {
        try {
            JspParserAPI parser = JspParserFactory.getJspParser();
            if (parser == null) {
                Logger.getLogger("global").log(Level.INFO, null, new NullPointerException());
            } else {
                WebModule webModule = WebModule.getWebModule((FileObject)fo);
                if (webModule != null) {
                    return parser.getTaglibMap(webModule);
                }
            }
        }
        catch (IOException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
        }
        return null;
    }

    @Override
    public Image getIcon(FileObject fo) {
        Image icon = null;
        try {
            icon = DataObject.find((FileObject)fo).getNodeDelegate().getIcon(1);
        }
        catch (DataObjectNotFoundException e) {
            e.printStackTrace(System.out);
        }
        return icon;
    }

    @Override
    public JspParserAPI.ParseResult getCachedParseResult(FileObject fo, boolean successfulOnly, boolean preferCurrent, boolean forceParse) {
        TagLibParseSupport sup = JspContextInfoImpl.getTagLibParseSupport(fo);
        if (sup != null) {
            return sup.getCachedParseResult(successfulOnly, preferCurrent, forceParse);
        }
        return null;
    }

    @Override
    public JspParserAPI.ParseResult getCachedParseResult(FileObject fo, boolean successfulOnly, boolean preferCurrent) {
        return this.getCachedParseResult(fo, successfulOnly, preferCurrent, false);
    }

    @Override
    public JspColoringData getJSPColoringData(FileObject fo) {
        TagLibParseSupport sup = JspContextInfoImpl.getTagLibParseSupport(fo);
        if (sup != null) {
            return sup.getJSPColoringData();
        }
        return null;
    }

    @Override
    public JspParserAPI.JspOpenInfo getCachedOpenInfo(FileObject fo, boolean preferCurrent) {
        TagLibParseSupport sup = JspContextInfoImpl.getTagLibParseSupport(fo);
        if (sup != null) {
            return sup.getCachedOpenInfo(preferCurrent, true);
        }
        return null;
    }

    @Override
    public FileObject guessWebModuleRoot(FileObject fo) {
        WebModule wm = WebModule.getWebModule((FileObject)fo);
        if (wm != null) {
            return wm.getDocumentBase();
        }
        return null;
    }
}

