/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspcompiler;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jspcompiler.SmapFileReader;
import org.netbeans.modules.web.jspcompiler.SmapResolver;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.OutputListener;

public final class JspJavacAntLogger
extends AntLogger {
    private static final Logger ERR = Logger.getLogger(JspJavacAntLogger.class.getName());
    private static final boolean LOGGABLE = ERR.isLoggable(Level.FINE);
    private static final String[] TASKS_OF_INTEREST = AntLogger.ALL_TASKS;
    private static final int[] LEVELS_OF_INTEREST = new int[]{2, 1, 0};
    private static final String JAVA_SUFFIX = ".java";
    private static final String SMAP_SUFFIX = ".class.smap";

    public boolean interestedInSession(AntSession session) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession session) {
        return true;
    }

    public boolean interestedInScript(File script, AntSession session) {
        return true;
    }

    public String[] interestedInTargets(AntSession session) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession session) {
        return TASKS_OF_INTEREST;
    }

    public int[] interestedInLogLevels(AntSession session) {
        return LEVELS_OF_INTEREST;
    }

    public void messageLogged(AntEvent event) {
        String line;
        if (event.isConsumed()) {
            return;
        }
        AntSession session = event.getSession();
        OutputListener hyper = JspJavacAntLogger.findHyperlink(session, line = event.getMessage());
        if (hyper != null) {
            event.getSession().println(line, event.getLogLevel() <= 1, hyper);
            event.consume();
        }
    }

    private static OutputListener findHyperlink(AntSession session, String line) {
        String message;
        int colon1;
        if (LOGGABLE) {
            ERR.log(Level.FINE, "line: " + line);
        }
        if (line.startsWith("file:///")) {
            line = line.substring(7);
            if (LOGGABLE) {
                ERR.log(Level.FINE, "removing file:///");
            }
        } else if (line.startsWith("file:")) {
            line = line.substring(5);
            if (LOGGABLE) {
                ERR.log(Level.FINE, "removing file:");
            }
        } else if (line.length() > 0 && line.charAt(0) == '/') {
            if (LOGGABLE) {
                ERR.log(Level.FINE, "result: looks like Unix file");
            }
        } else if (line.length() > 2 && line.charAt(1) == ':' && line.charAt(2) == '\\') {
            if (LOGGABLE) {
                ERR.log(Level.FINE, "result: looks like Windows file");
            }
        } else {
            if (LOGGABLE) {
                ERR.log(Level.FINE, "result: not a file");
            }
            return null;
        }
        if ((colon1 = line.indexOf(58)) == -1) {
            if (LOGGABLE) {
                ERR.log(Level.FINE, "result: no colon found");
            }
            return null;
        }
        String fileName = line.substring(0, colon1);
        File file = FileUtil.normalizeFile((File)new File(fileName));
        if (!file.exists()) {
            if (LOGGABLE) {
                ERR.log(Level.FINE, "result: no FO for " + fileName);
            }
            if ((colon1 = line.indexOf(58, colon1 + 1)) == -1) {
                if (LOGGABLE) {
                    ERR.log(Level.FINE, "result: no second colon found");
                }
                return null;
            }
            fileName = line.substring(0, colon1);
            file = FileUtil.normalizeFile((File)new File(fileName));
            if (!file.exists()) {
                if (LOGGABLE) {
                    ERR.log(Level.FINE, "result: no FO for " + fileName);
                }
                return null;
            }
        }
        int line1 = -1;
        int col1 = -1;
        int line2 = -1;
        int col2 = -1;
        int start = colon1 + 1;
        int colon2 = line.indexOf(58, colon1 + 1);
        if (colon2 != -1) {
            try {
                line1 = Integer.parseInt(line.substring(colon1 + 1, colon2).trim());
                start = colon2 + 1;
                int colon3 = line.indexOf(58, colon2 + 1);
                if (colon3 != -1) {
                    col1 = Integer.parseInt(line.substring(colon2 + 1, colon3).trim());
                    start = colon3 + 1;
                    int colon4 = line.indexOf(58, colon3 + 1);
                    if (colon4 != -1) {
                        line2 = Integer.parseInt(line.substring(colon3 + 1, colon4).trim());
                        start = colon4 + 1;
                        int colon5 = line.indexOf(58, colon4 + 1);
                        if (colon5 != -1) {
                            col2 = Integer.parseInt(line.substring(colon4 + 1, colon5).trim());
                            if (col2 == col1) {
                                col2 = -1;
                            }
                            start = colon5 + 1;
                        }
                    }
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((message = line.substring(start).trim()).length() == 0) {
            message = null;
        }
        if (LOGGABLE) {
            ERR.log(Level.FINE, "Hyperlink: [" + file + "," + line1 + "," + col1 + "," + line2 + "," + col2 + "," + message + "]");
        }
        File smapFile = JspJavacAntLogger.getSMAPFileForFile(file);
        if (LOGGABLE) {
            ERR.log(Level.FINE, "smapfile: [" + smapFile + "]");
        }
        if (smapFile != null && smapFile.exists()) {
            try {
                int newRow;
                SmapResolver resolver = new SmapResolver(new SmapFileReader(smapFile));
                String jspName = resolver.getJspFileName(line1, col1);
                if (jspName == null && (jspName = resolver.getJspFileName(line1 - 1, col1)) == null) {
                    return null;
                }
                if (LOGGABLE) {
                    ERR.log(Level.FINE, "translate: [" + line1 + ", " + col1 + "]");
                }
                if ((newRow = resolver.unmangle(line1, col1)) == -1) {
                    newRow = resolver.unmangle(line1 - 1, col1);
                    jspName = resolver.getJspFileName(line1 - 1, col1);
                }
                if (newRow == -1) {
                    newRow = resolver.unmangle(line1 + 1, col1);
                    jspName = resolver.getJspFileName(line1 + 1, col1);
                }
                try {
                    WebModule wm = WebModule.getWebModule((FileObject)FileUtil.toFileObject((File)file));
                    if (wm == null) {
                        return null;
                    }
                    FileObject jspFO = wm.getDocumentBase().getFileObject(jspName);
                    if (jspFO != null) {
                        return session.createStandardHyperlink(FileUtil.toFile((FileObject)jspFO).toURI().toURL(), message, newRow, -1, -1, -1);
                    }
                    return null;
                }
                catch (MalformedURLException e) {
                    assert (false) : e;
                    return null;
                }
            }
            catch (IOException e) {
                ERR.log(Level.INFO, null, e);
                return null;
            }
            catch (Exception e) {
                ERR.log(Level.INFO, null, e);
                return null;
            }
        }
        return null;
    }

    public static File getSMAPFileForFile(File javaFile) {
        File f = FileUtil.normalizeFile((File)javaFile);
        File dir = f.getAbsoluteFile().getParentFile();
        String name = f.getName();
        if (!name.endsWith(JAVA_SUFFIX)) {
            return null;
        }
        name = name.substring(0, name.length() - JAVA_SUFFIX.length());
        File newFile = new File(dir, name + SMAP_SUFFIX);
        return newFile;
    }
}

