/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2;

import java.util.EnumSet;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.spi.framework.PhpModuleCustomizerExtender;
import org.netbeans.modules.php.symfony2.Bundle;
import org.netbeans.modules.php.symfony2.Symfony2PhpFrameworkProvider;
import org.netbeans.modules.php.symfony2.commands.Symfony2Script;
import org.netbeans.modules.php.symfony2.preferences.Symfony2Preferences;
import org.netbeans.modules.php.symfony2.ui.customizer.Symfony2CustomizerPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;

public class Symfony2PhpModuleCustomizerExtender
extends PhpModuleCustomizerExtender {
    private final PhpModule phpModule;
    private final boolean originalEnabled;
    private final String originalAppDir;
    private final boolean originalCacheDirIgnored;
    private Symfony2CustomizerPanel component;
    private boolean valid = false;
    private String errorMessage = null;

    Symfony2PhpModuleCustomizerExtender(PhpModule phpModule) {
        this.phpModule = phpModule;
        this.originalEnabled = Symfony2PhpFrameworkProvider.getInstance().isInPhpModule(phpModule);
        this.originalAppDir = Symfony2Preferences.getAppDir(phpModule);
        this.originalCacheDirIgnored = Symfony2Preferences.isCacheDirIgnored(phpModule);
    }

    public String getDisplayName() {
        return Bundle.LBL_Symfony2();
    }

    public void addChangeListener(ChangeListener listener) {
        this.getPanel().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getPanel().removeChangeListener(listener);
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        this.validate();
        return this.valid;
    }

    public String getErrorMessage() {
        this.validate();
        return this.errorMessage;
    }

    public EnumSet<PhpModuleCustomizerExtender.Change> save(PhpModule phpModule) {
        EnumSet<PhpModuleCustomizerExtender.Change> changes = EnumSet.noneOf(PhpModuleCustomizerExtender.Change.class);
        this.saveEnabled(changes);
        this.saveAppDir(changes);
        this.saveCacheIgnored(changes);
        if (changes.isEmpty()) {
            return null;
        }
        return changes;
    }

    private void saveEnabled(EnumSet<PhpModuleCustomizerExtender.Change> changes) {
        boolean newEnabled = this.getPanel().isSupportEnabled();
        if (newEnabled != this.originalEnabled) {
            Symfony2Preferences.setEnabled(this.phpModule, newEnabled);
            changes.add(PhpModuleCustomizerExtender.Change.FRAMEWORK_CHANGE);
        }
    }

    private void saveAppDir(EnumSet<PhpModuleCustomizerExtender.Change> changes) {
        String newAppDir = this.getPanel().getAppDirectory();
        if (!newAppDir.equals(this.originalAppDir)) {
            Symfony2Preferences.setAppDir(this.phpModule, newAppDir);
            changes.add(PhpModuleCustomizerExtender.Change.FRAMEWORK_CHANGE);
        }
    }

    private void saveCacheIgnored(EnumSet<PhpModuleCustomizerExtender.Change> changes) {
        boolean newIgnored = this.getPanel().isIgnoreCacheDirectory();
        if (newIgnored != this.originalCacheDirIgnored) {
            Symfony2Preferences.setCacheDirIgnored(this.phpModule, newIgnored);
            changes.add(PhpModuleCustomizerExtender.Change.IGNORED_FILES_CHANGE);
        }
    }

    private Symfony2CustomizerPanel getPanel() {
        if (this.component == null) {
            this.component = new Symfony2CustomizerPanel(this.phpModule.getSourceDirectory());
            this.component.setSupportEnabled(this.originalEnabled);
            this.component.setAppDirectory(this.originalAppDir);
            this.component.setIgnoreCacheDirectory(this.originalCacheDirIgnored);
        }
        return this.component;
    }

    private void validate() {
        Symfony2CustomizerPanel panel = this.getPanel();
        if (!panel.isSupportEnabled()) {
            this.valid = true;
            this.errorMessage = null;
            return;
        }
        String appDir = panel.getAppDirectory();
        if (!StringUtils.hasText((String)appDir)) {
            this.valid = false;
            this.errorMessage = Bundle.Symfony2PhpModuleCustomizerExtender_error_appDir_empty();
            return;
        }
        FileObject sources = this.phpModule.getSourceDirectory();
        if (sources == null) {
            assert (false) : "Customizer extender for no sources of: " + this.phpModule.getName();
            this.valid = false;
            this.errorMessage = Bundle.Symfony2PhpModuleCustomizerExtender_error_sources_invalid();
            return;
        }
        FileObject fo = sources.getFileObject(appDir);
        if (fo == null || !FileUtil.isParentOf((FileObject)sources, (FileObject)fo)) {
            this.valid = false;
            this.errorMessage = Bundle.Symfony2PhpModuleCustomizerExtender_error_appDir_notChild();
            return;
        }
        if (Symfony2Script.getPath(this.phpModule, appDir) == null) {
            this.valid = false;
            this.errorMessage = Bundle.Symfony2PhpModuleCustomizerExtender_error_appDir_consoleNotFound();
            return;
        }
        this.valid = true;
        this.errorMessage = null;
    }
}

