/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.spi.framework.PhpModuleIgnoredFilesExtender;
import org.netbeans.modules.php.symfony2.preferences.Symfony2Preferences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class Symfony2PhpModuleIgnoredFilesExtender
extends PhpModuleIgnoredFilesExtender {
    private static final String CACHE_NAME = "cache";
    private static final String DEFAULT_CACHE_DIR = "app/cache";
    private final PhpModule phpModule;
    private final File cache;

    public Symfony2PhpModuleIgnoredFilesExtender(PhpModule phpModule) {
        assert (phpModule != null);
        this.phpModule = phpModule;
        this.cache = this.findCacheDir(phpModule);
    }

    private File findCacheDir(PhpModule phpModule) {
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        File defaultCacheDir = new File(FileUtil.toFile((FileObject)sourceDirectory), DEFAULT_CACHE_DIR.replace('/', File.separatorChar));
        FileObject appDir = sourceDirectory.getFileObject(Symfony2Preferences.getAppDir(phpModule));
        if (appDir == null) {
            return defaultCacheDir;
        }
        FileObject cacheFo = appDir.getFileObject(CACHE_NAME);
        if (cacheFo != null && cacheFo.isFolder()) {
            return FileUtil.toFile((FileObject)cacheFo);
        }
        return defaultCacheDir;
    }

    public Set<File> getIgnoredFiles() {
        if (this.cache == null) {
            return Collections.emptySet();
        }
        boolean cacheIgnored = Symfony2Preferences.isCacheDirIgnored(this.phpModule);
        return cacheIgnored ? Collections.singleton(this.cache) : Collections.emptySet();
    }
}

