/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.cssprep;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.api.CssPreprocessor;
import org.netbeans.modules.web.common.api.CssPreprocessors;
import org.netbeans.modules.web.common.api.CssPreprocessorsListener;
import org.netbeans.modules.web.common.cssprep.CssPreprocessorAccessor;
import org.netbeans.modules.web.common.cssprep.CssPreprocessorsAccessor;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectProblemsProviderSupport;
import org.openide.util.WeakListeners;

public final class CssPreprocessorsProblemProvider
implements ProjectProblemsProvider {
    final ProjectProblemsProviderSupport problemsProviderSupport = new ProjectProblemsProviderSupport((Object)this);
    final Project project;
    final PreprocessorsListener preprocessorsListener = new PreprocessorsListener();

    private CssPreprocessorsProblemProvider(Project project) {
        assert (project != null);
        this.project = project;
    }

    public static CssPreprocessorsProblemProvider create(Project project) {
        CssPreprocessorsProblemProvider problemProvider = new CssPreprocessorsProblemProvider(project);
        CssPreprocessors cssPreprocessors = CssPreprocessors.getDefault();
        cssPreprocessors.addCssPreprocessorsListener((CssPreprocessorsListener)WeakListeners.create(CssPreprocessorsListener.class, (EventListener)problemProvider.preprocessorsListener, (Object)cssPreprocessors));
        return problemProvider;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        return this.problemsProviderSupport.getProblems(new ProjectProblemsProviderSupport.ProblemsCollector(){

            public Collection<ProjectProblemsProvider.ProjectProblem> collectProblems() {
                ArrayList<ProjectProblemsProvider.ProjectProblem> currentProblems = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
                for (CssPreprocessor preprocessor : CssPreprocessorsAccessor.getDefault().getPreprocessors()) {
                    ProjectProblemsProvider problemsProvider = CssPreprocessorAccessor.getDefault().createProjectProblemsProvider(preprocessor, CssPreprocessorsProblemProvider.this.project);
                    if (problemsProvider == null) continue;
                    currentProblems.addAll(problemsProvider.getProblems());
                }
                return currentProblems;
            }
        });
    }

    private final class PreprocessorsListener
    implements CssPreprocessorsListener {
        private PreprocessorsListener() {
        }

        @Override
        public void preprocessorsChanged() {
            CssPreprocessorsProblemProvider.this.problemsProviderSupport.fireProblemsChange();
        }

        @Override
        public void optionsChanged(CssPreprocessor cssPreprocessor) {
            CssPreprocessorsProblemProvider.this.problemsProviderSupport.fireProblemsChange();
        }

        @Override
        public void customizerChanged(Project project, CssPreprocessor cssPreprocessor) {
            if (project.equals(project)) {
                CssPreprocessorsProblemProvider.this.problemsProviderSupport.fireProblemsChange();
            }
        }

        @Override
        public void processingErrorOccured(Project project, CssPreprocessor cssPreprocessor, String error) {
            if (project.equals(project)) {
                CssPreprocessorsProblemProvider.this.problemsProviderSupport.fireProblemsChange();
            }
        }
    }
}

