/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.actions;

import java.awt.Toolkit;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.cnd.refactoring.spi.CheckModificationHook;
import org.netbeans.modules.cnd.refactoring.spi.CsmRenameExtraObjectsProvider;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.ui.RenameRefactoringUI;
import org.netbeans.modules.cnd.refactoring.ui.WhereUsedQueryUI;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.netbeans.modules.refactoring.api.ui.ExplorerContext;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    private static final String FIND_USAGES_TRACKING = "FIND_USAGES";
    private static final String RENAME_TRACKING = "RENAME";
    private static final Lookup.Result<CsmRenameExtraObjectsProvider> providersResult = Lookup.getDefault().lookupResult(CsmRenameExtraObjectsProvider.class);

    public boolean canFindUsages(Lookup lookup) {
        CsmObject ctx = CsmRefactoringUtils.findContextObject(lookup);
        return CsmRefactoringUtils.isSupportedReference(ctx);
    }

    public void doFindUsages(Lookup lookup) {
        Runnable task = RefactoringActionsProvider.isFromEditor(lookup) ? new TextComponentTask(lookup){

            @Override
            protected RefactoringUI createRefactoringUI(CsmObject selectedElement, CsmContext editorContext) {
                UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{RefactoringActionsProvider.FIND_USAGES_TRACKING, "FROM_EDITOR"});
                return new WhereUsedQueryUI(selectedElement);
            }
        } : new NodeToElementTask(lookup){

            @Override
            protected RefactoringUI createRefactoringUI(CsmObject selectedElement) {
                UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{RefactoringActionsProvider.FIND_USAGES_TRACKING});
                return new WhereUsedQueryUI(selectedElement);
            }
        };
        task.run();
    }

    public boolean canRename(Lookup lookup) {
        CsmObject ctx;
        if (CsmModelAccessor.getModelState() != CsmModelState.ON) {
            return false;
        }
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if ((nodes.size() == 1 || nodes.isEmpty()) && CsmRefactoringUtils.isSupportedReference(ctx = CsmRefactoringUtils.findContextObject(lookup))) {
            if (CsmKindUtilities.isFile((CsmObject)ctx)) {
                Collection allFiles = lookup.lookupAll(CsmFile.class);
                boolean included = false;
                for (CsmFile csmFile : allFiles) {
                    Collection includers = CsmIncludeHierarchyResolver.getDefault().getFiles(csmFile);
                    if (!(included |= !includers.isEmpty())) {
                        for (CsmRenameExtraObjectsProvider prov : providersResult.allInstances()) {
                            if (!prov.needsRefactorRename(csmFile)) continue;
                            included = true;
                            break;
                        }
                    }
                    if (!included) continue;
                    break;
                }
                return included;
            }
            return true;
        }
        return false;
    }

    public void doRename(final Lookup lookup) {
        Runnable task = RefactoringActionsProvider.isFromEditor(lookup) ? new TextComponentTask(lookup){

            @Override
            protected RefactoringUI createRefactoringUI(CsmObject selectedElement, CsmContext editorContext) {
                UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{RefactoringActionsProvider.RENAME_TRACKING, "FROM_EDITOR"});
                return new RenameRefactoringUI(selectedElement, null);
            }
        } : new NodeToElementTask(lookup){

            @Override
            protected RefactoringUI createRefactoringUI(CsmObject selectedElement) {
                UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{RefactoringActionsProvider.RENAME_TRACKING});
                String newName = RefactoringActionsProvider.getName(lookup);
                return new RenameRefactoringUI(selectedElement, newName);
            }
        };
        task.run();
    }

    static void openRefactoringUI(final RefactoringUI ui) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TopComponent activetc = TopComponent.getRegistry().getActivated();
                UI.openRefactoringUI((RefactoringUI)ui, (TopComponent)activetc);
            }
        });
    }

    static boolean isFromEditor(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        return ec != null && CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)ec) != null;
    }

    static String getName(Lookup look) {
        ExplorerContext ren = (ExplorerContext)look.lookup(ExplorerContext.class);
        if (ren == null) {
            return null;
        }
        return ren.getNewName();
    }

    static abstract class NodeToElementTask
    implements Runnable {
        private Lookup context;
        private RefactoringUI ui;

        public NodeToElementTask(Lookup context) {
            this.context = context;
        }

        public void cancel() {
        }

        @Override
        public final void run() {
            CsmObject ctx = CsmRefactoringUtils.findContextObject(this.context);
            if (!CsmRefactoringUtils.isSupportedReference(ctx)) {
                return;
            }
            this.ui = this.createRefactoringUI(ctx);
            Collection hooks = this.context.lookupAll(CheckModificationHook.class);
            for (CheckModificationHook hook : hooks) {
                this.ui.getRefactoring().getContext().add((Object)hook);
            }
            if (this.ui != null) {
                RefactoringActionsProvider.openRefactoringUI(this.ui);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRefactorLoc"));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(CsmObject var1);
    }

    static abstract class TextComponentTask
    implements Runnable {
        private RefactoringUI ui;
        private Lookup lookup;
        private final CsmContext editorContext;

        public TextComponentTask(Lookup lkp) {
            this.lookup = lkp;
            this.editorContext = CsmContext.create(lkp);
        }

        @Override
        public final void run() {
            CsmObject ctx = CsmRefactoringUtils.findContextObject(this.lookup);
            if (ctx == null && this.editorContext == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            this.ui = this.createRefactoringUI(ctx, this.editorContext);
            if (this.ui != null) {
                RefactoringActionsProvider.openRefactoringUI(this.ui);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRefactorLoc"));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(CsmObject var1, CsmContext var2);
    }
}

