/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.hints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmCondition;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExceptionHandler;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmExpressionStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmTryCatchStatement;
import org.netbeans.modules.cnd.api.model.services.CsmExpressionResolver;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.openide.util.Pair;

public class ExpressionFinder {
    private final Document doc;
    private final CsmFile file;
    private final int caretOffset;
    private final int selectionStart;
    private final int selectionEnd;
    private final AtomicBoolean canceled;
    private StatementResult result;

    public ExpressionFinder(Document doc, CsmFile file, int caretOffset, int selectionStart, int selectionEnd, AtomicBoolean canceled) {
        this.doc = doc;
        this.file = file;
        this.caretOffset = caretOffset;
        this.selectionStart = selectionStart;
        this.selectionEnd = selectionEnd;
        this.canceled = canceled;
    }

    public StatementResult findExpressionStatement() {
        this.result = this.findExpressionStatement(this.file.getDeclarations());
        return this.result;
    }

    private StatementResult findExpressionStatement(Collection<? extends CsmOffsetableDeclaration> decls) {
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : decls) {
            if (this.canceled.get()) {
                return null;
            }
            if (csmOffsetableDeclaration.getStartOffset() >= this.selectionStart || this.selectionEnd >= csmOffsetableDeclaration.getEndOffset()) continue;
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetableDeclaration)) {
                CsmFunctionDefinition def = (CsmFunctionDefinition)csmOffsetableDeclaration;
                return this.findExpressionStatementInBody(def.getBody());
            }
            if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration)) {
                CsmNamespaceDefinition def = (CsmNamespaceDefinition)csmOffsetableDeclaration;
                return this.findExpressionStatement(def.getDeclarations());
            }
            if (!CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) continue;
            CsmClass cls = (CsmClass)csmOffsetableDeclaration;
            return this.findExpressionStatement(cls.getMembers());
        }
        return null;
    }

    private StatementResult findExpressionStatementInBody(CsmCompoundStatement body) {
        if (body != null) {
            CsmStatement st;
            int startOffset;
            List statements = body.getStatements();
            for (int i = 0; i < statements.size() && !this.canceled.get() && (startOffset = (st = (CsmStatement)statements.get(i)).getStartOffset()) <= this.selectionStart; ++i) {
                int nexStartOffset = i + 1 < statements.size() ? ((CsmStatement)statements.get(i + 1)).getStartOffset() : body.getEndOffset();
                if (startOffset > this.selectionStart || this.selectionEnd >= nexStartOffset) continue;
                StatementResult res = this.findExpressionStatement(st, nexStartOffset);
                if (res != null && res.getStatementInBody() == null) {
                    res.setStatementInBody(st);
                }
                if (res != null && res.getBody() == null) {
                    res.setBody(body);
                }
                return res;
            }
        }
        return null;
    }

    private StatementResult findExpressionStatement(CsmStatement st, final int nexStartOffset) {
        switch (st.getKind()) {
            case COMPOUND: {
                return this.findExpressionStatementInBody((CsmCompoundStatement)st);
            }
            case SWITCH: {
                int startOffset;
                CsmSwitchStatement switchStmt = (CsmSwitchStatement)st;
                CsmCondition condition = switchStmt.getCondition();
                if (condition != null && condition.getStartOffset() <= this.selectionStart && this.selectionEnd <= condition.getEndOffset()) {
                    return new StatementResult(st, null);
                }
                CsmStatement body = switchStmt.getBody();
                if (body != null && (startOffset = body.getStartOffset()) <= this.selectionStart && this.selectionEnd < nexStartOffset) {
                    return this.findExpressionStatement(body, nexStartOffset);
                }
                return null;
            }
            case FOR: {
                int startOffset;
                CsmForStatement forStmt = (CsmForStatement)st;
                CsmStatement initStatement = forStmt.getInitStatement();
                if (initStatement != null && initStatement.getStartOffset() <= this.selectionStart && this.selectionEnd <= initStatement.getEndOffset()) {
                    return new StatementResult(st, null);
                }
                CsmStatement body = forStmt.getBody();
                if (body != null && (startOffset = body.getStartOffset()) <= this.selectionStart && this.selectionEnd < nexStartOffset) {
                    return this.findExpressionStatement(body, nexStartOffset);
                }
                return null;
            }
            case WHILE: 
            case DO_WHILE: {
                CsmLoopStatement loopStmt = (CsmLoopStatement)st;
                CsmStatement body = loopStmt.getBody();
                if (body != null) {
                    CsmCondition condition;
                    int startOffset = body.getStartOffset();
                    int endOffset = nexStartOffset;
                    if (loopStmt.isPostCheck() && (condition = loopStmt.getCondition()) != null) {
                        endOffset = condition.getStartOffset();
                    }
                    if (startOffset <= this.selectionStart && this.selectionEnd < endOffset) {
                        return this.findExpressionStatement(body, endOffset);
                    }
                }
                return null;
            }
            case TRY_CATCH: {
                CsmTryCatchStatement tryStmt = (CsmTryCatchStatement)st;
                CsmStatement tryBody = tryStmt.getTryStatement();
                List handlers = tryStmt.getHandlers();
                if (tryBody != null) {
                    int startOffset = tryBody.getStartOffset();
                    int endOffset = nexStartOffset;
                    if (handlers != null && handlers.size() > 0) {
                        endOffset = ((CsmExceptionHandler)handlers.get(0)).getStartOffset();
                    }
                    if (startOffset <= this.selectionStart && this.selectionEnd < endOffset) {
                        return this.findExpressionStatement(tryBody, endOffset);
                    }
                }
                if (handlers != null) {
                    for (int i = 0; i < handlers.size(); ++i) {
                        CsmExceptionHandler handler = (CsmExceptionHandler)handlers.get(i);
                        int startOffset = handler.getStartOffset();
                        int endOffset = handler.getEndOffset();
                        if (startOffset > this.selectionStart || this.selectionEnd >= endOffset) continue;
                        return this.findExpressionStatement((CsmStatement)handler, endOffset);
                    }
                }
                return null;
            }
            case IF: {
                int endOffset;
                int startOffset;
                CsmIfStatement ifStmt = (CsmIfStatement)st;
                CsmCondition condition = ifStmt.getCondition();
                if (condition != null && condition.getStartOffset() <= this.selectionStart && this.selectionEnd <= condition.getEndOffset()) {
                    return new StatementResult(st, null);
                }
                CsmStatement thenStmt = ifStmt.getThen();
                CsmStatement elseStmt = ifStmt.getElse();
                if (thenStmt != null) {
                    startOffset = thenStmt.getStartOffset();
                    endOffset = thenStmt.getEndOffset();
                    if (elseStmt != null) {
                        endOffset = elseStmt.getStartOffset();
                    }
                    if (startOffset <= this.selectionStart && this.selectionEnd < endOffset) {
                        return this.findExpressionStatement(thenStmt, endOffset);
                    }
                }
                if (elseStmt != null) {
                    startOffset = elseStmt.getStartOffset();
                    endOffset = nexStartOffset;
                    if (startOffset <= this.selectionStart && this.selectionEnd < endOffset) {
                        return this.findExpressionStatement(elseStmt, endOffset);
                    }
                }
                return null;
            }
            case RETURN: {
                return new StatementResult(st, null);
            }
            case DECLARATION: {
                CsmDeclarationStatement decls = (CsmDeclarationStatement)st;
                List declarators = decls.getDeclarators();
                for (CsmDeclaration decl : declarators) {
                    CsmExpression initialValue;
                    CsmVariable d;
                    if (!(decl instanceof CsmVariable) || (d = (CsmVariable)decl).getStartOffset() > this.selectionStart || this.selectionEnd > d.getEndOffset() || (initialValue = d.getInitialValue()) == null || initialValue.getStartOffset() > this.selectionStart || this.selectionEnd > initialValue.getEndOffset()) continue;
                    return new StatementResult(st, null);
                }
                return null;
            }
            case EXPRESSION: {
                int startOffset = st.getStartOffset();
                final int endOffset = st.getEndOffset();
                final AtomicInteger trueEndOffset = new AtomicInteger(endOffset);
                this.doc.render(new Runnable(){

                    @Override
                    public void run() {
                        TokenHierarchy hi = TokenHierarchy.get((Document)ExpressionFinder.this.doc);
                        TokenSequence ts = hi.tokenSequence();
                        ts.move(endOffset);
                        while (ts.moveNext()) {
                            Token token = ts.token();
                            if (ts.offset() >= nexStartOffset) break;
                            if (!CppTokenId.SEMICOLON.equals((Object)token.id())) continue;
                            trueEndOffset.set(ts.offset() + 1);
                            break;
                        }
                    }
                });
                if (startOffset <= this.selectionStart && this.selectionEnd <= trueEndOffset.get()) {
                    if (this.isApplicable((CsmExpressionStatement)st)) {
                        return new StatementResult(st, (CsmExpressionStatement)st);
                    }
                    return new StatementResult(st, null);
                }
                return null;
            }
        }
        return null;
    }

    private boolean isApplicable(CsmExpressionStatement st) {
        return this.isApplicableExpression((CsmOffsetable)st.getExpression());
    }

    public CsmOffsetable applicableTextExpression() {
        try {
            CsmOffsetableImpl csmOffsetable;
            String text = this.doc.getText(this.selectionStart, this.selectionEnd - this.selectionStart);
            if (text.length() > 0 && this.isApplicableExpression(csmOffsetable = new CsmOffsetableImpl(this.file, this.selectionStart, this.selectionEnd, text))) {
                return csmOffsetable;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private boolean isApplicableExpression(CsmOffsetable expression) {
        final int startOffset = expression.getStartOffset();
        final int endOffset = expression.getEndOffset();
        final AtomicBoolean isAssignment = new AtomicBoolean(false);
        final AtomicBoolean isSingleID = new AtomicBoolean(true);
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                TokenHierarchy hi = TokenHierarchy.get((Document)ExpressionFinder.this.doc);
                TokenSequence ts = hi.tokenSequence();
                ts.move(startOffset);
                while (ts.moveNext()) {
                    Token token = ts.token();
                    if (ts.offset() >= endOffset) break;
                    if (CppTokenId.EQ.equals((Object)token.id()) || CppTokenId.MINUSEQ.equals((Object)token.id()) || CppTokenId.STAREQ.equals((Object)token.id()) || CppTokenId.SLASHEQ.equals((Object)token.id()) || CppTokenId.AMPEQ.equals((Object)token.id()) || CppTokenId.BAREQ.equals((Object)token.id()) || CppTokenId.CARETEQ.equals((Object)token.id()) || CppTokenId.PERCENTEQ.equals((Object)token.id()) || CppTokenId.LTLTEQ.equals((Object)token.id()) || CppTokenId.GTGTEQ.equals((Object)token.id())) {
                        isAssignment.set(true);
                        break;
                    }
                    if ("comment".equals(token.id().primaryCategory()) || "whitespace".equals(token.id().primaryCategory()) || "identifier".equals(token.id().primaryCategory())) continue;
                    isSingleID.set(false);
                }
            }
        });
        if (isAssignment.get()) {
            return false;
        }
        if (isSingleID.get()) {
            return false;
        }
        CsmType resolveType = CsmExpressionResolver.resolveType((CsmOffsetable)expression, null);
        if (resolveType == null) {
            return false;
        }
        String typeText = resolveType.getText().toString();
        return !"void".equals(typeText);
    }

    public boolean isExpressionSelection() {
        final AtomicBoolean applicableSelection = new AtomicBoolean(false);
        if (this.selectionStart < this.selectionEnd) {
            this.doc.render(new Runnable(){

                @Override
                public void run() {
                    TokenHierarchy hi = TokenHierarchy.get((Document)ExpressionFinder.this.doc);
                    TokenSequence ts = hi.tokenSequence();
                    ts.move(ExpressionFinder.this.selectionEnd);
                    boolean res = false;
                    if (ts.moveNext()) {
                        int from = ts.offset();
                        if (ExpressionFinder.this.selectionEnd == from) {
                            res = true;
                        }
                    }
                    if (!res) {
                        return;
                    }
                    ts.move(ExpressionFinder.this.selectionStart);
                    res = false;
                    if (ts.movePrevious()) {
                        Token token = ts.token();
                        int to = ts.offset() + token.length();
                        if (ExpressionFinder.this.selectionStart == to) {
                            res = true;
                        }
                    }
                    if (!res) {
                        return;
                    }
                    ts.move(ExpressionFinder.this.selectionStart);
                    int count = 0;
                    while (ts.moveNext()) {
                        Token token = ts.token();
                        if (ts.offset() >= ExpressionFinder.this.selectionEnd) break;
                        if (token.id() == CppTokenId.LPAREN) {
                            ++count;
                        }
                        if (token.id() != CppTokenId.RPAREN) continue;
                        --count;
                    }
                    if (count != 0) {
                        return;
                    }
                    applicableSelection.set(true);
                }
            });
        }
        return applicableSelection.get();
    }

    private static class CsmOffsetableImpl
    implements CsmOffsetable {
        private final CsmFile file;
        private final int selectionStart;
        private final int selectionEnd;
        private final String text;

        public CsmOffsetableImpl(CsmFile file, int selectionStart, int selectionEnd, String text) {
            this.file = file;
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
            this.text = text;
        }

        public CsmFile getContainingFile() {
            return this.file;
        }

        public int getStartOffset() {
            return this.selectionStart;
        }

        public int getEndOffset() {
            return this.selectionEnd;
        }

        public CsmOffsetable.Position getStartPosition() {
            return new CsmOffsetable.Position(){

                public int getOffset() {
                    return CsmOffsetableImpl.this.selectionStart;
                }

                public int getLine() {
                    return CsmFileInfoQuery.getDefault().getLineColumnByOffset(CsmOffsetableImpl.this.file, CsmOffsetableImpl.this.selectionStart)[0];
                }

                public int getColumn() {
                    return CsmFileInfoQuery.getDefault().getLineColumnByOffset(CsmOffsetableImpl.this.file, CsmOffsetableImpl.this.selectionStart)[1];
                }
            };
        }

        public CsmOffsetable.Position getEndPosition() {
            return new CsmOffsetable.Position(){

                public int getOffset() {
                    return CsmOffsetableImpl.this.selectionEnd;
                }

                public int getLine() {
                    return CsmFileInfoQuery.getDefault().getLineColumnByOffset(CsmOffsetableImpl.this.file, CsmOffsetableImpl.this.selectionEnd)[0];
                }

                public int getColumn() {
                    return CsmFileInfoQuery.getDefault().getLineColumnByOffset(CsmOffsetableImpl.this.file, CsmOffsetableImpl.this.selectionEnd)[1];
                }
            };
        }

        public CharSequence getText() {
            return this.text;
        }
    }

    public static final class StatementResult {
        private final CsmStatement container;
        private final CsmExpressionStatement expression;
        private CsmStatement statementInBody;
        private CsmCompoundStatement body;

        public StatementResult(CsmStatement container, CsmExpressionStatement expression) {
            this.expression = expression;
            this.container = container;
        }

        public CsmStatement getContainer() {
            return this.container;
        }

        public CsmExpressionStatement getExpression() {
            return this.expression;
        }

        public CsmStatement getStatementInBody() {
            return this.statementInBody;
        }

        public void setStatementInBody(CsmStatement statementInBody) {
            this.statementInBody = statementInBody;
        }

        public CsmCompoundStatement getBody() {
            return this.body;
        }

        public void setBody(CsmCompoundStatement body) {
            this.body = body;
        }

        public List<Pair<Integer, Integer>> getOccurrences(CsmOffsetable applicableTextExpression) {
            ArrayList<Pair<Integer, Integer>> occurrences = new ArrayList<Pair<Integer, Integer>>();
            if (this.getBody() != null) {
                String bodyText = this.getBody().getText().toString();
                String expressionText = applicableTextExpression.getText().toString();
                int since = applicableTextExpression.getEndOffset() - this.getBody().getStartOffset();
                this.findByTokenStream(occurrences, bodyText, expressionText, since, this.getBody().getStartOffset());
            }
            return occurrences;
        }

        private void findByTokenStream(List<Pair<Integer, Integer>> occurrences, String text, String sample, int start, int shift) {
            TokenHierarchy hi1 = TokenHierarchy.create((CharSequence)text, (Language)CppTokenId.languageCpp());
            TokenSequence textTS = hi1.tokenSequence();
            TokenHierarchy hi2 = TokenHierarchy.create((CharSequence)sample, (Language)CppTokenId.languageCpp());
            TokenSequence sampleTS = hi2.tokenSequence();
            textTS.move(start);
            while (textTS.moveNext()) {
                Token textToken = textTS.token();
                if (this.ignoredToken(textToken)) continue;
                int savedIndex = textTS.index();
                int startOffset = textTS.offset();
                int endOffset = -1;
                boolean match = true;
                sampleTS.moveStart();
                while (sampleTS.moveNext()) {
                    Token sampleToken = sampleTS.token();
                    if (this.ignoredToken(sampleToken)) continue;
                    if (textToken.id() == sampleToken.id() && textToken.text().toString().equals(sampleToken.text().toString())) {
                        endOffset = textTS.offset() + textToken.length();
                        boolean hasNext = false;
                        while (textTS.moveNext()) {
                            textToken = textTS.token();
                            if (this.ignoredToken(textToken)) continue;
                            hasNext = true;
                            break;
                        }
                        if (hasNext) continue;
                        match = false;
                        break;
                    }
                    match = false;
                    break;
                }
                if (!match) {
                    textTS.moveIndex(savedIndex);
                    textTS.moveNext();
                    continue;
                }
                occurrences.add((Pair<Integer, Integer>)Pair.of((Object)(shift + startOffset), (Object)(shift + endOffset)));
            }
        }

        private boolean ignoredToken(Token<?> token) {
            return CppTokenId.WHITESPACE.equals((Object)token.id()) || CppTokenId.BLOCK_COMMENT.equals((Object)token.id()) || CppTokenId.DOXYGEN_COMMENT.equals((Object)token.id()) || CppTokenId.DOXYGEN_LINE_COMMENT.equals((Object)token.id()) || CppTokenId.LINE_COMMENT.equals((Object)token.id()) || CppTokenId.ESCAPED_LINE.equals((Object)token.id()) || CppTokenId.ESCAPED_WHITESPACE.equals((Object)token.id()) || CppTokenId.NEW_LINE.equals((Object)token.id());
        }
    }
}

