/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.hints;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.deep.CsmExpressionStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.syntaxerr.AbstractCodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditFactory;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.refactoring.hints.AssignmentVariableFix;
import org.netbeans.modules.cnd.refactoring.hints.ExpressionFinder;
import org.netbeans.modules.cnd.refactoring.hints.InlineFix;
import org.netbeans.modules.cnd.refactoring.hints.IntroduceVariableFix;
import org.netbeans.modules.cnd.refactoring.hints.ReplaceWithPragmaOnce;
import org.netbeans.modules.cnd.refactoring.hints.StatementFinder;
import org.netbeans.modules.cnd.refactoring.hints.SuggestionProvider;
import org.netbeans.modules.cnd.refactoring.hints.SurroundWithIfndef;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.IndexingAwareParserResultTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.netbeans.modules.parsing.spi.support.CancelSupport;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SuggestionFactoryTask
extends IndexingAwareParserResultTask<Parser.Result> {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.cnd.model.tasks");
    private final CancelSupport cancel = CancelSupport.create((SchedulerTask)this);
    private AtomicBoolean canceled = new AtomicBoolean(false);

    public SuggestionFactoryTask() {
        super(TaskIndexingMode.ALLOWED_DURING_SCAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Parser.Result result, SchedulerEvent event) {
        SuggestionFactoryTask suggestionFactoryTask = this;
        synchronized (suggestionFactoryTask) {
            this.canceled.set(true);
            this.canceled = new AtomicBoolean(false);
        }
        if (this.cancel.isCancelled()) {
            return;
        }
        Collection audits = SuggestionProvider.getInstance().getAudits();
        boolean enabled = false;
        for (CodeAudit audit : audits) {
            if (!audit.isEnabled()) continue;
            enabled = true;
            break;
        }
        if (!enabled) {
            return;
        }
        long time = 0L;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "LineFactoryTask started");
            time = System.currentTimeMillis();
        }
        Document doc = result.getSnapshot().getSource().getDocument(false);
        FileObject fileObject = result.getSnapshot().getSource().getFileObject();
        CsmFile file = CsmFileInfoQuery.getDefault().getCsmFile(result);
        if (file != null && doc != null && doc.getProperty("macro-expansion-view-document") == null && event instanceof CursorMovedSchedulerEvent) {
            CsmCacheManager.enter();
            this.process(audits, doc, fileObject, (CursorMovedSchedulerEvent)event, file, this.canceled);
            CsmCacheManager.leave();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "LineFactoryTask finished for {0}ms", System.currentTimeMillis() - time);
        }
    }

    private void process(Collection<CodeAudit> audits, final Document doc, FileObject fileObject, CursorMovedSchedulerEvent cursorEvent, CsmFile file, AtomicBoolean canceled) {
        this.clearHint(doc, fileObject);
        int caretOffset = cursorEvent.getCaretOffset();
        JTextComponent comp = EditorRegistry.lastFocusedComponent();
        int selectionStart = caretOffset;
        int selectionEnd = caretOffset;
        if (comp != null) {
            selectionStart = Math.min(cursorEvent.getCaretOffset(), cursorEvent.getMarkOffset());
            selectionEnd = Math.max(cursorEvent.getCaretOffset(), cursorEvent.getMarkOffset());
        }
        if (canceled.get()) {
            return;
        }
        boolean introduce = false;
        boolean assign = false;
        boolean cases = false;
        boolean inline = false;
        boolean pragma = false;
        boolean defineMacro = false;
        for (CodeAudit audit : audits) {
            if ("IntroduceVariable".equals(audit.getID()) && audit.isEnabled()) {
                introduce = true;
                continue;
            }
            if ("AssignVariable".equals(audit.getID()) && audit.isEnabled()) {
                assign = true;
                continue;
            }
            if ("AddMissingCases".equals(audit.getID()) && audit.isEnabled()) {
                cases = true;
                continue;
            }
            if ("InstantInline".equals(audit.getID()) && audit.isEnabled()) {
                inline = true;
                continue;
            }
            if ("ReplaceWithPragmaOnce".equals(audit.getID()) && audit.isEnabled()) {
                pragma = true;
                continue;
            }
            if (!"SurroundWithIfndef".equals(audit.getID()) || !audit.isEnabled()) continue;
            defineMacro = true;
        }
        if (assign || introduce) {
            this.detectIntroduceVariable(file, caretOffset, selectionStart, selectionEnd, doc, canceled, assign, fileObject, introduce, comp);
        }
        if (cases && caretOffset > 0) {
            try {
                StatementFinder finder;
                CsmStatement findStatement;
                String text = doc.getText(caretOffset - 1, 1);
                if (text.startsWith("{") && (findStatement = (finder = new StatementFinder(doc, file, caretOffset, selectionStart, selectionEnd, canceled)).findStatement()) != null && findStatement.getKind() == CsmStatement.Kind.SWITCH) {
                    this.createSwitchHint(findStatement, doc, comp, fileObject, caretOffset);
                }
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
        if (inline) {
            CsmReference ref = CsmReferenceResolver.getDefault().findReference(doc, caretOffset);
            if (ref == null) {
                return;
            }
            if (CsmKindUtilities.isMacro((CsmObject)ref.getReferencedObject())) {
                String replacement = CsmMacroExpansion.expand((Document)doc, (CsmFile)file, (int)ref.getStartOffset(), (int)ref.getEndOffset(), (boolean)false);
                int refLine = CsmFileInfoQuery.getDefault().getLineColumnByOffset(file, ref.getStartOffset())[0];
                int objLine = CsmFileInfoQuery.getDefault().getLineColumnByOffset(file, ((CsmMacro)ref.getReferencedObject()).getStartOffset())[0];
                if (replacement != null && !replacement.isEmpty() && refLine != objLine) {
                    this.createInstantInlineHint(ref, doc, file, fileObject, replacement);
                }
            }
        }
        if (pragma) {
            CsmFileInfoQuery query = CsmFileInfoQuery.getDefault();
            if (file.isHeaderFile() && query.hasGuardBlock(file) && CndTokenUtilities.isInPreprocessorDirective((Document)doc, (int)caretOffset)) {
                final AtomicIntegerArray result = new AtomicIntegerArray(2);
                result.set(0, -1);
                result.set(1, -1);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        TokenSequence docTokenSequence = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)doc.getLength(), (boolean)false, (boolean)true);
                        if (docTokenSequence == null) {
                            return;
                        }
                        boolean isGuardMacro = false;
                        docTokenSequence.moveStart();
                        while (docTokenSequence.moveNext()) {
                            if (!(docTokenSequence.token().id() instanceof CppTokenId)) continue;
                            CppTokenId tokenId = (CppTokenId)docTokenSequence.token().id();
                            if (tokenId.equals((Object)CppTokenId.PREPROCESSOR_DIRECTIVE)) {
                                TokenSequence preprocTokenSequence = docTokenSequence.embedded(CppTokenId.languagePreproc());
                                if (preprocTokenSequence == null) {
                                    return;
                                }
                                preprocTokenSequence.moveStart();
                                block8: while (preprocTokenSequence.moveNext()) {
                                    switch ((CppTokenId)preprocTokenSequence.token().id()) {
                                        case PREPROCESSOR_PRAGMA: {
                                            return;
                                        }
                                        case PREPROCESSOR_IFNDEF: {
                                            result.set(0, preprocTokenSequence.offset());
                                            isGuardMacro = true;
                                            preprocTokenSequence.moveEnd();
                                            continue block8;
                                        }
                                        case PREPROCESSOR_IF: {
                                            isGuardMacro = true;
                                            continue block8;
                                        }
                                        case PREPROCESSOR_DEFINED: {
                                            if (isGuardMacro) {
                                                result.set(0, preprocTokenSequence.offset());
                                                preprocTokenSequence.moveEnd();
                                                continue block8;
                                            }
                                            return;
                                        }
                                        case PREPROCESSOR_DEFINE: {
                                            if (isGuardMacro) {
                                                result.set(1, preprocTokenSequence.offset());
                                            }
                                            return;
                                        }
                                    }
                                }
                                continue;
                            }
                            if (tokenId.primaryCategory().equals("whitespace") || tokenId.primaryCategory().equals("comment")) continue;
                            isGuardMacro = false;
                        }
                    }
                };
                FutureTask<AtomicIntegerArray> atomicOffsetsArray = new FutureTask<AtomicIntegerArray>(runnable, result);
                doc.render(atomicOffsetsArray);
                try {
                    int startResult = atomicOffsetsArray.get().get(0);
                    int endResult = atomicOffsetsArray.get().get(1);
                    if (startResult != -1 && endResult != -1) {
                        int startGuardLine = query.getLineColumnByOffset(file, startResult)[0];
                        int guardStart = (int)query.getOffset(file, startGuardLine, 1);
                        int endGuardLine = query.getLineColumnByOffset(file, endResult)[0] + 1;
                        int guardEnd = (int)query.getOffset(file, endGuardLine, 1) - 1;
                        if (caretOffset >= guardStart && caretOffset <= guardEnd) {
                            this.createReplaceWithPragmaOnceHint(caretOffset, doc, fileObject, guardStart, guardEnd);
                        }
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (defineMacro) {
            CsmMacro macro;
            CsmReference reference = CsmReferenceResolver.getDefault().findReference(file, doc, caretOffset);
            if (reference == null) {
                return;
            }
            if (CsmKindUtilities.isMacro((CsmObject)reference.getReferencedObject()) && caretOffset >= (macro = (CsmMacro)reference.getReferencedObject()).getStartOffset() && caretOffset <= macro.getEndOffset() && macro.getKind().equals((Object)CsmMacro.Kind.DEFINED)) {
                final int caret = caretOffset;
                final AtomicBoolean isLoneDefine = new AtomicBoolean(false);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        CppTokenId tokenId;
                        TokenSequence docTokenSequence = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)caret, (boolean)false, (boolean)true);
                        if (docTokenSequence == null) {
                            return;
                        }
                        docTokenSequence.movePrevious();
                        if (docTokenSequence.token().id() instanceof CppTokenId && (tokenId = (CppTokenId)docTokenSequence.token().id()).equals((Object)CppTokenId.PREPROCESSOR_DIRECTIVE)) {
                            TokenSequence preprocTokenSequence = docTokenSequence.embedded(CppTokenId.languagePreproc());
                            if (preprocTokenSequence == null) {
                                return;
                            }
                            preprocTokenSequence.moveStart();
                            preprocTokenSequence.moveNext();
                            preprocTokenSequence.moveNext();
                            CppTokenId preprocTokenId = (CppTokenId)preprocTokenSequence.token().id();
                            if (preprocTokenId.equals((Object)CppTokenId.PREPROCESSOR_IFNDEF) || preprocTokenId.equals((Object)CppTokenId.PREPROCESSOR_IF) || preprocTokenId.equals((Object)CppTokenId.PREPROCESSOR_ELIF) || preprocTokenId.equals((Object)CppTokenId.PREPROCESSOR_ELSE)) {
                                return;
                            }
                        }
                        isLoneDefine.set(true);
                    }
                };
                FutureTask<AtomicBoolean> checkLoneDefine = new FutureTask<AtomicBoolean>(runnable, isLoneDefine);
                doc.render(checkLoneDefine);
                try {
                    if (checkLoneDefine.get().get()) {
                        this.createSurroundWithIfndef(reference, doc, file, fileObject, macro.getName().toString());
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }

    private void detectIntroduceVariable(CsmFile file, int caretOffset, int selectionStart, int selectionEnd, Document doc, AtomicBoolean canceled, boolean assign, FileObject fileObject, boolean introduce, JTextComponent comp) {
        CsmOffsetable applicableTextExpression;
        CsmExpressionStatement expression;
        ExpressionFinder expressionFinder = new ExpressionFinder(doc, file, caretOffset, selectionStart, selectionEnd, canceled);
        ExpressionFinder.StatementResult res = expressionFinder.findExpressionStatement();
        if (res == null) {
            return;
        }
        if (canceled.get()) {
            return;
        }
        if (assign && (expression = res.getExpression()) != null) {
            this.createStatementHint(expression, doc, fileObject);
        }
        if (introduce && res.getContainer() != null && res.getStatementInBody() != null && comp != null && selectionStart < selectionEnd && expressionFinder.isExpressionSelection() && (res.getContainer().getStartOffset() != selectionStart || res.getContainer().getEndOffset() != selectionEnd) && (applicableTextExpression = expressionFinder.applicableTextExpression()) != null) {
            this.createExpressionHint(res.getStatementInBody(), applicableTextExpression, doc, comp, fileObject);
        }
    }

    private void createStatementHint(CsmExpressionStatement expression, Document doc, FileObject fo) {
        List<AssignmentVariableFix> fixes = Collections.singletonList(new AssignmentVariableFix(expression.getExpression(), doc, fo));
        String description = NbBundle.getMessage(SuggestionFactoryTask.class, (String)"AssignVariable.name");
        List<ErrorDescription> hints = Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)description, fixes, (FileObject)fo, (int)expression.getStartOffset(), (int)expression.getStartOffset()));
        HintsController.setErrors((Document)doc, (String)SuggestionFactoryTask.class.getName(), hints);
    }

    private void createExpressionHint(CsmStatement st, CsmOffsetable expression, Document doc, JTextComponent comp, FileObject fo) {
        List<IntroduceVariableFix> fixes = Collections.singletonList(new IntroduceVariableFix(st, expression, doc, comp, fo));
        String description = NbBundle.getMessage(SuggestionFactoryTask.class, (String)"IntroduceVariable.name");
        List<ErrorDescription> hints = Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)description, fixes, (FileObject)fo, (int)expression.getStartOffset(), (int)expression.getStartOffset()));
        HintsController.setErrors((Document)doc, (String)SuggestionFactoryTask.class.getName(), hints);
    }

    private void createSwitchHint(CsmStatement st, Document doc, JTextComponent comp, FileObject fo, int caretOffset) {
        List<StatementFinder.AddMissingCasesFixImpl> fixes = Collections.singletonList(new StatementFinder.AddMissingCasesFixImpl(st, doc, comp, fo, caretOffset));
        String description = NbBundle.getMessage(SuggestionFactoryTask.class, (String)"AddMissingCases.name");
        List<ErrorDescription> hints = Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)description, fixes, (FileObject)fo, (int)st.getStartOffset(), (int)st.getStartOffset()));
        HintsController.setErrors((Document)doc, (String)SuggestionFactoryTask.class.getName(), hints);
    }

    private void createInstantInlineHint(CsmReference ref, Document doc, CsmFile file, FileObject fo, String replacement) {
        List<InlineFix> fixes = Collections.singletonList(new InlineFix(ref, doc, file, replacement));
        String description = NbBundle.getMessage(SuggestionFactoryTask.class, (String)"InstantInline.name");
        List<ErrorDescription> hints = Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)description, fixes, (FileObject)fo, (int)ref.getStartOffset(), (int)ref.getStartOffset()));
        HintsController.setErrors((Document)doc, (String)SuggestionFactoryTask.class.getName(), hints);
    }

    private void createReplaceWithPragmaOnceHint(int caret, Document doc, FileObject fo, int guardBlockStart, int guardBlockEnd) {
        List<ReplaceWithPragmaOnce> fixes = Collections.singletonList(new ReplaceWithPragmaOnce(doc, guardBlockStart, guardBlockEnd));
        String text = NbBundle.getMessage(ReplaceWithPragmaOnce.class, (String)"HINT_Pragma");
        List<ErrorDescription> hints = Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)text, fixes, (FileObject)fo, (int)caret, (int)caret));
        HintsController.setErrors((Document)doc, (String)SuggestionFactoryTask.class.getName(), hints);
    }

    private void createSurroundWithIfndef(CsmReference ref, Document doc, CsmFile file, FileObject fo, String macroIdentifier) {
        List<SurroundWithIfndef> fixes = Collections.singletonList(new SurroundWithIfndef(doc, file, ref, macroIdentifier));
        String text = NbBundle.getMessage(ReplaceWithPragmaOnce.class, (String)"HINT_Ifndef");
        List<ErrorDescription> hints = Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)text, fixes, (FileObject)fo, (int)ref.getStartOffset(), (int)ref.getEndOffset()));
        HintsController.setErrors((Document)doc, (String)SuggestionFactoryTask.class.getName(), hints);
    }

    private void clearHint(Document doc, FileObject fo) {
        HintsController.setErrors((Document)doc, (String)SuggestionFactoryTask.class.getName(), Collections.emptyList());
    }

    public int getPriority() {
        return 500;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        SuggestionFactoryTask suggestionFactoryTask = this;
        synchronized (suggestionFactoryTask) {
            this.canceled.set(true);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "LineFactoryTask cancelled");
        }
    }

    public static final class SurroundWithIfndefAudit
    implements CodeAuditFactory {
        private static final String ID = "SurroundWithIfndef";

        public AbstractCodeAudit create(AuditPreferences preferences) {
            String text = NbBundle.getMessage(SurroundWithIfndef.class, (String)"HINT_Ifndef");
            return new AbstractCodeAudit(ID, text, text, "warning", true, preferences){

                public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
                    return true;
                }

                public String getKind() {
                    return "action";
                }

                public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static final class PragmaOnceAudit
    implements CodeAuditFactory {
        private static final String ID = "ReplaceWithPragmaOnce";

        public AbstractCodeAudit create(AuditPreferences preferences) {
            String text = NbBundle.getMessage(ReplaceWithPragmaOnce.class, (String)"HINT_Pragma");
            return new AbstractCodeAudit(ID, text, text, "warning", true, preferences){

                public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
                    return true;
                }

                public String getKind() {
                    return "action";
                }

                public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static final class InstantInline
    implements CodeAuditFactory {
        private static final String ID = "InstantInline";

        public AbstractCodeAudit create(AuditPreferences preferences) {
            String name = NbBundle.getMessage(InstantInline.class, (String)"InstantInline.name");
            String description = NbBundle.getMessage(InstantInline.class, (String)"InstantInline.description");
            return new AbstractCodeAudit(ID, name, description, "warning", true, preferences){

                public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
                    return true;
                }

                public String getKind() {
                    return "action";
                }

                public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static final class AddMissingCases
    implements CodeAuditFactory {
        private static final String ID = "AddMissingCases";

        public AbstractCodeAudit create(AuditPreferences preferences) {
            String name = NbBundle.getMessage(SuggestionFactoryTask.class, (String)"AddMissingCases.name");
            String description = NbBundle.getMessage(SuggestionFactoryTask.class, (String)"AddMissingCases.description");
            return new AbstractCodeAudit(ID, name, description, "warning", true, preferences){

                public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
                    return true;
                }

                public String getKind() {
                    return "action";
                }

                public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static final class AssignVariable
    implements CodeAuditFactory {
        private static final String ID = "AssignVariable";

        public AbstractCodeAudit create(AuditPreferences preferences) {
            String name = NbBundle.getMessage(SuggestionFactoryTask.class, (String)"AssignVariable.name");
            String description = NbBundle.getMessage(SuggestionFactoryTask.class, (String)"AssignVariable.description");
            return new AbstractCodeAudit(ID, name, description, "warning", true, preferences){

                public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
                    return true;
                }

                public String getKind() {
                    return "action";
                }

                public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static final class IntroduceVariable
    implements CodeAuditFactory {
        private static final String ID = "IntroduceVariable";

        public AbstractCodeAudit create(AuditPreferences preferences) {
            String name = NbBundle.getMessage(SuggestionFactoryTask.class, (String)"IntroduceVariable.name");
            String description = NbBundle.getMessage(SuggestionFactoryTask.class, (String)"IntroduceVariable.description");
            return new AbstractCodeAudit(ID, name, description, "warning", true, preferences){

                public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
                    return true;
                }

                public String getKind() {
                    return "action";
                }

                public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class SuggestionSourceFactory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singletonList(new SuggestionFactoryTask());
        }
    }
}

