/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.editor.api.FormattingSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.cnd.refactoring.api.IntroduceMethodRefactoring;
import org.netbeans.modules.cnd.refactoring.introduce.BodyFinder;
import org.netbeans.modules.cnd.refactoring.plugins.CsmModificationRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.plugins.CsmRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.refactoring.api.Problem;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;

public class IntroduceMethodPlugin
extends CsmModificationRefactoringPlugin {
    private final IntroduceMethodRefactoring refactoring;
    private BodyFinder referencedMethod;
    private BodyFinder.BodyResult bodyResult;

    public IntroduceMethodPlugin(IntroduceMethodRefactoring refactoring) {
        super(refactoring);
        this.refactoring = refactoring;
    }

    @Override
    protected Collection<CsmFile> getRefactoredFiles() {
        CsmFunction functionDeclaration;
        CsmFile containingFile;
        if (this.bodyResult == null) {
            return Collections.emptySet();
        }
        ArrayList<CsmFile> res = new ArrayList<CsmFile>();
        res.add(this.bodyResult.getFunction().getContainingFile());
        if (this.bodyResult.getFunctionKind() == IntroduceMethodRefactoring.IntroduceMethodContext.FunctionKind.MethodDefinition && !res.contains(containingFile = (functionDeclaration = this.bodyResult.getFunctionDeclaration()).getContainingFile())) {
            res.add(containingFile);
        }
        return res;
    }

    @Override
    public Problem fastCheckParameters() {
        Problem p = null;
        String functionName = this.refactoring.getFunctionName();
        if (!CndLexerUtilities.isCppIdentifier((CharSequence)functionName)) {
            return CsmRefactoringPlugin.createProblem(p, true, NbBundle.getMessage(IntroduceMethodPlugin.class, (String)"ERR_InvalidFunctionName", (Object)functionName));
        }
        IntroduceMethodRefactoring.ParameterInfo[] paramTable = this.refactoring.getParameterInfo();
        for (int i = 0; i < paramTable.length; ++i) {
            IntroduceMethodRefactoring.ParameterInfo in = paramTable[i];
            if (!in.getType().toString().endsWith("&") || !in.isByRef()) continue;
            return CsmRefactoringPlugin.createProblem(p, true, NbBundle.getMessage(IntroduceMethodPlugin.class, (String)"ERR_DoubleReference", (Object[])new Object[0]));
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Problem preCheck() {
        Problem preCheckProblem = null;
        this.fireProgressListenerStart(1, 5);
        this.fireProgressListenerStep();
        try {
            CsmContext editorContext = this.getEditorContext();
            AtomicBoolean canceled = new AtomicBoolean();
            this.referencedMethod = new BodyFinder(editorContext.getDocument(), editorContext.getFileObject(), editorContext.getFile(), editorContext.getCaretOffset(), editorContext.getStartOffset(), editorContext.getEndOffset(), canceled);
            this.refactoring.getRefactoringSource();
            this.bodyResult = this.referencedMethod.findBody();
            if (this.bodyResult == null) {
                Problem problem = new Problem(true, NbBundle.getMessage(IntroduceMethodPlugin.class, (String)"ERR_BadSelection"));
                return problem;
            }
            if (!this.bodyResult.isApplicable(new AtomicBoolean(false))) {
                Problem problem = new Problem(true, NbBundle.getMessage(IntroduceMethodPlugin.class, (String)"ERR_BadSelection"));
                return problem;
            }
            this.refactoring.setIntroduceMethodContext(this.bodyResult);
        }
        finally {
            this.fireProgressListenerStop();
        }
        return preCheckProblem;
    }

    @Override
    protected final void processFile(CsmFile csmFile, ModificationResult mr, AtomicReference<Problem> outProblem) {
        CsmFile containingFile = this.bodyResult.getFunction().getContainingFile();
        if (csmFile.equals(containingFile)) {
            CsmFunction functionDeclaration;
            CsmFile containingFile2;
            ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
            FileObject fo = CsmUtilities.getFileObject((CsmFile)csmFile);
            CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
            String method = FormattingSupport.getIndentedText((Document)this.bodyResult.getDocument(), (int)this.bodyResult.getInsetionOffset(), (CharSequence)this.refactoring.getMethodDefinition()).toString();
            PositionRef startPos = ces.createPositionRef(this.bodyResult.getInsetionOffset(), Position.Bias.Forward);
            PositionRef endPos = ces.createPositionRef(this.bodyResult.getInsetionOffset(), Position.Bias.Backward);
            String message = this.bodyResult.getFunctionKind() == IntroduceMethodRefactoring.IntroduceMethodContext.FunctionKind.Function ? NbBundle.getMessage(IntroduceMethodPlugin.class, (String)"LBL_Preview_FunctionDefinition") : NbBundle.getMessage(IntroduceMethodPlugin.class, (String)"LBL_Preview_MethodDefinition");
            ModificationResult.Difference diff = new ModificationResult.Difference(ModificationResult.Difference.Kind.INSERT, startPos, endPos, "", method, message);
            diffs.add(diff);
            String methodCall = this.refactoring.getMethodCall();
            startPos = ces.createPositionRef(this.bodyResult.getSelectionFrom(), Position.Bias.Forward);
            endPos = ces.createPositionRef(this.bodyResult.getSelectionTo(), Position.Bias.Backward);
            message = this.bodyResult.getFunctionKind() == IntroduceMethodRefactoring.IntroduceMethodContext.FunctionKind.Function ? NbBundle.getMessage(IntroduceMethodPlugin.class, (String)"LBL_Preview_FunctionCall") : NbBundle.getMessage(IntroduceMethodPlugin.class, (String)"LBL_Preview_MethodCall");
            diff = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, startPos, endPos, "", methodCall, message);
            diffs.add(diff);
            if (this.bodyResult.getFunctionKind() == IntroduceMethodRefactoring.IntroduceMethodContext.FunctionKind.MethodDefinition && containingFile.equals(containingFile2 = (functionDeclaration = this.bodyResult.getFunctionDeclaration()).getContainingFile())) {
                String decl = FormattingSupport.getIndentedText((Document)CsmUtilities.openDocument((CloneableEditorSupport)ces), (int)this.refactoring.getDeclarationInsetOffset(), (CharSequence)this.refactoring.getMethodDeclaration()).toString();
                startPos = ces.createPositionRef(this.refactoring.getDeclarationInsetOffset(), Position.Bias.Forward);
                endPos = ces.createPositionRef(this.refactoring.getDeclarationInsetOffset(), Position.Bias.Backward);
                diff = new ModificationResult.Difference(ModificationResult.Difference.Kind.INSERT, startPos, endPos, "", decl, NbBundle.getMessage(IntroduceMethodPlugin.class, (String)"LBL_Preview_MethodDeclaration"));
                diffs.add(diff);
            }
            Collections.sort(diffs, new Comparator<ModificationResult.Difference>(){

                @Override
                public int compare(ModificationResult.Difference o1, ModificationResult.Difference o2) {
                    return o1.getStartPosition().getOffset() - o2.getStartPosition().getOffset();
                }
            });
            for (ModificationResult.Difference df : diffs) {
                mr.addDifference(fo, df);
            }
        } else {
            containingFile = this.bodyResult.getFunctionDeclaration().getContainingFile();
            if (csmFile.equals(containingFile)) {
                FileObject fo = CsmUtilities.getFileObject((CsmFile)csmFile);
                CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
                String decl = FormattingSupport.getIndentedText((Document)CsmUtilities.openDocument((CloneableEditorSupport)ces), (int)this.refactoring.getDeclarationInsetOffset(), (CharSequence)this.refactoring.getMethodDeclaration()).toString();
                PositionRef startPos = ces.createPositionRef(this.refactoring.getDeclarationInsetOffset(), Position.Bias.Forward);
                PositionRef endPos = ces.createPositionRef(this.refactoring.getDeclarationInsetOffset(), Position.Bias.Backward);
                ModificationResult.Difference diff = new ModificationResult.Difference(ModificationResult.Difference.Kind.INSERT, startPos, endPos, "", decl, NbBundle.getMessage(IntroduceMethodPlugin.class, (String)"LBL_Preview_MethodDeclaration"));
                mr.addDifference(fo, diff);
            }
        }
    }
}

