/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.RefactoringModule;
import org.netbeans.modules.cnd.refactoring.ui.RenameRefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RenamePanel
extends JPanel
implements CustomRefactoringPanel {
    private final transient String oldName;
    private final transient ChangeListener parent;
    private final transient CsmObject origObject;
    private boolean initialized = false;
    private JPanel jPanel1;
    private JLabel label;
    private JTextField nameField;
    private JCheckBox textCheckBox;
    private JCheckBox updateReferencesCheckBox;

    public RenamePanel(CsmObject origObject, String oldName, ChangeListener parent, String name, boolean editable, boolean showUpdateReferences) {
        this.setName(name);
        this.oldName = oldName;
        this.parent = parent;
        this.origObject = origObject;
        this.initComponents();
        this.updateReferencesCheckBox.setVisible(showUpdateReferences);
        this.nameField.setEnabled(editable);
        this.nameField.requestFocus();
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                RenamePanel.this.parent.stateChanged(null);
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                RenamePanel.this.parent.stateChanged(null);
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                RenamePanel.this.parent.stateChanged(null);
            }
        });
    }

    @Override
    public boolean requestFocusInWindow() {
        this.nameField.requestFocusInWindow();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try {
            CsmCacheManager.enter();
            CsmObject resolvedObject = CsmRefactoringUtils.getReferencedElement(this.origObject);
            String objKindStr = RenamePanel.getObjectKind(resolvedObject);
            final String title = NbBundle.getMessage(RenamePanel.class, (String)"LBL_RenamePanelTitle", (Object)objKindStr, (Object)this.oldName);
            final RenamePanel panel = this;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    panel.setName(title);
                }
            });
        }
        finally {
            CsmCacheManager.leave();
        }
    }

    private static String getObjectKind(CsmObject obj) {
        String kindName = "";
        if (obj != null) {
            if (CsmKindUtilities.isClass((CsmObject)obj)) {
                CsmDeclaration.Kind kind = ((CsmClass)obj).getKind();
                if (kind == CsmDeclaration.Kind.STRUCT) {
                    kindName = RenamePanel.getString("LBL_Struct");
                } else if (kind == CsmDeclaration.Kind.UNION) {
                    kindName = RenamePanel.getString("LBL_Union");
                } else {
                    assert (kind == CsmDeclaration.Kind.CLASS) : "unexpected kind " + kind;
                    kindName = RenamePanel.getString("LBL_Class");
                }
            } else if (CsmKindUtilities.isEnum((CsmObject)obj)) {
                kindName = RenamePanel.getString("LBL_Enum");
            } else if (CsmKindUtilities.isMacro((CsmObject)obj)) {
                kindName = RenamePanel.getString("LBL_Macro");
            } else if (CsmKindUtilities.isFile((CsmObject)obj)) {
                kindName = RenamePanel.getString("LBL_File");
            } else if (CsmKindUtilities.isField((CsmObject)obj)) {
                kindName = RenamePanel.getString("LBL_Field");
            } else if (CsmKindUtilities.isParamVariable((CsmObject)obj)) {
                kindName = RenamePanel.getString("LBL_Parameter");
            } else if (CsmKindUtilities.isEnumerator((Object)obj)) {
                kindName = RenamePanel.getString("LBL_Enumerator");
            } else if (CsmKindUtilities.isVariable((CsmObject)obj)) {
                kindName = RenamePanel.getString("LBL_Variable");
            } else if (CsmKindUtilities.isNamespace((Object)obj)) {
                kindName = RenamePanel.getString("LBL_Namespace");
            } else if (CsmKindUtilities.isConstructor((CsmObject)obj)) {
                kindName = RenamePanel.getString("LBL_Constructor");
            } else if (CsmKindUtilities.isMethod((CsmObject)obj)) {
                kindName = RenamePanel.getString("LBL_Method");
            } else if (CsmKindUtilities.isFunction((CsmObject)obj)) {
                kindName = RenamePanel.getString("LBL_Function");
            } else if (CsmKindUtilities.isTypedef((CsmObject)obj)) {
                kindName = RenamePanel.getString("LBL_Typedef");
            } else if (CsmKindUtilities.isTypeAlias((CsmObject)obj)) {
                kindName = RenamePanel.getString("LBL_TypeAlias");
            }
        }
        return kindName;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(RenameRefactoringUI.class, (String)key);
    }

    @Override
    public void requestFocus() {
        this.nameField.requestFocus();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.nameField = new JTextField();
        this.jPanel1 = new JPanel();
        this.textCheckBox = new JCheckBox();
        this.updateReferencesCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setLayout(new GridBagLayout());
        this.label.setHorizontalAlignment(2);
        this.label.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getMessage(RenamePanel.class, (String)"LBL_NewName"));
        this.add((Component)this.label, new GridBagConstraints());
        this.nameField.setText(this.oldName);
        this.nameField.selectAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.nameField, gridBagConstraints);
        this.nameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RenamePanel.class, (String)"ACSD_nameField"));
        this.jPanel1.setMinimumSize(new Dimension(0, 0));
        this.jPanel1.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.textCheckBox.setSelected(RefactoringModule.getOption("searchInComments.rename", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.textCheckBox, (String)NbBundle.getBundle(RenamePanel.class).getString("LBL_RenameComments"));
        this.textCheckBox.setEnabled(false);
        this.textCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RenamePanel.this.textCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.textCheckBox, gridBagConstraints);
        this.textCheckBox.getAccessibleContext().setAccessibleDescription(this.textCheckBox.getText());
        Mnemonics.setLocalizedText((AbstractButton)this.updateReferencesCheckBox, (String)NbBundle.getBundle(RenamePanel.class).getString("LBL_RenameWithoutRefactoring"));
        this.updateReferencesCheckBox.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.updateReferencesCheckBox.setMargin(new Insets(2, 2, 0, 2));
        this.updateReferencesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.updateReferencesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.updateReferencesCheckBox, gridBagConstraints);
        this.updateReferencesCheckBox.getAccessibleContext().setAccessibleDescription(this.updateReferencesCheckBox.getText());
    }

    private void updateReferencesCheckBoxActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    private void textCheckBoxItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("searchInComments.rename", b);
    }

    public String getNameValue() {
        return this.nameField.getText();
    }

    public boolean searchInComments() {
        return this.textCheckBox.isSelected();
    }

    public boolean isUpdateReferences() {
        return !this.updateReferencesCheckBox.isVisible() || !this.updateReferencesCheckBox.isSelected();
    }

    public Component getComponent() {
        return this;
    }
}

