/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import javax.jws.soap.SOAPBinding;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.SetAnnotationArgument;
import org.netbeans.modules.websvc.editor.hints.rules.AbstractWebServiceRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class RPCStyleWrappedParameterStyle
extends AbstractWebServiceRule {
    @Override
    protected ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        AnnotationMirror annEntity = Utilities.findAnnotation(subject, "javax.jws.soap.SOAPBinding");
        if (annEntity != null) {
            AnnotationValue styleVal = Utilities.getAnnotationAttrValue(annEntity, "style");
            SOAPBinding.Style style = null;
            if (styleVal != null) {
                try {
                    style = SOAPBinding.Style.valueOf((String)styleVal.getValue().toString());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            AnnotationValue useVal = Utilities.getAnnotationAttrValue(annEntity, "use");
            SOAPBinding.Use use = null;
            if (useVal != null) {
                try {
                    use = SOAPBinding.Use.valueOf((String)useVal.getValue().toString());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            AnnotationValue paramStyleVal = Utilities.getAnnotationAttrValue(annEntity, "parameterStyle");
            SOAPBinding.ParameterStyle paramStyle = null;
            if (useVal != null) {
                try {
                    paramStyle = SOAPBinding.ParameterStyle.valueOf((String)paramStyleVal.getValue().toString());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (style == SOAPBinding.Style.RPC && use == SOAPBinding.Use.LITERAL && paramStyle != SOAPBinding.ParameterStyle.WRAPPED) {
                String label = NbBundle.getMessage(RPCStyleWrappedParameterStyle.class, (String)"MSG_RPCStyle_ParameterStyleWrapped");
                SetAnnotationArgument fix = new SetAnnotationArgument(ctx.getFileObject(), subject, annEntity, "parameterStyle", SOAPBinding.ParameterStyle.WRAPPED);
                AnnotationTree annotationTree = (AnnotationTree)ctx.getCompilationInfo().getTrees().getTree(subject, annEntity);
                ExpressionTree problemTree = paramStyle != null ? Utilities.getAnnotationArgumentTree(annotationTree, "parameterStyle") : ctx.getCompilationInfo().getTrees().getTree(subject, annEntity);
                ctx.setElementToAnnotate(problemTree);
                ErrorDescription problem = RPCStyleWrappedParameterStyle.createProblem((Element)subject, ctx, label, fix);
                ctx.setElementToAnnotate(null);
                return new ErrorDescription[]{problem};
            }
        }
        return null;
    }
}

