/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.libraries;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.exec.NpmExecutable;
import org.netbeans.modules.javascript.nodejs.ui.libraries.Library;
import org.openide.util.RequestProcessor;

public class LibraryProvider {
    private static final Map<Project, LibraryProvider> providers = Collections.synchronizedMap(new WeakHashMap());
    private static final RequestProcessor RP = new RequestProcessor(LibraryProvider.class.getName(), 3);
    private final Project project;
    private final Map<String, WeakReference<Library[]>> searchCache = Collections.synchronizedMap(new HashMap());
    private final Map<String, WeakReference<Library>> detailCache = Collections.synchronizedMap(new HashMap());
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private LibraryProvider(Project project) {
        this.project = project;
    }

    public static synchronized LibraryProvider forProject(Project project) {
        LibraryProvider provider = providers.get(project);
        if (provider == null) {
            provider = new LibraryProvider(project);
            providers.put(project, provider);
        }
        return provider;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public Library[] findLibraries(String searchTerm) {
        WeakReference<Library[]> reference = this.searchCache.get(searchTerm);
        Library[] result = null;
        if (reference != null) {
            result = (Library[])reference.get();
        }
        if (result == null) {
            SearchTask task = new SearchTask(searchTerm);
            RP.post((Runnable)task);
        }
        return result;
    }

    public Library libraryDetails(String libraryName, boolean cachedOnly) {
        WeakReference<Library> reference = this.detailCache.get(libraryName);
        Library result = null;
        if (reference != null) {
            result = (Library)reference.get();
        }
        if (result == null && !cachedOnly) {
            JSONObject details;
            assert (!EventQueue.isDispatchThread());
            NpmExecutable executable = NpmExecutable.getDefault(this.project, false);
            if (executable != null && (details = executable.view(libraryName)) != null) {
                result = this.parseLibraryDetails(details);
                reference = new WeakReference<Library>(result);
                this.detailCache.put(libraryName, reference);
            }
        }
        return result;
    }

    public Map<String, String> installedLibraries() {
        JSONObject json;
        HashMap<String, String> result = null;
        NpmExecutable executable = NpmExecutable.getDefault(this.project, false);
        if (executable != null && (json = executable.list(0)) != null) {
            result = new HashMap<String, String>();
            JSONObject dependencies = (JSONObject)json.get((Object)"dependencies");
            if (dependencies != null) {
                for (Object key : dependencies.keySet()) {
                    JSONObject libraryInfo;
                    String versionName;
                    Object value = dependencies.get(key);
                    if (!(value instanceof JSONObject) || (versionName = (String)(libraryInfo = (JSONObject)value).get((Object)"version")) == null) continue;
                    String libraryName = key.toString();
                    result.put(libraryName, versionName);
                }
            }
        }
        return result;
    }

    private Library parseLibraryDetails(JSONObject viewInfo) {
        Library.Version[] versions;
        String name = (String)viewInfo.get((Object)"name");
        Library library = new Library(name);
        String latestVersionName = (String)viewInfo.get((Object)"version");
        Library.Version latestVersion = null;
        Object versionsObject = viewInfo.get((Object)"versions");
        if (versionsObject instanceof JSONArray) {
            JSONArray versionArray = (JSONArray)viewInfo.get((Object)"versions");
            versions = new Library.Version[versionArray.size()];
            for (int i = 0; i < versionArray.size(); ++i) {
                String versionName = (String)versionArray.get(i);
                Library.Version version = new Library.Version(library, versionName);
                if (versionName.equals(latestVersionName)) {
                    latestVersion = version;
                }
                versions[i] = version;
            }
        } else {
            latestVersion = new Library.Version(library, versionsObject.toString());
            versions = new Library.Version[]{latestVersion};
        }
        library.setVersions(versions);
        library.setLatestVersion(latestVersion);
        return library;
    }

    void updateCache(String searchTerm, Library[] libraries) {
        if (libraries != null) {
            WeakReference<Library[]> reference = new WeakReference<Library[]>(libraries);
            this.searchCache.put(searchTerm, reference);
        }
        this.propertyChangeSupport.firePropertyChange(searchTerm, null, libraries);
    }

    private class SearchTask
    implements Runnable {
        private final String searchTerm;

        SearchTask(String searchTerm) {
            this.searchTerm = searchTerm;
        }

        @Override
        public void run() {
            NpmExecutable executable = NpmExecutable.getDefault(LibraryProvider.this.project, false);
            if (executable != null) {
                String result = executable.search(this.searchTerm);
                Library[] libraries = result == null ? null : this.parseSearchResult(result);
                LibraryProvider.this.updateCache(this.searchTerm, libraries);
            }
        }

        private Library[] parseSearchResult(String searchResult) {
            String[] lines = searchResult.split("\n");
            String header = lines[0];
            int descriptionIndex = header.indexOf("DESCRIPTION");
            int authorIndex = header.indexOf("AUTHOR");
            int dateIndex = header.indexOf("DATE");
            int versionIndex = header.indexOf("VERSION");
            int keywordsIndex = header.indexOf("KEYWORDS");
            LinkedList<Library> libraryList = new LinkedList<Library>();
            String name = "";
            String description = "";
            String versionName = "";
            for (int i = lines.length - 1; i >= 1; --i) {
                String line = lines[i];
                int length = line.length();
                String namePart = line.substring(0, descriptionIndex).trim();
                name = namePart.trim() + name;
                String descriptionPart = length < authorIndex ? line.substring(descriptionIndex).trim() : line.substring(descriptionIndex, authorIndex).trim();
                description = descriptionPart + "\n" + description;
                String versionNamePart = length < versionIndex ? "" : (length < keywordsIndex ? line.substring(versionIndex) : line.substring(versionIndex, keywordsIndex));
                if ((versionNamePart = versionNamePart.trim()).endsWith("\u2026")) {
                    versionNamePart = versionNamePart.substring(0, versionNamePart.length() - 1);
                }
                versionName = versionNamePart + versionName;
                if (length < dateIndex || Character.isWhitespace(line.charAt(dateIndex))) continue;
                if (!versionName.isEmpty()) {
                    String keywords = length < keywordsIndex ? "" : line.substring(keywordsIndex).trim();
                    Library library = new Library(name);
                    library.setDescription(description.trim());
                    if (!keywords.isEmpty()) {
                        library.setKeywords(keywords.split(" "));
                    }
                    Library.Version version = new Library.Version(library, versionName);
                    library.setLatestVersion(version);
                    libraryList.add(0, library);
                }
                name = "";
                description = "";
                versionName = "";
            }
            return libraryList.toArray(new Library[libraryList.size()]);
        }
    }
}

