/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.wizard;

import java.awt.Cursor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.javascript.nodejs.options.NodeJsOptions;
import org.netbeans.modules.javascript.nodejs.options.NodeJsOptionsValidator;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class ExpressPanelVisual
extends JPanel
implements PreferenceChangeListener,
HelpCtx.Provider {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final AtomicInteger listenerCount = new AtomicInteger();
    private JCheckBox enableExpressCheckBox;
    private JCheckBox lessCheckBox;
    private JLabel optionsLabel;

    public ExpressPanelVisual() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.enableExpressCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ExpressPanelVisual.this.lessCheckBox.setEnabled(e.getStateChange() == 1);
            }
        });
        DefaultItemListener defaultItemListener = new DefaultItemListener();
        this.enableExpressCheckBox.addItemListener(defaultItemListener);
        this.lessCheckBox.addItemListener(defaultItemListener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.javascript.nodejs.ui.wizard.ExpressPanelVisual");
    }

    boolean isExpressEnabled() {
        return this.enableExpressCheckBox.isSelected();
    }

    boolean isLessEnabled() {
        return this.lessCheckBox.isSelected();
    }

    String getErrorMessage() {
        if (!this.isExpressEnabled()) {
            return null;
        }
        ValidationResult result = new NodeJsOptionsValidator().validateExpress().getResult();
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return result.getFirstErrorMessage();
        }
        return result.getFirstWarningMessage();
    }

    void addChangeListener(ChangeListener listener) {
        if (this.listenerCount.getAndIncrement() == 0) {
            NodeJsOptions.getInstance().addPreferenceChangeListener(this);
        }
        this.changeSupport.addChangeListener(listener);
    }

    void removeChangeListener(ChangeListener listener) {
        if (this.listenerCount.decrementAndGet() == 0) {
            NodeJsOptions.getInstance().removePreferenceChangeListener(this);
        }
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        this.fireChange();
    }

    private void initComponents() {
        this.enableExpressCheckBox = new JCheckBox();
        this.optionsLabel = new JLabel();
        this.lessCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.enableExpressCheckBox, (String)NbBundle.getMessage(ExpressPanelVisual.class, (String)"ExpressPanelVisual.enableExpressCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.optionsLabel, (String)NbBundle.getMessage(ExpressPanelVisual.class, (String)"ExpressPanelVisual.optionsLabel.text"));
        this.optionsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ExpressPanelVisual.this.optionsLabelMousePressed(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ExpressPanelVisual.this.optionsLabelMouseEntered(evt);
            }
        });
        this.lessCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.lessCheckBox, (String)NbBundle.getMessage(ExpressPanelVisual.class, (String)"ExpressPanelVisual.lessCheckBox.text"));
        this.lessCheckBox.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.enableExpressCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.optionsLabel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lessCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enableExpressCheckBox).addComponent(this.optionsLabel, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.lessCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void optionsLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void optionsLabelMousePressed(MouseEvent evt) {
        OptionsDisplayer.getDefault().open("Html5/NodeJs");
    }

    private final class DefaultItemListener
    implements ItemListener {
        private DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ExpressPanelVisual.this.fireChange();
        }
    }
}

