/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.util;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;

public final class NodeInfo {
    private final AtomicReference<Future<Integer>> currentNodeTask;
    private final boolean debug;

    private NodeInfo(@NullAllowed AtomicReference<Future<Integer>> currentNodeTask, boolean debug) {
        this.currentNodeTask = currentNodeTask;
        this.debug = debug;
    }

    public static NodeInfo run(@NullAllowed AtomicReference<Future<Integer>> currentNodeTask) {
        return new NodeInfo(currentNodeTask, false);
    }

    public static NodeInfo debug(@NullAllowed AtomicReference<Future<Integer>> currentNodeTask) {
        return new NodeInfo(currentNodeTask, true);
    }

    public static NodeInfo none() {
        return new NodeInfo(null, false);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isRunning() {
        Future<Integer> nodeTask = this.getCurrentNodeTask();
        return nodeTask != null && !nodeTask.isDone();
    }

    public void stop() {
        Future<Integer> nodeTask = this.getCurrentNodeTask();
        assert (nodeTask != null);
        nodeTask.cancel(true);
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @CheckForNull
    private Future<Integer> getCurrentNodeTask() {
        if (this.currentNodeTask == null) {
            return null;
        }
        return this.currentNodeTask.get();
    }
}

