/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views.debugging;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.debugger.ui.views.debugging.ClickableIcon;
import org.netbeans.modules.debugger.ui.views.debugging.DebugTreeView;
import org.netbeans.modules.debugger.ui.views.debugging.FiltersDescriptor;
import org.netbeans.modules.debugger.ui.views.debugging.InfoPanel;
import org.netbeans.modules.debugger.ui.views.debugging.TapPanel;
import org.netbeans.modules.debugger.ui.views.debugging.ThreadsListener;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.netbeans.spi.debugger.ui.ViewFactory;
import org.netbeans.spi.debugger.ui.ViewLifecycle;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DebuggingViewComponent
extends TopComponent
implements HelpCtx.Provider,
ExplorerManager.Provider,
PropertyChangeListener,
TreeExpansionListener,
TreeModelListener,
AdjustmentListener,
ChangeListener,
MouseWheelListener,
ViewLifecycle.ModelUpdateListener {
    private static final String ID = "debuggingView";
    public static final int BAR_WIDTH = 8;
    static final Color hitsColor;
    static final Color hitsBarColor;
    static final Color deadlockColor;
    static final Color greenBarColor;
    private transient Color treeBackgroundColor = DebuggingViewComponent.getTreeBackgroundColor();
    private transient RequestProcessor requestProcessor = new RequestProcessor("DebuggingView Refresh Scheduler", 1);
    private transient AtomicBoolean refreshScheduled = new AtomicBoolean(false);
    private transient ExplorerManager manager = new ExplorerManager();
    private transient ViewLifecycle viewLifecycle;
    private Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");
    private PreferenceChangeListener prefListener;
    private SessionsComboBoxListener sessionsComboListener;
    private VisibleTreePosition visibleTreePosition = null;
    private boolean ignoreScrollAdjustment = false;
    private transient ImageIcon resumeIcon;
    private transient ImageIcon focusedResumeIcon;
    private transient ImageIcon pressedResumeIcon;
    private transient ImageIcon suspendIcon;
    private transient ImageIcon focusedSuspendIcon;
    private transient ImageIcon pressedSuspendIcon;
    private DebugTreeView treeView;
    private TapPanel tapPanel;
    private InfoPanel infoPanel;
    private DebuggingView.DVSupport debugger;
    private Session session;
    private DebuggingView.DVSupport previousDebugger;
    private Reference<DebuggingView.DVThread> threadMadeCurrentRef;
    private Reference<DebuggingView.DVThread> threadToScrollRef;
    private ViewRefresher viewRefresher = new ViewRefresher();
    private BarsPanel leftPanel;
    private IconsPanel rightPanel;
    private ThreadsListener threadsListener = null;
    private final Object lock = new Object();
    private static Reference<DebuggingViewComponent> instance;
    private JPanel leftPanel1;
    private JPanel mainPanel;
    private JScrollPane mainScrollPane;
    private JPanel rightPanel1;
    private JPanel scrollBarPanel;
    private JComboBox sessionComboBox;
    private JScrollBar treeScrollBar;
    private boolean isDelayScrollWithMarkingDirtyRegion = false;

    public DebuggingViewComponent() {
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/debugger/resources/debuggingView/debugging_16.png"));
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
        this.initComponents();
        this.resumeIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/debuggingView/resume_button_16.png", (boolean)false);
        this.focusedResumeIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/debuggingView/resume_button_focused_16.png", (boolean)false);
        this.pressedResumeIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/debuggingView/resume_button_pressed_16.png", (boolean)false);
        this.suspendIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/debuggingView/suspend_button_16.png", (boolean)false);
        this.focusedSuspendIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/debuggingView/suspend_button_focused_16.png", (boolean)false);
        this.pressedSuspendIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/debuggingView/suspend_button_pressed_16.png", (boolean)false);
        this.setBackground(this.treeBackgroundColor);
        this.leftPanel = new BarsPanel();
        this.rightPanel = new IconsPanel();
        this.mainPanel.setBackground(this.treeBackgroundColor);
        this.mainPanel.add((Component)this.leftPanel, "West");
        this.mainPanel.add((Component)this.rightPanel, "East");
        this.tapPanel = new TapPanel();
        this.tapPanel.setOrientation(2);
        this.tapPanel.setExpanded(true);
        this.infoPanel = new InfoPanel(this.tapPanel, this);
        this.tapPanel.add(this.infoPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add(this.tapPanel, gridBagConstraints);
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        this.prefListener = new DebuggingPreferenceChangeListener();
        this.preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefListener, (Object)this.preferences));
        this.sessionsComboListener = new SessionsComboBoxListener();
        this.scrollBarPanel.setVisible(false);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.scrollBarPanel.setBackground(this.tapPanel.getBackground());
            this.scrollBarPanel.setOpaque(true);
        }
        this.treeScrollBar.addAdjustmentListener(this);
        this.setSuspendTableVisible(this.preferences.getBoolean("show_suspend_table", true));
        this.mainScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!e.getValueIsAdjusting() && !DebuggingViewComponent.this.ignoreScrollAdjustment) {
                    DebuggingViewComponent.this.storeScrollPosition();
                }
            }
        });
    }

    private void initComponents() {
        this.sessionComboBox = new JComboBox();
        this.mainScrollPane = new JScrollPane();
        this.mainPanel = new JPanel();
        this.scrollBarPanel = new JPanel();
        this.treeScrollBar = new JScrollBar();
        this.leftPanel1 = new JPanel();
        this.rightPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.sessionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Java Project"}));
        this.sessionComboBox.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add(this.sessionComboBox, gridBagConstraints);
        this.sessionComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DebuggingViewComponent.class, (String)"DebuggingViewComponent.sessionComboBox.AccessibleContext.accessibleName"));
        this.sessionComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebuggingViewComponent.class, (String)"DebuggingViewComponent.sessionComboBox.AccessibleContext.accessibleDescription"));
        this.mainScrollPane.setBorder(null);
        this.mainScrollPane.setHorizontalScrollBarPolicy(31);
        this.mainScrollPane.setPreferredSize(new Dimension(32, 10));
        this.mainPanel.setLayout(new BorderLayout());
        this.mainScrollPane.setViewportView(this.mainPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.mainScrollPane, gridBagConstraints);
        this.scrollBarPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 17));
        this.scrollBarPanel.setLayout(new BorderLayout());
        this.treeScrollBar.setOrientation(0);
        this.scrollBarPanel.add((Component)this.treeScrollBar, "Center");
        this.leftPanel1.setOpaque(false);
        this.leftPanel1.setPreferredSize(new Dimension(8, 0));
        this.leftPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.scrollBarPanel.add((Component)this.leftPanel1, "West");
        this.rightPanel1.setOpaque(false);
        this.rightPanel1.setPreferredSize(new Dimension(24, 0));
        this.rightPanel1.setLayout(new FlowLayout(1, 0, 0));
        this.scrollBarPanel.add((Component)this.rightPanel1, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add(this.scrollBarPanel, gridBagConstraints);
    }

    private static Color getTreeBackgroundColor() {
        Color c = null;
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            c = UIManager.getColor("NbExplorerView.background");
        }
        if (c == null) {
            c = UIManager.getColor("Tree.textBackground");
        }
        return c;
    }

    static int luminance(Color c) {
        return (299 * c.getRed() + 587 * c.getGreen() + 114 * c.getBlue()) / 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootContext(final Models.CompoundModel model, final DebuggerEngine engine) {
        Node root = this.manager.getRootContext();
        if (root != null) {
            try {
                root.destroy();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (this.threadsListener == null) {
            this.threadsListener = ThreadsListener.getDefault();
        }
        if (engine != null) {
            final DebuggingView.DVSupport deb = (DebuggingView.DVSupport)engine.lookupFirst(null, DebuggingView.DVSupport.class);
            if (deb != null && this.threadsListener != null) {
                this.threadsListener.setDebuggingView(deb, this);
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.previousDebugger != null) {
                    this.previousDebugger.removePropertyChangeListener(this);
                }
                this.previousDebugger = this.debugger;
                this.debugger = deb;
                if (deb != null) {
                    this.session = (Session)engine.lookupFirst(null, Session.class);
                    deb.addPropertyChangeListener(this);
                } else {
                    this.session = null;
                }
            }
            if (this.threadsListener != null) {
                this.requestProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        DebuggingViewComponent.this.threadsListener.changeDebugger(deb);
                    }
                });
            }
            FiltersDescriptor.getInstance().setUpFilters(deb);
        } else {
            Object object = this.lock;
            synchronized (object) {
                if (this.previousDebugger != null) {
                    this.previousDebugger.removePropertyChangeListener(this);
                }
                this.previousDebugger = null;
                this.debugger = null;
                this.session = null;
            }
            if (this.threadsListener != null) {
                this.requestProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        DebuggingViewComponent.this.threadsListener.changeDebugger(null);
                    }
                });
            }
            FiltersDescriptor.getInstance().setUpFilters(null);
            this.visibleTreePosition = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Node root;
                if (model == null) {
                    root = Node.EMPTY;
                    DebuggingViewComponent.this.releaseTreeView();
                } else {
                    Object object = DebuggingViewComponent.this.lock;
                    synchronized (object) {
                        if (DebuggingViewComponent.this.treeView == null) {
                            DebuggingViewComponent.this.createTreeView();
                        }
                        root = Models.createNodes((Models.CompoundModel)model, (TreeView)DebuggingViewComponent.this.treeView);
                        DebuggingViewComponent.this.treeView.setExpansionModel((TreeExpansionModel)model);
                    }
                }
                DebuggingViewComponent.this.manager.setRootContext(root);
                DebuggingViewComponent.this.refreshView();
                DebuggingViewComponent.this.updateSessionsComboBox();
                DebuggingViewComponent.this.adjustTreeScrollBar(-1);
                if (engine == null) {
                    DebuggingViewComponent.this.setActivatedNodes(new Node[0]);
                    DebugTreeView tView = DebuggingViewComponent.this.getTreeView();
                    if (tView != null) {
                        tView.resetSelection();
                    }
                }
            }
        });
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public static DebuggingViewComponent getInstance() {
        DebuggingViewComponent view = (DebuggingViewComponent)WindowManager.getDefault().findTopComponent(ID);
        if (view == null) {
            view = DebuggingViewComponent.getDefault();
        }
        return view;
    }

    public void setSuspendTableVisible(boolean visible) {
        this.rightPanel.setVisible(visible);
    }

    public static synchronized DebuggingViewComponent getDefault() {
        DebuggingViewComponent view;
        if (instance == null) {
            view = new DebuggingViewComponent();
            instance = new WeakReference<DebuggingViewComponent>(view);
        } else {
            view = instance.get();
            if (view == null) {
                view = new DebuggingViewComponent();
                instance = new WeakReference<DebuggingViewComponent>(view);
            }
        }
        return view;
    }

    protected String preferredID() {
        return ID;
    }

    protected void componentShowing() {
        super.componentShowing();
        this.viewLifecycle = ViewFactory.getDefault().createViewLifecycle("DebuggingView", null);
        this.viewLifecycle.addModelUpdateListener(this);
    }

    protected void componentHidden() {
        super.componentHidden();
        if (this.viewLifecycle != null) {
            this.viewLifecycle.destroy();
            this.viewLifecycle = null;
            this.setRootContext(null, null);
        }
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("DebuggingView");
    }

    public int getPersistenceType() {
        return 0;
    }

    public boolean requestFocusInWindow() {
        DebugTreeView tView = this.getTreeView();
        if (tView != null) {
            return tView.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public String getName() {
        return NbBundle.getMessage(DebuggingViewComponent.class, (String)"CTL_Debugging_view");
    }

    public String getToolTipText() {
        return NbBundle.getMessage(DebuggingViewComponent.class, (String)"CTL_Debugging_tooltip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("rootContext".equals(propertyName) || "nodeChange".equals(propertyName)) {
            this.refreshView();
        } else if ("currentThread".equals(propertyName)) {
            DebuggingView.DVThread currentThread;
            Object object = this.lock;
            synchronized (object) {
                currentThread = this.debugger != null ? this.debugger.getCurrentThread() : null;
            }
            if (currentThread != null) {
                DebuggingView.DVThread thread;
                DebuggingView.DVThread dVThread = thread = this.threadMadeCurrentRef != null ? this.threadMadeCurrentRef.get() : null;
                if (thread != currentThread) {
                    this.threadToScrollRef = new WeakReference<DebuggingView.DVThread>(currentThread);
                }
            }
            this.refreshView();
        } else if (propertyName.equals("selectedNodes")) {
            final Node[] nodes = (Node[])evt.getNewValue();
            if (SwingUtilities.isEventDispatchThread()) {
                this.setActivatedNodes(nodes);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DebuggingViewComponent.this.setActivatedNodes(nodes);
                    }
                });
            }
        }
    }

    private static boolean isDebuggingSession(Session s) {
        DebuggerEngine engine = s.getCurrentEngine();
        if (engine == null) {
            return false;
        }
        return engine.lookupFirst(null, DebuggingView.DVSupport.class) != null;
    }

    void updateSessionsComboBox() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggingViewComponent.this.sessionComboBox.removeActionListener(DebuggingViewComponent.this.sessionsComboListener);
                DebuggingViewComponent.this.sessionComboBox.removePopupMenuListener(DebuggingViewComponent.this.sessionsComboListener);
                ComboBoxModel model = DebuggingViewComponent.this.sessionComboBox.getModel();
                DebuggingViewComponent.this.sessionComboBox.removeAllItems();
                DebuggerManager dm = DebuggerManager.getDebuggerManager();
                Session[] sessions = dm.getSessions();
                for (int x = 0; x < sessions.length; ++x) {
                    if (!DebuggingViewComponent.isDebuggingSession(sessions[x])) continue;
                    DebuggingViewComponent.this.sessionComboBox.addItem(new SessionItem(sessions[x]));
                }
                if (model.getSize() == 0) {
                    DebuggingViewComponent.this.sessionComboBox.addItem(new SessionItem(null));
                }
                DebuggingViewComponent.this.sessionComboBox.setSelectedItem(new SessionItem(dm.getCurrentSession()));
                DebuggingViewComponent.this.sessionComboBox.setVisible(model.getSize() > 1);
                DebuggingViewComponent.this.sessionComboBox.addActionListener(DebuggingViewComponent.this.sessionsComboListener);
                DebuggingViewComponent.this.sessionComboBox.addPopupMenuListener(DebuggingViewComponent.this.sessionsComboListener);
            }
        });
    }

    void makeThreadCurrent(DebuggingView.DVThread thread) {
        this.threadMadeCurrentRef = new WeakReference<DebuggingView.DVThread>(thread);
        thread.makeCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTreeView() {
        Object object = this.lock;
        synchronized (object) {
            this.releaseTreeView();
            this.treeView = new DebugTreeView();
            this.treeView.setRootVisible(false);
            this.treeView.setHorizontalScrollBarPolicy(31);
            this.treeView.setVerticalScrollBarPolicy(21);
            this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DebuggingViewComponent.class, (String)"DebuggingViewComponent.treeView.AccessibleContext.accessibleName"));
            this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebuggingViewComponent.class, (String)"DebuggingViewComponent.treeView.AccessibleContext.accessibleDescription"));
            this.treeView.getTree().addMouseWheelListener(this);
            this.treeView.addTreeExpansionListener(this);
            TreeModel model = this.treeView.getTree().getModel();
            model.addTreeModelListener(this);
            this.treeView.getViewport().addChangeListener(this);
            this.treeView.getTree().setScrollsOnExpand(false);
            this.mainPanel.add((Component)((Object)this.treeView), "Center");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseTreeView() {
        Object object = this.lock;
        synchronized (object) {
            if (this.treeView == null) {
                return;
            }
            this.treeView.getTree().removeMouseWheelListener(this);
            this.treeView.removeTreeExpansionListener(this);
            TreeModel model = this.treeView.getTree().getModel();
            model.removeTreeModelListener(this);
            this.treeView.getViewport().removeChangeListener(this);
            this.treeView.resetSelection();
            this.mainPanel.remove((Component)((Object)this.treeView));
            this.treeView = null;
        }
    }

    private DebugTreeView getTreeView() {
        return this.treeView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateTree() {
        this.ignoreScrollAdjustment = true;
        try {
            super.validateTree();
        }
        finally {
            this.ignoreScrollAdjustment = false;
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        TreePath path = event.getPath();
        this.checkIfWeShouldScrollToCurrentThread(path);
        this.refreshView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfWeShouldScrollToCurrentThread(TreePath path) {
        DebuggingView.DVThread currentThread;
        Node node = Visualizer.findNode((Object)path.getLastPathComponent());
        if (node == null) {
            return;
        }
        DebuggingView.DVThread dvThread = (DebuggingView.DVThread)node.getLookup().lookup(DebuggingView.DVThread.class);
        Object object = this.lock;
        synchronized (object) {
            currentThread = this.debugger != null ? this.debugger.getCurrentThread() : null;
        }
        if (currentThread != null && currentThread == dvThread) {
            this.threadToScrollRef = new WeakReference<DebuggingView.DVThread>(dvThread);
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.refreshView();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.refreshView();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        TreePath path = e.getTreePath();
        this.checkIfWeShouldScrollToCurrentThread(path);
        this.refreshView(true);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.refreshView(true);
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.refreshView();
    }

    InfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    void refreshView() {
        this.refreshView(false);
    }

    private void refreshView(boolean delayScrollWithMarkingDirtyRegion) {
        if (delayScrollWithMarkingDirtyRegion) {
            this.isDelayScrollWithMarkingDirtyRegion = true;
        }
        if (this.refreshScheduled.getAndSet(true)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggingViewComponent.this.refreshScheduled.set(false);
                DebuggingViewComponent.this.restoreScrollPosition(DebuggingViewComponent.this.isDelayScrollWithMarkingDirtyRegion);
                DebuggingViewComponent.this.isDelayScrollWithMarkingDirtyRegion = false;
                DebuggingViewComponent.this.requestProcessor.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HashSet<DebuggingView.DVThread> deadlockedThreads;
                        DebuggingView.DVSupport supp;
                        DebuggingView.DVThread currentThread = null;
                        Set<DebuggingView.Deadlock> deadlocks = null;
                        Object object = DebuggingViewComponent.this.lock;
                        synchronized (object) {
                            supp = DebuggingViewComponent.this.debugger;
                        }
                        if (supp != null) {
                            currentThread = supp.getCurrentThread();
                            deadlocks = supp.getDeadlocks();
                        }
                        if (deadlocks == null) {
                            deadlockedThreads = Collections.EMPTY_SET;
                        } else {
                            deadlockedThreads = new HashSet<DebuggingView.DVThread>();
                            for (DebuggingView.Deadlock deadlock : deadlocks) {
                                deadlockedThreads.addAll(deadlock.getThreads());
                            }
                        }
                        DebuggingViewComponent.this.viewRefresher.setup(currentThread, deadlockedThreads);
                        try {
                            SwingUtilities.invokeAndWait(DebuggingViewComponent.this.viewRefresher);
                        }
                        catch (InterruptedException ex) {
                        }
                        catch (InvocationTargetException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }, 20);
            }
        });
    }

    private void adjustTreeScrollBar(int treeViewWidth) {
        JScrollBar sbar;
        int unitHeight;
        DebugTreeView tView = this.getTreeView();
        if (tView == null) {
            this.scrollBarPanel.setVisible(false);
            return;
        }
        JViewport viewport = tView.getViewport();
        Point point = viewport.getViewPosition();
        if (point.y < 0) {
            viewport.setViewPosition(new Point(point.x, 0));
        }
        Dimension viewSize = viewport.getExtentSize();
        Dimension treeSize = viewport.getViewSize();
        if (treeViewWidth < 0) {
            treeViewWidth = treeSize.width;
        }
        if ((unitHeight = tView.getUnitHeight()) > 0 && (sbar = this.mainScrollPane.getVerticalScrollBar()).getUnitIncrement() != unitHeight) {
            sbar.setUnitIncrement(unitHeight);
        }
        if (treeViewWidth <= viewSize.width) {
            this.scrollBarPanel.setVisible(false);
        } else {
            this.treeScrollBar.setMaximum(treeViewWidth);
            this.treeScrollBar.setVisibleAmount(viewSize.width);
            if (unitHeight > 0) {
                this.treeScrollBar.setUnitIncrement(unitHeight / 2);
            }
            this.treeScrollBar.setBlockIncrement(viewSize.width);
            this.scrollBarPanel.setVisible(true);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        DebugTreeView tView = this.getTreeView();
        if (tView == null) {
            return;
        }
        JViewport viewport = tView.getViewport();
        Point position = viewport.getViewPosition();
        viewport.setViewPosition(new Point(e.getValue(), position.y));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggingViewComponent.this.adjustTreeScrollBar(-1);
            }
        });
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        JScrollBar scrollBar = this.mainScrollPane.getVerticalScrollBar();
        if (e.getScrollType() == 0) {
            int totalScrollAmount = e.getUnitsToScroll() * scrollBar.getUnitIncrement();
            scrollBar.setValue(scrollBar.getValue() + totalScrollAmount);
        }
    }

    @Override
    public void modelUpdated(Models.CompoundModel compoundModel, DebuggerEngine de) {
        this.setRootContext(compoundModel, de);
    }

    private void storeScrollPosition() {
        JTree tree = this.getJTree();
        if (tree != null) {
            int scrollTop = this.mainScrollPane.getViewport().getViewPosition().y;
            int row = tree.getClosestRowForLocation(tree.getRowBounds((int)0).x + 1, scrollTop);
            if (row >= 0) {
                TreePath path = tree.getPathForRow(row);
                if (path != null) {
                    int offset = tree.getRowBounds((int)row).y - scrollTop;
                    this.visibleTreePosition = new VisibleTreePosition(path, offset);
                    return;
                }
            } else {
                return;
            }
        }
        this.visibleTreePosition = null;
    }

    private void storeScrollPosition(TreePath path) {
        JTree tree = this.getJTree();
        if (tree != null && path != null) {
            int row = tree.getRowForPath(path);
            if (row >= 0) {
                int scrollTop = this.mainScrollPane.getViewport().getViewPosition().y;
                int offset = tree.getRowBounds((int)row).y - scrollTop;
                this.visibleTreePosition = new VisibleTreePosition(path, offset);
                return;
            }
            return;
        }
        this.visibleTreePosition = null;
    }

    private JTree getJTree() {
        JTree tree;
        DebugTreeView treeView1 = this.getTreeView();
        if (treeView1 != null && (tree = treeView1.getTree()) != null && tree.getRowCount() > 0) {
            return tree;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreScrollPosition(boolean delayScrollWithMarkingDirtyRegion) {
        Rectangle bounds;
        int row;
        JTree tree;
        if (this.visibleTreePosition != null && (tree = this.getJTree()) != null && (row = tree.getRowForPath(this.visibleTreePosition.getPath())) != -1 && (bounds = tree.getRowBounds(row)) != null) {
            int scrollY = bounds.y - this.visibleTreePosition.getOffset();
            JViewport viewport = this.mainScrollPane.getViewport();
            Rectangle rect = viewport.getViewRect();
            rect.y = scrollY;
            if (!rect.isEmpty()) {
                JComponent view = (JComponent)viewport.getView();
                if (delayScrollWithMarkingDirtyRegion) {
                    RepaintManager.currentManager(viewport).addDirtyRegion(view, rect.x, rect.x, rect.width, rect.height);
                }
                this.ignoreScrollAdjustment = true;
                try {
                    view.scrollRectToVisible(rect);
                }
                finally {
                    this.ignoreScrollAdjustment = false;
                }
            }
        }
    }

    static {
        int dl;
        Color tbc;
        Color c = UIManager.getColor("nb.debugger.debugging.BPHits");
        if (c == null) {
            c = new Color(255, 255, 178);
            tbc = DebuggingViewComponent.getTreeBackgroundColor();
            dl = Math.abs(DebuggingViewComponent.luminance(c) - DebuggingViewComponent.luminance(tbc));
            if (dl > 125) {
                c = new Color(70, 70, 0);
            }
        }
        hitsColor = c;
        deadlockColor = UIManager.getColor("nb.errorForeground");
        c = UIManager.getColor("nb.debugger.debugging.bars.BPHits");
        if (c == null) {
            c = new Color(230, 230, 130);
            tbc = DebuggingViewComponent.getTreeBackgroundColor();
            dl = Math.abs(DebuggingViewComponent.luminance(c) - DebuggingViewComponent.luminance(tbc));
            if (dl > 125) {
                c = new Color(120, 120, 25);
            }
        }
        hitsBarColor = c;
        c = UIManager.getColor("nb.debugger.debugging.bars.currentThread");
        if (c == null) {
            c = new Color(189, 230, 170);
            tbc = DebuggingViewComponent.getTreeBackgroundColor();
            dl = Math.abs(DebuggingViewComponent.luminance(c) - DebuggingViewComponent.luminance(tbc));
            if (dl > 125) {
                c = new Color(40, 100, 35);
            }
        }
        greenBarColor = c;
        instance = null;
    }

    private class VisibleTreePosition {
        final TreePath path;
        final int offset;

        public VisibleTreePosition(TreePath path, int offset) {
            this.path = path;
            this.offset = offset;
        }

        public TreePath getPath() {
            return this.path;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return "VisibleTreePosition[" + this.path + ", " + this.offset + "]";
        }
    }

    private class SessionItem {
        private Session session;

        SessionItem(Session session) {
            this.session = session;
        }

        public Session getSession() {
            return this.session;
        }

        public String toString() {
            if (this.session != null) {
                return this.session.getName();
            }
            return '<' + NbBundle.getMessage(DebuggingViewComponent.class, (String)"LBL_No_Session_Running") + '>';
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SessionItem)) {
                return false;
            }
            Session s = ((SessionItem)obj).getSession();
            if (this.session == null) {
                return s == null;
            }
            return this.session.equals(s);
        }

        public int hashCode() {
            return 87 + (this.session != null ? this.session.hashCode() : 0);
        }
    }

    private class SessionsComboBoxListener
    implements ActionListener,
    PopupMenuListener {
        SessionItem selectedItem = null;
        boolean popupVisible = false;

        private SessionsComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SessionItem si = (SessionItem)DebuggingViewComponent.this.sessionComboBox.getSelectedItem();
            if (this.popupVisible) {
                this.selectedItem = si;
            } else {
                this.changeSession(si);
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.popupVisible = true;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.changeSession(this.selectedItem);
            this.selectedItem = null;
            this.popupVisible = false;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.selectedItem = null;
            this.popupVisible = false;
        }

        private void changeSession(SessionItem si) {
            if (si != null) {
                Session ses = si.getSession();
                DebuggerManager dm = DebuggerManager.getDebuggerManager();
                if (ses != null && ses != dm.getCurrentSession()) {
                    dm.setCurrentSession(ses);
                }
            }
        }
    }

    private class IconsPanel
    extends JPanel {
        private int endSY;
        private int counter;
        private ArrayList<IconItem> icons = new ArrayList();

        IconsPanel() {
            this.setBackground(DebuggingViewComponent.this.treeBackgroundColor);
            this.setPreferredSize(new Dimension(24, 0));
            this.setLayout(new FlowLayout(0, 0, 0));
        }

        public void startReset() {
            this.counter = 0;
            this.endSY = 0;
        }

        public void endReset() {
            int size = this.icons.size();
            for (int x = size - 1; x >= this.counter; --x) {
                this.remove(x);
                this.icons.remove(x);
            }
        }

        public void addIcon(int sx, int sy, int rowHeight, DebuggingView.DVThread dvThread) {
            int height = sy - this.endSY + rowHeight;
            if (this.counter < this.icons.size()) {
                IconItem item = this.icons.get(this.counter);
                item.icon.changeThread(dvThread, (Container)((Object)DebuggingViewComponent.this), sx, sy, 24, height);
                item.panel.setPreferredSize(new Dimension(24, height));
                item.height = height;
            } else {
                JPanel panel = new JPanel(new GridBagLayout());
                panel.setBackground(DebuggingViewComponent.this.treeBackgroundColor);
                panel.setOpaque(false);
                panel.setPreferredSize(new Dimension(24, height));
                ClickableIcon icon = new ClickableIcon(DebuggingViewComponent.this.resumeIcon, DebuggingViewComponent.this.focusedResumeIcon, DebuggingViewComponent.this.pressedResumeIcon, DebuggingViewComponent.this.suspendIcon, DebuggingViewComponent.this.focusedSuspendIcon, DebuggingViewComponent.this.pressedSuspendIcon, dvThread, DebuggingViewComponent.this.treeView);
                icon.setBackground(DebuggingViewComponent.this.treeBackgroundColor);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 15;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                int delta = rowHeight - 16;
                int insetTop = delta / 2;
                int insetBottom = delta - insetTop;
                gridBagConstraints.insets = new Insets(insetTop, 0, insetBottom, 0);
                panel.add((Component)icon, gridBagConstraints);
                icon.initializeState((Container)((Object)DebuggingViewComponent.this), sx, sy, 24, height);
                IconItem item = new IconItem(height, icon, panel);
                this.icons.add(item);
                this.add(panel);
            }
            ++this.counter;
            this.endSY += height;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            DebugTreeView tView = DebuggingViewComponent.this.getTreeView();
            if (tView != null) {
                tView.paintStripes(g, this);
            }
        }

        private class IconItem {
            private int height;
            private ClickableIcon icon;
            private JPanel panel;

            IconItem(int height, ClickableIcon icon, JPanel panel) {
                this.height = height;
                this.icon = icon;
                this.panel = panel;
            }
        }
    }

    private class BarsPanel
    extends JPanel
    implements MouseMotionListener {
        private ArrayList<Bar> bars = new ArrayList();

        BarsPanel() {
            this.setBackground(DebuggingViewComponent.this.treeBackgroundColor);
            this.setPreferredSize(new Dimension(8, 0));
            this.setLayout(new FlowLayout(0, 0, 0));
            this.addMouseMotionListener(this);
        }

        public void clearBars() {
            this.bars.clear();
        }

        public void addBar(boolean isCurrent, boolean atBreakpoint, boolean inDeadlock, int height, int sy) {
            String toolTipText = null;
            Color color = null;
            Color secondaryColor = null;
            if (inDeadlock) {
                color = deadlockColor;
                toolTipText = NbBundle.getMessage(DebuggingViewComponent.class, (String)"LBL_DEADLOCKED_THREAD_TIP");
            } else if (isCurrent) {
                color = greenBarColor;
                toolTipText = NbBundle.getMessage(DebuggingViewComponent.class, (String)"LBL_CURRENT_BAR_TIP");
            } else if (atBreakpoint) {
                color = hitsBarColor;
                toolTipText = NbBundle.getMessage(DebuggingViewComponent.class, (String)"LBL_BREAKPOINT_HIT_TIP");
            }
            if (isCurrent && inDeadlock) {
                secondaryColor = greenBarColor;
                toolTipText = NbBundle.getMessage(DebuggingViewComponent.class, (String)"LBL_CURRENT_DEADLOCKED_TIP");
            }
            Bar bar = new Bar(sy, height, color, secondaryColor, toolTipText);
            this.bars.add(bar);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Color originalColor = g.getColor();
            Rectangle clipRect = g.getClipBounds();
            double clipYStart = clipRect.getY();
            double clipYEnd = clipYStart + clipRect.getHeight() - 1.0;
            int width = (int)this.getBounds().getWidth();
            for (Bar bar : this.bars) {
                Rectangle rect;
                if ((double)(bar.sy + bar.height - 1) < clipYStart) continue;
                if ((double)bar.sy > clipYEnd) break;
                if (bar.color != null) {
                    rect = new Rectangle(0, bar.sy + 1, width, bar.height - 1);
                    rect = rect.intersection(clipRect);
                    g.setColor(bar.color);
                    g.fillRect(rect.x, rect.y, rect.width, rect.height);
                }
                if (bar.secondaryColor == null) continue;
                rect = new Rectangle(width / 2 - 1, bar.sy + 1, (width + 1) / 2 + 1, bar.height - 1);
                if ((rect = rect.intersection(clipRect)).isEmpty()) continue;
                g.setColor(bar.secondaryColor);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            g.setColor(originalColor);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.computeToolTipText(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.computeToolTipText(e);
        }

        private void computeToolTipText(MouseEvent evt) {
            int sy = evt.getY();
            try {
                for (Bar bar : this.bars) {
                    if (sy < bar.sy || sy >= bar.sy + bar.height) continue;
                    this.setToolTipText(bar.toolTipText);
                    return;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            this.setToolTipText(null);
        }

        private class Bar {
            private int sy;
            private int height;
            private Color color;
            private Color secondaryColor = null;
            private String toolTipText;

            Bar(int sy, int height, Color color, Color secondary, String toolTipText) {
                this.sy = sy;
                this.height = height;
                this.color = color;
                this.secondaryColor = secondary;
                this.toolTipText = toolTipText;
            }
        }
    }

    private final class ViewRefresher
    implements Runnable {
        private DebuggingView.DVThread currentThread;
        private Set<DebuggingView.DVThread> deadlockedThreads;

        private ViewRefresher() {
        }

        void setup(DebuggingView.DVThread currentThread, Set<DebuggingView.DVThread> deadlockedThreads) {
            this.currentThread = currentThread;
            this.deadlockedThreads = deadlockedThreads;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DebugTreeView tView = DebuggingViewComponent.this.getTreeView();
            DebuggingViewComponent.this.leftPanel.clearBars();
            DebuggingViewComponent.this.rightPanel.startReset();
            int sx = (DebuggingViewComponent.this.rightPanel.getWidth() - 24) / 2;
            int sy = 0;
            DebuggingView.DVThread threadToScroll = DebuggingViewComponent.this.threadToScrollRef != null ? (DebuggingView.DVThread)DebuggingViewComponent.this.threadToScrollRef.get() : null;
            DebuggingViewComponent.this.threadToScrollRef = null;
            int scrollStart = -1;
            int scrollEnd = -1;
            int mainPanelHeight = 0;
            int treeViewWidth = 0;
            int leftBarHeight = 0;
            boolean isCurrent = false;
            boolean isAtBreakpoint = false;
            boolean isInDeadlock = false;
            Object currentObject = null;
            int currentSY = 0;
            int height = 0;
            TreePath scrollPath = null;
            if (tView != null) {
                for (TreePath path : tView.getVisiblePaths()) {
                    Node node = Visualizer.findNode((Object)path.getLastPathComponent());
                    DebuggingView.DVThread dvThread = (DebuggingView.DVThread)node.getLookup().lookup(DebuggingView.DVThread.class);
                    DebuggingView.DVThreadGroup dvThreadGroup = (DebuggingView.DVThreadGroup)node.getLookup().lookup(DebuggingView.DVThreadGroup.class);
                    JTree tree = tView.getTree();
                    Rectangle rect = tree.getRowBounds(tree.getRowForPath(path));
                    int n = height = rect != null ? (int)Math.round(rect.getHeight()) : 0;
                    if (dvThread != null || dvThreadGroup != null) {
                        if (dvThread == threadToScroll) {
                            scrollStart = mainPanelHeight;
                            scrollEnd = scrollStart + height;
                            scrollPath = path;
                        }
                        if (currentObject != null) {
                            this.addPanels(currentObject, isCurrent, isAtBreakpoint, isInDeadlock, leftBarHeight, sx, currentSY, height);
                        }
                        leftBarHeight = 0;
                        if (dvThread != null) {
                            boolean bl = isCurrent = dvThread == this.currentThread;
                            if (DebuggingViewComponent.this.threadsListener != null) {
                                isAtBreakpoint = DebuggingViewComponent.this.threadsListener.isBreakpointHit(dvThread);
                            }
                            isInDeadlock = this.deadlockedThreads.contains(dvThread);
                        } else {
                            isCurrent = false;
                            isAtBreakpoint = false;
                            isInDeadlock = false;
                        }
                        currentObject = dvThread != null ? dvThread : dvThreadGroup;
                        currentSY = sy;
                    }
                    mainPanelHeight += height;
                    treeViewWidth = rect != null ? Math.max(treeViewWidth, (int)Math.round(rect.getX() + rect.getWidth())) : treeViewWidth;
                    leftBarHeight += height;
                    sy += height;
                    if (scrollPath == null || !scrollPath.equals(path.getParentPath())) continue;
                    scrollEnd += height;
                }
            }
            if (currentObject != null) {
                this.addPanels(currentObject, isCurrent, isAtBreakpoint, isInDeadlock, leftBarHeight, sx, currentSY, height);
            }
            DebuggingViewComponent.this.rightPanel.endReset();
            DebuggingViewComponent.this.leftPanel.repaint();
            DebuggingViewComponent.this.rightPanel.revalidate();
            DebuggingViewComponent.this.rightPanel.repaint();
            if (tView != null) {
                tView.getTree().setPreferredSize(new Dimension(treeViewWidth, 0));
            }
            DebuggingViewComponent.this.mainPanel.setPreferredSize(new Dimension(0, mainPanelHeight));
            DebuggingViewComponent.this.mainScrollPane.revalidate();
            DebuggingViewComponent.this.mainPanel.revalidate();
            if (tView != null) {
                tView.repaint();
            }
            DebuggingViewComponent.this.adjustTreeScrollBar(treeViewWidth);
            if (scrollStart > -1) {
                JViewport viewport = DebuggingViewComponent.this.mainScrollPane.getViewport();
                int aRectHeight = Math.min(scrollEnd - scrollStart + 1, viewport.getHeight());
                Rectangle aRect = new Rectangle(0, scrollStart, 1, aRectHeight);
                if (!aRect.isEmpty()) {
                    DebuggingViewComponent.this.ignoreScrollAdjustment = true;
                    try {
                        ((JComponent)viewport.getView()).scrollRectToVisible(aRect);
                        DebuggingViewComponent.this.storeScrollPosition(scrollPath);
                    }
                    finally {
                        DebuggingViewComponent.this.ignoreScrollAdjustment = false;
                    }
                }
            } else {
                DebuggingViewComponent.this.restoreScrollPosition(false);
            }
        }

        private void addPanels(Object dvObject, boolean current, boolean atBreakpoint, boolean inDeadlock, int height, int sx, int sy, int rowHeight) {
            if (current || atBreakpoint || inDeadlock) {
                DebuggingViewComponent.this.leftPanel.addBar(current, atBreakpoint, inDeadlock, height, sy);
            }
            if (dvObject instanceof DebuggingView.DVThread) {
                DebuggingViewComponent.this.rightPanel.addIcon(sx, sy, rowHeight, (DebuggingView.DVThread)dvObject);
            }
        }
    }

    private final class DebuggingPreferenceChangeListener
    implements PreferenceChangeListener {
        private DebuggingPreferenceChangeListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String key = evt.getKey();
            if ("show_suspend_table".equals(key)) {
                DebuggingViewComponent.this.setSuspendTableVisible(evt.getNewValue().equals("true"));
            }
        }
    }
}

