/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.netbeans.lib.terminalemulator.TermStream;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.gdb2.Catalog;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerImpl;
import org.netbeans.modules.cnd.debugger.gdb2.GdbVersionPeculiarity;
import org.netbeans.modules.cnd.debugger.gdb2.KeyProcessing;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MICommandInjector;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIProxy;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

class Tap
extends TermStream
implements MICommandInjector {
    private final StringBuilder interceptBuffer = new StringBuilder();
    private final LinkedList<String> interceptedLines = new LinkedList();
    private final StringBuilder toTermBuf = new StringBuilder();
    private MIProxy miProxy;
    private GdbDebuggerImpl debugger;
    private boolean prompted = false;
    private boolean showMessage = true;
    private final RequestProcessor sendQueue = new RequestProcessor("GDB send queue", 1);
    private static final boolean TRACING_IN_CONSOLE = CndUtils.getBoolean((String)"cnd.gdb.trace.console", (boolean)false);
    private static final String PROMPT = "(gdb)";
    private final RequestProcessor processingQueue = new RequestProcessor("GDB output processing", 1);

    Tap() {
    }

    public void flush() {
        this.toDTE.flush();
    }

    public void putChar(char c) {
        this.processCharFromGdb(c);
        this.dispatchInterceptedLines();
    }

    public void putChars(char[] buf, int offset, int count) {
        CndUtils.assertUiThread();
        for (int bx = 0; bx < count; ++bx) {
            this.processCharFromGdb(buf[offset + bx]);
        }
        this.dispatchInterceptedLines();
    }

    public void sendChar(char c) {
        CndUtils.assertTrueInConsole((boolean)false, (String)"should not be used; KeyProcessingStream should send only lines");
        this.toDCE.sendChar(c);
    }

    public void sendChars(char[] c, int offset, int count) {
        if (this.showMessage && !this.debugger.getGdbVersionPeculiarity().supports(GdbVersionPeculiarity.Feature.BREAKPOINT_NOTIFICATIONS)) {
            NativeDebuggerManager.warning((String)Catalog.get("MSG_OldGdbVersionConsole"));
            this.showMessage = false;
        }
        this.prompted = false;
        String line = String.valueOf(c, offset, count);
        CndUtils.assertTrueInConsole((line.length() == 0 || line.endsWith("\n") ? 1 : 0) != 0, (String)"KeyProcessingStream should send only lines");
        String cmd = line.trim();
        if (this.debugger != null) {
            this.debugger.sendTerminalTypedCommand(cmd);
        } else {
            this.toDCE.sendChars(c, offset, count);
            this.toDCE.flush();
        }
    }

    void setMiProxy(MIProxy miProxy) {
        this.miProxy = miProxy;
    }

    void setDebugger(GdbDebuggerImpl debugger) {
        this.debugger = debugger;
    }

    @Override
    public void inject(String cmd) {
        final char[] cmda = cmd.toCharArray();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (TRACING_IN_CONSOLE) {
                    Tap.this.toDTE.putChars(KeyProcessing.ESCAPES.BOLD_SEQUENCE, 0, KeyProcessing.ESCAPES.BOLD_SEQUENCE.length);
                    Tap.this.toDTE.putChars(cmda, 0, cmda.length);
                    Tap.this.toDTE.putChar('\r');
                    Tap.this.toDTE.putChars(KeyProcessing.ESCAPES.RESET_SEQUENCE, 0, KeyProcessing.ESCAPES.RESET_SEQUENCE.length);
                    Tap.this.toDTE.flush();
                }
                Tap.this.sendQueue.post(new Runnable(){

                    @Override
                    public void run() {
                        Tap.this.toDCE.sendChars(cmda, 0, cmda.length);
                    }
                });
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    void printError(String errMsg) {
        final char[] cmda = errMsg.toCharArray();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Tap.this.toDTE.putChars(KeyProcessing.ESCAPES.RED_SEQUENCE, 0, KeyProcessing.ESCAPES.RED_SEQUENCE.length);
                Tap.this.toDTE.putChars(cmda, 0, cmda.length);
                Tap.this.toDTE.putChar('\r');
                Tap.this.toDTE.putChar('\n');
                Tap.this.toDTE.putChars(KeyProcessing.ESCAPES.RESET_SEQUENCE, 0, KeyProcessing.ESCAPES.RESET_SEQUENCE.length);
                Tap.this.toDTE.flush();
            }
        });
    }

    @Override
    public void log(String cmd) {
        final char[] cmda = cmd.toCharArray();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Tap.this.toDTE.putChars(KeyProcessing.ESCAPES.LOG_SEQUENCE, 0, KeyProcessing.ESCAPES.LOG_SEQUENCE.length);
                Tap.this.toDTE.putChars(cmda, 0, cmda.length);
                Tap.this.toDTE.putChars(KeyProcessing.ESCAPES.RESET_SEQUENCE, 0, KeyProcessing.ESCAPES.RESET_SEQUENCE.length);
                if (Tap.this.prompted) {
                    Tap.this.toDTE.putChars(Tap.PROMPT.toCharArray(), 0, Tap.PROMPT.length());
                    Tap.this.toDTE.putChar('\r');
                    Tap.this.toDTE.putChar('\n');
                }
                Tap.this.toDTE.flush();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCharFromGdb(char c) {
        this.toTermBuf.append(c);
        this.interceptBuffer.append(c);
        if (c == '\n') {
            String line = this.interceptBuffer.toString();
            LinkedList<String> linkedList = this.interceptedLines;
            synchronized (linkedList) {
                this.interceptedLines.addLast(line);
            }
            this.interceptBuffer.delete(0, this.interceptBuffer.length());
            this.toTermBuf.append('\r');
            if (line.startsWith("~")) {
                if (TRACING_IN_CONSOLE) {
                    this.toTermBuf.insert(0, KeyProcessing.ESCAPES.GREEN_SEQUENCE);
                    this.toTermBuf.append(KeyProcessing.ESCAPES.RESET_SEQUENCE);
                } else {
                    this.toTermBuf.delete(0, this.toTermBuf.length());
                }
            } else if (line.startsWith("&") || line.startsWith("*") || line.startsWith("=")) {
                if (TRACING_IN_CONSOLE) {
                    this.toTermBuf.insert(0, KeyProcessing.ESCAPES.BROWN_SEQUENCE);
                    this.toTermBuf.append(KeyProcessing.ESCAPES.RESET_SEQUENCE);
                } else {
                    this.toTermBuf.delete(0, this.toTermBuf.length());
                }
            } else {
                int caretx = line.indexOf(94);
                if (caretx != -1) {
                    if (TRACING_IN_CONSOLE) {
                        if (line.startsWith("^error,", caretx)) {
                            this.toTermBuf.insert(0, KeyProcessing.ESCAPES.RED_SEQUENCE);
                            this.toTermBuf.append(KeyProcessing.ESCAPES.RESET_SEQUENCE);
                        }
                    } else {
                        this.toTermBuf.delete(0, this.toTermBuf.length());
                    }
                }
            }
            if (this.toTermBuf.length() > 0) {
                boolean sendFlag = true;
                if (this.toTermBuf.toString().trim().equals(PROMPT)) {
                    if (this.prompted) {
                        sendFlag = false;
                    } else {
                        this.prompted = true;
                    }
                } else {
                    this.prompted = false;
                }
                if (sendFlag) {
                    char[] chars = new char[this.toTermBuf.length()];
                    this.toTermBuf.getChars(0, this.toTermBuf.length(), chars, 0);
                    this.toDTE.putChars(chars, 0, this.toTermBuf.length());
                    this.toTermBuf.delete(0, this.toTermBuf.length());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchInterceptedLines() {
        LinkedList<String> linkedList = this.interceptedLines;
        synchronized (linkedList) {
            while (!this.interceptedLines.isEmpty()) {
                final String line = this.interceptedLines.removeFirst();
                this.processingQueue.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Tap.this.miProxy.processLine(line);
                        }
                        catch (Exception e) {
                            Exceptions.printStackTrace((Throwable)new Exception("when processing line: " + line, e));
                        }
                    }
                });
            }
        }
    }
}

