/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.options;

import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.fortran.options.FmtOptions;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;

public final class FortranCodeStyle {
    private final Preferences preferences;
    private final CndLexerUtilities.FortranFormat autoDetectedFormat;

    private FortranCodeStyle(Preferences preferences, CndLexerUtilities.FortranFormat autoDetectedFormat) {
        this.preferences = preferences;
        this.autoDetectedFormat = autoDetectedFormat;
    }

    public InputAttributes setupLexerAttributes(Document doc) {
        InputAttributes lexerAttrs = (InputAttributes)doc.getProperty(InputAttributes.class);
        if (lexerAttrs == null) {
            lexerAttrs = new InputAttributes();
            doc.putProperty(InputAttributes.class, lexerAttrs);
        }
        lexerAttrs.setValue(FortranTokenId.languageFortran(), (Object)"fortran-maximum-text-width", (Object)this.getRrightMargin(), true);
        lexerAttrs.setValue(FortranTokenId.languageFortran(), (Object)"fortran-free-format", (Object)this.getFormatFortran(), true);
        return lexerAttrs;
    }

    public static FortranCodeStyle get(Document doc, Preferences pref) {
        return new FortranCodeStyle(pref, CndLexerUtilities.detectFortranFormat((Document)doc));
    }

    public static FortranCodeStyle get(Document doc) {
        return new FortranCodeStyle(CodeStylePreferences.get((Document)doc).getPreferences(), CndLexerUtilities.detectFortranFormat((Document)doc));
    }

    public boolean absoluteLabelIndent() {
        return true;
    }

    public boolean expandTabToSpaces() {
        return this.preferences.getBoolean("expand-tabs", FmtOptions.getDefaultAsBoolean("expand-tabs"));
    }

    public int getTabSize() {
        return this.preferences.getInt("tab-size", FmtOptions.getDefaultAsInt("tab-size"));
    }

    public int getRrightMargin() {
        return this.preferences.getInt("text-limit-width", FmtOptions.getDefaultAsInt("text-limit-width"));
    }

    public boolean indentCasesFromSwitch() {
        return true;
    }

    public CodeStyle.PreprocessorIndent indentPreprocessorDirectives() {
        return CodeStyle.PreprocessorIndent.START_LINE;
    }

    public int indentSize() {
        return this.preferences.getInt("indent-shift-width", FmtOptions.getDefaultAsInt("indent-shift-width"));
    }

    public CndLexerUtilities.FortranFormat getFormatFortran() {
        if (this.isAutoFormatDetection()) {
            return this.autoDetectedFormat;
        }
        if (this.preferences.getBoolean("freeFormat", FmtOptions.getDefaultAsBoolean("freeFormat"))) {
            return CndLexerUtilities.FortranFormat.FREE;
        }
        return CndLexerUtilities.FortranFormat.FIXED;
    }

    public void setFreeFormatFortran(boolean freeFormat) {
        this.preferences.putBoolean("freeFormat", freeFormat);
    }

    public boolean isAutoFormatDetection() {
        return this.preferences.getBoolean("autoDetect", FmtOptions.getDefaultAsBoolean("autoDetect"));
    }

    public void setAutoFormatDetection(boolean autoFormatDetection) {
        this.preferences.putBoolean("autoDetect", autoFormatDetection);
    }

    public boolean sharpAtStartLine() {
        return true;
    }

    public boolean spaceAfterComma() {
        return true;
    }

    public boolean spaceAroundAssignOps() {
        return true;
    }

    public boolean spaceAroundBinaryOps() {
        return true;
    }

    public boolean spaceAroundUnaryOps() {
        return false;
    }

    public boolean spaceBeforeComma() {
        return false;
    }

    public boolean spaceBeforeForParen() {
        return true;
    }

    public boolean spaceBeforeIfParen() {
        return true;
    }

    public boolean spaceBeforeKeywordParen() {
        return true;
    }

    public boolean spaceBeforeMethodCallParen() {
        return false;
    }

    public boolean spaceBeforeMethodDeclParen() {
        return false;
    }

    public boolean spaceBeforeSwitchParen() {
        return true;
    }

    public boolean spaceBeforeWhile() {
        return true;
    }

    public boolean spaceBeforeWhileParen() {
        return true;
    }

    public boolean spaceWithinForParens() {
        return false;
    }

    public boolean spaceWithinIfParens() {
        return false;
    }

    public boolean spaceWithinMethodCallParens() {
        return false;
    }

    public boolean spaceWithinMethodDeclParens() {
        return false;
    }

    public boolean spaceWithinParens() {
        return false;
    }

    public boolean spaceWithinSwitchParens() {
        return false;
    }

    public boolean spaceWithinWhileParens() {
        return false;
    }
}

