/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.options.BooleanNodeProp;
import org.netbeans.modules.cnd.editor.options.BracePlacementProperty;
import org.netbeans.modules.cnd.editor.options.EditorOptions;
import org.netbeans.modules.cnd.editor.options.EditorOptionsPanelController;
import org.netbeans.modules.cnd.editor.options.IntNodeProp;
import org.netbeans.modules.cnd.editor.options.ManageStylesPanel;
import org.netbeans.modules.cnd.editor.options.PreprocessorIndentProperty;
import org.netbeans.modules.cnd.editor.options.PreviewPreferences;
import org.netbeans.modules.cnd.editor.options.PreviewPreferencesModel;
import org.netbeans.modules.cnd.editor.options.VisibilityIndentProperty;
import org.netbeans.modules.cnd.editor.reformat.Reformatter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class EditorPropertySheet
extends JPanel
implements ActionListener,
PropertyChangeListener,
PreferenceChangeListener {
    private static final boolean TRACE = false;
    private final EditorOptionsPanelController topController;
    private boolean loaded = false;
    private final CodeStyle.Language language;
    private String lastChangedproperty;
    private PreviewPreferencesModel preferencesModel;
    private PreviewPreferencesModel.Filter filter;
    private PropertySheet holder;
    private boolean propertyChanged = false;
    private boolean stylesChanged = false;
    private PreviewPreferences lastSheetPreferences = null;
    private JPanel categoryPanel;
    private JLabel jLabel1;
    private JButton manageStyles;
    private JCheckBox overrideGlobalOptions;
    private JComboBox styleComboBox;

    EditorPropertySheet(EditorOptionsPanelController topControler, CodeStyle.Language language, PreviewPreferencesModel preferencesModel, PreviewPreferencesModel.Filter filter) {
        this.topController = topControler;
        this.language = language;
        this.preferencesModel = preferencesModel;
        this.filter = filter;
        this.initComponents();
        this.overrideGlobalOptions.addActionListener(this);
        this.holder = new PropertySheet();
        this.holder.setOpaque(false);
        this.holder.setDescriptionAreaVisible(false);
        this.holder.setPreferredSize(new Dimension(250, 150));
        GridBagConstraints fillConstraints = new GridBagConstraints();
        fillConstraints.gridwidth = 0;
        fillConstraints.gridheight = 0;
        fillConstraints.fill = 1;
        fillConstraints.weightx = 1.0;
        fillConstraints.weighty = 1.0;
        this.categoryPanel.add((Component)this.holder, fillConstraints);
        this.manageStyles.setMinimumSize(new Dimension(126, 26));
        switch (filter) {
            case Alignment: {
                this.setName(EditorPropertySheet.getString("Filter_Alignment_name"));
                break;
            }
            case All: {
                this.setName(EditorPropertySheet.getString("Filter_All_name"));
                break;
            }
            case BlankLines: {
                this.setName(EditorPropertySheet.getString("Filter_BlankLines_name"));
                break;
            }
            case Braces: {
                this.setName(EditorPropertySheet.getString("Filter_Braces_name"));
                break;
            }
            case Spaces: {
                this.setName(EditorPropertySheet.getString("Filter_Spaces_name"));
                break;
            }
            case TabsAndIndents: {
                this.setName(EditorPropertySheet.getString("Filter_TabsAndIndents_name"));
            }
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() == EditorPropertySheet.this) {
                    EditorPropertySheet.this.initLanguageCategory();
                }
            }
        });
    }

    private void initLanguageMap() {
        this.preferencesModel.initLanguageMap(this.language);
    }

    private void initLanguageCategory() {
        this.styleComboBox.removeActionListener(this);
        Map<String, PreviewPreferences> prefences = this.preferencesModel.getPrefences(this.language);
        if (prefences == null) {
            return;
        }
        DefaultComboBoxModel<EntryWrapper> model = new DefaultComboBoxModel<EntryWrapper>();
        ArrayList<EntryWrapper> list = new ArrayList<EntryWrapper>();
        for (Map.Entry<String, PreviewPreferences> entry : prefences.entrySet()) {
            list.add(new EntryWrapper(entry));
        }
        Collections.sort(list);
        int index = 0;
        int i = 0;
        for (EntryWrapper entry : list) {
            if (entry.name.equals(this.preferencesModel.getLanguageDefaultStyle(this.language))) {
                index = i;
            }
            model.addElement(entry);
            ++i;
        }
        this.styleComboBox.setModel(model);
        this.styleComboBox.setSelectedIndex(index);
        EntryWrapper entry = (EntryWrapper)this.styleComboBox.getSelectedItem();
        this.initSheets(entry.preferences);
        this.preferencesModel.setLanguageDefaultStyle(this.language, entry.name);
        this.styleComboBox.addActionListener(this);
        this.repaintPreview();
    }

    private void initSheets(PreviewPreferences preferences) {
        Sheet.Set set;
        if (this.lastSheetPreferences != null) {
            this.lastSheetPreferences.removePreferenceChangeListener(this);
        }
        this.overrideGlobalOptions.setSelected(preferences.getBoolean("overrideTabIndents", (Boolean)EditorOptions.getDefault(this.language, preferences.getStyleId(), "overrideTabIndents")));
        Sheet sheet = new Sheet();
        if (this.filter == PreviewPreferencesModel.Filter.All || this.filter == PreviewPreferencesModel.Filter.TabsAndIndents) {
            this.overrideGlobalOptions.setVisible(true);
            set = new Sheet.Set();
            set.setName("Indents");
            set.setDisplayName(EditorPropertySheet.getString("LBL_TabsAndIndents"));
            set.setShortDescription(EditorPropertySheet.getString("HINT_TabsAndIndents"));
            if (this.overrideGlobalOptions.isSelected()) {
                set.put((Node.Property)new IntNodeProp(this.language, preferences, "indentSize"));
                set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "expandTabToSpaces"));
                set.put((Node.Property)new IntNodeProp(this.language, preferences, "tabSize"));
            } else {
                set.put((Node.Property)new IntNodeProp(this.language, preferences, "indentSize", EditorOptions.getGlobalIndentSize()));
                set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "expandTabToSpaces", EditorOptions.getGlobalExpandTabs()));
                set.put((Node.Property)new IntNodeProp(this.language, preferences, "tabSize", EditorOptions.getGlobalTabSize()));
            }
            set.put((Node.Property)new IntNodeProp(this.language, preferences, "statementContinuationIndent"));
            set.put((Node.Property)new IntNodeProp(this.language, preferences, "constructorListContinuationIndent"));
            set.put((Node.Property)new PreprocessorIndentProperty(this.language, preferences, "indentPreprocessorDirectives"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "sharpAtStartLine"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "indentNamespace"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "indentCasesFromSwitch"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "absoluteLabelIndent"));
            set.put((Node.Property)new VisibilityIndentProperty(this.language, preferences, "indentVisibility"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceKeepExtra"));
            sheet.put(set);
        } else {
            this.overrideGlobalOptions.setVisible(false);
        }
        if (this.filter == PreviewPreferencesModel.Filter.All || this.filter == PreviewPreferencesModel.Filter.Braces) {
            set = new Sheet.Set();
            set.setName("BracesPlacement");
            set.setDisplayName(EditorPropertySheet.getString("LBL_BracesPlacement"));
            set.setShortDescription(EditorPropertySheet.getString("HINT_BracesPlacement"));
            set.put((Node.Property)new BracePlacementProperty(this.language, preferences, "newLineBeforeBraceNamespace"));
            set.put((Node.Property)new BracePlacementProperty(this.language, preferences, "newLineBeforeBraceClass"));
            set.put((Node.Property)new BracePlacementProperty(this.language, preferences, "newLineBeforeBraceDeclaration"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "ignoreEmptyFunctionBody"));
            set.put((Node.Property)new BracePlacementProperty(this.language, preferences, "newLineBeforeBraceLambda"));
            set.put((Node.Property)new BracePlacementProperty(this.language, preferences, "newLineBeforeBraceSwitch"));
            set.put((Node.Property)new BracePlacementProperty(this.language, preferences, "newLineBeforeBrace"));
            sheet.put(set);
        }
        if (this.filter == PreviewPreferencesModel.Filter.All || this.filter == PreviewPreferencesModel.Filter.Alignment) {
            set = new Sheet.Set();
            set.setName("MultilineAlignment");
            set.setDisplayName(EditorPropertySheet.getString("LBL_MultilineAlignment"));
            set.setShortDescription(EditorPropertySheet.getString("HINT_MultilineAlignment"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "alignMultilineMethodParams"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "alignMultilineCallArgs"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "alignMultilineArrayInit"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "alignMultilineFor"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "alignMultilineIfCondition"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "alignMultilineWhileCondition"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "alignMultilineParen"));
            sheet.put(set);
        }
        if (this.filter == PreviewPreferencesModel.Filter.All || this.filter == PreviewPreferencesModel.Filter.Braces) {
            set = new Sheet.Set();
            set.setName("NewLine");
            set.setDisplayName(EditorPropertySheet.getString("LBL_NewLine"));
            set.setShortDescription(EditorPropertySheet.getString("HINT_NewLine"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "newLineFunctionDefinitionName"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "newLineCatch"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "newLineElse"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "newLineWhile"));
            sheet.put(set);
        }
        if (this.filter == PreviewPreferencesModel.Filter.All || this.filter == PreviewPreferencesModel.Filter.Spaces) {
            set = new Sheet.Set();
            set.setName("SpacesBeforeKeywords");
            set.setDisplayName(EditorPropertySheet.getString("LBL_BeforeKeywords"));
            set.setShortDescription(EditorPropertySheet.getString("HINT_BeforeKeywords"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeCatch"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeElse"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeWhile"));
            sheet.put(set);
            set = new Sheet.Set();
            set.setName("SpacesBeforeParentheses");
            set.setDisplayName(EditorPropertySheet.getString("LBL_BeforeParentheses"));
            set.setShortDescription(EditorPropertySheet.getString("HINT_BeforeParentheses"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeMethodDeclParen"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeMethodCallParen"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeCatchParen"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeForParen"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeIfParen"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeSwitchParen"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeWhileParen"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeKeywordParen"));
            sheet.put(set);
            set = new Sheet.Set();
            set.setName("SpacesAroundOperators");
            set.setDisplayName(EditorPropertySheet.getString("LBL_AroundOperators"));
            set.setShortDescription(EditorPropertySheet.getString("HINT_AroundOperators"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceAroundAssignOps"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceAroundBinaryOps"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceAroundTernaryOps"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceAroundUnaryOps"));
            sheet.put(set);
            set = new Sheet.Set();
            set.setName("SpacesBeforeLeftBracess");
            set.setDisplayName(EditorPropertySheet.getString("LBL_BeforeLeftBraces"));
            set.setShortDescription(EditorPropertySheet.getString("HINT_BeforeLeftBraces"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeClassDeclLeftBrace"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeMethodDeclLeftBrace"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeLambdaLeftBrace"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeArrayInitLeftBrace"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeCatchLeftBrace"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeDoLeftBrace"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeElseLeftBrace"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeForLeftBrace"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeIfLeftBrace"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeSwitchLeftBrace"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeTryLeftBrace"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeWhileLeftBrace"));
            sheet.put(set);
            set = new Sheet.Set();
            set.setName("SpacesWithinParentheses");
            set.setDisplayName(EditorPropertySheet.getString("LBL_WithinParentheses"));
            set.setShortDescription(EditorPropertySheet.getString("HINT_WithinParentheses"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceWithinMethodDeclParens"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceWithinMethodCallParens"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceWithinBraces"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceWithinParens"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceWithinCatchParens"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceWithinForParens"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceWithinIfParens"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceWithinSwitchParens"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceWithinTypeCastParens"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceWithinWhileParens"));
            sheet.put(set);
            set = new Sheet.Set();
            set.setName("SpacesOther");
            set.setDisplayName(EditorPropertySheet.getString("LBL_Other_Spaces"));
            set.setShortDescription(EditorPropertySheet.getString("HINT_Other_Spaces"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeComma"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceAfterComma"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeSemi"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceAfterSemi"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceBeforeColon"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceAfterColon"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceAfterTypeCast"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "spaceAfterOperatorKeyword"));
            sheet.put(set);
        }
        if (this.filter == PreviewPreferencesModel.Filter.All || this.filter == PreviewPreferencesModel.Filter.BlankLines) {
            set = new Sheet.Set();
            set.setName("BlankLines");
            set.setDisplayName(EditorPropertySheet.getString("LBL_BlankLines"));
            set.setShortDescription(EditorPropertySheet.getString("HINT_BlankLines"));
            set.put((Node.Property)new IntNodeProp(this.language, preferences, "blankLinesBeforeClass"));
            set.put((Node.Property)new IntNodeProp(this.language, preferences, "blankLinesAfterClassHeader"));
            set.put((Node.Property)new IntNodeProp(this.language, preferences, "blankLinesBeforeMethods"));
            sheet.put(set);
        }
        if (this.filter == PreviewPreferencesModel.Filter.All || this.filter == PreviewPreferencesModel.Filter.TabsAndIndents) {
            set = new Sheet.Set();
            set.setName("Other");
            set.setDisplayName(EditorPropertySheet.getString("LBL_Other"));
            set.setShortDescription(EditorPropertySheet.getString("HINT_Other"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "addLeadingStarInComment"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "useBlockComment"));
            set.put((Node.Property)new BooleanNodeProp(this.language, preferences, "useInlineKeyword"));
            sheet.put(set);
        }
        DummyNode[] dummyNodes = new DummyNode[]{new DummyNode(sheet, "Sheet")};
        this.holder.setNodes((Node[])dummyNodes);
        preferences.addPreferenceChangeListener(this);
        this.lastSheetPreferences = preferences;
    }

    void load() {
        this.loaded = false;
        this.initLanguageMap();
        this.initLanguageCategory();
        this.loaded = true;
        this.repaintPreview();
        this.propertyChanged = false;
        this.stylesChanged = false;
    }

    void store() {
        if (this.filter != PreviewPreferencesModel.Filter.All) {
            return;
        }
        EditorOptions.setCurrentProfileId(this.language, this.preferencesModel.getLanguageDefaultStyle(this.language));
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, PreviewPreferences> prefEntry : this.preferencesModel.getLanguagePreferences(this.language).entrySet()) {
            String style = prefEntry.getKey();
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(style);
            PreviewPreferences pref = prefEntry.getValue();
            Preferences toSave = EditorOptions.getPreferences(this.language, style);
            if (style.equals(this.preferencesModel.getLanguageDefaultStyle(this.language))) {
                EditorOptions.setPreferences(CodeStyle.getDefault(this.language, null), toSave);
            }
            for (String key : EditorOptions.keys()) {
                Object v;
                Object o = EditorOptions.getDefault(this.language, style, key);
                if (o instanceof Boolean) {
                    v = pref.getBoolean(key, (Boolean)o);
                    if (!o.equals(v)) {
                        toSave.putBoolean(key, (Boolean)v);
                        continue;
                    }
                    toSave.remove(key);
                    continue;
                }
                if (o instanceof Integer) {
                    v = pref.getInt(key, (Integer)o);
                    if (!o.equals(v)) {
                        toSave.putInt(key, (Integer)v);
                        continue;
                    }
                    toSave.remove(key);
                    continue;
                }
                v = pref.get(key, o.toString());
                if (!o.equals(v)) {
                    toSave.put(key, (String)v);
                    continue;
                }
                toSave.remove(key);
            }
            if (!style.equals(this.preferencesModel.getLanguageDefaultStyle(this.language))) continue;
            EditorOptions.updateSimplePreferences(this.language, CodeStyle.getDefault(this.language, null));
        }
        EditorOptions.setAllStyles(this.language, buf.toString());
        this.preferencesModel.clear(this.language);
        this.holder.setNodes(null);
        this.propertyChanged = false;
        this.stylesChanged = false;
    }

    void cancel() {
        this.holder.setNodes(null);
        if (this.filter != PreviewPreferencesModel.Filter.All) {
            return;
        }
        this.preferencesModel.clear(this.language);
        this.propertyChanged = false;
        this.stylesChanged = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        EntryWrapper category;
        this.lastChangedproperty = null;
        if (this.styleComboBox.equals(e.getSource())) {
            EntryWrapper category2 = (EntryWrapper)this.styleComboBox.getSelectedItem();
            if (category2 != null) {
                this.preferencesModel.setLanguageDefaultStyle(this.language, category2.name);
                this.initSheets(category2.preferences);
                this.repaintPreview();
            }
        } else if (this.overrideGlobalOptions.equals(e.getSource()) && (category = (EntryWrapper)this.styleComboBox.getSelectedItem()) != null) {
            category.preferences.putBoolean("overrideTabIndents", this.overrideGlobalOptions.isSelected());
            this.preferencesModel.setLanguageDefaultStyle(this.language, category.name);
            this.initSheets(category.preferences);
            this.repaintPreview();
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        this.lastChangedproperty = evt.getKey();
        this.change();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.change();
    }

    private void change() {
        if (!this.loaded) {
            return;
        }
        this.firePrefsChanged();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                EditorPropertySheet.this.topController.changed(EditorPropertySheet.this.stylesChanged || EditorPropertySheet.this.propertyChanged);
                EditorPropertySheet.this.repaintPreview();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    private void firePrefsChanged() {
        boolean isChanged = false;
        Map<String, PreviewPreferences> languagePreferences = this.preferencesModel.getLanguagePreferences(this.language);
        if (languagePreferences != null) {
            Set<String> keys = EditorOptions.keys();
            for (String style : languagePreferences.keySet()) {
                for (String key : keys) {
                    String currentValue = languagePreferences.get(style).get(key, null);
                    String savedValue = EditorOptions.getPreferences(this.language, style).get(key, null);
                    if (currentValue == null) {
                        isChanged |= savedValue != null;
                        continue;
                    }
                    isChanged |= savedValue == null ? !EditorOptions.getDefault(this.language, style, key).toString().equals(currentValue) : !savedValue.equals(currentValue);
                }
            }
        }
        this.propertyChanged = isChanged;
    }

    public void repaintPreview() {
        EntryWrapper category = (EntryWrapper)this.styleComboBox.getSelectedItem();
        if (category == null) {
            category = (EntryWrapper)this.styleComboBox.getItemAt(0);
        }
        JEditorPane previewPane = (JEditorPane)this.topController.getPreviewComponent();
        if (this.loaded) {
            PreviewPreferences p = new PreviewPreferences(category.preferences, category.preferences.getLanguage(), category.preferences.getStyleId());
            p.makeAllKeys(category.preferences);
            p.putBoolean("overrideTabIndents", this.overrideGlobalOptions.isSelected());
            if (!this.overrideGlobalOptions.isSelected()) {
                p.putBoolean("expandTabToSpaces", EditorOptions.getGlobalExpandTabs());
                p.putInt("tabSize", EditorOptions.getGlobalTabSize());
                p.putInt("indentSize", EditorOptions.getGlobalIndentSize());
            }
            p.putInt("tab-size", p.getInt("tabSize", 8));
            p.putBoolean("expand-tabs", p.getBoolean("expandTabToSpaces", true));
            p.putInt("spaces-per-tab", p.getInt("indentSize", 4));
            p.putInt("indent-shift-width", p.getInt("indentSize", 4));
            Document doc = previewPane.getDocument();
            doc.putProperty("Tools-Options->Editor->Formatting->Preview - Preferences", p);
            doc.putProperty("tab-size", p.getInt("tabSize", 8));
            previewPane.setIgnoreRepaint(true);
            this.refreshPreview(previewPane, p);
            previewPane.setIgnoreRepaint(false);
            previewPane.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
            previewPane.repaint(100L);
        }
    }

    private String getPreviewText() {
        String suffix;
        switch (this.language) {
            case C: {
                suffix = ".c";
                break;
            }
            case HEADER: {
                suffix = ".cpp";
                break;
            }
            default: {
                suffix = ".cpp";
            }
        }
        if (this.lastChangedproperty != null) {
            if (this.lastChangedproperty.startsWith("space")) {
                return this.loadPreviewExample("SAMPLE_Spaces" + suffix);
            }
            if (this.lastChangedproperty.startsWith("blank")) {
                return this.loadPreviewExample("SAMPLE_BlankLines" + suffix);
            }
            if (this.lastChangedproperty.startsWith("align") || this.lastChangedproperty.startsWith("new")) {
                return this.loadPreviewExample("SAMPLE_AlignBraces" + suffix);
            }
        }
        return this.loadPreviewExample("SAMPLE_TabsIndents" + suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadPreviewExample(String example) {
        FileObject exampleFile = FileUtil.getConfigFile((String)("OptionsDialog/CPlusPlus/FormatterPreviewExamples/" + example));
        if (exampleFile != null && exampleFile.getSize() > 0L) {
            StringBuilder sb = new StringBuilder((int)exampleFile.getSize());
            try {
                InputStreamReader is = new InputStreamReader(exampleFile.getInputStream());
                char[] buffer = new char[1024];
                try {
                    int size;
                    while (0 < (size = is.read(buffer, 0, buffer.length))) {
                        sb.append(buffer, 0, size);
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException ioe) {
                Logger.getLogger(EditorPropertySheet.class.getName()).log(Level.FINE, null, ioe);
            }
            return sb.toString();
        }
        return "";
    }

    private void refreshPreview(JEditorPane pane, Preferences p) {
        pane.setText(this.getPreviewText());
        final BaseDocument bd = (BaseDocument)pane.getDocument();
        EntryWrapper entry = (EntryWrapper)this.styleComboBox.getSelectedItem();
        final CodeStyle codeStyle = EditorOptions.createCodeStyle(this.language, entry.name, p, false);
        bd.runAtomicAsUser(new Runnable(){

            @Override
            public void run() {
                try {
                    new Reformatter((Document)bd, codeStyle).reformat();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private static String getString(String key) {
        return NbBundle.getMessage(EditorPropertySheet.class, (String)key);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.styleComboBox = new JComboBox();
        this.categoryPanel = new JPanel();
        this.manageStyles = new JButton();
        this.overrideGlobalOptions = new JCheckBox();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.styleComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(EditorPropertySheet.class, (String)"LBL_Style_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.styleComboBox.setMaximumSize(new Dimension(100, 25));
        this.styleComboBox.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.styleComboBox, gridBagConstraints);
        this.categoryPanel.setBorder(BorderFactory.createEtchedBorder());
        this.categoryPanel.setOpaque(false);
        this.categoryPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.categoryPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.manageStyles, (String)NbBundle.getMessage(EditorPropertySheet.class, (String)"EditorPropertySheet.manageStyles.text"));
        this.manageStyles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorPropertySheet.this.manageStylesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.manageStyles, gridBagConstraints);
        this.overrideGlobalOptions.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.overrideGlobalOptions, (String)NbBundle.getMessage(EditorPropertySheet.class, (String)"LBL_OverrideGlobalOptions"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        this.add((Component)this.overrideGlobalOptions, gridBagConstraints);
    }

    private void manageStylesActionPerformed(ActionEvent evt) {
        Map<String, PreviewPreferences> clone = this.preferencesModel.clonePreferences(this.language);
        ManageStylesPanel stylesPanel = new ManageStylesPanel(this.language, clone);
        DialogDescriptor dd = new DialogDescriptor((Object)stylesPanel, EditorPropertySheet.getString("MANAGE_STYLES_DIALOG_TITLE"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            this.preferencesModel.resetPreferences(this.language, clone);
            this.initLanguageCategory();
            HashSet<String> saved = new HashSet<String>();
            saved.addAll(EditorOptions.getAllStyles(this.language));
            this.stylesChanged = !clone.keySet().equals(saved);
            this.topController.changed(this.stylesChanged || this.propertyChanged);
        }
    }

    private static class DummyNode
    extends AbstractNode {
        public DummyNode(Sheet sheet, String name) {
            super(Children.LEAF);
            if (sheet != null) {
                this.setSheet(sheet);
            }
            this.setName(name);
        }
    }

    private static class EntryWrapper
    implements Comparable<EntryWrapper> {
        private final String name;
        private final String displayName;
        private final PreviewPreferences preferences;

        private EntryWrapper(Map.Entry<String, PreviewPreferences> enrty) {
            this.name = enrty.getKey();
            this.preferences = enrty.getValue();
            this.displayName = EditorOptions.getStyleDisplayName(this.preferences.getLanguage(), this.name);
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compareTo(EntryWrapper o) {
            return this.displayName.compareTo(o.displayName);
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + (this.displayName != null ? this.displayName.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntryWrapper other = (EntryWrapper)obj;
            return !(this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName));
        }
    }
}

