/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.browser.webview;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.browser.api.WebBrowser;
import org.netbeans.core.browser.webview.NoWebBrowserImpl;
import org.netbeans.core.browser.webview.OldRuntimePanel;
import org.openide.util.Lookup;

public class WebBrowserImplProvider {
    private static final Logger log = Logger.getLogger(WebBrowserImplProvider.class.getName());

    static WebBrowser createBrowser() {
        return WebBrowserImplProvider.createBrowser(null);
    }

    static WebBrowser createBrowser(File runtimePath) {
        ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (null == cl) {
            cl = WebBrowserImplProvider.class.getClassLoader();
        }
        try {
            if (cl != null) {
                cl.loadClass("com.sun.javafx.scene.web.Debugger");
                Class<?> platform = cl.loadClass("javafx.application.Platform");
                Method m = platform.getMethod("setImplicitExit", Boolean.TYPE);
            }
        }
        catch (Throwable ex) {
            log.log(Level.INFO, "JavaFX runtime is too old - minimum version required is 2.2.0b20", ex);
            return new NoWebBrowserImpl("JavaFX runtime is too old - minimum version required is 2.2.0b20");
        }
        try {
            if (cl != null) {
                Class<?> impl = cl.loadClass("org.netbeans.core.browser.webview.ext.WebBrowserImpl");
                Constructor<?> c = impl.getConstructor(new Class[0]);
                return (WebBrowser)c.newInstance(new Object[0]);
            }
        }
        catch (Throwable ex) {
            log.log(Level.INFO, ex.getMessage(), ex);
            return new NoWebBrowserImpl(ex.getMessage());
        }
        return new NoWebBrowserImpl(new OldRuntimePanel());
    }
}

