/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.xml.ws.Holder;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.derby.Bundle;
import org.netbeans.modules.derby.DerbyActivator;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.ExecSupport;
import org.netbeans.modules.derby.StartAction;
import org.netbeans.modules.derby.Util;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.netbeans.modules.derby.ui.SecurityManagerBugPanel;
import org.netbeans.spi.db.explorer.DatabaseRuntime;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.NotificationDisplayer;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class RegisterDerby
implements DatabaseRuntime {
    private static final Logger LOGGER = Logger.getLogger(RegisterDerby.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final String DISABLE_SECURITY_MANAGER = "disableSecurityManager";
    private static final String DO_NOT_CHECK_SECURITY_MANAGER_BUG = "doNotCheckSecurityManagerBug";
    private static final String SECURITY_MANAGER_BUG_OUTPUT = "java.security.AccessControlException: access denied (\"java.net.SocketPermission\"";
    private static final int START_TIMEOUT = 0;
    private static RegisterDerby reg = null;
    private static Process process = null;

    private RegisterDerby() {
    }

    public static synchronized RegisterDerby getDefault() {
        if (reg == null) {
            reg = new RegisterDerby();
            if (EventQueue.isDispatchThread()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        DerbyActivator.activate();
                    }
                });
            } else {
                DerbyActivator.activate();
            }
        }
        return reg;
    }

    public boolean acceptsDatabaseURL(String url) {
        return url.trim().startsWith("jdbc:derby://localhost");
    }

    public boolean isRunning() {
        if (process != null) {
            try {
                int e = process.exitValue();
                process = null;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        return process != null;
    }

    public String getJDBCDriverClass() {
        return "org.apache.derby.jdbc.ClientDriver";
    }

    public boolean canStart() {
        return DerbyOptions.getDefault().getLocation().length() > 0;
    }

    public void start() {
        this.start(0);
    }

    private String getNetworkServerClasspath() {
        return Util.getDerbyFile("lib/derby.jar").getAbsolutePath() + File.pathSeparator + Util.getDerbyFile("lib/derbytools.jar").getAbsolutePath() + File.pathSeparator + Util.getDerbyFile("lib/derbynet.jar").getAbsolutePath();
    }

    private JDBCDriver getRegisteredDerbyDriver() {
        JDBCDriver[] drvs = JDBCDriverManager.getDefault().getDrivers("org.apache.derby.jdbc.ClientDriver");
        if (drvs.length > 0) {
            return drvs[0];
        }
        return null;
    }

    public int getPort() {
        return 1527;
    }

    void postCreateNewDatabase(final String databaseName, final String user, final String password) throws Exception {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (!RegisterDerby.this.ensureStarted(true)) {
                        return;
                    }
                    ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RegisterDerby.class, (String)"MSG_CreatingDBProgressLabel", (Object)databaseName));
                    ph.start();
                    try {
                        DerbyDatabases.createDatabase(databaseName, user, password);
                    }
                    finally {
                        ph.finish();
                    }
                }
                catch (IOException | RuntimeException | DatabaseException e) {
                    LOGGER.log(Level.WARNING, null, e);
                    String message = NbBundle.getMessage(RegisterDerby.class, (String)"ERR_CreateDatabase", (Object)e.getMessage());
                    Util.showInformation(message);
                }
            }
        });
    }

    private String getDerbySystemHome() {
        return DerbyOptions.getDefault().getSystemHome();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDerbyPropertiesFile() {
        File derbyProperties = new File(this.getDerbySystemHome(), "derby.properties");
        if (derbyProperties.exists()) {
            return;
        }
        Properties derbyProps = new Properties();
        if (Utilities.isMac()) {
            derbyProps.setProperty("derby.storage.fileSyncTransactionLog", "true");
        }
        OutputStream fileos = null;
        try {
            File derbyPropertiesParent = derbyProperties.getParentFile();
            derbyPropertiesParent.mkdirs();
            fileos = new FileOutputStream(derbyProperties);
            derbyProps.store(fileos, NbBundle.getMessage(RegisterDerby.class, (String)"MSG_DerbyPropsFile"));
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, ex.getLocalizedMessage() + " while createDerbyPropertiesFile into " + derbyProps, ex);
        }
        finally {
            if (fileos != null) {
                try {
                    fileos.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
            }
        }
    }

    private File getInstallLocation() {
        String location = DerbyOptions.getDefault().getLocation();
        if (location.equals("")) {
            return null;
        }
        return new File(location);
    }

    private String[] getEnvironment() {
        String location = DerbyOptions.getDefault().getLocation();
        if (location.equals("")) {
            return null;
        }
        return new String[]{"DERBY_INSTALL=" + location};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean start(int waitTime) {
        if (process != null) {
            this.stop();
        }
        if (!Util.checkInstallLocation()) {
            return false;
        }
        try {
            String java = RegisterDerby.getJavaExecutable();
            this.createDerbyPropertiesFile();
            NbProcessDescriptor desc = new NbProcessDescriptor(java, "-Dderby.system.home=\"" + this.getDerbySystemHome() + "\" " + "-classpath \"" + this.getNetworkServerClasspath() + "\"" + " org.apache.derby.drda.NetworkServerControl start" + this.startArgs());
            if (LOG) {
                LOGGER.log(Level.FINE, "Running {0} {1}", new Object[]{desc.getProcessName(), desc.getArguments()});
            }
            process = desc.exec(null, this.getEnvironment(), true, this.getInstallLocation());
            ExecSupport ee = new ExecSupport(process, NbBundle.getMessage(StartAction.class, (String)"LBL_outputtab"));
            ee.setStringToLookFor("" + this.getPort());
            this.addSecurityBugHandler(ee);
            ee.start();
            if (waitTime >= 0) {
                boolean canStart = this.waitStart(ee, waitTime);
                if (!canStart) {
                    this.stop();
                }
                boolean bl = canStart;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException | RuntimeException e) {
            Util.showInformation(e.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            InputOutput io = IOProvider.getDefault().getIO(NbBundle.getMessage(StartAction.class, (String)"LBL_outputtab"), false);
            io.getOut().close();
        }
    }

    private void addSecurityBugHandler(ExecSupport ee) {
        Preferences prefs = NbPreferences.forModule(RegisterDerby.class);
        if (!prefs.getBoolean(DISABLE_SECURITY_MANAGER, false) && !prefs.getBoolean(DO_NOT_CHECK_SECURITY_MANAGER_BUG, false)) {
            ee.addOutputStringHandler(SECURITY_MANAGER_BUG_OUTPUT, this.createSecurityManagerBugHandler());
        }
    }

    public Runnable createSecurityManagerBugHandler() {
        return new Runnable(){

            @Override
            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeLater(this);
                    return;
                }
                class NotifyPanel
                extends SecurityManagerBugPanel {
                    NotifyPanel() {
                    }

                    @Override
                    public void disableSecurityManagerClicked() {
                        NbPreferences.forModule(RegisterDerby.class).putBoolean(RegisterDerby.DISABLE_SECURITY_MANAGER, true);
                    }

                    @Override
                    public void doNotShowAgainClicked() {
                        NbPreferences.forModule(RegisterDerby.class).putBoolean(RegisterDerby.DO_NOT_CHECK_SECURITY_MANAGER_BUG, true);
                    }
                }
                NotificationDisplayer.getDefault().notify(Bundle.TTL_SecurityBug(), RegisterDerby.this.getDbIcon(), (JComponent)new NotifyPanel(), (JComponent)new NotifyPanel(), NotificationDisplayer.Priority.HIGH);
            }
        };
    }

    private String startArgs() {
        Preferences prefs = NbPreferences.forModule(RegisterDerby.class);
        if (prefs.getBoolean(DISABLE_SECURITY_MANAGER, false)) {
            return " -noSecurityManager";
        }
        return "";
    }

    private Icon getDbIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/derby/resources/database.gif", (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitStart(final ExecSupport execSupport, int waitTime) {
        boolean started = false;
        final Holder forceExit = new Holder((Object)false);
        String waitMessage = NbBundle.getMessage(RegisterDerby.class, (String)"MSG_StartingDerby");
        ProgressHandle progress = ProgressHandleFactory.createHandle((String)waitMessage, (Cancellable)new Cancellable(){

            public boolean cancel() {
                forceExit.value = true;
                return execSupport.interruptWaiting();
            }
        });
        progress.start();
        try {
            while (!started) {
                started = execSupport.waitForMessage(waitTime * 1000);
                if (started) continue;
                if (waitTime <= 0 || ((Boolean)forceExit.value).booleanValue()) break;
                String title = NbBundle.getMessage(RegisterDerby.class, (String)"LBL_DerbyDatabase");
                String message = NbBundle.getMessage(RegisterDerby.class, (String)"MSG_WaitStart", (Object)waitTime);
                NotifyDescriptor.Confirmation waitConfirmation = new NotifyDescriptor.Confirmation((Object)message, title, 0);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)waitConfirmation) == NotifyDescriptor.YES_OPTION) continue;
                break;
            }
            if (!started) {
                execSupport.terminate();
                LOGGER.log(Level.WARNING, "Derby server failed to start");
            }
        }
        finally {
            progress.finish();
        }
        return started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            if (process == null) {
                return;
            }
            String java = RegisterDerby.getJavaExecutable();
            NbProcessDescriptor desc = new NbProcessDescriptor(java, "-Dderby.system.home=\"" + this.getDerbySystemHome() + "\" " + "-classpath \"" + this.getNetworkServerClasspath() + "\"" + " org.apache.derby.drda.NetworkServerControl shutdown");
            if (LOG) {
                LOGGER.log(Level.FINE, "Running {0} {1}", new Object[]{desc.getProcessName(), desc.getArguments()});
            }
            Process shutwownProcess = desc.exec(null, this.getEnvironment(), true, this.getInstallLocation());
            shutwownProcess.waitFor();
            process.destroy();
            this.disconnectAllDerbyConnections();
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            Util.showInformation(e.getMessage());
        }
        finally {
            process = null;
        }
    }

    private static String getJavaExecutable() {
        File javaExe = new File(System.getProperty("java.home"), "/bin/java" + (Utilities.isWindows() ? ".exe" : ""));
        assert (javaExe.exists() && javaExe.canExecute()) : javaExe + " exists and it's executable.";
        File javaExeNormalized = FileUtil.normalizeFile((File)javaExe);
        FileObject javaFO = FileUtil.toFileObject((File)javaExeNormalized);
        if (javaFO == null) {
            throw new RuntimeException(NbBundle.getMessage(RegisterDerby.class, (String)"EXC_JavaExecutableNotFound"));
        }
        String java = FileUtil.toFile((FileObject)javaFO).getAbsolutePath();
        if (java == null) {
            throw new RuntimeException(NbBundle.getMessage(RegisterDerby.class, (String)"EXC_JavaExecutableNotFound"));
        }
        return java;
    }

    private void disconnectAllDerbyConnections() {
        DatabaseConnection[] dbconn = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < dbconn.length; ++i) {
            if (!RegisterDerby.getDefault().acceptsDatabaseURL(dbconn[i].getDatabaseURL())) continue;
            ConnectionManager.getDefault().disconnect(dbconn[i]);
        }
    }

    public boolean ensureStarted(boolean waitIfNotStarted) {
        if (this.isRunning()) {
            return true;
        }
        if (!this.canStart()) {
            return false;
        }
        if (waitIfNotStarted) {
            return this.start(0);
        }
        this.start(-1);
        return false;
    }
}

