/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.apigen.commands;

import java.awt.EventQueue;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.apigen.commands.Bundle;
import org.netbeans.modules.php.apigen.options.ApiGenOptions;
import org.netbeans.modules.php.apigen.ui.ApiGenPreferences;
import org.netbeans.modules.php.apigen.ui.options.ApiGenOptionsPanelController;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class ApiGenScript {
    static final Logger LOGGER = Logger.getLogger(ApiGenScript.class.getName());
    public static final String SCRIPT_NAME = "apigen";
    public static final String SCRIPT_NAME_LONG = "apigen" + FileUtils.getScriptExtension((boolean)true);
    public static final String ACCESS_LEVEL_PUBLIC = "public";
    public static final String ACCESS_LEVEL_PROTECTED = "protected";
    public static final String ACCESS_LEVEL_PRIVATE = "private";
    public static final String DEFAULT_CONFIG_NAME = "apigen.neon";
    public static final String DEFAULT_ACCESS_LEVELS = "public,protected";
    public static final boolean DEFAULT_INTERNAL = false;
    public static final boolean DEFAULT_PHP = true;
    public static final boolean DEFAULT_TREE = true;
    public static final boolean DEFAULT_DEPRECATED = false;
    public static final boolean DEFAULT_TODO = false;
    public static final boolean DEFAULT_DOWNLOAD = false;
    public static final boolean DEFAULT_SOURCE_CODE = true;
    private static final String GENERATE_PARAM = "generate";
    private static final String SOURCE_PARAM = "--source";
    private static final String DESTINATION_PARAM = "--destination";
    private static final String TITLE_PARAM = "--title";
    private static final String CONFIG_PARAM = "--config";
    private static final String CHARSET_PARAM = "--charset";
    private static final String EXCLUDE_PARAM = "--exclude";
    private static final String ACCESS_LEVELS_PARAM = "--access-levels";
    private static final String INTERNAL_PARAM = "--internal";
    private static final String PHP_PARAM = "--php";
    private static final String TREE_PARAM = "--tree";
    private static final String DEPRECATED_PARAM = "--deprecated";
    private static final String TODO_PARAM = "--todo";
    private static final String DOWNLOAD_PARAM = "--download";
    private static final String NO_SOURCE_CODE_PARAM = "--no-source-code";
    private final String apiGenPath;

    private ApiGenScript(String apiGenPath) {
        this.apiGenPath = apiGenPath;
    }

    public static ApiGenScript getDefault() throws InvalidPhpExecutableException {
        String apiGen = ApiGenOptions.getInstance().getApiGen();
        String error = ApiGenScript.validate(apiGen);
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new ApiGenScript(apiGen);
    }

    public static String validate(String apiGenPath) {
        return PhpExecutableValidator.validateCommand((String)apiGenPath, (String)Bundle.ApiGenScript_script_label());
    }

    public void generateDocumentation(PhpModule phpModule) {
        assert (!EventQueue.isDispatchThread());
        String target = ApiGenPreferences.getTarget(phpModule, true);
        if (target == null) {
            return;
        }
        Future result = new PhpExecutable(this.apiGenPath).optionsSubcategory("FrameworksAndTools/ApiGen").workDir(FileUtil.toFile((FileObject)phpModule.getProjectDirectory())).displayName(Bundle.ApiGenScript_api_generating(phpModule.getDisplayName())).additionalParameters(this.getGenerateParams(phpModule)).run(this.getDescriptor());
        try {
            File index;
            File targetDir = new File(target);
            if (result != null && (Integer)result.get() == 0 && targetDir.isDirectory() && (index = new File(target, "index.html")).isFile()) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(Utilities.toURI((File)index).toURL());
            }
            if (targetDir.isDirectory()) {
                FileUtil.refreshFor((File[])new File[]{targetDir});
            }
        }
        catch (CancellationException ex) {
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex, (String)"FrameworksAndTools/ApiGen");
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, ex.getLocalizedMessage(), ex);
        }
    }

    private ExecutionDescriptor getDescriptor() {
        return PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath(ApiGenOptionsPanelController.getOptionsPath()).inputVisible(false);
    }

    private List<String> getGenerateParams(PhpModule phpModule) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(GENERATE_PARAM);
        if (ApiGenPreferences.getBoolean(phpModule, ApiGenPreferences.HAS_CONFIG)) {
            this.addConfig(phpModule, params);
        } else {
            this.addSource(phpModule, params);
            this.addDestination(phpModule, params);
            this.addTitle(phpModule, params);
            this.addCharsets(phpModule, params);
            this.addExcludes(phpModule, params);
            this.addAccessLevels(phpModule, params);
            this.addInternal(phpModule, params);
            this.addPhp(phpModule, params);
            this.addTree(phpModule, params);
            this.addDeprecated(phpModule, params);
            this.addTodo(phpModule, params);
            this.addDownload(phpModule, params);
            this.addSourceCode(phpModule, params);
        }
        return params;
    }

    private void addSource(PhpModule phpModule, List<String> params) {
        params.add(SOURCE_PARAM);
        params.add(FileUtil.toFile((FileObject)phpModule.getSourceDirectory()).getAbsolutePath());
    }

    private void addDestination(PhpModule phpModule, List<String> params) {
        params.add(DESTINATION_PARAM);
        params.add(ApiGenPreferences.getTarget(phpModule, false));
    }

    private void addTitle(PhpModule phpModule, List<String> params) {
        params.add(TITLE_PARAM);
        params.add(ApiGenPreferences.get(phpModule, ApiGenPreferences.TITLE));
    }

    private void addConfig(PhpModule phpModule, List<String> params) {
        String config = ApiGenPreferences.get(phpModule, ApiGenPreferences.CONFIG);
        if (StringUtils.hasText((String)config)) {
            params.add(CONFIG_PARAM);
            params.add(config);
        }
    }

    private void addCharsets(PhpModule phpModule, List<String> params) {
        for (String charset : ApiGenPreferences.getMore(phpModule, ApiGenPreferences.CHARSETS)) {
            params.add(CHARSET_PARAM);
            params.add(charset);
        }
    }

    private void addExcludes(PhpModule phpModule, List<String> params) {
        for (String exclude : ApiGenPreferences.getMore(phpModule, ApiGenPreferences.EXCLUDES)) {
            params.add(EXCLUDE_PARAM);
            params.add(exclude);
        }
    }

    private void addAccessLevels(PhpModule phpModule, List<String> params) {
        for (String level : ApiGenPreferences.getMore(phpModule, ApiGenPreferences.ACCESS_LEVELS)) {
            params.add(ACCESS_LEVELS_PARAM);
            params.add(level);
        }
    }

    private void addInternal(PhpModule phpModule, List<String> params) {
        this.addBoolean(params, INTERNAL_PARAM, ApiGenPreferences.getBoolean(phpModule, ApiGenPreferences.INTERNAL));
    }

    private void addPhp(PhpModule phpModule, List<String> params) {
        this.addBoolean(params, PHP_PARAM, ApiGenPreferences.getBoolean(phpModule, ApiGenPreferences.PHP));
    }

    private void addTree(PhpModule phpModule, List<String> params) {
        this.addBoolean(params, TREE_PARAM, ApiGenPreferences.getBoolean(phpModule, ApiGenPreferences.TREE));
    }

    private void addDeprecated(PhpModule phpModule, List<String> params) {
        this.addBoolean(params, DEPRECATED_PARAM, ApiGenPreferences.getBoolean(phpModule, ApiGenPreferences.DEPRECATED));
    }

    private void addTodo(PhpModule phpModule, List<String> params) {
        this.addBoolean(params, TODO_PARAM, ApiGenPreferences.getBoolean(phpModule, ApiGenPreferences.TODO));
    }

    private void addDownload(PhpModule phpModule, List<String> params) {
        this.addBoolean(params, DOWNLOAD_PARAM, ApiGenPreferences.getBoolean(phpModule, ApiGenPreferences.DOWNLOAD));
    }

    private void addSourceCode(PhpModule phpModule, List<String> params) {
        if (ApiGenPreferences.getBoolean(phpModule, ApiGenPreferences.SOURCE_CODE)) {
            return;
        }
        params.add(NO_SOURCE_CODE_PARAM);
    }

    private void addBoolean(List<String> params, String param, boolean value) {
        if (!value) {
            return;
        }
        params.add(param);
    }
}

